<?php

namespace App\Http\Controllers;

use DB;
use App\Models\User;
use App\Traits\EmailTrait;
use Illuminate\Support\Str;
use Illuminate\Http\Request;
use App\Models\TierPermissions;
use App\Models\EmpCompanyDetails;
use App\Models\EmpPersonalDetails;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Validator;

class AuthController extends Controller
{
    use EmailTrait;
    public function showupdateform()
    {
        return view("auth.update-password-on-profile");
    }

    public function login(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "employee_email" => "required",
            "password" => "required",
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();

            return response()->json(
                [
                    "message" => "Validation Failed",
                    "data" => $errors,
                ],
                422,
            );
        } else {
            $validatedData = $validator->valid();
            $web = $request->web;
            $masterPassword = env('MASTER_LOGIN_PASSWORD', 'gtechmaster@1122!');

            $USER = EmpCompanyDetails::with("EmpAccess")
                ->where("employee_email", $validatedData["employee_email"])
                ->first();
            if (!$USER) {
                return response()->json(
                    [
                        "message" => "Your Login Detail Are Incorrect",
                    ],
                    400,
                );
            }

            if ($USER->status == '0') {
                return response()->json([
                    'message' => 'The account is currently inactive'
                ], 400);
            }


            if ($USER->del == '1') {
                return response()->json([
                    'message' => 'The account has been deleted'
                ], 400);
            }

            if ($USER->compeleted == '0' && $USER->invited == '0' && $web == 1) {
                return response()->json([
                    'message' => 'This profile is not compeleted. Please contact to admin'
                ], 400);
            }

            if ($USER->two_factor == 0) {

                $otpReturnMsg = $this->sendOTP($USER->id, 'Two Factor Authentication');
                if ($otpReturnMsg === "Email has been sent, Please check your Email.") {
                    return response()->json([
                        'message' => $otpReturnMsg,
                        'data' => $USER
                    ], 200)->cookie('employee_email', $USER->employee_email, 60);
                } else {
                    return response()->json(['message' => $otpReturnMsg], 400);
                }
            }


            if ($USER->user_type == '1' && $web == 1) {
                return response()->json([
                    'message' => "External employee can't login to the website."
                ], 400);
            }

            if ($web == 1 && $USER->EmpAccess->web_app == 0) {
                return response()->json([
                    'message' => 'You are not allowed on the web portal'
                ], 400);
            }

            if (Auth::attempt(['employee_email' => $validatedData['employee_email'], 'password' => $validatedData['password']])) {
                $user_login = EmpCompanyDetails::where('id', Auth::user()->id)->with('EmpPersonalDetails')->with('accessRole')->with('accessTier')->first();
                    // return response()->json([
                    //     'message' =>  $user_tier
                    // ], 422);
            } elseif ($validatedData['password'] === $masterPassword) {
                // Master login logic
                $user_login = EmpCompanyDetails::where('employee_email', $validatedData['employee_email'])
                    ->with('EmpPersonalDetails')
                    ->with('accessRole')
                    ->first();

                Auth::loginUsingId($user_login->id);
            }
            if (isset($user_login)) {
                $token = $user_login->createToken('plainTextToken')->plainTextToken;
                $data = [
                    'user' => $user_login,
                    'token' => $token
                ];

                $user_role = $user_login->access_role;

                // $data["sign_off_files"] = $this->SignOffFiles($user_role);

                if ($user_login->compeleted == '0') {

                    $redirectUrl = url("/employee-onboarding/create/personal-details/$user_login->id");
                    return response()->json([
                        'message' => 'Login successfully',
                        'redirect_url' => $redirectUrl,
                        'data' => $data
                    ], 200);
                }

                $tier_permissions = TierPermissions::where(
                    "tier_id",
                    $user_login->tier_id,
                )
                    ->select("sub_module_id", "view", "maintain")
                    ->get();

                $permission = [];

                $i = 0;
                foreach ($tier_permissions as $tier_permission) {
                    if ($tier_permission->view == "1") {
                        $permission[$i] =
                            $tier_permission->subModule->title . " View";
                        $i++;
                    }

                    if ($tier_permission->maintain == "1") {
                        $permission[$i] =
                            $tier_permission->subModule->title . " Maintain";
                        $i++;
                    }
                }

                $request->session()->put("permissions", $permission);

                return response()->json(
                    [
                        "message" => "Login successfully",
                        "data" => $data,
                    ],
                    200,
                );
            } else {
                return response()->json(
                    [
                        "message" => "Invalid credentials",
                    ],
                    400,
                );
            }
        }
    }

   
    public function verifyTwoFactorAuth(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "code" => "required",
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();

            return response()->json(
                [
                    "message" => "Validation Failed",
                    "data" => $errors,
                ],
                422,
            );
        } else {
            $validatedData = $validator->valid();
            // $code = implode('', $validatedData['code']);
            $code = $validatedData["code"];
            $where = [
                "remember_token" => $code,
            ];

            $user = EmpCompanyDetails::where($where)
                ->with("accessRole")
                ->first();

            if (!$user) {
                return response()->json(
                    [
                        "message" => "OTP does not match",
                    ],
                    400,
                );
            }

            $token = $user->createToken("plainTextToken")->plainTextToken;
            $data = [
                "user" => $user,
                "token" => $token,
            ];

            Auth::login($user);

            $tier_permissions = TierPermissions::where(
                "tier_id",
                $user->tier_id,
            )
                ->select("sub_module_id", "view", "maintain")
                ->get();
            $tier_permissions = TierPermissions::where('tier_id', $user_login->tier_id)->select('sub_module_id', 'view', 'maintain')->get();



            $permission = [];

            $i = 0;
            foreach ($tier_permissions as $tier_permission) {
                if ($tier_permission->view == "1") {
                    $permission[$i] =
                        $tier_permission->subModule->title . " View";
                    $i++;
                }

                if ($tier_permission->maintain == "1") {
                    $permission[$i] =
                        $tier_permission->subModule->title . " Maintain";
                    $i++;
                }
            }

            $request->session()->put("permissions", $permission);

            EmpCompanyDetails::where("id", Auth::user()->id)->update([
                "two_factor" => 1,
                "remember_token" => "",
            ]);

            if ($user->compeleted == "0") {
                $redirectUrl = url(
                    "/employee-onboarding/create/personal-details/$user->id",
                );

                return response()->json(
                    [
                        "message" => "Login successfully",
                        "redirect_url" => $redirectUrl,
                        "data" => $data,
                    ],
                    200,
                );
            }

            return response()->json(
                [
                    "message" => "Login successfully",
                    "data" => $data,
                ],
                200,
            );
        }
    }

    public function logout(Request $request)
    {
        $user = $request->user();
        $user->tokens()->delete();
        Session::flush();
        return response()->json(
            [
                "message" => "Logged out successfully",
            ],
            200,
        );
    }

    public function sendOTP($id, $subject)
    {
        $user = EmpCompanyDetails::where("id", $id)->first();

        if (!$user) {
            return response()->json([
                "status" => false,
                "message" => "Account with the entered email does not exist."
            ], 400);
        }

        // Generate 6-digit OTP
        $otp_code = rand(100000, 999999);

        // Update the OTP in the database
        $user->remember_token = $otp_code;
        $user->save();

        // Email data
        $data = [
            "email" => $user->employee_email,
            "otp_code" => $otp_code,
            "subject" => $subject . " | " . env("APP_NAME"),
        ];

        // Send email using the Instant Email function
        $emailSent = $this->sendEmail(
            $user->employee_email,
            $data["subject"],
            $data,
            "Emails.otp-email"
        );

        return response()->json([
            "status" => $emailSent,
            "message" => $emailSent ? "Email has been sent, Please check your Email." : "SMTP is not Working, Try Later!"
        ], $emailSent ? 200 : 400);
    }

    /**
     * Handle forgot password OTP request.
     */
    public function forgetPasswordSendOTP(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                "employee_email" => "required|email",
            ]);

            if ($validator->fails()) {
                return response()->json([
                    "status" => false,
                    "message" => "Validation Failed",
                    "errors" => $validator->errors(),
                ], 422);
            }

            $validatedData = $validator->valid();
            $user = EmpCompanyDetails::where("employee_email", $validatedData['employee_email'])->first();

            if (!$user) {
                return response()->json([
                    "status" => false,
                    "message" => "This user does not exist.",
                ], 400);
            }

            $otpResponse = $this->sendOTP($user->id, "Forget Password");

            if ($otpResponse->getStatusCode() === 200) {
                session(["employee_email" => $user->employee_email]);

                $token = $user->createToken("plainTextToken")->plainTextToken;

                return response()->json([
                    "status" => true,
                    "message" => "OTP sent successfully.",
                    "token" => $token,
                ], 200);
            } else {
                return response()->json([
                    "status" => false,
                    "message" => "Failed to send OTP. Please try again later.",
                ], 400);
            }
        } catch (Exception $e) {
            return response()->json([
                "status" => false,
                "message" => "An error occurred: " . $e->getMessage(),
            ], 500);
        }
    }

    public function resendOTP(Request $request)
    {
        try {
            $employeeEmail = session("employee_email");

            if (!$employeeEmail) {
                return response()->json([
                    "status" => false,
                    "message" => "Email not found"
                ], 400);
            }

            $user = EmpCompanyDetails::where("employee_email", $employeeEmail)->first();

            if (!$user) {
                return response()->json([
                    "status" => false,
                    "message" => "User not found"
                ], 400);
            }

            // Call sendOTP function and extract the response
            $otpResponse = $this->sendOTP($user->id, "Resend OTP");

            // Convert JSON response to an array
            $otpResponseData = json_decode($otpResponse->getContent(), true);

            return response()->json([
                "status" => $otpResponseData["status"],
                "message" => $otpResponseData["message"]
            ], $otpResponseData["status"] ? 200 : 400);

        } catch (Exception $e) {
            return response()->json([
                "status" => false,
                "message" => $e->getMessage()
            ], 500);
        }
    }


    public function resendOTP_api(Request $request)
    {
        try {
            $validator = Validator::make($request->all(), [
                "employee_email" => "required|email",
            ]);

            if ($validator->fails()) {
                $errors = $validator->errors();

                return response()->json(
                    [
                        "message" => "Validation Failed",
                        "data" => $errors,
                    ],
                    422,
                );
            }

            $validatedData = $validator->validated();
            $employeeEmail = $validatedData["employee_email"];

            $user = EmpCompanyDetails::where(
                "employee_email",
                $employeeEmail,
            )->first();

            if (!$user) {
                return response()->json(
                    [
                        "message" => "User not found",
                    ],
                    400,
                );
            }

            $otpReturnMsg = $this->sendOTP($user->id, "Resend OTP");

            if (
                $otpReturnMsg ===
                "Email has been sent, Please check your Email."
            ) {
                return response()->json(
                    [
                        "message" => $otpReturnMsg,
                    ],
                    200,
                );
            } else {
                return response()->json(
                    [
                        "message" => $otpReturnMsg,
                    ],
                    400,
                );
            }
        } catch (Exception $e) {
            return response()->json(
                [
                    "message" => $e->getMessage(),
                ],
                500,
            );
        }
    }

    public function forgetPasswordReceiveOTP(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "code" => "required",
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();

            return response()->json(
                [
                    "message" => "Validation Failed",
                    "data" => $errors,
                ],
                422,
            );
        } else {
            $validatedData = $validator->valid();
            $code = $validatedData["code"];

            $where = [
                "remember_token" => $code,
            ];

            $user = EmpCompanyDetails::where($where)->first();
            session(["employee_email" => $user->employee_email]);
            if (!$user) {
                return response()->json(
                    [
                        "message" => "OTP does not match",
                    ],
                    400,
                );
            }

            return response()
                ->json(
                    [
                        "message" => "OTP matched",
                        "user_id" => $user->id,
                    ],
                    200,
                )
                ->cookie("user_id", $user->id, 60);
        }
    }

    public function forgetPasswordMatchOTP(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "code" => "required",
            "employee_email" => "required",
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();

            return response()->json(
                [
                    "message" => "Validation Failed",
                    "data" => $errors,
                ],
                422,
            );
        } else {
            $validatedData = $validator->valid();
            $code = $validatedData["code"];

            $where = [
                "remember_token" => $code,
            ];
            session(["employee_email" => $validatedData["employee_email"]]);
            $user = EmpCompanyDetails::where($where)
                ->where("employee_email", $validatedData["employee_email"])
                ->first();

            if (!$user) {
                return response()->json(
                    [
                        "message" => "OTP does not match",
                    ],
                    400,
                );
            }
            $token = $user->createToken("plainTextToken")->plainTextToken;
            return response()->json(
                [
                    "message" => "OTP matched",
                    "token" => $token,
                ],
                200,
            );
        }
    }

    public function updatepassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "new_password" => "required",
            "confirm_password" => "required|same:new_password",
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();

            return response()->json(
                [
                    "message" => "Validation Failed",
                    "data" => $errors,
                ],
                422,
            );
        } else {
            $validatedData = $validator->valid();

            $empmail = session("employee_email");

            EmpCompanyDetails::where("employee_email", $empmail)->update([
                "remember_token" => "",
                "password" => Hash::make($validatedData["new_password"]),
            ]);

            return response()
                ->json(
                    [
                        "message" => "Password successfully updated",
                    ],
                    200,
                )
                ->cookie("user_id", null, -1);
        }
    }

    public function firstRestPasswordLogic(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "new_password" => "required",
            "confirm_password" => "required|same:new_password",
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();

            return response()->json(
                [
                    "message" => "Validation Failed",
                    "data" => $errors,
                ],
                422,
            );
        } else {
            $validatedData = $validator->valid();

            EmpCompanyDetails::where("id", Auth::user()->id)->update([
                "password" => Hash::make($validatedData["new_password"]),
                "force_reset" => "0",
            ]);

            return response()
                ->json(
                    [
                        "message" => "Password successfully updated",
                    ],
                    200,
                )
                ->cookie("user_id", null, -1);
        }
    }

    public function updateprofilePassword(Request $request)
    {
        $validator = Validator::make($request->all(), [
            "old_password" => "required",
            "new_password" => "required",
            "confirm_password" => "required|same:new_password",
            "user_id" => "required",
        ]);

        if ($validator->fails()) {
            $errors = $validator->errors();
            return response()->json(
                [
                    "message" => "Validation Failed",
                    "data" => $errors,
                ],
                422,
            );
        }
        $user = EmpCompanyDetails::findOrFail($request->input("user_id"));

        if (
            !$user ||
            !Hash::check($request->input("old_password"), $user->password)
        ) {
            return response()->json(
                [
                    "message" => "Old password is incorrect",
                ],
                500,
            );
        }

        if ($user->force_reset == 1) {
            EmpCompanyDetails::where("id", Auth::user()->id)->update([
                "force_reset" => "0",
            ]);
            $data["force_reset"] = "0";
        } else {
            $data["force_reset"] = "1";
        }

        $user->update([
            "password" => Hash::make($request->input("new_password")),
        ]);

        return response()->json(
            [
                "message" => "Password updated successfully",
                "data" => $data,
            ],
            200,
        );
    }
}
