<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Auth;
use DB;
use App\Models\EmpTeam;
use App\Models\EmpTeamsMember;
use App\Models\EmpTeamsMemberNotCompelete;
use App\Models\TeamHistory;
use App\Models\EmpCompanyDetails;
use App\Models\EmpPersonalDetails;

class EmpTeamController extends Controller
{

    public function index(Request $request)
    {
        $emp_teams =  EmpTeam::orderBy('id', 'DESC')->where('del','0')->get();

        $data['emp_teams'] = $emp_teams; 
 
         return response()->json([
             'message' => 'Employee Teams Get Successfully',
             'data'   => $data
         ],200);
        
    }

    public function create()
    {
        $supervisor  =  EmpCompanyDetails::with('empPersonalDetails')
                         ->where('access_role','tl') // Supervisor
                        ->where('compeleted','1')
                        ->where('status','1')
                        ->where('del','0')
                        ->orderBy('id', 'DESC')
                        ->get();

        $data['supervisor'] = $supervisor;
 
         return response()->json([
             'message' => '',
             'data'   => $data
         ],200);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'supervisor' => 'required',
            'description' => 'required'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
            ],422);


        } else {
          
           $validatedData =  $validator->validated();
           
           $validatedData['created_by'] = Auth::user()->id;
           
           EmpTeam::insert($validatedData);

           $emp_teams =  EmpTeam::where('del','0')->orderBy('id', 'DESC')->get();

           $data['emp_teams'] = $emp_teams;
    
            return response()->json([
                'message' => 'Employee Teams Saved Successfully',
                'data'   => $data
            ],200);
            
        }        

    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        $supervisor  =  EmpCompanyDetails::with('empPersonalDetails')
                        // ->where('access_role', 'spv')
                        ->where('compeleted','1')
                        ->where('status','1')
                        ->where('del','0')
                        ->orderBy('id', 'DESC')
                        ->get();
                        
        $data['supervisor'] = $supervisor;
 
         return response()->json([
             'message' => '',
             'data'   => $data
         ],200);
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'supervisor' => 'required',
            'description' => 'required'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

            EmpTeam::where('id', $id)->update($validatedData);

            $emp_teams =  EmpTeam::where('del','0')->orderBy('id', 'DESC')->get();

            $data['emp_teams'] = $emp_teams;
     
             return response()->json([
                 'message' => 'Employee Teams Updated Successfully',
                 'data'   =>   $data
             ],200);
            
        }        

    }

    public function destroy($id)
    {
        EmpTeam::where('id', $id)->update([
            'del' => '1'
        ]);

        $emp_teams =  EmpTeam::where('del','0')->orderBy('id', 'DESC')->get();

        $data['emp_teams'] = $emp_teams;
 
         return response()->json([
             'message' => 'Employee Teams Deleted Successfully',
             'data'   => $data
         ],200);
    }

    public function addRemoveTeamMember(Request $request)
    {

        $authPersonalDetails  = EmpPersonalDetails::where('emp_id',Auth::user()->id)->first();
        
    
        $empPersonalDetails   = EmpPersonalDetails::where('emp_id',$request->emp_id)->first();
        $teamDetails   = EmpTeam::where('id',$request->team_id)->first();
        if( EmpTeamsMember::where(['team_id' => $request->team_id, 'emp_id' => $request->emp_id])->count() > 0 )    
        {

            EmpTeamsMember::where([
                'team_id' => $request->team_id,
                'emp_id' => $request->emp_id,
                ])->delete();

            if($request->applied == 1){
                $description = "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> deleted the memeber: '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  from  '{$teamDetails->title}' team.";
            }
        }
        else
        {
            EmpTeamsMember::insert([
                'team_id' => $request->team_id,
                'emp_id' => $request->emp_id,
                'applied' => $request->applied
            ]);
            if($request->applied == 1){
                $description = "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> added the memeber: '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  in  '{$teamDetails->title}' team.";
            }
        }


        if($request->applied == 1){
            TeamHistory::create([
                'team_id' => $request->team_id,
                'emp_id' => $request->emp_id,
                'description' => $description
            ]);

        }


        return response()->json([
            'message' => 'Team Memeber Updated Successfully'
        ],200);
        

        
    }

    public function GetTeamMember(Request $request)
    {
        $teams_member =   EmpTeamsMember::where('team_id' , $request->team_id)->where('applied' , '1')->orderBy('id', 'DESC')->get();
        $emp_team =   EmpTeam::with('teamSupervisor')->where('id', $request->team_id)->orderBy('id', 'DESC')->first();

        $data['teams_member'] = $teams_member;
        $data['emp_team'] = $emp_team;

        return response()->json([
            'message' => 'Get Team Memeber Successfully',
            'data'   => $data
        ],200);
    }

    public function GetTeamHistory(Request $request)
    {
        $team_history =   TeamHistory::orderBy('id', 'DESC')->get();

        $data['team_history'] = $team_history;

        return response()->json([
            'message' => 'Get Team History Successfully',
            'data'   => $data
        ],200);
    }

}
