<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Auth;
use DB;
use App\Models\EmpType;

class EmpTypeController extends Controller
{
    public function index()
    {
        $emp_types =  EmpType::where('del','0')->get();

        $data['emp_types'] = $emp_types;
 
         return response()->json([
             'message' => 'Employee Type Get Successfully',
             'data'   => $data
         ],200);
        
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required'
                ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();

            return response()->json([
                'message' => 'Validation Failed',
                'data' => $errors
            ],422);


        } else {
          
           $validatedData =  $validator->validated();
           
           $validatedData['created_by'] =  Auth::user()->id;
           
           EmpType::insert($validatedData);

           $emp_types =  EmpType::where('del','0')->get();

           $data['emp_types'] = $emp_types;
    
            return response()->json([
                'message' => 'Employee Type Saved Successfully',
                'data'   => $data
            ],200);
            
        }        

    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required'
        ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();

            return response()->json([
                'message' => 'Validation Failed',
                'data' => $errors
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

            EmpType::where('id', $id)->update($validatedData);

            $emp_types =  EmpType::where('del','0')->get();

            $data['emp_types'] = $emp_types;
     
             return response()->json([
                 'message' => 'Employee Type Updated Successfully',
                 'data'   =>   $data
             ],200);
            
        }        

    }

    public function destroy($id)
    {
        EmpType::where('id', $id)->update([
            'del' => '1'
        ]);

        $emp_types =  EmpType::where('del','0')->get();

        $data['emp_types'] = $emp_types;
 
         return response()->json([
             'message' => 'Employee Type Deleted Successfully',
             'data'   => $data
         ],200);
    }
}
