<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Auth;
use DB;
use App\Models\EmpWorkExperience;

class EmpWorkExperienceController extends Controller
{
    public function index()
    {
        $emp_work_experiences =  EmpWorkExperience::where('del','0')->get();

        $data['emp_work_experiences'] = $emp_work_experiences;
 
         return response()->json([
             'message' => 'Work Experience Get Successfully',
             'data'   => $data
         ],200);
         
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
        ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();

            return response()->json([
                'message' => 'Validation Failed',
                'data' => $errors
            ],422);


        } else {
          
           $validatedData =  $validator->validated();
           
           $validatedData['created_by'] = Auth::user()->id;
           
           EmpWorkExperience::insert($validatedData);

           $emp_work_experiences =  EmpWorkExperience::where('del','0')->get();

           $data['emp_work_experiences'] = $emp_work_experiences;
    
            return response()->json([
                'message' => 'Work Experience Saved Successfully',
                'data'   => $data
            ],200);
            
        }        

    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required'
        ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();

            return response()->json([
                'message' => 'Validation Failed',
                'data' => $errors
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

            EmpWorkExperience::where('id', $id)->update($validatedData);

            $emp_work_experiences =  EmpWorkExperience::where('del','0')->get();

            $data['emp_work_experiences'] = $emp_work_experiences;
     
             return response()->json([
                 'message' => 'Work Experience Updated Successfully',
                 'data'   =>   $data
             ],200);
            
        }        

    }

    public function destroy($id)
    {
        EmpWorkExperience::where('id', $id)->update([
            'del' => '1'
        ]);

        $emp_work_experiences =  EmpWorkExperience::where('del','0')->get();

        $data['emp_work_experiences'] = $emp_work_experiences;
 
         return response()->json([
             'message' => 'Work Experience Deleted Successfully',
             'data'   => $data
         ],200);
    }
}
