<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Auth;
use DB;
use App\Models\EmpWorkerType;

class EmpWorkerTypeController extends Controller
{
    public function index()
    {
        $emp_worker_types =  EmpWorkerType::where('del','0')->get();

        $data['emp_worker_types'] = $emp_worker_types;
 
         return response()->json([
             'message' => 'Worker Type Get Successfully',
             'data'   => $data
         ],200);
         
    }

    public function create()
    {
        //
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
        ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();

            return response()->json([
                'message' => 'Validation Failed',
                'data' => $errors
            ],422);


        } else {
          
           $validatedData =  $validator->validated();
           
           $validatedData['created_by'] = Auth::user()->id;
           
           EmpWorkerType::insert($validatedData);

           $emp_worker_types =  EmpWorkerType::where('del','0')->get();

           $data['emp_worker_types'] = $emp_worker_types;
    
            return response()->json([
                'message' => 'Worker Type Saved Successfully',
                'data'   => $data
            ],200);
            
        }        

    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        //
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required'
        ]);
        
        if ($validator->fails()) {

            $errors = $validator->errors();

            return response()->json([
                'message' => 'Validation Failed',
                'data' => $errors
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

            EmpWorkerType::where('id', $id)->update($validatedData);

            $emp_worker_types =  EmpWorkerType::where('del','0')->get();

            $data['emp_worker_types'] = $emp_worker_types;
     
             return response()->json([
                 'message' => 'Worker Type Updated Successfully',
                 'data'   =>   $data
             ],200);
            
        }        

    }

    public function destroy($id)
    {
        EmpWorkerType::where('id', $id)->update([
            'del' => '1'
        ]);

        $emp_worker_types =  EmpWorkerType::where('del','0')->get();

        $data['emp_worker_types'] = $emp_worker_types;
 
         return response()->json([
             'message' => 'Worker Type Deleted Successfully',
             'data'   => $data
         ],200);
    }
}
