<?php


namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Auth;
use DB;
use App\Models\EmpCompanyDetails;
use App\Models\EmpPermit;
use App\Models\EmpPersonalDetails;
use App\Models\EmpType;
use App\Models\Role;
use App\Models\EmpDocuments;
use Illuminate\Validation\Rule;
use App\General\MetaClass;
use Illuminate\Support\Facades\Hash;
use App\Models\EmpEmergencyContacts;
use App\Models\EmpAccess;
use App\Models\Fund;
use App\Models\FundsMeta;
use App\Models\EmpTeamsMember;
use App\Models\RequiredDocument;
use App\Models\EmpListChangeCol;
use Illuminate\Support\Facades\Response;



class EmployeeController extends Controller
{
    
    public function active_employees_list() {
      $employees = EmpCompanyDetails::where('status', 1)
                    ->orderBy('id', 'desc') 
                    ->get(['id', 'employee_email'])
                    ->map(function ($employee) {
                        return [
                            'value' => $employee->id,
                            'label' => $employee->employee_email
                        ];
                    });

      return response()->json([
          'message' => 'Get Users List Successfully',
          'data' => $employees,
      ], 200);
  }

    public function index(Request $request)
    {
      $query = EmpCompanyDetails::query();
      $query->where('del','0');
      
      if($request->filled('invited'))
      {
        $query->where('invited',$request->invited);
      }
   
      if($request->filled('filter'))
      {
        $query =  $this->filter(json_decode($request->filter, true),$query);
      }

      $query->with(['empPersonalDetails','empDocuments','empEmergencyContacts','empAccess','accessRole','empTeamsMembers','empMetaData']);
    
      $count = $query->count();
      $start = $request->input('from', 0);
      $per_page = $request->input('per_page', 20);
      $query->offset($start)->limit($per_page);
      $query->orderBy('id', 'desc');
      $query_result = $query->get();

      $i= 0 ;


          $data =  [
              'users' => $query_result,
          ];
         
          $array_filter =  json_decode($request->filter, true);
          $filters = [
            'first_name' => $array_filter['first_name'] ?? '', 
            'middle_name' => $array_filter['middle_name'] ?? '',
            'last_name' => $array_filter['last_name'] ?? '',
            'employee_email' => $array_filter['employee_email'] ?? '',
            'compeleted' => $array_filter['compeleted'] ?? '',
            'status' => $array_filter['status'] ?? '',
            'access_role' => $array_filter['access_role'] ?? '',
          ];

          return response()->json([
              'message' => 'Get Users List Successfully',
              'data' => $data,
              'count' => $count,
              'filters' => $filters
          ],200);


    }

    public function filter($filters,$query)
    {
    
        foreach ($filters as $filterName => $filterValue) {
              if ($filterValue != null ||  $filterValue !="" ) {
                  switch ($filterName) {
                  case 'first_name':
                    $query->whereHas('empPersonalDetails', function ($subquery) use ($filterValue) {
                    $subquery->where('first_name', 'like', '%' . $filterValue . '%');
                  });
                  break;
                  case 'middle_name':
                    $query->whereHas('empPersonalDetails', function ($subquery) use ($filterValue) {
                    $subquery->where('middle_name', 'like', '%' . $filterValue . '%');
                  });
                  break;
                  case 'last_name':
                    $query->whereHas('empPersonalDetails', function ($subquery) use ($filterValue) {
                    $subquery->where('last_name', 'like', '%' . $filterValue . '%');
                  });
                  break;
                  case 'employee_email':
                    $query->where('employee_email', 'like', '%' . $filterValue . '%');
                  break;
                  case 'streat_address':
                    $query->whereHas('empPersonalDetails', function ($subquery) use ($filterValue) {
                      $subquery->where('streat_address', 'like', '%' . $filterValue . '%');
                    });
                    break;
                  case 'mobile':
                    $query->whereHas('empPersonalDetails', function ($subquery) use ($filterValue) {
                      $subquery->where('mobile', 'like', '%' . $filterValue . '%');
                    });
                  break;
                  case 'tax_file_no':
                    $query->where('tax_file_no', 'like', '%' . $filterValue . '%');
                  break;
                  case 'bank_name':
                    $query->whereHas('empMetaData', function ($subquery) use ($filterValue) {
                      $subquery->where('option', 'bank_name')
                               ->where('value', 'like', '%' . $filterValue . '%');
                  });
                  break;
                  case 'account_number':
                    $query->whereHas('empMetaData', function ($subquery) use ($filterValue) {
                      $subquery->where('option', 'account_number')
                      ->where('value', 'like', '%' . $filterValue . '%');
                  });
                  break;

                  case 'teams':
                    $emp_teams_members = EmpTeamsMember::where('team_id', $filterValue)->pluck('emp_id')->toArray();
                    $query->whereIn('id', $emp_teams_members);
                  break;
                  case 'access_role':
                    $query->where('access_role', 'like', '%' . $filterValue . '%');
                  break;
                  case 'completed':
                      $filterValue =   $filterValue ? 1 : 0;
                      $query->where('compeleted', 'like', '%' . $filterValue . '%');
                  break;
                  case 'status':
                      $filterValue =   $filterValue ? 1 : 0;
                      $query->where('status', 'like', '%' . $filterValue . '%');
                  break;
                  case 'user_type':
                    $filterValue =   $filterValue ? 1 : 0;
                    $query->where('user_type', 'like', '%' . $filterValue . '%');
                  break;
                  case 'link_key':
                    $query->where('link_key', 'like', '%' . $filterValue . '%');
                  break;                        
                  }
              }
        }

        return $query;
    }

    public function empDownload(Request $request)
    {
        $query = EmpCompanyDetails::with(['empPersonalDetails','empDocuments','empEmergencyContacts','empAccess','accessRole','empTeamsMembers']);

        if($request->filled('invited'))
        {
          $query->where('invited',$request->invited);
        }
        
        if($request->filled('filter'))
        {
          $query = $this->filter(json_decode($request->filter, true),$query);
        }

        $query->where('del','0');
        $query->orderBy('id', 'desc');
        $emps = $query->get();

        $cols = DB::table('emp_list_change_cols')->pluck('col')->toArray();
      
          $columns = [
              'First Name',
              'Middle Name',
              'Last Name',
              'Employee Email',
              'Teams',
              'Role',
              'Mobile',
              'Address',
              'Tax File No',
              'Account Number',
              'BSB',
              'Registration',
              'Status',
              'Type',
          ];

          $col_list[] = "Employee Id";
          $col_list[] = "External Id";
          $indexs = [];
          $i = 2;
          foreach ($columns as $column) {
            if (in_array($column, $cols))
            {
              $col_list[] = $column;
            }
            else
            {
              $indexs[] = $i;
            }
            $i++;
          }

          $csvData[] = $col_list;

          $data_list  = [];

          foreach ($emps as $emp) {
              $team_list = "";
              foreach ($emp->empTeamsMembers as $et) {
                  $team_list .= $et->empTeamsList->title . ",";
              }
              
              $team_list = rtrim($team_list, ',');
          
              $user_meta = DB::table('user_meta')
                              ->where('emp_id', $emp->id)
                              ->get();             
              $data_list = [
                $emp->id,
                $this->searchInMeta($user_meta,'employee_payroll_or_external_id'),
                $emp->empPersonalDetails ? $emp->empPersonalDetails->first_name : '',
                $emp->empPersonalDetails ? $emp->empPersonalDetails->middle_name : '',
                $emp->empPersonalDetails ? $emp->empPersonalDetails->last_name : '',
                $emp->employee_email,
                $team_list,
                $emp->accessRole ? $emp->accessRole->title : '',
                $emp->empPersonalDetails ? $emp->empPersonalDetails->mobile : '',
                $emp->empPersonalDetails ? $emp->empPersonalDetails->streat_address : '',
                $emp->tax_file_no,
                $this->searchInMeta($user_meta,'account_number'),
                $this->searchInMeta($user_meta,'bank_name'),
                $emp->registration == 0 ? 'InProcess' : 'Completed',
                $emp->status == 0 ? 'InActive' : 'Active',
                $emp->user_type == 0 ? 'Internal' : 'External'
              ];
          
              $csvData[] = array_values(array_diff_key($data_list, array_flip($indexs)));
            
          }
          

        $headers = [
            'Content-Type' => 'text/csv',
            'Content-Disposition' => 'attachment; filename="emp.csv"', 
        ];

        
        $callback = function () use ($csvData) {
            $file = fopen('php://output', 'w');
            foreach ($csvData as $row) {
                fputcsv($file, $row);
            }
            fclose($file);
        };

        return Response::stream($callback, 200, $headers);
    }

    function searchInMeta($dataArray, $option) {
      $value = '';
      foreach ($dataArray as $element) {
          if ($element->option === $option) {
              $value = $element->value;
              break;
          }
      }
      return $value;
  }
  

    public function profile(Request $request)
    {
      if(EmpCompanyDetails::where('id', $request->id)->count() == 0)
      {
        return response()->json([
          'message' => 'Employee not found',
          'data' => []
        ],400);
      }
      
      $query = EmpCompanyDetails::query();
      $query->where('del','0');
      $query->where('id', $request->id);
      
      $query->with(['empPersonalDetails','empEmergencyContacts','empAccess','workExperience','workerType']);

      $query_result = $query->first();
      
      $query_result['empType'] = EmpType::where('id', $query_result->employment_type)->select('id','title')->first();
      $query_result['empWorkPermit'] = EmpPermit::where('id',$query_result->work_permit_type)->select('id','title')->first();
      $query_result['empAccessRole'] = Role::where('code',$query_result->access_role)->select('id','title','code')->first();
      


      $data['profile'] = $query_result;
      
      $funds_meta = FundsMeta::with('fund')->where('emp_id',$request->id)->get();
   
      $data['funds_meta'] = $funds_meta;


      $data['medicalAttachFiles'] = DB::table('medical_attach_files')->where('emp_id', $request->id)->get();

      $data['emp_documents'] =  EmpDocuments::where('emp_id',$request->id)->where('del', '0')->get();  
      $data['required_documents'] = RequiredDocument::with('requiredDocumentField')->where('del','0')->get();


      $user_meta =  DB::table('user_meta')->where('emp_id',$request->id)->get();
            
      $employee_payroll_or_external_id = MetaClass::getOptionValue('employee_payroll_or_external_id', $user_meta);

      $data['meta']['employee_payroll_or_external_id'] = $employee_payroll_or_external_id;

      return response()->json([
              'message' => 'Get Profile Successfully',
              'data' => $data
      ],200);


    }
    
    public function show($id)
    {
      //
    }

    public function edit($id)
    {
      //
    }

    public function update(Request $request, $id)
    {
      //
    }
    
    public function store(Request $request)
    {
      //
    }

    public function destroy($id)
    {

      EmpCompanyDetails::where('id',$id)->update(['del'=> '1']);

      return response()->json([
          'message' => 'Employee Deleted Successfully'
      ],200);
    }

    public function updateStatus($id)
    {     

      $emp =  EmpCompanyDetails::where('id',$id)->first();
      $status = $emp->status == '1' ? '0' : '1';
      EmpCompanyDetails::where('id',$id)->update(['status'=> $status]);

        $data['status'] = $status;

        return response()->json([
            'message' => 'Employee Status Updated Successfully',
            'data' => $data
        ],200);
            
               
    }

    public function changeCol(Request $request)
    {
      $arr = [];
      $col = $request->col;
      if($col){
        DB::table('emp_list_change_cols')->delete();
        for($i = 0; $i < count($col); $i++)
        {
          $arr[$i]['col'] = $col[$i];
        }
        EmpListChangeCol::insert($arr);
      }
      return back();
    }

}
