<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use Illuminate\Support\Facades\Validator;
use App\Models\PublicHoliday;
use Illuminate\Validation\Rule;
class LeaveController extends Controller
{
    
    public function list_holidays(){
        $currentYear = date('Y');
    
        $query = PublicHoliday::whereYear('from', $currentYear);
        $count = $query->count();
        $holidays = $query->get();
    
        return response()->json([
            'message' => 'Get Holiday List Successfully',
            'data' => $holidays,
            'count' => $count,
        ],200);
    }
    


    public function index(Request $request)
    {
        $query = PublicHoliday::query();

        if($request->filled('filter'))
        {
          $query =  $this->filter(json_decode($request->filter, true),$query);
        }
  
        $count = $query->count();
        $start = $request->input('from', 0);
        $query->offset($start)->limit(10);
        $query->orderBy('id', 'desc');
        $query_result = $query->get();

        $data =  [
            'holidays' => $query_result,
        ];
        $array_filter =  json_decode($request->filter, true);
        $filters = [
          'first_name' => $array_filter['first_name'] ?? '', 
          'middle_name' => $array_filter['middle_name'] ?? '',
          'last_name' => $array_filter['first_name'] ?? '',
          'employee_email' => $array_filter['last_name'] ?? '',
          'compeleted' => $array_filter['first_name'] ?? '',
          'status' => $array_filter['compeleted'] ?? '',
        ];

        return response()->json([
            'message' => 'Get Holiday List Successfully',
            'data' => $data,
            'count' => $count,
            'filters' => $filters
        ],200);


    }

    public function filter($filters,$query)
    {
     
        foreach ($filters as $filterName => $filterValue) {
              if ($filterValue != null ||  $filterValue !="" ) {
                  switch ($filterName) {
                  case 'company':
                    $query->whereHas('company', function ($subquery) use ($filterValue) {
                    $subquery->where('fname', 'like', '%' . $filterValue . '%');
                  });
                  break;
                  case 'title':
                      $query->where('title', 'like', '%' . $filterValue . '%');
                  break;
                  case 'status':
                      $filterValue =   $filterValue ? 1 : 0;
                      $query->where('status', 'like', '%' . $filterValue . '%');
                  break;
                  case 'latitude':
                    $query->where('latitude', 'like', '%' . $filterValue . '%');
                  break;  
                  case 'longitude':
                    $query->where('longitude', 'like', '%' . $filterValue . '%');
                  break;                     
                  case 'area_radius':
                    $query->where('area_radius', 'like', '%' . $filterValue . '%');
                  break; 
                  case 'State':
                    $query->where('State', 'like', '%' . $filterValue . '%');
                  break;                  
                  }
              }
        }

        return $query;
    } 

    public function store(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'holiday_name' => 'required|string|unique:public_holidays,title',
            'description' => 'required|string',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
        ]);
 
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' =>  $error
            ],422);


        } else {
          
           $validatedData =  $validator->validated();
           
           
           PublicHoliday::insert([
            'title' =>$validatedData['holiday_name'],
            'description' => $validatedData['description'],
            'from' => $validatedData['start_date'],
            'to' => $validatedData['end_date']
        ]);

           $data = PublicHoliday::all();
           session()->flash('success', 'Holiday Saved Successfully');
            return response()->json([
                'message' => 'Holiday Saved Successfully',
                'data'   => $data
            ],200);
            
        }        

    }

    public function edit($id)
    {
        $publicholiday = PublicHoliday::where('id',$id)->get();
        return response()->json($publicholiday);
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'holiday_name' => 'required|string|unique:public_holidays,title,' . $id,
            'description' => 'required|string',
            'start_date' => 'required|date',
            'end_date' => 'required|date|after_or_equal:start_date',
        ]);
    
        if ($validator->fails()) {
            $errors = $validator->errors();
            return response()->json([
                'message' => 'Validation Failed',
                'data' => $errors
            ], 422);
        } else {
            $publicHoliday = PublicHoliday::findOrFail($id);
            $validatedData =  $validator->validated();
            $publicHoliday->update([
                'title' =>$validatedData['holiday_name'],
                'description' => $validatedData['description'],
                'from' => $validatedData['start_date'],
                'to' => $validatedData['end_date']
            ]);
    
            $data = PublicHoliday::all();
            session()->flash('success', 'Holiday Updated Successfully');
            return response()->json([
                'message' => 'Holiday Updated Successfully',
                'data' => $data
            ], 200);
        }
    }
    
    public function destroy($id)
    {
        PublicHoliday::where('id',$id)->delete();
        session()->flash('success', 'Holiday Deleted Successfully');
        return response()->json([
            'message' => 'Holiday Deleted Successfully'
        ],200);
    }

    public function holidaydesc($id)
    {
        $data = PublicHoliday::findOrFail($id);
        return response()->json([
            'data'   => $data
        ],200);
    }
}
