<?php

namespace App\Http\Controllers;

use App\Models\LeavePackage;
use App\Models\LeaveType;
use App\Models\Role;
use DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Http\Request;

class LeavePackageController extends Controller
{
    public function __construct()
    {
        $this->middleware('Permissions:Leave Package Maintain')->only(['create', 'edit']);
    }
    
    public function index(Request $request)
    {
        $query = LeavePackage::query();

        if($request->filled('filter'))
        {
          $query =  $this->filter(json_decode($request->filter, true),$query);
        }
        $query->with('leaveType');

        $count = $query->count();
        $start = $request->input('from', 0);
        $query->offset($start)->limit(10);
        $query->orderBy('id', 'desc');
        $query_result = $query->get();

        $data = [
            'leavepackages' => $query_result,
        ];
        
        $array_filter =  json_decode($request->filter, true);
        $filters = [
          'first_name' => $array_filter['first_name'] ?? '', 
          'middle_name' => $array_filter['middle_name'] ?? '',
          'last_name' => $array_filter['first_name'] ?? '',
          'employee_email' => $array_filter['last_name'] ?? '',
          'compeleted' => $array_filter['first_name'] ?? '',
          'status' => $array_filter['compeleted'] ?? '',
        ];

        return response()->json([
            'message' => 'Get Leave Package List Successfully',
            'data' => $data,
            'count' => $count,
            'filters' => $filters
        ],200);
    }

    public function filter($filters,$query)
    {
     
        foreach ($filters as $filterName => $filterValue) {
              if ($filterValue != null ||  $filterValue !="" ) {
                  switch ($filterName) {
                  case 'company':
                    $query->whereHas('company', function ($subquery) use ($filterValue) {
                    $subquery->where('fname', 'like', '%' . $filterValue . '%');
                  });
                  break;
                  case 'title':
                      $query->where('title', 'like', '%' . $filterValue . '%');
                  break;
                  case 'status':
                      $filterValue =   $filterValue ? 1 : 0;
                      $query->where('status', 'like', '%' . $filterValue . '%');
                  break;
                  case 'latitude':
                    $query->where('latitude', 'like', '%' . $filterValue . '%');
                  break;  
                  case 'longitude':
                    $query->where('longitude', 'like', '%' . $filterValue . '%');
                  break;                     
                  case 'area_radius':
                    $query->where('area_radius', 'like', '%' . $filterValue . '%');
                  break; 
                  case 'State':
                    $query->where('State', 'like', '%' . $filterValue . '%');
                  break;                  
                  }
              }
        }

        return $query;
    } 

    public function create(Request $request)
    {
        $leave_types =  LeaveType::orderBy('id', 'DESC')->get();
        $employee_roles =  Role::where('del','0')->get();
        return view('LeavePackage.create',compact('leave_types','employee_roles'));
    }

   
    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'leave_package' => 'required|unique:leave_packages,title',
            'leave_type' => 'required',
            'leave_number' => 'required',
            'is_paid' => 'nullable',
            'color_code' => 'nullable',
            'renew_on' => 'nullable',
            'employee_roles.*' => 'required'
        ]);
        if ($validator->fails()) {
            $error = $validator->errors()->first();
            return response()->json([
                'message' => $error
            ],422);
        } else {
          
           $validatedData =  $validator->validated();
           
           
           LeavePackage::insert([
            'title' =>$validatedData['leave_package'],
            'leave_type_id' => $validatedData['leave_type'],
            'leave_number' => $validatedData['leave_number'],
            'color_code' => $validatedData['color_code'],
            'renew_on' => $validatedData['renew_on'],
            'employee_roles' => implode(",",$validatedData['employee_roles'])
        ]);

           $data = LeavePackage::all();
           session()->flash('success', 'Leave Package Saved Successfully');
            return response()->json([
                'message' => 'Leave Package Saved Successfully',
                'data'   => $data
            ],200);
            
        } 
    }

    public function show(LeavePackage $leavePackage)
    {
        //
    }

    public function edit($id)
    {
        $leavePackage = leavePackage::where('id',$id)->first();
        $leave_types  = LeaveType::all();
        $employee_roles =  Role::where('del','0')->get();
        return view('LeavePackage.edit', compact('leavePackage', 'leave_types','employee_roles'));
    }

   
    public function update(Request $request, $id)
    {
        
        $validator = Validator::make($request->all(), [
            'leave_package' => 'required',
            'leave_type' => 'required',
            'leave_number' => 'required',
            'is_paid' => 'nullable',
            'color_code' => 'nullable',
            'renew_on' => 'nullable',
            'employee_roles.*' => 'required'
        ]);
    
        if ($validator->fails()) {
            $error = $validator->errors()->first();
            return response()->json([
                'message' => $error
            ], 422);
        } else {
            $publicHoliday = leavePackage::findOrFail($id);
            $validatedData =  $validator->validated();
            $publicHoliday->update([
                'title' =>$validatedData['leave_package'],
                'leave_type_id' => $validatedData['leave_type'],
                'leave_number' => $validatedData['leave_number'],
                // 'is_paid' => $validatedData['is_paid'],
                'color_code' => $validatedData['color_code'],
                'renew_on' => $validatedData['renew_on'],
                'employee_roles' => implode(",",$validatedData['employee_roles'])
            ]);
    
            $data = leavePackage::where('id',$id)->get();
            session()->flash('success', 'Leave Package Updated Successfully');
            return response()->json([
                'message' => 'Leave Package Updated Successfully',
                'data' => $data
            ], 200);
        }
    }

   
    public function destroy($id)
    {
        LeavePackage::where('id',$id)->delete();
        session()->flash('success', 'Leave Package Deleted Successfully');
        return response()->json([
            'message' => 'Leave Package Deleted Successfully'
        ],200);
    }
}
