<?php

namespace App\Http\Controllers;

use App\Models\LeaveType;
use DB;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Http\Request;

class LeaveTypeController extends Controller
{
    
    public function index(Request $request)
    {
        $query = LeaveType::query();

        if($request->filled('filter'))
        {
          $query =  $this->filter(json_decode($request->filter, true),$query);
        }
  
        $count = $query->count();
        $start = $request->input('from', 0);
        $query->offset($start)->limit(10);
        $query->orderBy('id', 'desc');
        $query_result = $query->get();

        $data =  [
            'leavetypes' => $query_result,
        ];
        $array_filter =  json_decode($request->filter, true);
        $filters = [
          'first_name' => $array_filter['first_name'] ?? '', 
          'middle_name' => $array_filter['middle_name'] ?? '',
          'last_name' => $array_filter['first_name'] ?? '',
          'employee_email' => $array_filter['last_name'] ?? '',
          'compeleted' => $array_filter['first_name'] ?? '',
          'status' => $array_filter['compeleted'] ?? '',
        ];

        return response()->json([
            'message' => 'Get Holiday List Successfully',
            'data' => $data,
            'count' => $count,
            'filters' => $filters
        ],200);
    }

    public function filter($filters,$query)
    {
     
        foreach ($filters as $filterName => $filterValue) {
              if ($filterValue != null ||  $filterValue !="" ) {
                  switch ($filterName) {
                  case 'company':
                    $query->whereHas('company', function ($subquery) use ($filterValue) {
                    $subquery->where('fname', 'like', '%' . $filterValue . '%');
                  });
                  break;
                  case 'title':
                      $query->where('title', 'like', '%' . $filterValue . '%');
                  break;
                  case 'status':
                      $filterValue =   $filterValue ? 1 : 0;
                      $query->where('status', 'like', '%' . $filterValue . '%');
                  break;
                  case 'latitude':
                    $query->where('latitude', 'like', '%' . $filterValue . '%');
                  break;  
                  case 'longitude':
                    $query->where('longitude', 'like', '%' . $filterValue . '%');
                  break;                     
                  case 'area_radius':
                    $query->where('area_radius', 'like', '%' . $filterValue . '%');
                  break; 
                  case 'State':
                    $query->where('State', 'like', '%' . $filterValue . '%');
                  break;                  
                  }
              }
        }

        return $query;
    } 
 
    public function create()
    {
        //
    }

   
    public function store(Request $request)
    {
         $validator = Validator::make($request->all(), [
            'leave_type' => 'required|string|unique:leave_types,title',
            'description' => 'required|string',
            'leave_hours' => 'required',
        ]);
 
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
            ],422);


        } else {
          
           $validatedData =  $validator->validated();
           
           
           LeaveType::insert([
            'title' =>$validatedData['leave_type'],
            'leave_hours' =>$validatedData['leave_hours'],
            'description' => $validatedData['description']
        ]);

           $data = LeaveType::all();
           session()->flash('success', 'Leave Type Saved Successfully');
            return response()->json([
                'message' => 'Leave Type Saved Successfully',
                'data'   => $data
            ],200);
            
        }      
    }

  
    public function show(LeaveType $leaveType)
    {
        //
    }

    
    public function edit($id)
    {
        $publicholiday = LeaveType::where('id',$id)->get();
        return response()->json($publicholiday);
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'leave_type' => 'required|string|unique:leave_types,title,' . $id,
            'description' => 'required|string',
            'leave_hours' => 'required',
        ]);
    
        if ($validator->fails()) {
            $error = $validator->errors()->first();
            return response()->json([
                'message' => $error
            ], 422);
        } else {
            $publicHoliday = LeaveType::findOrFail($id);
            $validatedData =  $validator->validated();
            $publicHoliday->update([
                'title' =>$validatedData['leave_type'],
                'leave_hours' =>$validatedData['leave_hours'],
                'description' => $validatedData['description']
            ]);
    
            $data = LeaveType::all();
            session()->flash('success', 'Leave Type Updated Successfully');
            return response()->json([
                'message' => 'Leave Type Updated Successfully',
                'data' => $data
            ], 200);
        }
    }

  
    public function destroy($id)
    {
        LeaveType::where('id',$id)->delete();
        session()->flash('success', 'Leave Type Deleted Successfully');
        return response()->json([
            'message' => 'Leave Type Deleted Successfully'
        ],200);
    }
    public function leavetypedesc($id)
    {
        $data = LeaveType::findOrFail($id);
        return response()->json([
            'data'   => $data
        ],200);
    }
}
