<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Intervention\Image\ImageManager;
use Illuminate\Support\Facades\DB;
use App\Models\Tier;
use App\Models\PermissionsModules;
use App\Models\PermissionsSubModules;
use App\Models\TierPermissions;


class PermissionsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $tiers =  Tier::get();
        $permissions_modules =  PermissionsModules::with('permissionsSubModule')->where('del','0')->get();
        return view('Permission/permission',compact('tiers','permissions_modules'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
       $modules =  $request->module;
       $arr = [];
       $i=0;
    
        foreach ($modules as $key => $values) {

            $arr[$i] = [
                    "tier_id" =>  $request->tier_id,
                    "sub_module_id" => $key,
                    "view" => $modules[$key][0],
                    "maintain" => $modules[$key][1]
            ];
            $i++;
        }

            
        TierPermissions::where('tier_id', $request->tier_id)->delete();
        TierPermissions::insert($arr);

            return response()->json([
                'message' => 'Permissions Saved Successfully'
            ],200);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }
}
