<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Auth;
use App\Models\EmpCompanyDetails;
use App\Models\Role;
use App\Models\Tier;
use DB;
use App\Models\TierPermissions;



class RoleController extends Controller
{

    public function index(Request $request)
    {
        $data['roles'] = Role::where('del','0')->get();


            return response()->json([
                'message' => 'Get Roles Successfully',
                'data' => $data
            ],200);
    }

    public function show($id)
    {

       $role =  Role::where('id',$id)->first();
      

       $data['role'] = $role;


        return response()->json([
            'message' => 'Get Role Successfully',
            'data' => $data
        ],200);
    }

    public function edit($id)
    {
        $role = Role::find($id);

        if($role)
        {
            $data =  [
                'role' => $role
                ];

                return response()->json([
                    'message' => 'Get Role Successfully',
                    'data' => $data
                ],200);

        }
        else
        {
            return response()->json([
                'message' => 'Role Not Found'
            ],400);
        }
        
    }

    public function update(Request $request, $id)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'code' => ['required',Rule::unique('roles')->ignore($id)]
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
            $validatedData =  $validator->validated();

            $role = Role::where('id', $id)->first();

            if($role->code == 'A-1' ||  $role->code == 'emp' || $role->code == 'Hr' || $role->code == 'spv' || EmpCompanyDetails::where('access_role',$role->id)->count())
            {
                return response()->json([
                    'message' => 'Does not allow the updation of this role'
                ],400);
            }

           Role::where('id', $id)->update($validatedData);
           $data['roles'] = Role::where('del','0')->get();

            return response()->json([
                'message' => 'Role Updated Successfully',
                'data' => $data
            ],200);
            
        }        

    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'title' => 'required',
            'code' => ['required',Rule::unique('roles')]
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
           $validatedData =  $validator->validated();        
           
           Role::insert($validatedData);
           $data['roles'] = Role::where('del','0')->get();
    
            return response()->json([
                'message' => 'Role Saved Successfully',
                'data' => $data
            ],200);
            
        }        

    }


    public function destroy(Role $role)
    {
        if($role->code == 'A-1' ||  $role->code == 'emp' || $role->code == 'Hr' || $role->code == 'spv' || EmpCompanyDetails::where('access_role',$role->id)->count())
        {
            return response()->json([
                'message' => 'Does not allow the deletion of this role'
            ],400);
        }

        Role::where('id', $role->id)->update([
            'del' => '1'
        ]);



        $data['roles'] = Role::where('del','0')->get();

        return response()->json([
            'message' => 'Role Deleted Successfully',
            'data' => $data
        ],200);

    }

    
    public function tierRelatedData(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'tier_id' => 'required'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
                
            ],422);


        } else {
          
          $validatedData =  $validator->validated();   
           
          $tier =  Tier::where('id',$validatedData['tier_id'])->first();
          $users =  EmpCompanyDetails::with('empPersonalDetails')->where('tier_id', $tier->id)->where('compeleted', '1')->where('del','0')->get();

          $arr = [];
          $i = 0;

          foreach($users as $user)
          {
            $arr[$i]['first_name'] =   $user->empPersonalDetails ? $user->empPersonalDetails->first_name : "";
            $arr[$i]['last_name'] =  $user->empPersonalDetails ? $user->empPersonalDetails->last_name : "";
            $arr[$i]['middle_name'] = $user->empPersonalDetails ? $user->empPersonalDetails->middle_name : "";
            $arr[$i]['user_id'] =  $user->id;
            $i++;
          }
          $tier_permissions =  TierPermissions::where('tier_id', $validatedData['tier_id'])->where('del','0')->get();

          $data['users'] = $arr;
          $data['tier_permissions'] = $tier_permissions;
           
          
    
            return response()->json([
                'data' => $data,
                'message' => 'Get Role Related Data Successfully'
            ],200);
            
        }        

    }

}
