<?php

namespace App\Http\Controllers;

use App\Models\RosterTemplate;
use App\Models\EmpPersonalDetails;
use App\Models\EmpCompanyDetails;
use App\Models\RosterAssign;
use App\Models\RosterHistory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;
use Illuminate\Support\Facades\Hash;
use Auth;
use DB;
use Carbon\Carbon;
use App\Jobs\SendEmailJob;
use App\Models\PublicHoliday;
use App\Traits\RosterTemplateTrait;


class RosterTemplateController extends Controller
{
    use RosterTemplateTrait;

    
    public function index(Request $request)
    {
   

        $validator = Validator::make($request->all(), [
            'start_date' => 'required',
            'end_date' => 'required',
            'scheduler_mode' => 'required',
            'user_type' => 'nullable',
            'selected_employee' => 'nullable'

        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
            ],422);


        } else {
          
                $validatedData =  $validator->validated();

            
                $dates_array =  $this->getDatesBetween($validatedData['start_date'], $validatedData['end_date']);
           
                $selected_employee =   $request->selected_employee;
             
                $query = EmpCompanyDetails::query();
                $query->where('id','!=', '1');
                $query->where('del', '0');
                $query->where('compeleted', '1');
                $query->where('approved', '1');
                $query->where('status', '1');
                if (!is_null($selected_employee) && count($selected_employee) > 0) {
                   $query->whereIn('id', $selected_employee);
                
                }
                if($validatedData['user_type'] == '0' || $validatedData['user_type'] == '1'){
                    $query->where('user_type', $validatedData['user_type']);
                }
                $query->with(['empPersonalDetails' => function ($query) {
                    $query->select('emp_id','first_name','middle_name','last_name','image');
                }]);
    
                
                $count = $query->count();
                $from = $request->input('from', 0);
                $per_page = $request->input('per_page', 10);
                $query->offset($from)->limit($per_page);
                $query->orderBy('id', 'desc');
                $users = $query->select('id','user_type')->get();
   
             
                $data =  [
                    'html' => view('Roaster/roster_table', ['users' => $users,'dates_array' => $dates_array , 'count' => $count, 'from' => $from, 'per_page' => $per_page  ])->render()
                ];
      
                return response()->json([
                'message' => 'Get Roster Successfully',
                'data' => $data
                ],200);


        }

    }

    public function create(Request $request)
    {
        if($request->is_template == 1){

        $templates = RosterTemplate::where('is_saved','1')->where('status',1)->get();

        $templates_data = [];
        $i = 0;

        foreach($templates as $t)
        {
            $templates_data[$i] = $t;
            $templates_data[$i]['start_time_am_pm'] = $this->AM_PM($t->start_time);
            $templates_data[$i]['end_time_am_pm'] = $this->AM_PM($t->end_time);
            $i++;
        }

        $data =  [
            'saved_templates' => $templates_data,
            'date'=> $request->date,
        ];

        }
        else
        {

            $template = RosterTemplate::where('id',$request->template_id)->first();

            

            $data =  [
                'user_id' => $request->user_id,
                'date'=> $request->date,
                'template' => $template
            ]; 
        }

                
      
        return response()->json([
        'message' => 'Get Data Successfully',
        'data' => $data
        ],200);



    }

    function AM_PM($TIME)
    {
        $time = Carbon::parse($TIME);
        $time = str_replace("M","",$time->format('g:i A'));
        $time = str_replace(' ', '',$time);
        $time = str_replace(':00', '',$time);
        return $time;
    }

    function templateAssign(Request $request)
    {
        return $this->rosterTemplateAssign($request);
        // if($request->date < date('Y-m-d'))
        // {
        //     return response()->json([
        //         'message' => 'Scheduler does not allow changes to be made for past dates.'
        //     ],422); 
        // }

        // $RosterTemplate =   RosterTemplate::find($request->template_id);
        // $start_ = Carbon::parse($RosterTemplate->start_time);
        // $end_ = Carbon::parse($RosterTemplate->end_time);
        // $required_minutes =  $end_->diffInMinutes($start_); 
        // $required_minutes = $required_minutes - $RosterTemplate->break_minutes ?? 0;

        // $fixedStartTime = $RosterTemplate->start_time;
        // $fixedEndTime = $RosterTemplate->end_time;
        // $overlapExists = RosterAssign::where('assign_to',$request->user_id)->where('schedule_date',$request->date)->pluck('roster_template_id');
        // if($overlapExists)
        // {
        //     $matchingTemplates = RosterTemplate::whereIn('id', $overlapExists)->get();
          
        //     foreach ($matchingTemplates as $range) {
        //         $start = $range->start_time; 
        //         $end =  $range->end_time; 
        //         if ($this->isOverlap($fixedStartTime, $fixedEndTime, $start, $end)) {
        //             return response()->json([
        //                 'message' => ' Shift Conflict :already assigned a shift during this time. Please choose a different time slot. '
        //             ],422);
                   
        //         }
        //         else{
        //             // return response()->json([
        //             //     'message' => 'Done  Please choose a different time slot. '
        //             // ],422);
        //         }
        //     }
            
        // }

        // remove this code for double Entry in RoasterTemplate
        // $insert_id =   RosterTemplate::insertGetId([
        //     'start_time' => $RosterTemplate->start_time,
        //     'end_time' => $RosterTemplate->end_time,
        //     'break_minutes' => $RosterTemplate->break_minutes,
        //     'color_code' => $RosterTemplate->color_code,
        //     'shift_notes' => $RosterTemplate->shift_notes,
        //     'repeat_shift' => '0',
        //     'repeat_every' => $RosterTemplate->repeat_shift == '1' ?  $RosterTemplate->repeat_every : '',
        //     'end_date' => $RosterTemplate->end_date,
        //     'is_saved' => '0',
        //     'working_hours' => $required_minutes,
        //     'created_by' =>  Auth::user()->id
        // ]);

        // RosterAssign::insert([

        //     'assign_to' => $request->user_id,
        //     'roster_template_id' => $request->template_id,
        //     'schedule_date' => $request->date,

        // ]);

        // $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();

        // $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();

        // $history_arr = [
        //     'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> assigned  shift '{$request->template_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($request->date))."' date .",
        //     'roster_template_id' => $request->template_id
        // ];


        // $this->storeHistory($history_arr);

        // return response()->json([
        //     'message' => 'Template Assign Successfully'
        // ],200);
    }

    

    private function isOverlap($start1, $end1, $start2, $end2)
    {
        // Normalize the intervals by checking if they cross midnight
        if ($start1 > $end1) {
            $end1 = date('H:i:s', strtotime($end1) + 86400); // Add 24 hours to end1
        }
        if ($start2 > $end2) {
            $end2 = date('H:i:s', strtotime($end2) + 86400); // Add 24 hours to end2
        }

        return $start1 < $end2 && $start2 < $end1;
    }

    public function store(Request $request)
    {
        return $this->handleRosterTemplate($request);
        // $validator = Validator::make($request->all(), [
        //     'user_id' => 'required',
        //     'date' => 'required',
        //     'template_id' => 'required',
        //     'publish' => 'required',
        //     'start_time' => 'required',
        //     'end_time' => 'required',
        //     'break_minutes' => 'required',
        //     'color_code' => 'required',
        //     'shift_notes' => 'required',
        //     'repeat_shift' => 'required',
        //     'repeat_every' => 'required',
        //     'end_date' => 'required',
        //     'save_shift' => 'required',
        //     'edit' => 'nullable' 
        // ]);

        
        
        // if ($validator->fails()) {

        //     $errors = $validator->errors()->first();

        //     return response()->json([
        //         'message' => $errors
        //     ],422);


        // } else {

        //     $validatedData =  $validator->validated();
        //     $start_ = Carbon::parse($request->start_time);
        //     $end_ = Carbon::parse($request->end_time);
        //     $required_minutes =  $end_->diffInMinutes($start_); 
        //     $required_minutes = $required_minutes - $request->break_minutes ?? 0;
        //     if($request->date < date('Y-m-d'))
        //     {
        //         return response()->json([
        //             'message' => 'Scheduler does not allow changes to be made for past dates.'
        //         ],422); 
        //     }


        //     if($request->end_date < $request->date)
        //     {
        //         return response()->json([
        //             'message' => 'End Date must be bigger than or Equal to '.date('d-m-Y', strtotime($request->date)).' date.'
        //         ],422); 
        //     }

        //     $fixedStartTime = $request->start_time; 
        //     $fixedEndTime = $request->end_time; 
        //     $overlapExists = RosterAssign::where('assign_to',$request->user_id)->where('schedule_date',$request->date)->pluck('roster_template_id');
        //     if($request->edit == "edit")
        //     {
        //         $templateId = $request->template_id;
        //         $overlapExists = $overlapExists->reject(function($value) use ($templateId) {
        //             return $value == $templateId;
        //         });
        //     }

        //     if($request->edit == "edit")
        //     {
        //        $existingTemplate = RosterTemplate::where(['id' => $request->template_id ])->first();
        //        if (!$existingTemplate) {
        //         return response()->json(['message' => 'Template not found'], 404);
        //         }
        //         // Compare only the specified fields
        //         $fieldsToCompare = ['start_time', 'end_time', 'break_minutes', 'color_code'];            
        //         $changes = [];
        //         foreach ($fieldsToCompare as $field) {
        //             if ($existingTemplate->$field != $validatedData[$field]) {
        //                 $changes[$field] = [
        //                     'old' => $existingTemplate->$field,
        //                     'new' => $validatedData[$field]
        //                 ];
        //             }
        //         }
        
        //         // If there are changes, return them
        //         if (empty($changes)) {
        //             return response()->json([
        //                 'message' => 'No Data  changed',
                       
        //             ]);
        //         }                     
        //     }
           
        //     if($overlapExists)
        //     {
                
        //         $matchingTemplates = RosterTemplate::whereIn('id', $overlapExists)->get();
    
        //         foreach ($matchingTemplates as $range) {
        //             $start = $range->start_time; 
        //             $end =  $range->end_time; 
        //             if ($this->isOverlap($fixedStartTime, $fixedEndTime, $start, $end)) {
        //                 return response()->json([
        //                     'message' => 'Shift Conflict :already assigned a shift during this time. Please choose a different time slot.  '
        //                 ],422);
                       
        //             }
        //         }
                
        //     }
           
        //   $deleted_able =   RosterTemplate::where(['id' => $request->template_id, 'is_saved' => '0'])->count();
        //   RosterAssign::where([
        //     'assign_to' => $request->user_id,
        //     'roster_template_id' =>  $request->template_id,
        //     'schedule_date' => $request->date,
        // ])->delete();
        //   if($deleted_able != 0)
        //   {
        //     RosterAssign::where([
        //         'assign_to' => $request->user_id,
        //         'roster_template_id' =>  $request->template_id,
        //         'schedule_date' => $request->date,
        //     ])->delete();
        //   }


            // if($request->save_shift == '1')
            // {
            //     RosterTemplate::insertGetId([
            //         'start_time' => $request->start_time,
            //         'end_time' => $request->end_time,
            //         'break_minutes' => $request->break_minutes,
            //         'color_code' => $request->color_code,
            //         'shift_notes' => $request->shift_notes,
            //         'repeat_shift' => '0',
            //         'repeat_every' => $request->repeat_shift == '1' ?  $request->repeat_every : '',
            //         'end_date' => $request->end_date,
            //         'is_saved' => $request->save_shift,
            //         'working_hours' => $required_minutes,
            //         'created_by' =>  Auth::user()->id
            //     ]);
            // }


            // $insert_id =   RosterTemplate::insertGetId([
            //     'start_time' => $request->start_time,
            //     'end_time' => $request->end_time,
            //     'break_minutes' => $request->break_minutes,
            //     'color_code' => $request->color_code,
            //     'shift_notes' => $request->shift_notes,
            //     'repeat_shift' => $request->repeat_shift,
            //     'repeat_every' => $request->repeat_shift == '1' ?  $request->repeat_every : '',
            //     'end_date' => $request->end_date,
            //     'working_hours' => $required_minutes,
            //     'is_saved' => '0',
            //     'created_by' =>  Auth::user()->id
            // ]);
            
            // $getDatesBetweens = $this->getDatesBetween($request->date, $request->end_date);
            // $header_date =  Carbon::parse($request->date);

            // if($request->repeat_shift == '1'){

            //     foreach ($getDatesBetweens as $key => $getDatesBetween) 
            //     {
            //         $getDatesBetween =  Carbon::parse($getDatesBetween);


            //         if($request->repeat_every == '2' )
            //         {
            //             if($header_date->format('D') == $getDatesBetween->format('D') && $key % 2 == 0 )
            //             {
            //                 RosterAssign::insertGetId([
            //                     'assign_to' => $request->user_id,
            //                     'roster_template_id' =>  $insert_id,
            //                     'schedule_date' => $getDatesBetween,
            //                 ]);

            //                     $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();

            //                     $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();

            //                     $history_arr = [
            //                         'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> assigned  shift '{$insert_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($getDatesBetween))."' date .",
            //                         'roster_template_id' => $insert_id
            //                     ];

            //                     $this->storeHistory($history_arr);
            //             }

            //         }
            //         else
            //         {
            //             if($header_date->format('D') == $getDatesBetween->format('D'))
            //             {
            //                 RosterAssign::insertGetId([
            //                     'assign_to' => $request->user_id,
            //                     'roster_template_id' =>  $insert_id,
            //                     'schedule_date' => $getDatesBetween,
            //                 ]);

            //                 $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();

            //                 $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();

            //                 $history_arr = [
            //                     'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> assigned  shift '{$insert_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($getDatesBetween))."' date .",
            //                     'roster_template_id' => $insert_id
            //                 ];

            //                 $this->storeHistory($history_arr);
            //             }

            //         }



            //     }
            // }
            // else
            // {
            //     RosterAssign::insertGetId([
            //         'assign_to' => $request->user_id,
            //         'roster_template_id' =>  $insert_id,
            //         'schedule_date' => $request->date,
            //     ]);

            //     $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();

            //     $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();
        
            //     $history_arr = [
            //         'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> assigned  shift '{$insert_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($request->date))."' date .",
            //         'roster_template_id' => $insert_id
            //     ];


            //     $this->storeHistory($history_arr);
        
        
               


            // }

            // if($request->publish)
            // {
            //     $this->publish_specific_person($request->user_id);
            // }


           

        //     return response()->json([
        //         'message' => 'Shift Create Successfully'
        //     ],200);

        // }
        
    }


    public function publish(Request $request)
    {
        $start_date = $request->start_date < date('Y-m-d')  ?  date('Y-m-d') :  $request->start_date;

        $this->publish_notify($start_date,$request->end_date,$request->note,$request->emp_arr);

        return response()->json([
            'message' => 'Publish Successfully'
        ],200);

    }

    public function publish_notify($start_date,$end_date,$note,$emp_arr)
    {

       $dates_array =  $this->getDatesBetween($start_date,$end_date);

       $roster_assigns = RosterAssign::whereIn('schedule_date', $dates_array)->pluck('assign_to')->unique()->toArray();
       $params = [];

       if($emp_arr)
       {
            $roster_assigns =  $emp_arr;
       }
     
       foreach($roster_assigns as $roster_assign)
       {
            $emp_company_details = EmpCompanyDetails::with('empPersonalDetails')->where('id', $roster_assign)->first();

            $params = [
                'subject' => 'Scheduler Notification | '.env("APP_NAME"),
                'to' => $emp_company_details->employee_email,
                'msg' => view('Emails/roster_email', ['email' => $emp_company_details->employee_email, 'name' => $emp_company_details->empPersonalDetails->first_name.' '.$emp_company_details->empPersonalDetails->middle_name.' '.$emp_company_details->empPersonalDetails->last_name , 'note' => $note, 'subject' => 'Scheduler Notification'])->render()
                ];

            dispatch(new SendEmailJob($params));
         $this->save_notifications('Scheduler Notification','Shift Assigned To You',Auth::user()->id,$roster_assign,'publish_roster_notification');          
       }

       return true;
    }

    public function publishCustom(Request $request)
    {

        $validator = Validator::make($request->all(), [
            'recipients' => 'required',
            'start_date' => 'required',
            'end_date' => 'required',
            'note' => 'required'
            
        ]);

        
        if ($validator->fails()) {

            $errors = $validator->errors()->first();

            return response()->json([
                'message' => $errors
            ],422);


        } else {

            
            if (strtotime($request->end_date) < strtotime($request->start_date)) {
                return response()->json([
                    'message' => 'End date must be bigger or equal to start date.'
                ], 400);
            }
            
            

        
        $items = $request->recipients;

        $emp_arr = [];


        if (in_array("all",  $items))
        {
            $EmpCompanyDetails = EmpCompanyDetails::where(['del' => '0','compeleted' => '1','approved' => '1', 'status' => '1'])->select('id')->get();
            
            foreach($EmpCompanyDetails as $EmpCompanyDetail)
            {
                if($EmpCompanyDetail->id == 1)
                {
                    continue; 
                }
                
                $emp_arr[] = $EmpCompanyDetail->id;
            }
        }
        else
        {
            foreach($items as $item)
            {
                $arr =  explode(".",$item);

                if($arr['0'] == 'employee')
                {
                    $EmpCompanyDetails = EmpCompanyDetails::where(['del' => '0','compeleted' => '1','approved' => '1', 'status' => '1', 'id' => $arr[1]])->select('id')->get();

                    foreach($EmpCompanyDetails as $EmpCompanyDetail)
                    {
                        if($EmpCompanyDetail->id == 1)
                        {
                            continue; 
                        }

                        $emp_arr[] = $EmpCompanyDetail->id;
                    }

                }

            }

        }

        $emp_arr = array_unique($emp_arr);

       
        

        


        $this->publish_notify($request->start_date,$request->end_date,$request->note,$emp_arr);

        return response()->json([
            'message' => 'Publish Successfully'
        ],200);

        }

    }

    public function publish_specific_person($emp_id)
    {
        $emp_company_details = EmpCompanyDetails::with('empPersonalDetails')->where('id', $emp_id)->first();

        $params = [
            'subject' => 'Scheduler Notification | '.env("APP_NAME"),
            'to' => $emp_company_details->employee_email,
            'blade' => view('Emails/roster_email', ['email' => $emp_company_details->employee_email, 'name' => $emp_company_details->empPersonalDetails->first_name.' '.$emp_company_details->empPersonalDetails->middle_name.' '.$emp_company_details->empPersonalDetails->last_name , 'note' => '', 'subject' => 'Scheduler Notification'])->render()
            ];

        dispatch(new SendEmailJob($params));
        $this->save_notifications('Scheduler Notification','Shift Assigned To You',Auth::user()->id,$emp_id,'publish_roster_notification');         
   
        return true;
    }

    public function show(RosterTemplate $rosterTemplate)
    {
        //
    }

    public function edit(RosterTemplate $rosterTemplate)
    {
        //
    }

    public function repeatShiftUpdate(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'user_id' => 'required',
            'date' => 'required',
            'template_id' => 'required',
            'publish' => 'required',
            'start_time' => 'required',
            'end_time' => 'required',
            'break_minutes' => 'required',
            'color_code' => 'required',
            'shift_notes' => 'required',
            'repeat_shift' => 'required',
            'repeat_every' => 'required',
            'end_date' => 'required',
            'save_shift' => 'required',
            'edit' => 'nullable',
            'publish' => 'required'
        ]);


       

        
        if ($validator->fails()) {

            $errors = $validator->errors()->first();

            return response()->json([
                'message' => $errors
            ],422);


        } else {

            $validatedData =  $validator->validated();

            $start_ = Carbon::parse($request->start_time);
            $end_ = Carbon::parse($request->end_time);
            $required_minutes =  $end_->diffInMinutes($start_); 
            $required_minutes = $required_minutes - $request->break_minutes ?? 0;

            

            if($request->date < date('Y-m-d'))
            {
                return response()->json([
                    'message' => 'Scheduler does not allow changes to be made for past dates.'
                ],422); 
            }

            if($request->end_date < $request->date)
            {
                return response()->json([
                    'message' => 'End Date must be bigger than or Equal to '.date('d-m-Y', strtotime($request->date)).' date.'
                ],422); 
            }

            $todays_date  = date('Y-m-d');

            if($request->save_shift == '1')
            {
                RosterTemplate::insertGetId([
                    'start_time' => $request->start_time,
                    'end_time' => $request->end_time,
                    'break_minutes' => $request->break_minutes,
                    'color_code' => $request->color_code,
                    'shift_notes' => $request->shift_notes,
                    'repeat_shift' => '0',
                    'repeat_every' => $request->repeat_shift == '1' ?  $request->repeat_every : '',
                    'end_date' => $request->end_date,
                    'is_saved' => $request->save_shift,
                    'working_hours' => $required_minutes,
                    'created_by' =>  Auth::user()->id
                ]);
            }

            $insert_id =   RosterTemplate::insertGetId([
                'start_time' => $request->start_time,
                'end_time' => $request->end_time,
                'break_minutes' => $request->break_minutes,
                'color_code' => $request->color_code,
                'shift_notes' => $request->shift_notes,
                'repeat_shift' => $request->repeat_shift,
                'repeat_every' => $request->repeat_shift == '1' ?  $request->repeat_every : '',
                'end_date' => $request->end_date,
                'working_hours' => $required_minutes,
                'is_saved' => '0',
                'created_by' =>  Auth::user()->id
            ]);


            // $getDates = RosterAssign::where([

            //     ['assign_to', '=', $request->user_id],
            //     ['roster_template_id', '=', $request->template_id],
            //     ['schedule_date', '>=', $todays_date]

            // ])->get();


            
            
            RosterAssign::where([

                ['assign_to', '=', $request->user_id],
                ['roster_template_id', '=', $request->template_id],
                ['schedule_date', '>=', $request->date]

            ])->delete();

         


            $getDatesBetweens = $this->getDatesBetween($request->date, $request->end_date);
            $header_date =  Carbon::parse($request->date);


            foreach ($getDatesBetweens as $key => $getDatesBetween) 
            {
                $getDatesBetween =  Carbon::parse($getDatesBetween);


                if($request->repeat_every == '2' )
                {
                    if($header_date->format('D') == $getDatesBetween->format('D') && $key % 2 == 0 )
                    {
                        RosterAssign::insertGetId([
                            'assign_to' => $request->user_id,
                            'roster_template_id' =>  $insert_id,
                            'schedule_date' => $getDatesBetween,
                        ]);

                            $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();

                            $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();

                            $history_arr = [
                                'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> assigned  shift '{$insert_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($getDatesBetween))."' date .",
                                'roster_template_id' => $insert_id
                            ];

                            $this->storeHistory($history_arr);
                    }

                }
                else
                {
                    if($header_date->format('D') == $getDatesBetween->format('D'))
                    {
                        RosterAssign::insertGetId([
                            'assign_to' => $request->user_id,
                            'roster_template_id' =>  $insert_id,
                            'schedule_date' => $getDatesBetween,
                        ]);

                        $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();

                        $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();

                        $history_arr = [
                            'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> updated  shift '{$insert_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($getDatesBetween))."' date .",
                            'roster_template_id' => $insert_id
                        ];

                        $this->storeHistory($history_arr);
                    }

                }



            }

            // $yesterday = Carbon::yesterday();

            // RosterTemplate::where('id',$request->template_id)->update([
            //     'end_date' =>  $yesterday->format('Y-m-d')
            // ]);

         


            // foreach($getDates as $getDate)
            // {
            //     // if(Carbon::parse($getDate->schedule_date) <= Carbon::parse($request->end_date) ){

            //         RosterAssign::insertGetId([
            //             'assign_to' => $request->user_id,
            //             'roster_template_id' =>  $insert_id,
            //             'schedule_date' => $getDate->schedule_date
            //         ]);



            //     $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();

            //     $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();

            //     $history_arr = [
            //         'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> updated  shift '{$insert_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($getDate->schedule_date))."' date .",
            //         'roster_template_id' => $insert_id
            //     ];

            //     $this->storeHistory($history_arr);

            //     // }
            // }


            return response()->json([
                'message' => 'Shift Updated Successfully'
            ],200);

        }
        
    }

    public function destroy(Request $request)
    {
      
       if($request->repeat_shift == '1')
       {
            if($request->to_all_shift == '1')
            {
                $this->rosterTemplateDelete($request->template_id);
                RosterAssign::where([
                    ['assign_to', '=', $request->user_id],
                    ['roster_template_id', '=', $request->template_id],
                    ['schedule_date', '>=', $request->date],
                ])->delete();
                  

                
                $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();

                $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();

                $rosterTemplate  = RosterTemplate::where('id', $request->template_id)->first();

        
                $history_arr = [
                    'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> deleted shifts which where assigned  '{$request->template_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($request->date))."' to '".date('d-m-Y', strtotime($rosterTemplate->end_date))."' date .",
                    'roster_template_id' => $request->template_id
                ];



            }
            else
            {
                if($request->date < date('Y-m-d'))
                {
                    return response()->json([
                    'message' => 'Scheduler does not allow changes to be made for past dates.'
                    ],422); 
                }
                  $this->rosterTemplateDelete($request->template_id);
                RosterAssign::where([
                    ['assign_to', '=', $request->user_id],
                    ['roster_template_id', '=', $request->template_id],
                    ['schedule_date', '=', $request->date],
                ])->delete();
               
                
                $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();

                $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();
        
                $history_arr = [
                    'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> deleted a shifts which was assigned  '{$request->template_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($request->date))."' date .",
                    'roster_template_id' => $request->template_id
                ];

            }
       }
       else
       {
                if($request->date < date('Y-m-d'))
                {
                    return response()->json([
                        'message' => 'Scheduler does not allow changes to be made for past dates.'
                    ],422); 
                }
            $this->rosterTemplateDelete($request->template_id);
            RosterAssign::where([
                ['assign_to', '=', $request->user_id],
                ['roster_template_id', '=', $request->template_id],
                ['schedule_date', '=', $request->date],
            ])->delete();
           

            $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();

            $empPersonalDetails  = EmpPersonalDetails::where('emp_id', $request->user_id)->first();
     
            $history_arr = [
                'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> deleted a shifts which was assigned  '{$request->template_id}' template to '{$empPersonalDetails->first_name} {$empPersonalDetails->middle_name} {$empPersonalDetails->last_name}'  at '".date('d-m-Y', strtotime($request->date))."' date .",
                'roster_template_id' => $request->template_id
            ];
       }


       $this->storeHistory($history_arr);




    }

    public function rosterTemplateDelete($templateId)
    {
        $rosterTemplate  = RosterTemplate::where('id', $templateId)->first();
        if($rosterTemplate->is_saved != 1)
        {
           $rosterAssignee = RosterAssign::where('roster_template_id',$templateId)->count();
           if($rosterAssignee == 1)
           {
                 $data = RosterTemplate::where('id', $templateId)->delete();
                return response()->json([
                    'message' => 'Template Deleted Successfully.'.$rosterTemplate
                ],200);
           }

        }
       
        
    }

    function getDatesBetween($start_date, $end_date)
    {
        $dates = [];

        $start = Carbon::parse($start_date);
        $end = Carbon::parse($end_date);

        while ($start->lte($end)) {
            $dates[] = $start->toDateString();
            $start->addDay();
        }

        return $dates;
    }

    public function getHistory(Request $request)
    {
        $history =   RosterHistory::orderBy('id', 'DESC')->get();

        $data['history'] = $history;

        return response()->json([
            'message' => 'Get History Successfully',
            'data'   => $data
        ],200);
    }

    public function storeHistory($arr)
    {
        RosterHistory::create([
            'roster_template_id' => $arr['roster_template_id'],
            'updated_by' => Auth::user()->id,
            'description' => $arr['description']
        ]);

    }


    public function rosterApi(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'emp_id' => 'required',
            'date' => 'required'
        ]);
        
        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error
            ],422);


        } else {
          
                $validatedData =  $validator->validated();
                $RosterAssigns = RosterAssign::with('rosterTemplate')->where(['assign_to' => $validatedData['emp_id'],'schedule_date' => $validatedData['date']])->get();

               $data['roster'] =  $RosterAssigns;
      
                return response()->json([
                'message' => 'Get Roster Successfully',
                'data' => $data
                ],200);


        }

    }



    public function bulkScheduleSave(Request $request)
    {
       
        $validator = Validator::make($request->all(), [
            'start_date' => 'required',
            'end_date' => 'required|after_or_equal:start_date',
            'start_time' => 'required',
            'end_time' => 'required|after:start_time',
            'color_code' => 'required',
            'break_minutes' => 'required',
            'shift_notes' => 'required',
            'users_ids' => ['required', 'array', 'min:1'],
            'working_days_hidden' => 'required'
        ],[

            'end_time.after' => 'End time must be after start time',
            'users_ids.required' => 'Please select atleast one employee',
            'working_days_hidden.required' => 'Please select atleast one day'
        ]);

        
        if ($validator->fails()) {

            $errors = $validator->errors()->first();

            return response()->json([
                'message' => $errors
            ],422);


        } 
        else 
        {
              if($request->start_date < date('Y-m-d'))
            {
                return response()->json([
                    'message' => 'Scheduler does not allow changes to be made for past dates.'
                ],422); 
            }

            $arr = [
                'start_date' => $request->start_date,
                'end_date' => $request->end_date,
                'start_time' => $request->start_time,
                'end_time' => $request->end_time,
                'color_code' => $request->color_code,
                'break_minutes' => $request->break_minutes,
                'shift_notes' => $request->shift_notes,
                'users_ids' => $request->users_ids,
                'working_hours' => $request->working_hours,
                'working_days_hidden' =>$request->working_days_hidden
            ];
           
            return $this->bulkScheduleRoasterCreate($arr,$arr);
        }


           
        //    $validatedData =  $validator->validated();
        //     $days_array =  explode(",", $validatedData['working_days_hidden']);
        //     $start_ = Carbon::parse($request->start_time);
        //     $end_ = Carbon::parse($request->end_time);
        //     $required_minutes =  $end_->diffInMinutes($start_); 
        //     $required_minutes = $required_minutes - $request->break_minutes ?? 0;

          

            // $getDatesBetweens = $this->getDatesBetween($request->start_date, $request->end_date);

            


            //  foreach($getDatesBetweens as $for_this_date)
            //  {
            //     if(!in_array(Carbon::parse($for_this_date)->format('D'), $days_array))
            //     {
            //         continue;
            //     }
            //     foreach($request->users_ids as  $user_id)
            //     {         
            //         $fixedStartTime = $request->start_time; 
            //         $fixedEndTime = $request->end_time; 
            //         $overlapExists = RosterAssign::where('assign_to', $user_id)
            //                 ->where('schedule_date', $for_this_date)
            //                 ->pluck('roster_template_id');
            //         if ($overlapExists->isNotEmpty()) {
            //             // Fetch the matching templates
            //             $matchingTemplates = RosterTemplate::whereIn('id', $overlapExists)->get();
                        
            //             // Iterate through the matching templates to check for overlaps
            //             foreach ($matchingTemplates as $range) {
            //                 $start = $range->start_time; 
            //                 $end = $range->end_time; 
                            
            //                 // Check if there is an overlap
            //                 if ($this->isOverlap($fixedStartTime, $fixedEndTime, $start, $end)) {
            //                     $emp= EmpCompanyDetails::find($user_id);
            //                     return response()->json([
            //                         'message' => 'Shift Conflict'.' '
            //                         . $emp->empPersonalDetails->first_name . ' '
            //                         . ($emp->empPersonalDetails->middle_name ? $emp->empPersonalDetails->middle_name . ' ' : '') // Check if middle name exists
            //                         . $emp->empPersonalDetails->last_name.' '
            //                         .':is already assigned a shift during this time. Please choose a different time slot.'
            //                     ], 422);
                               
            //                 }
            //                 else{
            //                     // return response()->json([
            //                     //     'message' => 'Done  Please choose a different time slot. '
            //                     // ],422);
            //                 }
                            
            //             }
            //         }  
                    

            //     }

            //  }

            //  $insert_id = 0;
            //  $shiftAlreadyCreated = false;
            // foreach($getDatesBetweens as $for_this_date)
            // {
                
            //     // $insert_id = 0;
            //     if(!in_array(Carbon::parse($for_this_date)->format('D'), $days_array))
            //     {
            //         continue;
            //     }

            //     foreach($request->users_ids as  $user_id)
            //     {         
            //         // remove  

            //         // $fixedStartTime = $request->start_time; 
            //         // $fixedEndTime = $request->end_time; 
            //         // $overlapExists = RosterAssign::where('assign_to', $user_id)
            //         //         ->where('schedule_date', $for_this_date)
            //         //         ->pluck('roster_template_id');
            //         // if ($overlapExists->isNotEmpty()) {
            //         //     // Fetch the matching templates
            //         //     $matchingTemplates = RosterTemplate::whereIn('id', $overlapExists)->get();
                        
            //         //     // Iterate through the matching templates to check for overlaps
            //         //     foreach ($matchingTemplates as $range) {
            //         //         $start = $range->start_time; 
            //         //         $end = $range->end_time; 
            //         //         $emp= EmpCompanyDetails::find($user_id);
            //         //         // Check if there is an overlap
            //         //         return response()->json([
            //         //             'message' => 'Shift Conflict'.' '
            //         //             . $emp->empPersonalDetails->first_name . ' '
            //         //             . ($emp->empPersonalDetails->middle_name ? $emp->empPersonalDetails->middle_name . ' ' : '') // Check if middle name exists
            //         //             . $emp->empPersonalDetails->last_name.' '
            //         //             .':is already assigned a shift during this time. Please choose a different time slot.'
            //         //         ], 422);
            //         //     }
            //         // }  

            //         // remove
            //         if (!$shiftAlreadyCreated) {
            //             $insert_id =   RosterTemplate::insertGetId([
            //                 'start_time' => $request->start_time,
            //                 'end_time' => $request->end_time,
            //                 'break_minutes' => $request->break_minutes,
            //                 'color_code' => $request->color_code,
            //                 'shift_notes' => $request->shift_notes,
            //                 'repeat_shift' => 0,
            //                 'repeat_every' => 0,
            //                 'end_date' => $for_this_date,
            //                 'working_hours' => $required_minutes,
            //                 'is_saved' => '0',
            //                 'created_by' =>  Auth::user()->id
            //             ]);
            //             $shiftAlreadyCreated = true;
            //         }

            //         RosterAssign::insertGetId([
            //             'assign_to' => $user_id,
            //             'roster_template_id' =>  $insert_id,
            //             'schedule_date' => $for_this_date,
            //         ]);

            //     }


            // }
        





            // ////// history //////

            // $authPersonalDetails = EmpPersonalDetails::where('emp_id', Auth::user()->id)->first();
        
            // $history_arr = [
            //     'description' => "<a href='".url('/')."/user-profile/".Auth::user()->id."' style='text-transform: capitalize;' role='button' class='primary text-decoration-none'> {$authPersonalDetails->first_name} {$authPersonalDetails->middle_name} {$authPersonalDetails->last_name}</a> created a bulk schedule at ".date('d-m-Y')." date",
            //     'roster_template_id' => 0
            // ];

            // $this->storeHistory($history_arr);

            ////// history end //////

            // return response()->json([
            //     'message' => 'Bulk Schedule Created Successfully'
            // ],200);

        // }
        
    }

    public function deleteTemplate(Request $request){
        $validator = Validator::make($request->all(), [
            'start_time' => 'required',
            'end_time' => 'required|after:start_time',
            'start_date' => 'required',
            'end_date' => 'required|after_or_equal:start_date',
            'users_ids' => ['required', 'array', 'min:1'],
        ],[
            'end_time.after' => 'End time must be after start time',
            'users_ids.required' => 'Please select atleast one employee',
        ]);
        if ($validator->fails()) {

            $errors = $validator->errors()->first();

            return response()->json([
                'message' => $errors
            ],422);
        }

        $roster_template_ids = RosterTemplate::join('roster_assigns','roster_templates.id','roster_assigns.roster_template_id')
                            ->where('roster_templates.start_time', $request->start_time)->where('roster_templates.end_time',$request->end_time)
                            ->where('roster_assigns.schedule_date','<=',$request->end_date)
                            ->where('roster_assigns.schedule_date','>=',$request->start_date)
                            ->whereIn('roster_assigns.assign_to',$request->users_ids)
                            ->pluck('roster_assigns.id as template_assign_id')->toArray();
                            
        $count = count($roster_template_ids);
        //  RosterAssign::whereIn('id',$roster_template_ids)->delete();
        foreach ($roster_template_ids as $template_assign_id) {
            $template = RosterAssign::where('id',$template_assign_id)->first();
            RosterAssign::where('id', $template_assign_id)->delete();
            
            if($template)
            {
                $this->rosterTemplateDelete($template->roster_template_id); // Testing is remaing data is passing template instead of assignee 
            }
             
        }
        return response()->json([
            'message' => 'Roster deleted successfully ',
            'data' => []
        ],200);
    }
    public function templateDelete(Request $request)
    {
        $validator = Validator::make(
            $request->all(),
            [
                "template_id" => "required|exists:roster_templates,id",
            ],
            [
                "template_id.exists" => "Template not found",
            ]
        );
    
        if ($validator->fails()) {
            $errors = $validator->errors()->first();
            return response()->json(
                [
                    "message" => $errors,
                ],
                422
            );
        }
       
        $templateId = $request->input('template_id');
        
        // Find the template along with its related assigns
        $roster_template = RosterTemplate::with(['assigns' => function ($query) {
            $query->where('schedule_date', '>=', now()->toDateString()); // Filtering to include only today's and future assigns
        }])
        ->find($templateId);
                                        
        if ($roster_template) {
            // Delete all the filtered related assigns (roster_assigns)
            foreach ($roster_template->assigns as $assign) {
                $assign->delete(); // Delete each filtered assign
            }
    
            // Check if all assigns are deleted or only the filtered ones
            if ($roster_template->assigns()->exists()) {
                $roster_template->update(['status' => 0]);
                return response()->json(['success' => 'Only future and todays assignments deleted']);
            } else {
                // Now delete the template itself if no assigns are left
                $roster_template->delete();
                return response()->json(['success' => 'Template and its assignments deleted successfully']);
            }
        } else {
            return response()->json(['error' => 'Template not found'], 404);
        }
    }


    public function rosterDataCleanApi($id)
    {
         $roster_template_ids =  RosterTemplate::find($id);
          // this code get same roster according to Start Time , End Time and Color Code 
          $getSameRoster =RosterTemplate::where('start_time', $roster_template_ids->start_time)
                        ->where('end_time',$roster_template_ids->end_time)
                        ->where('color_code',$roster_template_ids->color_code)
                        // ->where('end_date',$roster_template_ids->end_date)  //this end time is seprate confirm end time is nessary or not 
                        ->pluck("id")
                        ->toArray();
                        // Important aslo discusss Date start-date and End-date
            // this count to confim entry in Roster Template and Assigne Template   
             return   $getSameRoster;  
            $totaleRosterCount = count($getSameRoster);
            // this code get Assignee roster according to  the list $getSameRoster roaster where start Time, End Time and Color Code
            $assigneRoster = RosterAssign::whereIn('roster_template_id',$getSameRoster)->get();
            // this count to confim entry in Roster Template and Assigne Template            
             $totaleAssigneRoster = count($assigneRoster);
            // update roster_template_id to passing roaster id on params
            $assigneRoster =RosterAssign::whereIn('roster_template_id', $getSameRoster)
            ->update(['roster_template_id' => $id]);

            

            // Filter array to remove 
            $sameRosterRemove = array_values(array_filter($getSameRoster, function($value) use ($id) {
                return intval($value) !== intval($id);
            }));

            // delete  repated  data 
            $assigneRoster = RosterTemplate::whereIn('id',$sameRosterRemove)->delete();

           

         return $assigneRoster;
        
    }
    // This is not done yet  i calculata this  and testing is remaing  
    public function rosterDataCleanApiloop($limit, $badge)
    {
        // Calculate the start and end IDs based on the limit and badge.
        $startId = ($badge - 1) * $limit + 1;
        $endId = $badge * $limit;
         // Initialize a counter for the total deleted roster templates.
        $totalDeleted = 0;
       
        // Loop through the range of IDs.
        for ($id = $startId; $id <= $endId; $id++) {
            // Step 1: Retrieve the roster template based on the current ID.
            $roster_template_ids = RosterTemplate::find($id);

            if (!$roster_template_ids) {
                continue; // Skip if the roster template doesn't exist.
            }

            // Step 2: Find all roster templates with the same start time, end time, and color code as the current one.
            $getSameRoster = RosterTemplate::where('start_time', $roster_template_ids->start_time)
                            ->where('end_time', $roster_template_ids->end_time)
                            ->where('color_code', $roster_template_ids->color_code)
                             // ->where('end_date',$roster_template_ids->end_date)  //this end time is seprate confirm end time is nessary or not  also check on live and ensure  
                            ->pluck("id")
                            ->toArray();

            // Step 3: Count the number of matching roster templates.
            $totaleRosterCount = count($getSameRoster);

            // // Step 4: Find all `RosterAssign` entries that reference the matching roster templates. (for testing and checking )
            // $assigneRoster = RosterAssign::whereIn('roster_template_id', $getSameRoster)->get();

            // Step 5: Update the `roster_template_id` in `RosterAssign` entries to the current template ID (`$id`).
            $assigneRoster = RosterAssign::whereIn('roster_template_id', $getSameRoster)
                                        ->update(['roster_template_id' => $id]);
           
            // Step 6: Filter out the current template ID (`$id`) from the list of matching roster template IDs.
            $sameRosterRemove = array_values(array_filter($getSameRoster, function($value) use ($id) {
                return intval($value) !== intval($id);
            }));

            // Step 7: Delete the remaining duplicate roster templates.
            $deleted =  RosterTemplate::whereIn('id', $sameRosterRemove)->where('is_saved', '!=', 1)->delete();
            $totalDeleted += $deleted;
        }

        // Optionally, you can return a message or the number of cleaned records.
        return response()->json([
            'message' => "Roster data cleaned for ID range $startId to $endId.",
            'total_deleted' => $totalDeleted
        ]);
    }


}
