<?php

namespace App\Http\Controllers;

use App\Models\Settings;
use App\Models\ReportLog;
use Illuminate\Http\Request;
use App\Models\AttendanceLog;
use App\General\SettingsClass;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Intervention\Image\ImageManager;
use Illuminate\Support\Facades\Validator;

class SettingsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $settings = Settings::get();
        $webLogo  = SettingsClass::getOptionValue('_web_logo', $settings);
        return view('Settings/settings',compact('settings','webLogo'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $meta_ = $request->only([
            '_web_logo',
            '_financial_year_end_date',
            '_financial_year_start_date',
            '_financial_year_end_month',
            '_financial_year_start_month',
            '_working_days',
            '_time_zone',
        ]);

        $settings = Settings::get();

        if ($request->hasFile('_web_logo')) {
            $image = $request->file('_web_logo');
            $imageName = time() . '.' . $image->getClientOriginalExtension();
            $image->move(public_path('upload/images'), $imageName);
            $meta_['_web_logo'] = 'upload/images/' . $imageName;
        } else {
            $webLogo = SettingsClass::getOptionValue('_web_logo', $settings);
            if ($webLogo) {
                $meta_['_web_logo'] = $webLogo;
            }
        }

        $settingsMeta = [];

        foreach ($meta_ as $option => $value) {
            if ($value !== null) {
                $settingsMeta[] = [
                    
                    'option' => $option,
                    'value' => $value,
                ];
            }
        }
        DB::table('settings')->whereIn('option', [
            '_financial_year_end_date',
            '_financial_year_start_date',
            '_financial_year_end_month',
            '_financial_year_start_month',
            '_working_days',
            '_time_zone',
            '_web_logo',
        ])->delete();

        DB::table('settings')->insert($settingsMeta);

        return redirect()->back()->with('success', 'Settings Updated Successfully.');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        //
    }

    public function getInternalEmployeeRosterSetting(){
        $roster_setting = DB::table('settings')->whereIn('option', [
            'roster_setting_title',
            'roster_setting_paid_break',
            'roster_setting_color_code',
            'roster_setting_start_time',
            'roster_setting_end_time',
            'roster_setting_description',
            'roster_setting_working_hours',
            'roster_setting_working_days',
            'roster_setting_number_of_days',
        ])->select('option','value')->get();

        return response()->json([
            'message' => 'Get Internal Employee Roster Setting Successfully.',
            'data' => $roster_setting
        ],200);
    }
    
    public function internalEmployeeRosterSetting(Request $request){

        $validator = Validator::make($request->all(), [
            'title' => 'required|string|max:255',
            'paid_break' => 'required|integer|min:0',
            'color_code' => 'nullable|regex:/^#[0-9a-fA-F]{6}$/',
            'start_time' => 'required',
            'end_time' => 'required',
            'description' => 'nullable',
            'working_hours' => 'nullable',
            'working_days' => 'required|array',
            'number_of_days' => 'required|integer|min:1|max:365',
        ],
        [
            'working_days.required' => 'Please select one or more working days'
        ]
        );

        if ($validator->fails()) {

            $error = $validator->errors()->first();

            return response()->json([
                'message' => $error                
            ],422);
        }

        $meta = $request->only([
            'title',
            'paid_break',
            'color_code',
            'start_time',
            'end_time',
            'description',
            'working_hours',
            'working_days',
            'number_of_days',
        ]);

        DB::table('settings')->whereIn('option', [
            'roster_setting_title',
            'roster_setting_paid_break',
            'roster_setting_color_code',
            'roster_setting_start_time',
            'roster_setting_end_time',
            'roster_setting_description',
            'roster_setting_working_hours',
            'roster_setting_working_days',
            'roster_setting_number_of_days',
        ])->delete();
        
        $settingsMeta = [];

        foreach ($meta as $option => $value) {
            if ($value !== null) {
                if($option == 'working_days'){
                    $value = implode(',', $value);
                }
                $settingsMeta[] = [
                    'option' => "roster_setting_".$option,
                    'value' => $value,
                ];
            }
        }

        DB::table('settings')->insert($settingsMeta);

        return response()->json([
            'message' => 'Internal Employee Roster Setting Saved.',
            'data' => $settingsMeta
        ],200);
    }

    public function getAttendanceLogs(Request $request)
    {
        $query = AttendanceLog::query();

        if($request->filled('filter'))
        {
          $query =  $this->filter(json_decode($request->filter, true),$query);
        }
  
        $query->with(['EmpPersonalDetails','EmpCompanyDetails','Sites']);

        $count = $query->count();
        $start = $request->input('from', 0);
        $query->offset($start)->limit(10);
        $query->orderBy('id', 'desc');
        $query_result = $query->get();

        $data =  [
            'attendances' => $query_result,
            'all_sites' => sitesList()
        ];
        $array_filter =  json_decode($request->filter, true);
        $filters = [
          'first_name' => $array_filter['first_name'] ?? '', 
          'middle_name' => $array_filter['middle_name'] ?? '',
          'last_name' => $array_filter['first_name'] ?? '',
          'employee_email' => $array_filter['last_name'] ?? '',
          'compeleted' => $array_filter['first_name'] ?? '',
          'status' => $array_filter['compeleted'] ?? '',
        ];

        return response()->json([
            'message' => 'Get Attendance List Successfully',
            'data' => $data,
            'count' => $count,
            'filters' => $filters
        ],200);


    }

    public function filter($filters,$query)
    {
     
        foreach ($filters as $filterName => $filterValue) {
            if ($filterValue != null ||  $filterValue !="" ) {
                switch ($filterName) {
                    case 'first_name':
                        $filterValue  = explode(" ",$filterValue);
                    
                        if(count($filterValue) == 1)
                        {
                            $query->whereHas('empPersonalDetails', function ($subquery) use ($filterValue) {
                                $subquery->where('first_name', 'like', '%' . $filterValue[0] . '%');
                                $subquery->orWhere('middle_name', 'like', '%' . $filterValue[0] . '%');
                                $subquery->orWhere('last_name', 'like', '%' . $filterValue[0] . '%');
                            });

                        }

                        if(count($filterValue) == 2)
                        {
                            $query->whereHas('empPersonalDetails', function ($subquery) use ($filterValue) {
                                $subquery->where('first_name', 'like', '%' . $filterValue[0] . '%');
                                $subquery->where('middle_name', 'like', '%' . $filterValue[1] . '%');
                                $subquery->where('last_name', 'like', '%' . $filterValue[1] . '%');
                            });

                        }

                        if(count($filterValue) == 3)
                        {
                            $query->whereHas('empPersonalDetails', function ($subquery) use ($filterValue) {
                                $subquery->where('first_name', 'like', '%' . $filterValue[0] . '%');
                                $subquery->where('middle_name', 'like', '%' . $filterValue[1] . '%');
                                $subquery->where('last_name', 'like', '%' . $filterValue[2] . '%');
                            });
                        }
                    break;
                    case 'title':
                        $query->whereHas('sites', function ($subquery) use ($filterValue) {
                            $subquery->where('title', 'like', '%' . $filterValue . '%');
                        });
                    break;
                    case 'date':
                        $query->where('date','=',formatDate($filterValue));
                    break;    
                  }
              }
        }

        return $query;
    }
    public function getReportsLogs(Request $request)
    {
    $query = ReportLog::query();

    if ($request->filled('filter')) {
        $query = $this->Reportfilter(json_decode($request->filter, true), $query);
    }
    $query->with(['emppersonaldetails', 'empcompanydetails']);

    $count = $query->count();
    $start = $request->input('from', 0);
    $query->offset($start)->limit(10)->orderBy('id', 'desc'); // Moved orderBy to the correct position

    $query_result = $query->get();
    $data = [
        'attendances' => $query_result,
    ];

    $array_filter = json_decode($request->filter, true);
    $filters = [
        'first_name' => $array_filter['first_name'] ?? '',
        'middle_name' => $array_filter['middle_name'] ?? '',
        'last_name' => $array_filter['last_name'] ?? '', // Corrected key
        'employee_email' => $array_filter['employee_email'] ?? '', // Corrected key
        'completed' => $array_filter['completed'] ?? '', // Corrected key
        'status' => $array_filter['status'] ?? '', // Corrected key
    ];

    return response()->json([
        'message' => 'Get Attendance List Successfully',
        'data' => $data,
        'count' => $count,
        'filters' => $filters
    ], 200);
    }

    public function Reportfilter($filters,$query)
    {
      
        foreach ($filters as $filterName => $filterValue) {
            if ($filterValue != null ||  $filterValue !="" ) {
                switch ($filterName) {
                    case 'first_name':
                        $filterValue  = explode(" ",$filterValue);
                    
                        if(count($filterValue) == 1)
                        {
                            $query->whereHas('empPersonalDetails', function ($subquery) use ($filterValue) {
                                $subquery->where('first_name', 'like', '%' . $filterValue[0] . '%');
                                $subquery->orWhere('middle_name', 'like', '%' . $filterValue[0] . '%');
                                $subquery->orWhere('last_name', 'like', '%' . $filterValue[0] . '%');
                            });

                        }

                        if(count($filterValue) == 2)
                        {
                            $query->whereHas('empPersonalDetails', function ($subquery) use ($filterValue) {
                                $subquery->where('first_name', 'like', '%' . $filterValue[0] . '%');
                                $subquery->where('middle_name', 'like', '%' . $filterValue[1] . '%');
                                $subquery->where('last_name', 'like', '%' . $filterValue[1] . '%');
                            });

                        }

                        if(count($filterValue) == 3)
                        {
                            $query->whereHas('empPersonalDetails', function ($subquery) use ($filterValue) {
                                $subquery->where('first_name', 'like', '%' . $filterValue[0] . '%');
                                $subquery->where('middle_name', 'like', '%' . $filterValue[1] . '%');
                                $subquery->where('last_name', 'like', '%' . $filterValue[2] . '%');
                            });
                        }
                    break;
                    case 'report_type':
                        $query->where('report_type', $filterValue);
                        break;
                        
                    case 'date':
                          
                            $query->whereDate('created_at', '=', $filterValue);
                            break;   
                  }
              }
        }

        return $query;
    }
}
