<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class DynamicMail extends Mailable
{
    use Queueable, SerializesModels;
    public $data;
    public $subject;
    public $template;
    /**
     * Create a new message instance.
     *
     * @return void
     */
    public function __construct($data, $subject, $template)
    {
        $this->data = $data;
        $this->subject = $subject;
        $this->template = $template;    }

    /**
     * Build the message.
     *
     * @return $this
     */
    public function build()
    {
        return $this->from(env('MAIL_FROM_ADDRESS'))
        ->subject($this->subject)
        ->view($this->template)
        ->with('data', $this->data);
    }
}
