<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AttendanceLog extends Model
{
    use HasFactory;
    protected $fillable = [
        'employee_id',
        'site_id',
        'check_in',
        'check_out',
        'date',
        'longitude',
        'latitude',
        'message',
        'error_type',
        'request_type'
    ];

    public function emppersonaldetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'employee_id', 'emp_id');
    }
    public function empcompanydetails()
    {
        return $this->belongsTo(EmpCompanyDetails::class,'employee_id', 'id');
    }
    public function sites()
    {
        return $this->belongsTo(Sites::class,'site_id');
    }
}
