<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;
use Illuminate\Database\Eloquent\Model;

class EmpCompanyDetails extends Authenticatable
{
    use HasApiTokens, HasFactory, Notifiable;
    
    protected $table = 'emp_company_details';
    protected $fillable = ['employee_email','employment_type','remember_token','access_role','work_permit_type','tax_file_no','tier_id','employment_start_date','employment_end_date','attendance_effective_from','status','invited','password','approved','approved_by','approved_at','created_by','is_submitted','compeleted','rejected','force_reset'];

    
    public function empPersonalDetails()
    {
        return $this->hasOne(EmpPersonalDetails::class, 'emp_id', 'id');
    }

    public function accessRole()
    {
        return $this->hasOne(Role::class, 'code', 'access_role');
    }
    public function accessTier()
    {
        return $this->hasOne(Tier::class, 'id', 'tier_id');
    }
    public function workerType()
    {
        return $this->hasOne(EmpWorkerType::class, 'id', 'worker_type');
    }

    public function workExperience()
    {
        return $this->hasOne(EmpWorkExperience::class, 'id', 'work_experience');
    }

    public function tierEmpPersonalDetail()
    {
        return $this->hasOne(EmpPersonalDetails::class, 'emp_id', 'id')->select('emp_id','image');
    }

    public function empAccess()
    {
        return $this->hasOne(EmpAccess::class, 'emp_id', 'id');
    }

    public function empTier()
    {
        return $this->hasOne(Tier::class, 'id', 'tier_id');
    }

    public function empEmergencyContacts()
    {
        return $this->hasMany(EmpEmergencyContacts::class, 'emp_id', 'id');
    }

    public function empDocuments()
    {
        return $this->hasMany(EmpDocuments::class, 'emp_id', 'id');
    }

    public function empTeamsMembers()
    {
        return $this->hasMany(EmpTeamsMember::class, 'emp_id', 'id')->with('empTeamsList');
    }

    public function rosterAssign()
    {
        return $this->hasOne(RosterAssign::class, 'assign_to', 'id');
    }

    public function empMetaData()
    {
        return $this->hasMany(UserMeta::class, 'emp_id', 'id');
    }
    public function payrolls()
{
    return $this->hasMany(Payroll::class, 'employee_id');
}


}


