<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EmployeeAttendance extends Model
{
    use HasFactory;
    protected $fillable = [
        'employee_id',
        'roster_template_id',
        'site_id',
        'added_by',
        'status',
        'approved_by',
        'check_in',
        'check_out',
        'date',
        'working_hours',
        'image'
    ];

    public function emppersonaldetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'employee_id', 'emp_id');
    }

    public function empTeamsMembers()
    {
        return $this->hasMany(EmpTeamsMember::class, 'emp_id', 'employee_id')->with('empTeamsList');
    }

    public function empcompanydetails()
    {
        return $this->belongsTo(EmpCompanyDetails::class,'employee_id', 'id');
    }

    public function addedby()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'added_by', 'emp_id');
    }

    public function sites()
    {
        return $this->belongsTo(Sites::class,'site_id');
    }
    public function breaks()
    {
        return $this->hasMany(EmployeeBreak::class, 'emp_attendance_id');
    }
    public function rosterassign()
    {
        return $this->HasOne(RosterAssign::class,'assign_to','employee_id');
    }
    public function assignto()
    {
        return $this->HasOne(EmpPersonalDetails::class,'employee_id','assign_to');
    }

    public function rosterTemplate()
    {
        return $this->belongsTo(RosterTemplate::class, 'roster_template_id', 'id');
    }

    public function present_employee_details()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'employee_id', 'emp_id')->select('emp_id','first_name','middle_name','last_name','image');
    }
    public function employee_site()
    {
        return $this->belongsTo(Sites::class,'site_id')->select('id','title');
    }
}
