<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class MeetingUser extends Model
{
    use HasFactory;

    public function meeting_employees()
    {
        return $this->hasOne(EmpPersonalDetails::class,'id','employee_id')->select('id','emp_id','first_name','middle_name','last_name','image');
    }

    public function meeting_attendances()
    {
        return $this->hasMany(MeetingAttendance::class,'meeting_id','id');
    }
}
