<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Notification extends Model
{
    use HasFactory;
    protected $table = "all_notifications";

    protected $fillable = [
        'title',
        'short_description',
        'sender_id',
        'receiver_id',
        'type',
        'read',
    ];

    public function senderDetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'sender_id', 'emp_id')->select('emp_id','first_name','middle_name','last_name','image');
    }

    public function receiverDetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'receiver_id', 'emp_id')->select('emp_id','first_name','middle_name','last_name','image');
    }
    // abc
    public function sites()
    {
        return $this->belongsTo(Sites::class,'site_id')->select('id','title');
    }

    public function teams()
    {
        return $this->belongsTo(EmpTeam::class,'team_id')->select('id','title');
    }
}
