<?php

namespace App\Models;

use Carbon\Carbon;
use DateTimeInterface;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Overtime extends Model
{
    use HasFactory;

    protected $fillable = ['employee_id', 'site_id', 'check_in', 'check_out', 'date', 'working_hours', 'status','description'];

    protected $dates = ['check_in', 'check_out', 'date']; // Carbon instances for date handling

    public function emppersonaldetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'employee_id', 'emp_id');
    }

    public function empTeamsMembers()
    {
        return $this->hasMany(EmpTeamsMember::class, 'emp_id', 'employee_id')->with('empTeamsList');
    }

    public function empcompanydetails()
    {
        return $this->belongsTo(EmpCompanyDetails::class,'employee_id', 'id');
    }
    public function sites()
    {
        return $this->belongsTo(Sites::class,'site_id');
    }

    // protected function serializeDate(DateTimeInterface $date)
    // {
    //     return $date->timezone('Asia/Karachi')->format('H:i:s');
    // }

    public function getCheckInAttribute($value)
    {
        return Carbon::parse($value)->timezone('Asia/Karachi')->format('H:i:s');
    }

    /**
     * Get the check-out time formatted.
     *
     * @param  string  $value
     * @return string
     */
    public function getCheckOutAttribute($value)
    {
        return Carbon::parse($value)->timezone('Asia/Karachi')->format('H:i:s');
    }

    /**
     * Get the date formatted.
     *
     * @param  string  $value
     * @return string
     */
    public function getDateAttribute($value)
    {
        return Carbon::parse($value)->timezone('Asia/Karachi')->format('Y-m-d');
    }
}

