<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PorfileSubmittedLog extends Model
{
    use HasFactory;

    protected $table = "porfile_submitted_logs";
    
    protected $fillable = ['emp_id','description ','approved_by','rejected_by','date'];


    public function approvedBy()
    {
        return $this->hasOne(EmpPersonalDetails::class, 'emp_id', 'approved_by');
    }

    public function rejectedBy()
    {
        return $this->hasOne(EmpPersonalDetails::class, 'emp_id', 'rejected_by');
    }

    
}
