<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Project extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'client_id',
        'thumbnail ',
        'description',
        'address',
        'longitude',
        'latitude',
        'area_radius',
        'state'
    ];

    public function projectDocuments()
    {
        return $this->hasMany(ProjectDocument::class);
    }
    public function projectMeta()
    {
        return $this->hasOne(ProjectMeta::class);
    }

    public function company()
    {
        return $this->belongsTo(Company::class, 'client_id');
    }
}
