<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class RequiredDocumentField extends Model
{
    use HasFactory;

    protected $fillable = ['doc_id','field_type','field_name'];

    protected $appends = ['hasData'];

    public function empDocuments()
    {
        return $this->hasMany(EmpDocuments::class, 'required_document_field', 'id');
    }

    public function getHasDataAttribute()
    {
        return $this->empDocuments()->count();
    }

} 
