<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Sites extends Model
{
    use HasFactory;
    protected $table = 'sites';
    protected $fillable = [
        'title',
        'description',
        'longitude',
        'latitude',
        'area_radius',
        'project_id', 
        'company_client', 
        'external_id', 
        'supervisor_id',
        'site_state',
        'street_address',
        'created_by',
        'del',
        'status'
    ];

    public function project()
    {
        return $this->belongsTo(Project::class, 'project_id');
    }
   
    public function emppersonaldetails()
    {
        return $this->belongsTo(EmpPersonalDetails::class,'supervisor_id', 'emp_id');
    }

    public function company()
    {
        return $this->belongsTo(Company::class,'company_client');
    }

}
