<?php

namespace App\Traits;
use Illuminate\Support\Facades\View;
use App\Mail\DynamicMail;
use Illuminate\Http\Request;
use SendGrid;
use SendGrid\Mail\Mail;
    
trait EmailTrait
{
    
    
    public function sendEmail($to, $subject, $data, $template)
    {
        // Render the Blade template as HTML
        $htmlContent = View::make($template, $data)->render();
    
        try {
            $email = new Mail();
            $email->setFrom(env('MAIL_FROM_ADDRESS'), "HRM");
            $email->setSubject($subject);
            $email->addTo($to);
            $email->addContent("text/plain", strip_tags($htmlContent)); // Plain text version
            $email->addContent("text/html", $htmlContent); // HTML version
    
            $sendgrid = new SendGrid(env('MAIL_PASSWORD')); // Use API key from .env
            $response = $sendgrid->send($email);
    
            if ($response->statusCode() >= 200 && $response->statusCode() < 300) {
                return true;
            } else {
                \Log::error("SendGrid email failed. Status Code: " . $response->statusCode());
                return false;
            }
        } catch (\Exception $e) {
            \Log::error("Email sending failed: " . $e->getMessage());
            return false;
        }
        
    }


    public function sendEmail_cc($to, $subject, $data, $template, $cc = [])
    {
        // Render the Blade template as HTML
        $htmlContent = View::make($template, $data)->render();

        try {
            $email = new Mail();
            $email->setFrom(env('MAIL_FROM_ADDRESS'), "HRM");
            $email->setSubject($subject);
            $email->addTo($to);
            
            // Add CC recipients
            if (!empty($cc)) {
                foreach ($cc as $ccEmail) {
                    $email->addCc($ccEmail);
                }
            }

            $email->addContent("text/plain", strip_tags($htmlContent)); // Plain text version
            $email->addContent("text/html", $htmlContent); // HTML version

            $sendgrid = new SendGrid(env('MAIL_PASSWORD')); // Use API key from .env
            $response = $sendgrid->send($email);

            if ($response->statusCode() >= 200 && $response->statusCode() < 300) {
                return true;
            } else {
                \Log::error("SendGrid email failed. Status Code: " . $response->statusCode());
                return false;
            }
        } catch (\Exception $e) {
            \Log::error("Email sending failed: " . $e->getMessage());
            return false;
        }
    }

    public function sendEmailWithAttachment($to, $subject, $data, $template, $attachmentPath = null, $attachmentName = null, $attachmentMime = 'application/pdf')
    {
        // Render the Blade template as HTML
        $htmlContent = View::make($template, $data)->render();
    
        try {
            $email = new Mail();
            $email->setFrom(env('MAIL_FROM_ADDRESS'), "HRM");
            $email->setSubject($subject);
            $email->addTo($to);
            $email->addContent("text/plain", strip_tags($htmlContent)); // Plain text version
            $email->addContent("text/html", $htmlContent); // HTML version

            // Add attachment if provided
            if ($attachmentPath && file_exists($attachmentPath)) {
                $attachmentContent = file_get_contents($attachmentPath);
                $attachmentBase64 = base64_encode($attachmentContent);
                $email->addAttachment(
                    $attachmentBase64,
                    $attachmentMime,
                    $attachmentName ?: basename($attachmentPath),
                    'attachment'
                );
            }
    
            $sendgrid = new SendGrid(env('MAIL_PASSWORD')); // Use API key from .env
            $response = $sendgrid->send($email);
    
            if ($response->statusCode() >= 200 && $response->statusCode() < 300) {
                return true;
            } else {
                \Log::error("SendGrid email failed. Status Code: " . $response->statusCode());
                return false;
            }
        } catch (\Exception $e) {
            \Log::error("Email sending failed: " . $e->getMessage());
            return false;
        }
    }

}
