<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateCompanyTable extends Migration
{
   
    public function up()
    {
        Schema::create('company', function (Blueprint $table) {
            $table->id();
            $table->string('fname');
            $table->string('mname')->nullable();
            $table->string('lname');
            $table->string('mobile');
            $table->string('phone');
            $table->string('email');
            $table->string('doc_1')->nullable();
            $table->string('doc_2')->nullable();
            $table->string('doc_3')->nullable();
            $table->string('logo_img');
            $table->string('active')->default('1');
            $table->string('del')->default('0');
            $table->timestamps();
        });
    }


    public function down()
    {
        Schema::dropIfExists('company');
    }
}


