<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddPdfPathToPayrollsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::table('payrolls', function (Blueprint $table) {
            $table->string('pdf_path')->nullable()->after('status');
            $table->string('attendance_pdf_path')->nullable()->after('pdf_path');
        });
        Schema::table('roster_templates', function (Blueprint $table) {
            $table->boolean('status')->default(1)->after('updated_at'); // 1 = active, 0 = inactive
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::table('payrolls', function (Blueprint $table) {
            $table->dropColumn('pdf_path');
        });
        Schema::table('roster_templates', function (Blueprint $table) {
            $table->dropColumn('status');
        });
    }
}
