<?php
use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::table('leave_requests', function (Blueprint $table) {
            $table->integer('paid_days')->default(0)->after('number_of_leaves');
            $table->json('paid_dates')->nullable()->after('paid_days');
            $table->text('custom_approval_reason')->nullable()->after('paid_dates');
        });
    }

    public function down(): void
    {
        Schema::table('leave_requests', function (Blueprint $table) {
            $table->dropColumn(['paid_days', 'paid_dates', 'custom_approval_reason']);
        });
    }
}; 