@extends('includes/layout')
@section('main-page-content')
    <style>
        .hidden {
            display: none;
        }
    </style>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="row">
            <div class="col-12">
                <div class="card mb-4">
                    <div class="border-bottom p-3">
                        <div class="h4 pb-0 mb-0 ">Select Appropriate Site And Date</div>
                    </div>
                    <div class="card-body p-0">
                        <div class="row p-3">
                            <div class="col-lg-3 col-sm-4 mb-3">
                                <select class="form-select" name="site_id" id="siteid" aria-label="Default select example"
                                    onchange="getDataBetweenDates(0)">
                                    <option selected value="">--Select Site--</option>
                                    @foreach ($sites as $site)
                                        <option value="{{ $site->id }}">{{ $site->title }}</option>
                                    @endforeach
                                </select>
                            </div>

                            <div class="col-lg-3 col-sm-4 mb-3">
                                <div class="d-flex align-items-center mt-2 mt-md-0">
                                    <label class="me-2 text_size">From</label>
                                    <input type="date" class="form-control" id="fromDate" name="from">
                                </div>
                            </div>
                            <div class="col-lg-3 col-sm-4 mt-2 mt-md-0">
                                <div class="d-flex align-items-center">
                                    <label class="me-2 text_size">To</label>
                                    <input type="date" class="form-control" id="toDate" name="to">
                                </div>
                            </div>
                            <div
                                class="col-lg-3 col-sm-4 mb-3 d-flex justify-content-lg-end justify-content-md-start justify-content-end mt-2 mt-md-0">
                                <button class="search-btn btn btn-primary waves-effect waves-light"
                                    onclick="getDataBetweenDates(0);">Search</button>
                            </div>
                        </div>
                        <div class="border-bottom"></div>
                        <div class="row p-3 total-emp">
                            <div class="col-lg-6 col-sm-12 mb-3">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between h-px-75">
                                            <h5 class="card-title total_emp"></h5>
                                        </div>
                                        <div class="d-flex justify-content-between">
                                            <div>Total Employees</div>
                                            <div><svg xmlns="http://www.w3.org/2000/svg" width="25" height="25"
                                                    viewBox="0 0 25 25" fill="none">
                                                    <rect width="25" height="25" rx="2" fill="#15A7F5" />
                                                    <path
                                                        d="M18.182 19.318V17.9132C18.182 17.168 17.886 16.4534 17.3591 15.9264C16.8322 15.3995 16.1175 15.1035 15.3723 15.1035H9.75302C9.00785 15.1035 8.2932 15.3995 7.76629 15.9264C7.23938 16.4534 6.94336 17.168 6.94336 17.9132V19.318"
                                                        stroke="white" stroke-linecap="round" stroke-linejoin="round" />
                                                    <path
                                                        d="M12.5616 12.2931C14.1133 12.2931 15.3713 11.0352 15.3713 9.48349C15.3713 7.93176 14.1133 6.67383 12.5616 6.67383C11.0099 6.67383 9.75195 7.93176 9.75195 9.48349C9.75195 11.0352 11.0099 12.2931 12.5616 12.2931Z"
                                                        stroke="white" stroke-linecap="round" stroke-linejoin="round" />
                                                </svg></div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="col-lg-6 col-sm-12 mb-3">
                                <div class="card">
                                    <div class="card-body">
                                        <div class="d-flex justify-content-between h-px-75">
                                            <h5 class="card-title total_w_h">750</h5>
                                        </div>
                                        <div class="d-flex justify-content-between">
                                            <div>Total Hours Spent</div>
                                            <div>
                                                <svg xmlns="http://www.w3.org/2000/svg" width="25" height="25"
                                                    viewBox="0 0 25 25" fill="none">
                                                    <rect width="25" height="25" rx="2" fill="#56CA00" />
                                                    <g transform="scale(0.8)">
                                                        <circle cx="15.625" cy="15.625" r="8" stroke="white"
                                                            stroke-width="1.5" />
                                                        <path d="M15.625 15.625V10.625" stroke="white"
                                                            stroke-linecap="round" />
                                                        <path d="M15.625 15.625H18.75" stroke="white"
                                                            stroke-linecap="round" />
                                                    </g>
                                                </svg>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-lg-4 col-sm-12">
                <div class="card mb-4">
                    <div class="card-body p-0">

                        <div class="border-bottom p-4">
                            <div class="d-flex justify-content-center">
                                <svg xmlns="http://www.w3.org/2000/svg" width="28" height="28" viewBox="0 0 28 28"
                                    fill="none">
                                    <path
                                        d="M6.9994 9.96169C8.10728 9.96169 9.13849 9.52166 9.90731 8.7229C10.103 8.33317 10.3525 7.97503 10.6464 7.65847C10.9059 7.11425 11.0379 6.53067 11.0379 5.92323C11.0379 3.69642 9.22621 1.88477 6.9994 1.88477C4.77259 1.88477 2.96094 3.69642 2.96094 5.92323C2.96094 8.15003 4.77259 9.96169 6.9994 9.96169Z"
                                        fill="#019FF3" />
                                    <path
                                        d="M13.9994 14.8074C16.2262 14.8074 18.0379 12.9957 18.0379 10.7689C18.0379 8.54212 16.2262 6.73047 13.9994 6.73047C11.7726 6.73047 9.96094 8.54212 9.96094 10.7689C9.96094 12.9957 11.7726 14.8074 13.9994 14.8074Z"
                                        fill="#019FF3" />
                                    <path
                                        d="M18.0915 8.7229C18.8603 9.52166 19.8915 9.96169 20.9994 9.96169C23.2262 9.96169 25.0379 8.15003 25.0379 5.92323C25.0379 3.69642 23.2262 1.88477 20.9994 1.88477C18.7726 1.88477 16.9609 3.69642 16.9609 5.92323C16.9609 6.53061 17.0928 7.11414 17.3524 7.65837C17.6463 7.97498 17.8958 8.33311 18.0915 8.7229Z"
                                        fill="#019FF3" />
                                    <path
                                        d="M20.9993 10.5C20.1457 10.5 19.3282 10.6846 18.5669 11.0486C18.4568 12.8662 17.2814 14.4 15.6582 15.0337C18.2697 15.7607 20.1916 18.16 20.1916 21V21.8077H26.6532V16.1538C26.6532 13.0363 24.1168 10.5 20.9993 10.5Z"
                                        fill="#019FF3" />
                                    <path
                                        d="M12.3407 15.0337C10.7175 14.3999 9.542 12.8662 9.43194 11.0486C8.67061 10.6846 7.85317 10.5 6.99955 10.5C3.88202 10.5 1.3457 13.0363 1.3457 16.1538V21.8077H7.80724V21C7.80724 18.16 9.72917 15.7607 12.3407 15.0337Z"
                                        fill="#019FF3" />
                                    <path
                                        d="M13.9995 15.3457C10.882 15.3457 8.3457 17.8821 8.3457 20.9995V26.6534H19.6534V20.9995C19.6534 17.8821 17.1171 15.3457 13.9995 15.3457Z"
                                        fill="#019FF3" />
                                </svg>
                                <div class="h4 mb-0 ms-4">Employee List</div>
                            </div>
                            <div class="d-flex justify-content-center mt-3">
                                <input type="text" name="search" class="ps-2 input_search" placeholder="Search">
                                <button class="search-btn btn btn-primary btn-sm waves-effect waves-light ms-2"
                                    onclick="getDataBetweenDates(0);"><i class=" mdi mdi-magnify"></i>
                                </button>
                                <button class="search-btn btn btn-primary btn-sm waves-effect waves-light ms-2"
                                    onclick="clearEmployeeNameFilter();">X</button>
                            </div>
                        </div>
                        <div class="p-3 all_employee">

                        </div>
                        <div class="text-center pt-0" id="noResults"></div>
                    </div>
                </div>
            </div>
            <div class="col-lg-8 col-sm-12">
                <div class="card mb-4">
                    <div class="card-body p-0">
                        <div class="p-3 d-flex justify-content-between align-items-center">
                            <div class="me-auto">
                                <div class="h4 pb-0 mb-0" id="selectedTitle">Attendance Details</div>
                            </div>
                            <button class="btn btn-warning" id="exportCSV" onclick="exportAttendance(this)">Export Attendance</button>
                        </div>
                        <div>
                            <div class="table-responsive text-nowrap border-bottom">
                                <table class="table" id="filteredResults">
                                    <thead class="table-head-color bg-primary">
                                        <tr class="bg-primary">
                                            <th style="width: 10%;">Date</th>
                                            <th>Type</th>
                                            <th>Day</th>
                                           
                                            <th>Site</th>
                                            <th>Check In/Check Out</th>
                                            <th>Break In/Break Out</th>
                                            <th>Total Required Hours</th>
                                            <th>Spent Hours</th>
                                            <th>Difference</th>
                                        </tr>
                                    </thead>
                                    <tbody class="table-border-bottom-0 table-body">

                                    </tbody>
                                </table>
                            </div>
                            <nav aria-label="Page navigation" class="mt-3">
                                {{-- <ul class="pagination justify-content-end pages_btn">

                                </ul> --}}
                            </nav>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
@endsection
@section('css-js')
    <script>
        function convertToCSV(table) {
            var csv = [];
            var headers = [];
            var rows = table.querySelectorAll('tbody tr');
            var headerCols = table.querySelectorAll('thead th');

            // Extract headers
            for (var h = 0; h < headerCols.length; h++) {
                headers.push(headerCols[h].innerText);
            }
            csv.push(headers.join(','));

            for (var i = 0; i < rows.length; i++) {
                var row = [];
                var cols = rows[i].querySelectorAll('td');
                var date            = cols[0].innerText;
                var day             = cols[1].innerText;
                var site            = cols[2].innerText;
                var attendance      = cols[3].innerText;
                var break_time      = cols[4].innerText;
                var required_hours  = cols[5].innerText;
                var spent_hours     = cols[6].innerText;
                var difference      = cols[7].innerText;
                row.push(date, day, site, attendance, break_time, required_hours, spent_hours, difference);
                csv.push(row.join(','));
            }

            return csv.join('\n');
        }

        function downloadCSV() {
            var table = document.getElementById('filteredResults');
            var csv = convertToCSV(table);
            var blob = new Blob([csv], { type: 'text/csv' });
            var a = document.createElement('a');
            a.href = window.URL.createObjectURL(blob);
            a.download = 'employee_attendance.csv';
            document.body.appendChild(a);
            a.click();
            document.body.removeChild(a);
        }

        function clearEmployeeNameFilter(){
            $('input[name="search"]').val('');
            getDataBetweenDates(0);
        }

        $(document).ready(function() {
            $('#siteid').change(function() {
                if ($(this).val() !== "") {
                    var selectedTitle = $('#siteid option:selected').text();
                    $('#selectedTitle').text('Attendance Details / ' + selectedTitle);
                } else {
                    $('#selectedTitle').text('Attendance Details');
                }
            });
        });

        $(document).ready(function() {
            getDataBetweenDates(0);
        });

        const today = new Date();
        document.getElementById('toDate').valueAsDate = today;
        const oneWeekAgo = new Date(today);
        oneWeekAgo.setDate(oneWeekAgo.getDate() - 7);
        document.getElementById('fromDate').valueAsDate = oneWeekAgo;

        // -- REUSABLE FUNCTIONS --
        function formatDate(dateString) {
            // dateString is "YYYY-MM-DD"
            const parts = dateString.split('-');
            return `${parts[2]}-${parts[1]}-${parts[0]}`; // "DD-MM-YYYY"
        }

        function _24_to_12_time(timeStr) {
            // Implement your existing 24h->12h conversion
            // e.g. "14:30" -> "2:30 PM"
            // For brevity, fill in your logic or existing function
            if(!timeStr) return '';
            const [hour, minute] = timeStr.split(':');
            let h = parseInt(hour);
            let suffix = h >= 12 ? "PM" : "AM";
            h = (h % 12) || 12;
            return `${h}:${minute} ${suffix}`;
        }

        function convertMinutesToHours(minutes) {
    if (!minutes || isNaN(minutes)) return '0h 0m';
    
    // Handle negative minutes properly
    let isNegative = minutes < 0;
    let absMinutes = Math.abs(minutes);
    
    let h = Math.floor(absMinutes / 60);
    let m = absMinutes % 60;
    
    // Format the result with a single negative sign if needed
    if (isNegative) {
        return `-${h}h ${m}m`;
    } else {
        return `${h}h ${m}m`;
    }
}
        // ------------------------

        function getDataBetweenDates(from) {
            var searchInput = $('input[name="search"]').val().toLowerCase().trim();
            const toDate = document.getElementById('toDate').value;
            const fromDate = document.getElementById('fromDate').value;
            const siteid = document.getElementById('siteid').value;
            $.ajax({
                type: 'GET',
                url: "{{ url('/attendance-portal-employee') }}",
                data: {
                    to: toDate,
                    from: fromDate,
                    site_id: siteid,
                    page: from,
                    employee_name: searchInput
                },
                success: function(response) {
                    var attendances = response.data;
                    $('.total_r_h').text(response.requirehours);
                    $('.total_w_h').text(response.workinghours);
                    $('.total_emp').text(response.employe);

                    var html = '';
                    var arr = [];

                    for (var i = 0; i < attendances.length; i++) {
                        // Make sure we only list each employee once
                        if (!arr.includes(attendances[i].emp_id)) {
                            arr.push(attendances[i].emp_id);
                            html += `
                              <div class="search_div" onclick="selectedtab(this);">
                                <div class="d-flex align-items-center cursor-pointer p-1 my-2 set_bg_colot"
                                     data-id="${attendances[i].emp_id}" onclick="getEmpAttendance(this);">
                                    <div class="border h-px-40 w-px-40 rounded-circle"
                                         style="background-image: url('${attendances[i].image}');
                                                background-size: cover;
                                                background-repeat:no-repeat">
                                    </div>
                                    <div>
                                        <span class="fw-medium emp_name ms-2" style="font-size: 12px; color:#000000;">
                                            ${attendances[i].first_name ? attendances[i].first_name : ''}
                                            ${attendances[i].middle_name ? attendances[i].middle_name : ''}
                                            ${attendances[i].last_name ? attendances[i].last_name : ''}
                                        </span>
                                        <div class="ms-2 fs-tiny emp_role">
                                            ${attendances[i].title ? attendances[i].title : ''}
                                            (${attendances[i].user_type == 0 ? 'Internal' : 'External' })
                                        </div>
                                    </div>
                                </div>
                              </div>`;
                        }
                    }

                    $('.table-body').html(`<tr><td colspan="8" class="text-center">No record found.</td></tr>`);

                    if (html == ``) {
                        $('.all_employee').html(`<div class="text-center">No record found.</div>`);
                    } else {
                        html += `<ul class="pagination justify-content-center employee_pages_btn mt-5"></ul>`;
                        $('.all_employee').html(html);
                    }

                    var count = parseInt(response.employe) < 10 ? 1 : parseInt(response.employe) / 10;
                    count = Math.ceil(count);
                    var pages_btn = ``;

                    pages_btn += `
                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}" onclick="getDataBetweenDates(0);">
                            <a class="page-link waves-effect" href="javascript:void(0);">
                                <i class="tf-icon mdi mdi-chevron-double-left"></i>
                            </a>
                        </li>
                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"
                            onclick="$('.active').prev('.p-btn').trigger('onclick');">
                            <a class="page-link waves-effect" href="javascript:void(0);">
                                <i class="tf-icon mdi mdi-chevron-left"></i>
                            </a>
                        </li>`;

                    $('.p-btn').removeClass('active');

                    var c = 0;
                    for (c = 0; c < count; c++) {
                        if (
                            (from == (c - 2) * 10) ||
                            (from == (c - 1) * 10) ||
                            (from == (c - 0) * 10) ||
                            (from == (c + 1) * 10) ||
                            (from == (c + 2) * 10)
                        ) {
                            pages_btn += `
                                <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' }"
                                    onclick="getDataBetweenDates(${c*10});">
                                   <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                </li>`;
                        }
                    }

                    pages_btn += `
                        <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"
                            onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);">
                                <i class="tf-icon mdi mdi-chevron-right"></i>
                            </a>
                        </li>
                        <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"
                            onclick="getDataBetweenDates(${(c-1)*10});">
                            <a class="page-link waves-effect" href="javascript:void(0);">
                                <i class="tf-icon mdi mdi-chevron-double-right"></i>
                            </a>
                        </li>`;

                    $('.employee_pages_btn').html(pages_btn);
                },
                error: function(response) {
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }

        function selectedtab(element) {
            $('.search_div').removeClass('selected');
            $(element).addClass('selected');
        }

        // -------------- UPDATED getEmpAttendance --------------
        function getEmpAttendance(_this) {
    const toDate = document.getElementById('toDate').value;
    const fromDate = document.getElementById('fromDate').value;
    var id = $(_this).attr('data-id');
    const siteid = document.getElementById('siteid').value;
    var weekday = ["Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday"];

    $('#exportCSV').attr('data-id', id);

    $.ajax({
        type: 'GET',
        url: 'employe-attendance',
        data: {
            to: toDate,
            from: fromDate,
            empid: id,
            site_id: siteid
        },
        success: function(response) {
            var records = response.data;
            var html = ``;
            for (var i = 0; i < records.length; i++) {
                var item = records[i];
console.log(item);
                // -- Extract date portion if there's time data (like "2025-10-27 00:00:00.000000")
                var datePart = item.date.split(' ')[0];  // "2025-10-27"
                var dateArr = datePart.split('-');       // ["2025","10","27"]
                var yyyy = parseInt(dateArr[0]);
                var mm   = parseInt(dateArr[1]);
                var dd   = parseInt(dateArr[2]);

                // Format as d-m-y
                var formattedDate = dd + '-' + mm + '-' + yyyy; 

                // Get the weekday name
                var dateObj = new Date(yyyy, mm - 1, dd);
                var dayName = weekday[dateObj.getDay()];

                // Safely extract site title
                var siteTitle = item.sites?.title ?? 'Global Site';

                let checkIn  = '';
                let checkOut = '';

                if (item.flag === 'overtime') {
                // Show time first, then date
                checkIn  = item.check_in  ? formatOvertimeDateTime(item.check_in)   : '';
                checkOut = item.check_out ? formatOvertimeDateTime(item.check_out) : '';
                } else {
                // Attendance stays the same as before
                checkIn  = item.check_in  ? _24_to_12_time(item.check_in)  : '';
                checkOut = item.check_out ? _24_to_12_time(item.check_out) : '';
                }
                var flag =item.flag;
                // Breaks (attendance only)
                var breaksHTML = '';
                if (item.flag === 'attendance' && item.breaks && item.breaks.length > 0) {
                    breaksHTML = item.breaks.map(function(breakItem) {
                        var bi = breakItem.break_in  ? breakItem.break_in  : '';
                        var bo = breakItem.break_out ? breakItem.break_out : '';
                        return bi + ' - ' + bo;
                    }).join('<br>');
                }

                // Required hours (attendance only)
                var totalRequiredHours = 0;
                if (item.flag === 'attendance' &&
                    item.roster_assign &&
                    item.roster_assign.roster_template) {
                    totalRequiredHours = item.roster_template?.working_hours ?? 0;
                }

                // Check if item is defined before accessing its working_hours
                var spentHours = item?.working_hours ?? 0;

                // Difference
                var differenceInMinutes = 0;
                if (item.flag === 'attendance') {
                    var lable='success';
                    differenceInMinutes =spentHours -totalRequiredHours;
                } else if (item.flag === 'overtime') {
                    var lable='primary';
                    // For overtime, you might show total OT hours in difference
                    differenceInMinutes = spentHours;
                }

                html += `
                    <tr>
                        <td><span class="fw-medium">${formattedDate}</span></td>
                        <td><span class="badge rounded-pill bg-label-${lable}">${flag}</span></td>
                        <td><span class="fw-medium">${dayName}</span></td>
                        <td><span class="fw-medium">${siteTitle ?? 'Global Site'}</span></td>
                        <td>${checkIn} - ${checkOut}</td>
                        <td>${breaksHTML}</td>
                        <td>${convertMinutesToHours(totalRequiredHours)}</td>
                        <td class="text-primary">${convertMinutesToHours(spentHours)}</td>
                        <td class="text-warning">${convertMinutesToHours(differenceInMinutes)}</td>
                    </tr>
                `;
            }

            // Render rows
            $('.table-body').html(html);

            if (html === ``) {
                $('.table-body').html(
                    `<tr><td colspan="8" class="text-center">No record found.</td></tr>`
                );
            }
        },
        error: function(error) {
            toastr.error("Something went wrong");
        }
    });
}
/**
 * Converts a datetime like "2025-03-02 09:00:00.000000"
 * or "2025-03-02T09:00:00.000000Z"
 * into "09:00 AM 02-03-2025" (hh:mm AM/PM DD-MM-YYYY).
 */
function formatOvertimeDateTime(dateTimeStr) {
  if (!dateTimeStr) return '';

  // 1) Remove trailing fractional seconds, e.g. ".000000"
  dateTimeStr = dateTimeStr.replace(/\.\d+/, ''); 

  // 2) If there's a space instead of 'T', replace it (for ISO parsing).
  if (dateTimeStr.indexOf('T') === -1 && dateTimeStr.indexOf(' ') !== -1) {
    dateTimeStr = dateTimeStr.replace(' ', 'T');
  }

  // 3) Parse as standard ISO-like string
  const dateObj = new Date(dateTimeStr);

  // 4) If invalid, return raw string
  if (isNaN(dateObj.getTime())) {
    return dateTimeStr;
  }

  // Extract components
  let day    = dateObj.getDate();       // 1-31
  let month  = dateObj.getMonth() + 1;  // 0-11 => 1-12
  let year   = dateObj.getFullYear();   
  let hour   = dateObj.getHours();      // 0-23
  let minute = dateObj.getMinutes();    // 0-59

  // Determine AM/PM
  const suffix = hour >= 12 ? 'PM' : 'AM';

  // Convert to 12-hour format
  hour = hour % 12;
  if (hour === 0) hour = 12;

  // Zero-pad
  const dd = (day   < 10 ? '0' + day   : day);
  const mm = (month < 10 ? '0' + month : month);
  const hh = (hour  < 10 ? '0' + hour  : hour);
  const mn = (minute < 10 ? '0' + minute : minute);

  // Return "hh:mm AM/PM DD-MM-YYYY"
  return `${hh}:${mn} ${suffix} ${dd}-${mm}-${year}`;
}


        // -------------------------------------------------------

        function exportAttendance(obj) {
            const toDate = document.getElementById('toDate').value;
            const fromDate = document.getElementById('fromDate').value;
            var id = $(obj).attr('data-id');
            const siteid = document.getElementById('siteid').value;

            if (!id) {
                toastr.error('Please select any employee.');
                return;
            }

            // Construct the URL with all necessary query parameters
            var url = `attendance-export?to=${encodeURIComponent(toDate)}&from=${encodeURIComponent(fromDate)}&empid=${id}&site_id=${siteid}`;

            // Redirect to the URL, which should trigger the download
            window.location.href = url;
        }
    </script>

    <style>
        @media only screen and (min-width: 320px) and (max-width: 425px) {
            .time-section {
                margin-top: 30px;
            }
        }

        @media only screen and (min-width: 280px) and (max-width: 540px) {
            .search-btn {
                margin-top: 15px;
            }
        }
    </style>
@endsection
