@extends('includes/layout')
@section('main-page-content')
    @php $cols = DB::table('attendance_list_change_cols')->pluck('col')->toArray();  @endphp
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body">
                <div class="dashboard border-bottom  py-2 justify-content-between align-items-center">
                    <div>
                        <div class="h4 pb-0 mb-0">Attendance List</div>
                        <small class="Attendence_pkg_small">Dashboard-Attendance List</small>
                    </div>
                    <div class="dashboard-btn justify-content-end align-items-center">
                        @if (in_array('Attendance Maintain', Session::get('permissions')))
                        <!-- <div class="dropdown me-2">
                            <button class="btn btn-warning dropdown-toggle Attendence_pkg_small" type="button" id="dropdownMenuButton" data-bs-toggle="dropdown" aria-expanded="false">
                                System Checkout
                            </button>
                            <ul class="dropdown-menu dropdown-menu-width" aria-labelledby="dropdownMenuButton">
                                <li><a class="dropdown-item" href="#" onclick="updateButtonText('Option 1', 1);">Option 1</a></li>
                                <li><a class="dropdown-item" href="#" onclick="updateButtonText('Option 2', 0);">Option 2</a></li>
                            </ul>
                        </div> -->
                        <div>
                            <div class="dropdown me-2">
                                <select class="form-select btn  dropdown-toggle Attendence_pkg_small BORDERRRR" id="exampleSelect" onchange="_system_checkout_filter(this)">
                                    <option selected value='2'>All Checkout</option>
                                    <option value="0">Self Checkout</option>
                                    <option value="1">System Checkout</option>
                                </select>
                            </div>
                        </div>




                            <button class="btn btn-primary waves-effect waves-light me-2 Attendence_pkg_small"
                                onclick="_download_attendance();">Download Attendance</button>
                            <button class="btn btn-primary waves-effect waves-light Attendence_pkg_small"
                                onclick="window.location='{{ route('attendance.create') }}'"><span
                                    class="mdi mdi-plus"></span>Add Attendance</button>
                        @endif

                        <div class="btn-group Btn_width_dropdown">
                            <button class="btn btn-primary waves-effect waves-light ms-md-2 dropdown-toggle" type="button"
                                data-bs-toggle="dropdown" data-bs-auto-close="false">
                                <span class="mdi mdi-format-list-checks"></span>
                            </button>
                            <form action="{{ url('/attendance-list/change-col') }}" method="post">
                                @csrf
                                <ul class="dropdown-menu column-filter p-2" style="width: 100%;">
                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Employee"
                                                {{ in_array('Employee', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Employee
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Type"
                                                {{ in_array('Type', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Type
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Teams"
                                                {{ in_array('Teams', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Teams
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Site"
                                                {{ in_array('Site', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Site
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Check In"
                                                {{ in_array('Check In', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Check In
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Check Out"
                                                {{ in_array('Check Out', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Check Out
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Working Hours"
                                                {{ in_array('Working Hours', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Working Hours
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Date"
                                                {{ in_array('Date', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Date
                                            </label>
                                        </div>
                                    </li>
                                    <li>
                                        <button type="submit" class="btn btn-primary btn-sm">Save Changes</button>
                                    </li>
                                </ul>
                            </form>
                        </div>
                    </div>
                </div>
                <div>
                    <div class="table-responsive text-nowrap border-bottom">
                        <table class="table">
                            <thead class="table-head-color bg-primary">
                                <tr>
                                    <th style="width: 13%; " class="{{ in_array('Employee', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter-form filter form-control" name="first_name"
                                            id="" placeholder="Employee" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-first_name"
                                            autocomplete="false">
                                    </th>
                                    <th style="width: 11%;" class="{{ in_array('Type', $cols) ? '' : 'd-none' }}">
                                        <select class="filter select-color" style="border-radius:0;" name="user_type"
                                            id="">
                                            <option value="">Type</option>
                                            <option value="0">Internal</option>
                                            <option value="1">External</option>
                                        </select>
                                    </th>
                                    <th style="min-width: 150px;" class="{{ in_array('Teams', $cols) ? '' : 'd-none' }}">
                                        <select class="filter select-color" style="border-radius:0;" name="teams"
                                            aria-placeholder="Teams" id="">
                                            <option value="">Teams</option>
                                            @php
                                                $emp_teams = DB::table('emp_teams')->where('del', '0')->get();
                                            @endphp
                                            @foreach ($emp_teams as $t)
                                                <option value="{{ $t->id }}">{{ $t->title }}</option>
                                            @endforeach
                                        </select>
                                    </th>
                                    <th style="min-width: 100px;" class="{{ in_array('Site', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter-form filter form-control" name="title"
                                            id="" placeholder="Site" autocomplete="off">
                                        <input type="text" style="display:none" name="title" autocomplete="false">
                                    </th>
                                    <th style="min-width: 150px;"
                                        class="{{ in_array('Check In', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="Check_in" id=""
                                            placeholder="Check In" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-Check_in"
                                            autocomplete="false">
                                    </th>
                                    <th style="min-width: 150px;"
                                        class="{{ in_array('Check Out', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="Check_out"
                                            id="" placeholder="Check Out" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-Check_out"
                                            autocomplete="false">
                                    </th>
                                    <th style="min-width: 180px;"
                                        class="{{ in_array('Working Hours', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="working_hours"
                                            id="" placeholder="Working Hours" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-working_hours"
                                            autocomplete="false">
                                    </th>

                                    <th style="width: 17%;" class="{{ in_array('Date', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="date" id=""
                                            placeholder="Date" autocomplete="off" style="font-size:11px">
                                        <input type="text" style="display:none" name="fake-date"
                                            autocomplete="false">
                                    </th>

                                    <th style="width: 10%;" class="text-center">
                                        <div style="margin-top:6px;display:block;">
                                            <button class="btn btn-success btn-sm p-2 waves-effect waves-light filter-btn"
                                                onclick="_filter(1); _get(0);">submit</button>
                                            <button
                                                class="btn btn-danger btn-sm p-2 waves-effect waves-light filter-btn-close"
                                                onclick="_filter(0);  _get(0);">x</button>
                                        </div>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0 table-body">

                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-3">
                        <ul class="pagination justify-content-md-end justify-content-center pages_btn">

                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="DeleteEmp" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this record?<br><br>
                    <b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you
                    genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger" id="attendance-id" data-id=""
                        onclick="_delete(this)">Delete</button>
                </div>
            </div>
        </div>
    </div>



    <div class="modal fade" id="DownloadAttendanceModal" tabindex="-1" aria-labelledby="DownloadAttendanceModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-primary px-4 py-2">
                    <h5 class="modal-title text-white" id="DownloadAttendanceModalLabel">Download Attendance</h5>
                </div>
                <div class="modal-body">
                    <div class="mb-2">
                        <label class="form-label">Start Time</label>
                        <input type="date" class="form-control" id="download_attendance_start_time">
                    </div>
                    <div class="mb-2">
                        <label class="form-label">End Time</label>
                        <input type="date" class="form-control " id="download_attendance_end_time">
                    </div>
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-primary" onclick="_download_attendance();">Download</button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('css-js')
    <script>
        $(document).ready(function() {

            $('input[name="date"]').daterangepicker({
                locale: {
                    format: 'DD-MM-YYYY',
                    separator: ' / '
                }
            });

            _filter(0);
            _get(0);
        });


        function formatDate(dateString) {
            const parts = dateString.split('-');
            const formattedDate = `${parts[2]}-${parts[1]}-${parts[0]}`;
            return formattedDate;
        }

        function _filter(filter_on) {

            var collection = document.getElementsByClassName("filter");
            var arr = {};

            for (let i = 0; i < collection.length; i++) {
                arr[collection[i].name] = filter_on == 1 ? collection[i].value : '';
            }

            if (filter_on == 0) {
                $('.filter').val('');
            }

            localStorage.setItem('filter', JSON.stringify(arr));

        }

        function _system_checkout_filter(filter_on) {
            var checkout_filter_value = $(filter_on).val();
            var add_filter = {};
            add_filter['system_checkout'] = checkout_filter_value;

            localStorage.setItem('filter', JSON.stringify(add_filter));
            _get(0);
        }

        function _get(from) {

            $.ajax({
                type: "GET",
                url: `{{ url('api/attendance-get') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },

                success: function(response) {
                    var attendances = response.data.attendances;
                    var html = ``;
                    var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count) / 10;
                    count = Math.ceil(count);
                    var pages_btn = ``;

                    pages_btn += `
                            <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                    </li>
                                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                        </li>`;

                    $('.p-btn').removeClass('active');

                    var c = 0;
                    for (c = 0; c < count; c++) {
                        if (
                            (from == (c - 3) * 10) ||
                            (from == (c - 2) * 10) ||
                            (from == (c - 1) * 10) ||
                            (from == (c - 0) * 10) ||
                            (from == (c + 1) * 10) ||
                            (from == (c + 2) * 10) ||
                            (from == (c + 3) * 10)
                        ) {
                            pages_btn += `
                                    <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*10});">
                                    <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                    </li>
                                    `;
                        }

                    }

                    pages_btn += `

                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                    </li>
                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*10});" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                    </li>
                    `;


                    $('.pages_btn').html(pages_btn);



                    for (var i = 0; i < attendances.length; i++) {

                        var totalMinutes = attendances[i].working_hours || 0;
                        var hours = Math.floor(totalMinutes / 60);
                        var minutes = totalMinutes % 60;
                        var formattedHours = hours + ':' + (minutes < 10 ? '0' : '') + minutes;

                        var emp_teams_members = attendances[i]?.emp_teams_members ?? [];

                        var teams_list = '';
                        for (j = 0; j < emp_teams_members.length; j++) {
                            // if(emp_teams_members[j].emp_teams_list.applied == '1')
                            // {
                            teams_list += emp_teams_members[j].emp_teams_list.title + ',';
                            // }
                        }

                        let checkoutType = attendances[i].checkout_type;
                        let checkOutTime = attendances[i].check_out ? _24_to_12_time(attendances[i].check_out) : '';
                        let textColor = checkoutType == 1 ? 'style="color:red !important"' : '';

                        html += `
                        <tr>
                            <td class="{{ in_array('Employee', $cols) ? '' : 'd-none' }}">
                                <div class="d-flex align-items-center">
                                    <div class="border h-px-40 w-px-40 rounded-circle" style="background-image: url('${attendances[i].emp_personal_details.image}'); background-size: cover; background-repeat:no-repeat"></div>
                                    <div class="ms-1">
                                        ${attendances[i].emp_personal_details.first_name ? attendances[i].emp_personal_details.first_name : ''}
                                        ${attendances[i].emp_personal_details.middle_name ? attendances[i].emp_personal_details.middle_name : ''}
                                        ${attendances[i].emp_personal_details.last_name ? attendances[i].emp_personal_details.last_name : ''}
                                    </div>
                                </div>
                            </td>
                            <td class="user_type-col${attendances[i]?.id}  {{ in_array('Type', $cols) ? '' : 'd-none' }}">
                            ${attendances[i]?.emp_company_details.user_type == "0" ?
                            '<span class="badge rounded-pill bg-label-success me-1">Internal</span>'
                            :
                            '<span class="badge rounded-pill bg-label-warning me-1">External</span>'
                             }</td>
                             <td class="{{ in_array('Teams', $cols) ? '' : 'd-none' }}">${teams_list.replace(/,\s*$/, "")}</td>
                            <td class="{{ in_array('Site', $cols) ? '' : 'd-none' }}">${attendances[i].sites?.title ?? 'Global Site'}</td>
                            <td class="text-primary {{ in_array('Check In', $cols) ? '' : 'd-none' }}">${attendances[i].check_in ? _24_to_12_time(attendances[i].check_in) : ''}</td>
                            <td class="text-primary {{ in_array('Check Out', $cols) ? '' : 'd-none' }}" ${textColor}>${attendances[i].check_out ? _24_to_12_time(attendances[i].check_out) : ''}</td>
                            <td class="{{ in_array('Working Hours', $cols) ? '' : 'd-none' }}">${convertMinutesToHours(attendances[i].working_hours)}</td>
                            <td class="{{ in_array('Date', $cols) ? '' : 'd-none' }}">${formatDate(attendances[i].date)}</td>
                            <td>
                            @if (in_array('Attendance Maintain', Session::get('permissions')))

                              <div class="dropdown cursor-pointer d-flex justify-content-center">
                              <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>

                              <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                              <li class="${attendances[i].image ? '' : 'd-none'}"><a class="dropdown-item py-1 ps-2"  target="_blank" href="{{ url('/') }}/${attendances[i].image}" ><span class="mdi mdi-eye mdi-20px text-warning"></span>View Image</a></li>
                              <li><a class="dropdown-item py-1 ps-2"  onclick="window.location='/attendance/${attendances[i]?.id}/edit'"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                              <li><a class="dropdown-item py-1 ps-2"  data-id="${attendances[i].id}" onclick="_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                              </ul>
                              </div>
                              @endif
                            </td>
                        </tr>`;
                    }
                    $('.table-body').html(html);

                    if (html == ``) {
                        $('.table-body').html(
                            `<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                    }

                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }

        function _delete_modal(_this) {
            var id = $(_this).attr('data-id');
            $('#attendance-id').attr('data-id', id);
            $('#DeleteEmp').modal('show');
        }

        function _delete(_this) {
            var id = $(_this).attr('data-id');
            $.ajax({
                type: "DELETE",
                url: "/attendance/" + id,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.message) {
                        toastr.success(response.message);
                    } else {
                        toastr.success("Attendance Deleted Successfully");
                    }
                    _get(0);
                    $('#DeleteEmp').modal('hide');
                },
                error: function(response) {
                    if (response.status == 500) {
                        toastr.error("Something went wrong");
                    } else {
                        toastr.error(response.responseJSON.message);
                    }
                }
            });
        }

        function _download_attendance_modal() {
            $('#download_attendance_start_time').val('');
            $('#download_attendance_end_time').val('');
            $('#DownloadAttendanceModal').modal('show');
        }

        function _download_attendance() {
            loader(true);

            $.ajax({
                type: "POST",
                url: "{{ url('/api/attendance/download') }}",
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    'filter': localStorage.getItem('filter')
                },
                success: function(response) {
                    loader(false);
                    var link = document.createElement('a');
                    link.href = URL.createObjectURL(new Blob([response]));
                    link.setAttribute('download', 'attendance.csv');
                    document.body.appendChild(link);
                    link.click();
                    link.parentNode.removeChild(link);
                },
                error: function(xhr, status, error) {
                    loader(false);
                    if (xhr.status == 500) {
                        toastr.error("Something went wrong");
                    } else {
                        toastr.error(xhr.responseJSON.message);
                    }
                }
            });
        }

        function updateButtonText(optionText, value) {
                document.getElementById('dropdownMenuButton').textContent = optionText;
                if (value === 1) {
                    _system_checkout_filter(value);
                } else {
                    _get(value);
                }
            }
    </script>

    <style>
        .filter {
            width: 100%;
            height: 33px;
            outline: none;
            background: white;
        }

        .filter-form {
            width: 100%;
            height: 33px;
            outline: none;
            background: white;
        }

        .select-color {
            color: #787878;
            font-size: 0.9375rem;
            font-weight: 400;
            line-height: 1.47;
            background-size: 9px 5px;
            border: 1px solid #d4d3d5;
            border-radius: 0.375rem;
            transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
            padding-left: 5px;
        }

        .list_color:hover {
            color: #15A7F5;
        }

        .bg-primary th {
            color: white;
        }

        .dashboard {
            display: flex;
        }

        .dashboard-btn {
            display: flex;
        }

        @media only screen and (min-width: 320px) and (max-width: 520px) {
            .dashboard {
                display: block;
            }

            .dashboard-btn {
                display: block;
            }

            .dashboard-btn .btn {
                margin-top: 10px;
            }
        }
    </style>
@endsection
