<!DOCTYPE html>
@php
    use App\General\SettingsClass;
    use Illuminate\Support\Facades\Route;

    $settings_ = DB::table('settings')->get();
    $webLogo_ = SettingsClass::getOptionValue('_web_logo', $settings_);

@endphp
<html lang="en" class="light-style layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default"
  data-assets-path="../assets/" data-template="vertical-menu-template-free">

<head>
  <meta charset="utf-8" />
  <meta name="viewport"
    content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
  <title>Dashboard - Analytics | Materio - Bootstrap Material Design Admin Template</title>
  <meta name="description" content="" />
  <!-- Favicon -->
  <link rel="icon" type="image/x-icon" href="{{ url($webLogo_) }}" />
  <link rel="icon" type="image/x-icon" href="../assets/img/favicon/favicon.ico" />
  <!-- Fonts -->
  <link rel="preconnect" href="https://fonts.googleapis.com" />
  <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
  <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
    rel="stylesheet" />
  <link rel="stylesheet" href="../assets/vendor/fonts/materialdesignicons.css" />
  <!-- Menu waves for no-customizer fix -->
  <link rel="stylesheet" href="../assets/vendor/libs/node-waves/node-waves.css" />
  <!-- Core CSS -->
  <link rel="stylesheet" href="../assets/vendor/css/core.css" class="template-customizer-core-css" />
  <link rel="stylesheet" href="../assets/vendor/css/theme-default.css" />
  <link rel="stylesheet" href="../assets/css/demo.css" />
  <!-- Vendors CSS -->
  <link rel="stylesheet" href="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
  <link rel="stylesheet" href="../assets/vendor/libs/apex-charts/apex-charts.css" />
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
  <!-- Page CSS -->
  <!-- Helpers -->
  <script src="../assets/vendor/js/helpers.js"></script>
  <!--! Template customizer & Theme config files MUST be included after core stylesheets and helpers.js in the <head> section -->
  <!--? Config:  Mandatory theme config file contain global vars & default theme options, Set your preferred theme option in this file.  -->
  <script src="../assets/js/config.js"></script>
</head>
<style>
  .authentication-wrapper.authentication-cover .authentication-inner {
    min-height: 100vh;
    position: relative;
  }

  .authentication-wrapper .authentication-inner {
    width: 100%;
  }

  .authentication-wrapper .authentication-image-model {
    width: 768px;
  }

  .authentication-wrapper.authentication-cover .authentication-image-tree {
    position: absolute;
    bottom: 3rem;
    left: 3rem;
  }

  .authentication-wrapper.authentication-cover .authentication-image {
    inset-inline-start: unset;
  }

  .authentication-wrapper .authentication-image {
    z-index: -1;
    inline-size: 100%;
    position: absolute;
    inset-inline-start: 0;
    bottom: 0;
  }

  .light-style .authentication-wrapper .authentication-bg {
    background-color: #fff;
  }

  @media (max-width: 1199.98px) {
    .authentication-cover .authentication-image-model {
      position: relative;
      width: 575px;
      top: 6rem;
    }
  }

  @media (max-width: 768px) {
    .full_loader
      {
    min-width:5vw !important;
  }
  }
  .full_loader
      {
            background: url('/loader.gif');
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-position: center;
            background-size: 50px;
            z-index: 1000;
            position: absolute;
            min-width: 100vw;
            min-height: 100vh;
            overflow: hidden;
            max-width: 100vw;
            max-height: 100vh;
            background-color: white;
      }


</style>

<body>
  <div class="full_loader "></div>
  <div class="authentication-wrapper authentication-cover">
    <!-- Logo -->
    <a href="index.html" class="auth-cover-brand d-flex align-items-center gap-2">
      <span class="app-brand-logo demo">
          <span style="color:var(--bs-primary);">

              <img src="{{url($webLogo_)}}" height="70" width="200" >
          </span>
      </span>
  </a>
    <!-- /Logo -->
    <div class="authentication-inner row m-0">
      <!-- /Left Section -->
      <div class="d-none d-lg-flex col-lg-7 col-xl-8 align-items-center justify-content-center p-5 pb-2">
        <div>
          <img src="../assets/img/illustrations/auth-cover-login.png"
            class="authentication-image-model d-none d-lg-block" alt="">
        </div>
        <img src="../assets/img/illustrations/auth-cover-mask-light.png"
          class="scaleX-n1-rtl authentication-image d-none d-lg-block w-75" alt="">
      </div>
      <!-- /Left Section -->
      <!-- Forgot Password -->
      <div class="d-flex col-12 col-lg-5 col-xl-4 align-items-center authentication-bg p-sm-5 p-4">
        <div class="w-px-400 mx-auto">
          <h4 class="mb-2">Forgot Password? 🔒</h4>
          <p class="mb-4">Enter your email and we'll send you instructions to reset your password</p>
          <form id="formAuthentication" class="mb-3 fv-plugins-bootstrap5 fv-plugins-framework" action="" method="" novalidate="novalidate">
            <div class="form-floating form-floating-outline mb-3 fv-plugins-icon-container">
              <input type="text" class="form-control email" id="email" name="employee_email" placeholder="Enter your email" autofocus="">
              <label for="email">Email</label>
            </div>
            <div class="btn-container d-flex" style="position: relative">
            <button class="btn btn-primary d-grid w-100 waves-effect waves-light submit" >Send Reset Link</button>
              
          </div>
          </form>
          <div class="text-center">
            <a href="{{('/')}}" class="d-flex align-items-center justify-content-center">
              <i class="mdi mdi-chevron-left scaleX-n1-rtl mdi-24px"></i>
              Back to login
            </a>
          </div>
        </div>
      </div>
      <!-- /Forgot Password -->
    </div>
  </div>

  <script src="../assets/vendor/libs/jquery/jquery.js"></script>
  <script src="../assets/vendor/libs/popper/popper.js"></script>
  <script src="../assets/vendor/js/bootstrap.js"></script>
  <script src="../assets/vendor/libs/node-waves/node-waves.js"></script>
  <script src="../assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
  <script src="../assets/vendor/js/menu.js"></script>
  <!-- endbuild -->
  <!-- Vendors JS -->
  <script src="../assets/vendor/libs/apex-charts/apexcharts.js"></script>
  <!-- Main JS -->
  <script src="../assets/js/main.js"></script>
  <!-- Page JS -->
  <script src="../assets/js/dashboards-analytics.js"></script>
  <!-- Place this tag in your head or just before your close body tag. -->
  <script async defer src="https://buttons.github.io/buttons.js"></script>
  <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js" ></script>
  <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<script>
  $(document).ready(function() {
    $('.full_loader').addClass('d-none');
    function loader(show) {
      if (show) {
          $('.full_loader').removeClass('d-none');
      } else {
          $('.full_loader').addClass('d-none');
      }
  }
    $(".submit").on("click", function(e) {
      e.preventDefault();
      loader(true);
      $.ajax({
          headers: {
                      'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
          type: "POST",
          url: "{{url('api/forget-password-send-otp')}}",
          data: {
              "employee_email": $('.email').val(),
          },
          success: function(response) {
            loader(false);
              toastr.success(response.message);
              window.location.href = '{{ url('/') }}/account-verification';
             
          },
          error: function(response) {
            loader(false);
            if (response.status == 422) {
            var errors = response.responseJSON.data;   
            $.each(errors, function(field, messages) {
                  error_msg = messages[0]; 
                  toastr.error(error_msg);
            });
            }
        else  if (response.status == 500) {
          loader(false);
            toastr.error("Something went wrong");
       
          }
          else
          {
            toastr.error(response.responseJSON.message)
     
          }
    }
      });

  });


  });
</script>
</body>
</html>