<!DOCTYPE html>
@php
    use App\General\SettingsClass;
    use Illuminate\Support\Facades\Route;

    $settings_ = DB::table('settings')->get();
    $webLogo_ = SettingsClass::getOptionValue('_web_logo', $settings_);

@endphp
<html lang="en" class="light-style layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default"
    data-assets-path="{{ url('/') }}/assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>{{ env('APP_NAME') }}</title>
    <meta name="description" content="" />
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ url($webLogo_) }}" />
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/fonts/materialdesignicons.css" />
    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/node-waves/node-waves.css" />
    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/css/theme-default.css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/css/demo.css" />
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <!-- Page CSS -->
    <!-- Helpers -->
    <script src="{{ url('/') }}/assets/vendor/js/helpers.js"></script>

    <script src="{{ url('/') }}/assets/js/config.js"></script>
    <link href='https://fonts.googleapis.com/css?family=Poppins' rel='stylesheet'>
</head>
<style>
    .authentication-wrapper .authentication-image-model {
        width: 768px;
    }

    .authentication-wrapper.authentication-cover .authentication-inner {
        min-height: 100vh;
        position: relative;
    }

    .authentication-wrapper .authentication-inner {
        width: 100%;
    }

    .authentication-wrapper.authentication-cover .authentication-image-tree {
        position: absolute;
        bottom: 3rem;
        left: 3rem;
    }

    .authentication-wrapper.authentication-cover .authentication-image {
        inset-inline-start: unset;
    }

    .authentication-wrapper .authentication-image {
        z-index: -1;
        inline-size: 100%;
        position: absolute;
        inset-inline-start: 0;
        bottom: 0;
    }

    .light-style .authentication-wrapper .authentication-bg {
        background-color: #fff;
    }

    @media (max-width: 1199.98px) {
        .authentication-cover .authentication-image-model {
            position: relative;
            width: 575px;
            top: 6rem;
        }
    }

    .full_loader {
        background: url('/loader.gif');
        background-repeat: no-repeat;
        background-attachment: fixed;
        background-position: center;
        background-size: 50px;
        z-index: 1000;
        position: absolute;
        min-width: 100vw;
        min-height: 100vh;
        overflow: hidden;
        max-width: 100vw;
        max-height: 100vh;
        background-color: white;
    }
</style>

<body>
    <div class="full_loader "></div>
    <div class="authentication-wrapper authentication-cover">
        <!-- Logo -->
        <a href="{{url('/')}}" class="auth-cover-brand d-flex align-items-center gap-2">
            <span class="app-brand-logo demo" >
                <span style="color:var(--bs-primary);">

                    <img src="{{ url($webLogo_) }}" width="200" height="70">
                </span>
            </span>
            {{-- <span class="app-brand-text demo text-heading fw-semibold">{{env("APP_NAME")}}</span> --}}
        </a>
        <!-- /Logo -->
        <div class="authentication-inner row m-0">
            <!-- /Left Section -->
            <div class="d-none d-lg-flex col-lg-7 col-xl-8 align-items-center justify-content-center p-5 pb-2">
                <div>

                    <img src="{{ url('/') }}/assets/img/illustrations/auth-cover-login.png"
                        class="authentication-image-model d-none d-lg-block bb" alt="auth-model">
                </div>

                <!-- <img src="{{ url('/') }}/assets/img/illustrations/auth-cover-mask-light.png"
          class="scaleX-n1-rtl authentication-image d-none d-lg-block w-75 b" alt=""> -->
            </div>
            <!-- /Left Section -->

            <!-- Login -->
            <div
                class="d-flex col-12 col-lg-5 col-xl-4 align-items-center authentication-bg position-relative py-sm-5 px-4 py-4">
                <div class="w-px-400 mx-auto pt-5 pt-lg-0">
                    <h4 class="mb-2">Welcome to {{ env('APP_NAME') }}! 👋</h4>
                    <p class="mb-4">Please sign-in to your account and start the adventure</p>

                    <form id="loginformAuthentication" class="mb-3 fv-plugins-bootstrap5 fv-plugins-framework "
                        novalidate="novalidate">
                        @csrf
                        <div class="form-floating form-floating-outline mb-3 fv-plugins-icon-container">
                            <input type="hidden" name="web" value="1">
                            <input type="text" class="form-control remember_email" id="email"
                                name="employee_email" placeholder="Enter your email or username" autofocus=""
                                value="">
                            <label for="email">Email</label>
                            <div
                                class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                            </div>
                        </div>
                        <div class="mb-3 fv-plugins-icon-container">
                            <div class="form-password-toggle">
                                <div class="input-group input-group-merge">
                                    <div class="form-floating form-floating-outline">
                                        <input type="password" id="password" class="form-control remember_password"
                                            name="password" placeholder="············" aria-describedby="password"
                                            value="">
                                        <label for="password">Password</label>
                                    </div>
                                    <span class="input-group-text cursor-pointer"><i
                                            class="mdi mdi-eye-off-outline"></i></span>
                                </div>
                            </div>
                            <div
                                class="fv-plugins-message-container fv-plugins-message-container--enabled invalid-feedback">
                            </div>
                        </div>
                        <div class="mb-3 d-flex justify-content-between flex-wrap">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="remember-me" value="1"
                                    name="remember-me">
                                <label class="form-check-label me-2" for="remember-me">
                                    Remember Me
                                </label>
                            </div>
                            <a href="{{ url('/') }}/forgot-password" class="float-end mb-1">
                                <span>Forgot Password?</span>
                            </a>
                        </div>
                        <button class="btn btn-primary d-grid w-100 waves-effect waves-light">
                            Sign in
                        </button>
                    </form>



                    <div class="divider my-4">
                        <div class="divider-text">or</div>
                    </div>

                    <div class="d-flex justify-content-center gap-2">
                        <a href="javascript:;"
                            class="btn btn-icon btn-lg rounded-pill btn-text-facebook waves-effect waves-light">
                            <i class="tf-icons mdi mdi-24px mdi-facebook"></i>
                        </a>
                        <a href="javascript:;"
                            class="btn btn-icon btn-lg rounded-pill btn-text-google-plus waves-effect waves-light">
                            <i class="tf-icons mdi mdi-24px mdi-google"></i>
                        </a>
                    </div>
                </div>
            </div>
            <!-- /Login -->
        </div>
    </div>


    <script src="{{ url('/') }}/assets/vendor/libs/jquery/jquery.js"></script>
    <script src="{{ url('/') }}/assets/vendor/libs/popper/popper.js"></script>
    <script src="{{ url('/') }}/assets/vendor/js/bootstrap.js"></script>
    <script src="{{ url('/') }}/assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="{{ url('/') }}/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="{{ url('/') }}/assets/vendor/js/menu.js"></script>
    <!-- endbuild -->
    <!-- Vendors JS -->
    <script src="{{ url('/') }}/assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <!-- Main JS -->
    <script src="{{ url('/') }}/assets/js/main.js"></script>
    <!-- Page JS -->
    <script src="{{ url('/') }}/assets/js/dashboards-analytics.js"></script>
    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


    <script>
        $(document).ready(function() {
            $('.full_loader').addClass('d-none');
            if (localStorage.getItem('rememberMe') === 'true') {
                $('#remember-me').prop('checked', true);
                $('.remember_email').val(localStorage.getItem('email'));
                $('.remember_password').val(localStorage.getItem('password'));
            }
        });

        function loader(show) {
            if (show) {
                $('.full_loader').removeClass('d-none');
            } else {
                $('.full_loader').addClass('d-none');
            }
        }
        // Handle form submission
        $('#loginformAuthentication').submit(function(e) {
            e.preventDefault();
            loader(true);
            var formData = new FormData(this);

            $.ajax({
                type: "POST",
                url: "{{ url('/api/login') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: formData,
                processData: false,
                contentType: false,
                success: function(response) {
                    toastr.success(response.message);
                    loader(false);
                    if ($('#remember-me').is(':checked')) {
                        localStorage.setItem('rememberMe', true);
                        localStorage.setItem('email', $('.remember_email').val());
                        localStorage.setItem('password', $('.remember_password').val());
                    } else {
                        localStorage.removeItem('rememberMe');
                        localStorage.removeItem('email');
                        localStorage.removeItem('password');
                    }

                    if (response.data.user.two_factor == 0) {
                        window.location.href = "{{ url('/two-factor') }}";
                    } else if (response.data.user.force_reset == 1) {
                        window.location.href = "{{ url('/first-rest-password') }}";
                    } else if (response.redirect_url) {
                        window.location.href = response.redirect_url;
                    } else {
                        window.location.href = "{{ url('/dashboard') }}";
                    }


                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else if (response.status == 500) {
                        loader(false);
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        });
    </script>
</body>

</html>
