@php
  use App\General\SettingsClass;
  use Illuminate\Support\Facades\Route;
  $settings_ = DB::table('settings')->get();
@endphp
<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>{{$subject}}</title>
  <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Inter:wght@100;200;300;400;500;600;700;800;900&display=swap" rel="stylesheet">
  <link rel="stylesheet" href="css/emails_style.css">
<style>
  *{
  padding: 0;
  margin: 0;
  font-family: Inter !important;
}
#email-body{
  min-width: 600px;
  width: 600px;
  max-width: 600px;
  margin: 0 auto;
  font-family: Inter !important;

}
#email-header{
  padding: 18px 25px;
  background-color: #15A7F5;
}
#email-content{
  padding: 42px 34px;
}
.greeting-section{
  font-size: 14px;
  margin-bottom: 18px;
}
#tagline-section{
  background-color:#EDEDED;
  padding: 14px;
  text-align: center;
}
.small-tagline{
  font-size: 13px;
}
.big-tagline{
  font-size: 14px;
}
.big-tagline a{
  color: #019FF3;
  font-weight: 700;
  text-decoration: none;
}
.footer-logo{
  margin-top: 16px;
  height: 35px;
}
.company-title{
  font-size: 14px;
  font-weight: 600;
}
.company-address-contact{
  color: gray;
  font-size: 12px;
}
.email-content-area p{
  font-size: 14px;
  margin-bottom: 15px;
}
.thank-you-section{
  margin-bottom: 0px !important;
}
.OTP-section{
  font-size: 30px !important;
  font-weight: 800;
}
.credentials-section{
  font-size: 16px;
}
.requirements-list{
  margin-left: 40px;
  margin-bottom: 16px;
  font-size: 14px;
}
</style>
</head>
<body>
  <div id="email-body">
    <div id="email-header">
      <img src="{{url(SettingsClass::getOptionValue('_web_logo', $settings_))}}" height="54px" width="auto">
    </div>
    <div id="email-content">
      <div class="greeting-section">Hi, <b>{{$email}}</b></div>
      <div class="email-content-area">
        <p class="OTP-section">Your Password: {{$password}},</p>
        <p>If you did not request this Credentials, you can safely ignore this email. Feel Free to change your password any time.</p>
        <p class="thank-you-section">Thank You</p>
      </div>
    </div>
    <div id="email-footer">
      <div id="tagline-section">
        <p class="small-tagline">This email is auto generated, don’t reply on this Email.</p>
        <p class="big-tagline">For any question and query, consider <a href="mailto:{{env('EMAIL_ADDRESS')}}">{{env('EMAIL_ADDRESS')}}</a></p>
      </div>
      <div class="company-details">
        <img src="{{url(SettingsClass::getOptionValue('_web_logo', $settings_))}}" class="footer-logo">
        <div class="company-title">{{env("APP_NAME")}} Group Australia</div>
        <div class="company-address-contact">
        101 Rookwood Road Yagoona – NSW 2199, Sydney, Australia<br>
        Call : 02 8005 6676
        </div>
      </div>
    </div>
  </div>
</body>
</html>