@extends('includes/layout')
@section('main-page-content')
    @php
        $step = request()->step;
        $update = 0;
        $profile_compeleted = DB::table('emp_company_details')
            ->where('id', request()->id)
            ->first();
    @endphp

    @if (request()->id == Auth::user()->id && ($step == 'company-details' || $step == 'access'))
        <script>
            window.location.href = "{{ url('/employee-onboarding/create/personal-details/' . request()->id) }}";
        </script>
    @endif

    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-header p-0">
                <div class="nav-align-top">
                    <ul class="nav nav-tabs" role="tablist">
                        <li class="nav-item @if (request()->id == Auth::user()->id) d-none @endif " role="presentation">
                            <button type="button"
                                class="nav-link  nav-link-onclick   @if ($step == 'company-details') active @endif"
                                step="company-details">
                                Company Details
                            </button>
                        </li>
                        @if (!isset($_GET['invite']))
                            <li class="nav-item" role="presentation">
                                <button type="button"
                                    class="nav-link  nav-link-onclick   @if ($step == 'personal-details') active @endif"
                                    step="personal-details">
                                    Personal Details
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button type="button"
                                    class="nav-link  nav-link-onclick   @if ($step == 'documents-certifications') active @endif"
                                    step="documents-certifications">
                                    Documents & Certifications
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button type="button"
                                    class="nav-link  nav-link-onclick    @if ($step == 'emergency-contacts') active @endif"
                                    step="emergency-contacts">
                                    Emergency Contacts
                                </button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button type="button"
                                    class="nav-link   nav-link-onclick   @if (request()->id == Auth::user()->id) d-none @endif  @if ($step == 'access') active @endif"
                                    step="access">
                                    Access
                                </button>
                            </li>
                        @endif
                        <span class="tab-slider" style="left: 0px; width: 91.1719px; bottom: 0px;"></span>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="tab-content p-0">

                    @if ($step == 'company-details')
                        @include('Employee/NewEmployeeOnboarding/companyDetails')
                        @php
                            $update = DB::table('emp_company_details')
                                ->where('id', request()->id)
                                ->count();
                        @endphp
                    @endif

                    @if ($step == 'personal-details')
                        @include('Employee/NewEmployeeOnboarding/personalDetails')
                        @php
                            $update = DB::table('emp_personal_details')
                                ->where('emp_id', request()->id)
                                ->count();
                        @endphp
                    @endif

                    @if ($step == 'documents-certifications')
                        @include('Employee/NewEmployeeOnboarding/documentsCertifications')
                        @php
                            $update = DB::table('emp_documents')
                                ->where('emp_id', request()->id)
                                ->count();
                        @endphp
                    @endif

                    @if ($step == 'emergency-contacts')
                        @include('Employee/NewEmployeeOnboarding/emergencyContacts')
                        @php
                            $update = DB::table('emp_emergency_contacts')
                                ->where('emp_id', request()->id)
                                ->count();
                        @endphp
                    @endif

                    @if ($step == 'access')
                        @include('Employee/NewEmployeeOnboarding/access')
                        @php
                            $update = DB::table('emp_access')
                                ->where('emp_id', request()->id)
                                ->count();
                        @endphp
                    @endif








                </div>
            </div>
        </div>
        <div class="d-flex justify-content-between align-items-center">

            <button class="btn btn-outline-dark waves-effect   @if ($step == 'company-details') invisible @endif"
                onclick="_back();">Back</button>

            <button class="btn btn-primary waves-effect" onclick="_sumbit();">
                @if (isset($_GET['invite']))
                    Submit
                @else
                    Submit and Next
                @endif
            </button>
        </div>
    </div>
    <!-- =======> 1 -->
@endsection

<!-- =======> 3 -->

@section('css-js')
    <!-- =======> 2 -->
    <script>
        $(document).ready(function() {

            $('.nav-link-onclick').removeClass('waves-effect');

        });



        @if ($step == 'company-details')

            $(document).ready(function() {
                _get();
                @if (request()->id != 0)
                    $('#employee_email').attr('disabled', 'disabled');
                @endif

            });

            function _get() {
                loader(true);

                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/emp-company-details-edit') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: {
                        'emp_id': '{{ request()->id }}'
                    },
                    success: function(response) {


                        var emp_types = response.data.emp_types;
                        var emp_roles = response.data.emp_roles;
                        var employee_teams = response.data.employee_teams;
                        var emp_teams = response.data.emp_teams;
                        var emp_permits = response.data.emp_permits;
                        var pkg_tiers = response.data.pkg_tiers;


                        var html = `<option value="" >--Select Employment Type--</option>`;

                        for (var i = 0; i < emp_types.length; i++) {
                            html += `<option value="${emp_types[i].id}" >${emp_types[i].title}</option>`;
                        }

                        $('#employment_type').html(html);

                        var html = `<option value="" >--Select Access Role--</option>`;

                        for (var i = 0; i < emp_roles.length; i++) {
                            html += `<option value="${emp_roles[i].code}" >${emp_roles[i].title}</option>`;
                        }

                        $('#access_role').html(html);

                        var html = ``;




                        var html = `<option value="" >--Select Tier Package--</option>`;

                        var html = `<option selected value="" >--select--</option>`;

                        for (var i = 0; i < pkg_tiers.length; i++) {
                            html += `<option value="${pkg_tiers[i].id}" >${pkg_tiers[i].title}</option>`;
                        }

                        $('#tier_id').html(html);

                        var html = ``;

                        for (var i = 0; i < emp_teams.length; i++) {
                            html += `<option value="${emp_teams[i].id}" >${emp_teams[i].title}</option>`;
                        }

                        $('#employee_teams').html(html);


                        var s2_field = $('#employee_teams').select2();

                        var html = `<option value="" >--Work Permit Type--</option>`;

                        for (var i = 0; i < emp_permits.length; i++) {
                            html += `<option value="${emp_permits[i].id}" >${emp_permits[i].title}</option>`;
                        }

                        $('#work_permit_type').html(html);


                        var _data = response.data.emp_company_details;

                        if (_data) {



                            $('#attendance_effective_from').val(_data.attendance_effective_from);
                            $('#status').val(_data.status);
                            $('#employment_end_date').val(_data.employment_end_date);
                            $('#employment_start_date').val(_data.employment_start_date);
                            $('#tax_file_no').val(_data.tax_file_no);
                            $('#work_permit_type').val(_data.work_permit_type);

                            var employee_teams = employee_teams.split(',');

                            employee_teams.forEach(function(v) {
                                if (s2_field.find('option[value="' + v + '"]').length)
                                    s2_field.find('option[value="' + v + '"]').click();
                            });

                            s2_field.val(employee_teams).trigger("change");


                            $('#access_role').val(_data.access_role);
                            $('#employment_type').val(_data.employment_type);
                            $('#employee_email').val(_data.employee_email);
                            $('#tier_id').val(_data.tier_id);
                        }

                        var _meta = response.data.meta;

                        if (_meta) {
                            $('#employee_payroll_or_external_id').val(_meta.employee_payroll_or_external_id);
                        }

                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });

            }

            function _sumbit() {
                loader(true);

                var _FormData = new FormData();

                _FormData.append("emp_id", '{{ request()->id }}');
                _FormData.append("attendance_effective_from", $('#attendance_effective_from').val());
                _FormData.append("employment_end_date", $('#employment_end_date').val());
                _FormData.append("employment_start_date", $('#employment_start_date').val());
                _FormData.append("tax_file_no", $('#tax_file_no').val());
                _FormData.append("tier_id", $('#tier_id').val());
                _FormData.append("work_permit_type", $('#work_permit_type').val());
                _FormData.append("employee_teams", $('#employee_teams').val());
                _FormData.append("access_role", $('#access_role').val());
                _FormData.append("employment_type", $('#employment_type').val());
                _FormData.append("employee_email", $('#employee_email').val());
                _FormData.append("status", $('#status').val());
                _FormData.append("credentials", $('#credentials').is(":checked") ? "1" : "0");
                _FormData.append("invited",
                    @if (isset($_GET['invite']))
                        "1"
                    @else
                        "0"
                    @endif );
                _FormData.append("employee_payroll_or_external_id", $('#employee_payroll_or_external_id').val());




                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/emp-company-details-store') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: _FormData,
                    processData: false,
                    contentType: false,
                    success: function(response) {

                   
                        @if (isset($_GET['invite']))

                            toastr.success("Email Has Been Send To Invited User");

                            setTimeout(
                                function() {
                                    window.location.href = "{{ url('invite-employee-list') }}" ;
                                },
                                1000);
                        @else
                            toastr.success(response.message);

                            setTimeout(
                                function() {
                                    window.location.href =
                                        "{{ url('/employee-onboarding/create/personal-details') }}/" +
                                        response.data.emp_id;
                                },
                                900);
                        @endif



                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });

            }

            function _back() {
                @if (isset($_GET['invite']))

                    window.location.href = "{{ url('/') }}/invite-employee-list";
                @else

                    window.location.href = "{{ url('/') }}/employee-list";
                @endif
            }

        @endif

        @if ($step == 'personal-details')

            $(document).ready(function() {
                _get();
            });

            function previewThumbnail() {
                const thumbnailInput = document.querySelector('input[name="thumbnail"]');
                const thumbnailPreview = document.getElementById('thumbnail-preview');
                const file = thumbnailInput.files[0];

                if (file) {
                    const reader = new FileReader();
                    reader.onload = function() {
                        thumbnailPreview.innerHTML =
                            `<img src="${reader.result}" class="rounded-circle" alt="Thumbnail Preview" style="width: 200px;height: 200px;">`;
                    };
                    reader.readAsDataURL(file);
                }
            }

            function _get() {

                loader(true);

                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/emp-personal-details-edit') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: {
                        'emp_id': '{{ request()->id }}'
                    },
                    success: function(response) {

                        var _data = response.data.emp_personal_details;
                        var funds = response.data.funds;
                        var funds_meta = response.data.funds_meta;

                        if (_data) {
                            $('#first_name').val(_data.first_name);
                            $('#middle_name').val(_data.middle_name ? _data.middle_name : '');
                            $('#last_name').val(_data.last_name ? _data.last_name : '');
                            $('#mobile').val(_data.mobile);
                            $('#streat_address').val(_data.streat_address);
                            $('#suburb').val(_data.suburb);
                            $('#state').val(_data.state);
                            $('#postcode').val(_data.postcode);
                            $('#date_of_birth').val(_data.date_of_birth);
                            $('#blood_group').val(_data.blood_group);
                            $('#thumbnail-preview').html(
                                `<img src="${_data.image}" class="rounded-circle" alt="Thumbnail Preview" style="width: 200px;height: 200px;">`
                            );

                        }

                        var _html = `<label class="text-dark mb-3 ">Superannuation Funds</label>`;
                        for (i = 0; i < funds.length; i++) {

                            _html += `<div class="input-group mb-1 superannuations-border-color" >
                                              <div class="input-group-text form-check mb-0 rounded-0">
                                                  <input  class="form-check-input m-auto superannuations-checkbox superannuations-checkbox${funds[i].id}" data-id="${funds[i].id}" data-title="${funds[i].title}" data-percentage="${funds[i].percentage}"  data-usi="${funds[i].usi}" data-usi-number="${funds[i].usi_number}" type="checkbox" value="" onclick="funds_checkbox(${funds[i].id});" >
                                              </div>
                                              <div class="form-control rounded-0 text-capitalize">
                                                 <div class="input-detail">
                                                <div class="col-md-3">
                                                    ${funds[i].title}
                                                </div>
                                                <div class="col-md-2">
                                                    ${funds[i].percentage}%
                                                </div>
                                                <div class="col-md-2">
                                                    ${funds[i].usi == 1 ? 'USI': 'Non-USI' }
                                                </div>

                                                <div class="col-md-2">
                                                    <input data-usi-number-id="${funds[i].id}" value="${funds[i].usi_number ?  funds[i].usi_number : '' }" placeholder="Fund number"  disabled class="superannuations-usi-number" >
                                                </div>
                                                 <div class="col-md-3">
                                                    <input  type="number" data-member-number-id="${funds[i].id}" value="${funds[i].member_number ?  funds[i].member_number : '' }" placeholder="Member number"   class="superannuations-usi-number" >
                                                </div>
                                                  </div>
                                              </div>
                                          </div>`;
                        }


                        $('.append_superannuation').html(_html);


                        for (i = 0; i < funds_meta.length; i++) {
                            $('.superannuations-checkbox' + funds_meta[i]['fund_id']).prop('checked', true);

                            if ($('.superannuations-checkbox' + funds_meta[i]['fund_id']).attr('data-usi') ==
                                0) {
                                $('[data-usi-number-id="' + funds_meta[i]['fund_id'] + '"]').removeAttr(
                                    'disabled');
                                    $('[data-member-number-id="' + funds_meta[i]['fund_id'] + '"]').removeAttr(
                                        'disabled');
                                $('input[data-usi-number-id="' + funds_meta[i]['fund_id'] + '"]').val(
                                    funds_meta[i]['usi_number']);
                                $('input[data-member-number-id="' + funds_meta[i]['fund_id'] + '"]').val(
                                        funds_meta[i]['member_number']);
                            }

                        }


                        var _meta = response.data.meta;

                        if (_meta) {
                            $('#account_title').val(_meta.account_title);
                            $('#account_number').val(_meta.account_number);
                            $('#bank_name').val(_meta.bank_name);
                        }

                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });

            }




            function funds_checkbox(id) {

                var title = $('.superannuations-checkbox' + id).attr('data-title');
                var percentage = $('.superannuations-checkbox' + id).attr('data-percentage');
                var usi = $('.superannuations-checkbox' + id).attr('data-usi');
                var usi_number = $('.superannuations-checkbox' + id).attr('data-usi-number');
                var member_number = $('.superannuations-checkbox' + id).attr('data-member-number');


                if ($('.superannuations-checkbox' + id).is(":checked") && usi == 0) {
                    $('[data-usi-number-id="' + id + '"]').removeAttr('disabled');
                    $('[data-member-number-id="' + id + '"]').removeAttr('disabled');

                } else {
                    $('[data-usi-number-id="' + id + '"]').attr('disabled', 'disabled');
                    // $('[data-member-number-id="' + id + '"]').attr('disabled', 'disabled');

                }

            }

            function _sumbit() {
                loader(true);

                var arr = [];

                var checkboxes_selected = document.querySelectorAll('.superannuations-checkbox:checked');

                for (var i = 0; i < checkboxes_selected.length; i++) {
                    var checkbox = checkboxes_selected[i];
                    var id = checkbox.getAttribute('data-id');
                    var usi = checkbox.getAttribute('data-usi');
                    var usi_number = $('input[data-usi-number-id="' + id + '"]').val();
                    var member_number = $('input[data-member-number-id="' + id + '"]').val();


                    if (!usi_number || !$.isNumeric(usi_number)) {
                        toastr.error("Please enter a valid fund number")
                        loader(false);
                        return 0;
                    }

                    arr[i] = {
                        'id': id,
                        'usi_number': usi_number,
                        'member_number': member_number

                    };


                }



                var _FormData = new FormData();
                _FormData.append("emp_id", '{{ request()->id }}');
                _FormData.append("first_name", $('#first_name').val());
                _FormData.append("last_name", $('#last_name').val());
                _FormData.append("middle_name", $('#middle_name').val());
                _FormData.append("mobile", $('#mobile').val());
                _FormData.append("streat_address", $('#streat_address').val());
                _FormData.append("suburb", $('#suburb').val());
                _FormData.append("state", $('#state').val());
                _FormData.append("postcode", $('#postcode').val());
                _FormData.append("date_of_birth", $('#date_of_birth').val());
                _FormData.append("blood_group", $('#blood_group').val());
                _FormData.append("blood_group", $('#blood_group').val());
                // _FormData.append("image", $('#thumbnail')[0].files[0]);
                _FormData.append("image", $('#thumbnail')[0].files.length ? $('#thumbnail')[0].files[0] : null);
                _FormData.append("superannuations_funds", JSON.stringify(arr));
                _FormData.append("account_title", $('#account_title').val());
                _FormData.append("account_number", $('#account_number').val());
                _FormData.append("bank_name", $('#bank_name').val());
               
               

                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/emp-personal-details-store') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: _FormData,
                    processData: false,
                    contentType: false,
                    success: function(response) {

                        toastr.success(response.message);

                        setTimeout(
                            function() {
                                window.location.href =
                                    "{{ url('/employee-onboarding/create/documents-certifications') }}/" +
                                    response.data.emp_id;
                            },
                            1000);



                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });

            }

            function _back() {
                window.location.href = "{{ url('/employee-onboarding/create/company-details') }}/{{ request()->id }}";
            }

            var apiKey = 'AgZX0rYQbjfv4k7X9FgD7qZOFbk-cdyVG8PQH582yHiIubT07RL65I2URD9GTWnB';

            var addressInputs = document.querySelectorAll('#streat_address');
            var suggestionsContainers = document.querySelectorAll('.suggestions');
            var detailsContainers = document.querySelectorAll('.details');

            addressInputs.forEach((addressInput, index) => {
                const suggestionsContainer = suggestionsContainers[index];
                const detailsContainer = detailsContainers[index];

                addressInput.addEventListener('input', async () => {
                    const query = addressInput.value;
                    suggestionsContainer.innerHTML = '';

                    if (query.length >= 3) {
                        const suggestionEndpoint =
                            `https://dev.virtualearth.net/REST/v1/Autosuggest?query=${query}&key=${apiKey}`;
                        const response = await fetch(suggestionEndpoint);
                        const data = await response.json();

                        const suggestions = data.resourceSets[0].resources[0].value;

                        suggestions.forEach(suggestion => {
                            if (suggestion.__type === "Address") {
                                const formattedAddress = suggestion.address.formattedAddress;
                                const suggestionItem = document.createElement('div');
                                suggestionItem.classList.add('suggestion');
                                suggestionItem.textContent = formattedAddress;
                                suggestionItem.addEventListener('click', () => {
                                    displayDetails(suggestion, detailsContainer);
                                    addressInput.value = formattedAddress;
                                    suggestionsContainer.innerHTML = '';
                                });
                                suggestionsContainer.appendChild(suggestionItem);
                            }
                        });
                        suggestionsContainer.classList.add('has-suggestions');
                    } else {
                        suggestionsContainer.classList.remove('has-suggestions');
                    }
                });

                document.addEventListener('click', (event) => {
                    if (event.target !== addressInput && event.target !== suggestionsContainer) {
                        suggestionsContainer.innerHTML = '';
                        detailsContainer.innerHTML = '';
                        suggestionsContainer.classList.remove('has-suggestions');
                    }
                });
            });

            function displayDetails(suggestion, detailsContainer) {
                if (suggestion.__type === "Address") {
                    const address = suggestion.address;
                    const details = `
              <h2>Details</h2>
              <p>Country/Region: ${address.countryRegion}</p>
              <p>Locality: ${address.locality}</p>
              <p>Admin District: ${address.adminDistrict}</p>
              <p>Postal Code: ${address.postalCode}</p>
              <p>Street Address: ${address.addressLine}</p>
              <p>Street Name: ${address.streetName}</p>
              <p>Formatted Address: ${address.formattedAddress}</p>
          `;
                    detailsContainer.innerHTML = details;
                }
            }

        @endif

        @if ($step == 'documents-certifications')

            $(document).ready(function() {
                _get();
            });

            function _get() {

                loader(true);

                    $.ajax({
                        type: "POST",
                        url: "{{ url('/api/emp-documents-edit') }}",
                        headers: {
                            'X-CSRF-TOKEN': '{{ csrf_token() }}'
                        },
                        data: {
                            'emp_id': '{{ request()->id }}'
                        },
                        success: function(response) {


                            var _data = response.data.required_documents;
                            var emp_documents = response.data.emp_documents;
                            var save_docs = {};
                            var _save_docs = '';

                            var html = ``;
                            var required_document;

                            for (var i = 0; i < emp_documents.length; i++) {
                                if (!save_docs.hasOwnProperty(emp_documents[i].required_document)) {
                                    save_docs[emp_documents[i].required_document] = {};
                                }
                                save_docs[emp_documents[i].required_document][emp_documents[i].required_document_field] = emp_documents[i].value;
                            }

                            for (var i = 0; i < _data.length; i++) {

                                if (_data[i].for_who == 1) {
                                    continue;
                                }

                                html += `<div class="row mt-4">
                                                                <div class="form-group col-md-4 mt-1">
                                                                    <p class=""><span style="font-weight:bold;">${_data[i].title}</span></p>
                                                                </div>
                                                                <div class="row col-md-8">
                                                                `;

                                required_document = _data[i].required_document_field;

                                for (var j = 0; j < required_document.length; j++) {

                                    if (required_document[j].status == 0) {
                                        continue;
                                    }
                                    _save_docs = save_docs[_data[i].id] ? save_docs[_data[i].id][required_document[j].id] ? save_docs[_data[i].id][required_document[j].id] : "" : "";

                                    html += `<div class="form-group col-md-6 mt-3  ${required_document[j].field_type == 'file' ? 'position-relative': '' } " >
                                                        <lable>${required_document[j].field_name} <span class="text-danger">${required_document[j].field_required == '1' ? '*' : ''}</span>  </lable>
                                                            ${required_document[j].field_type == 'file' ? '<div class="license">' : '' }
                                                                <input type="${required_document[j].field_type}" placeholder="${required_document[j].field_name}"  class="form-control input-file mt-2  ${required_document[j].field_required == '1' ? 'required-class' : ''} "    name="document_array[${_data[i].id}][${required_document[j].id}]" value="${required_document[j].field_type != 'file' ? _save_docs : '' }" >
                                                            ${required_document[j].field_type == 'file' ?
                                                            `</div>
                                                            <a href="${required_document[j].field_type == 'file' ? "{{url('/')}}/"+_save_docs : '' }" target="_blank" class="eye-icon  ${_save_docs == ''  ?  'd-none' : ''  } "> <span class="mdi mdi-eye text-primary" role="button"></span></a>
                                                            <a href="${required_document[j].field_type == 'file' ? "{{url('/')}}/"+_save_docs : '' }" download class="arrow-icon  ${_save_docs == ''  ?  'd-none' : ''  }"> <span class="mdi mdi-cloud-download mdi-20px text-info me-2"></span></a>` : '' } 
                                                        </div>`;
                                }

                                html += `</div></div>`;
                            }

                            $('#doc-form').html(html);

                            loader(false);

                            $('input[type="file"]').change(function(event) {
                                var fileSize = this.files[0].size;
                                var fileSizeInMB = fileSize / (1024 * 1024);
                                if (Math.round(fileSizeInMB) > 1) {
                                    toastr.error("Maximum file size must be 1MB.");
                                    $(this).val('');
                                }
                            });

                        },
                        error: function(response) {
                            loader(false);
                            if (response.status == 500) {
                                toastr.error("Something went wrong")
                            } else {
                                toastr.error(response.responseJSON.message)
                            }
                        }
                    });

            }

            function _sumbit() {
                loader(true);
                    
                var _FormData = new FormData($('#doc-form')[0]);
                _FormData.append("emp_id", '{{ request()->id }}');

                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/emp-documents-store') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: _FormData,
                    processData: false,
                    contentType: false,
                    success: function(response) {

                        toastr.success(response.message);
                        setTimeout(
                            function() {
                                window.location.href =
                                    "{{ url('/employee-onboarding/create/emergency-contacts') }}/" +
                                    response.data.emp_id;
                            },
                            1000);

                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });

            }

            function _back() {
                window.location.href = "{{ url('/employee-onboarding/create/personal-details') }}/{{ request()->id }}";
            }

        @endif

        @if ($step == 'emergency-contacts')

            var objs = {};

            $(document).ready(function() {
                _get();
            });


            function _create_or_update_modal(id) {

                var obj = objs[id];



                if (!obj) {
                    obj = null;
                }


                $('#AddUpdateContectLabel').html(obj ? 'Update Contact' : 'Contact');
                $('#contect_id').val(obj ? obj.id : '0');
                $('#contect_name').val(obj ? obj.name : '');
                $('#contect_relation').val(obj ? obj.relation : '');
                $('#contect_phone').val(obj ? obj.phone : '');
                $('#contect_address').val(obj ? obj.address : '');
                $('#contect_email').val(obj ? obj?.email : '');

                $('#AddUpdateContect').modal('show');
            }

            function _get() {

                loader(true);

                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/emp-emergency-contacts-edit') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: {
                        'emp_id': '{{ request()->id }}'
                    },
                    success: function(response) {



                        var _data = response.data.emp_emergency_contacts;

                        objs = _data;

                        var html = ``;

                        for (var i = 0; i < _data.length; i++) {

                            html += `<tr>
                                              <td>
                                                <span class="fw-medium">${_data[i].name}</span>
                                              </td>
                                              <td>${_data[i].relation}</td>
                                              <td>${_data[i].phone}</td>
                                              <td>${_data[i].email ? _data[i].email : '-' }</td>
                                              <td>${_data[i].address ?  _data[i].address : '-'}</td>
                                              <td>
                                                <button class="btn p-0"  onclick="_create_or_update_modal(${i});"  ><span class="mdi mdi-square-edit-outline mdi-20px text-warning me-2"></span></button>
                                                <button class="btn p-0" onclick="_delete_modal(${_data[i].id});"  ><span class="mdi mdi-trash-can-outline mdi-20px text-danger me-2"></span></button>
                                              </td>
                                            </tr>`
                        }

                        $('.contect-table').html(html);

                        if (html == ``) {
                            $('.contect-table').html(
                                `<tr><td class="text-center "  colspan="5" > No Emergency Contact added yet </td></tr>`
                            );
                        }




                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });

            }

            function _store() {
                loader(true);

                var _FormData = new FormData();
                _FormData.append("emp_id", '{{ request()->id }}');
                _FormData.append("id", $('#contect_id').val());
                _FormData.append("address", $('#contect_address').val());
                _FormData.append("phone", $('#contect_phone').val());
                _FormData.append("relation", $('#contect_relation').val());
                _FormData.append("email", $('#contect_email').val());
                _FormData.append("name", $('#contect_name').val());

                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/emp-emergency-contacts-store') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: _FormData,
                    processData: false,
                    contentType: false,
                    success: function(response) {

                        toastr.success(response.message);
                        _get();



                        $('#AddUpdateContect').modal('hide');

                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });

            }

            function _delete(_this) {
                loader(true);

                var _FormData = new FormData();
                _FormData.append("id", $(_this).attr('data-id'));

                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/emp-emergency-contacts-delete') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: _FormData,
                    processData: false,
                    contentType: false,
                    success: function(response) {

                        toastr.success(response.message);
                        _get();
                        $('#DeleteContect').modal('hide');

                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });

            }

            function _delete_modal(id) {
                $('#delete-contect-id').attr('data-id', id);
                $('#DeleteContect').modal('show');
            }


            function _sumbit() {
                loader(true);

                var _FormData = new FormData();
                _FormData.append("emp_id", '{{ request()->id }}');

                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/emp-emergency-contacts-count') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: _FormData,
                    processData: false,
                    contentType: false,
                    success: function(response) {




                        @if (request()->id == Auth::user()->id && $profile_compeleted->compeleted == 1)



                            setTimeout(
                                function() {
                                    window.location.href = "{{ url('/user-profile') }}" + "/" + response
                                        .data.emp_id;
                                },
                                1000);
                        @elseif (request()->id == Auth::user()->id)

                            setTimeout(
                                function() {
                                    window.location.href = "{{ url('/employee-profile-compeleted') }}";
                                },
                                1000);
                        @else

                            setTimeout(
                                function() {
                                    window.location.href =
                                        "{{ url('/employee-onboarding/create/access') }}/" + response.data
                                        .emp_id;
                                },
                                1000);
                        @endif

                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });

            }

            function _back() {
                window.location.href =
                    "{{ url('/employee-onboarding/create/documents-certifications') }}/{{ request()->id }}";
            }
        @endif

        @if ($step == 'access')

            $(document).ready(function() {
                _get();
            });

            function _get() {

                loader(true);

                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/emp-access-edit') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: {
                        'emp_id': '{{ request()->id }}'
                    },
                    success: function(response) {

                        var _data = response.data.emp_access;


                        if (_data) {



                            if (_data.web_app == 1) {
                                $("#access_web_app").attr("checked", "checked");
                            } else {
                                $("#access_web_app").removeAttr("checked");
                            }


                            if (_data.mobile_app == 1) {
                                $("#access_mobile_app").attr("checked", "checked");
                            } else {
                                $("#access_mobile_app").removeAttr("checked");
                            }

                            if (_data.attendance == 1) {

                                $("#access_attendance").attr("checked", "checked");
                            } else {

                                $("#access_attendance").removeAttr("checked");
                            }

                            if (_data.timesheet_reminders == 1) {
                                $("#access_timesheet_reminders").attr("checked", "checked");
                            } else {
                                $("#access_timesheet_reminders").removeAttr("checked");
                            }

                            if (_data.email == 1) {
                                $("#access_email").attr("checked", "checked");
                            } else {
                                $("#access_email").removeAttr("checked");
                            }

                            if (_data.timesheet == 1) {
                                $("#access_timesheet").attr("checked", "checked");
                            } else {
                                $("#access_timesheet").removeAttr("checked");
                            }

                        }





                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });

            }

            function _sumbit() {
                loader(true);

                var _FormData = new FormData();
                _FormData.append("emp_id", '{{ request()->id }}');
                _FormData.append("email", $('#access_email').is(':checked') ? "1" : "0");
                _FormData.append("timesheet_reminders", $('#access_timesheet_reminders').is(':checked') ? "1" : "0");
                _FormData.append("timesheet", $('#access_timesheet').is(':checked') ? "1" : "0");
                _FormData.append("attendance", $('#access_attendance').is(':checked') ? "1" : "0");
                _FormData.append("web_app", $('#access_web_app').is(':checked') ? "1" : "0");
                _FormData.append("mobile_app", $('#access_mobile_app').is(':checked') ? "1" : "0");
                $.ajax({
                    type: "POST",
                    url: "{{ url('/api/emp-access-store') }}",
                    headers: {
                        'X-CSRF-TOKEN': '{{ csrf_token() }}'
                    },
                    data: _FormData,
                    processData: false,
                    contentType: false,
                    success: function(response) {

                        toastr.success(response.message);

                        setTimeout(
                            function() {
                                window.location.href = "{{ url('/employee-list') }}"
                            },
                            1000);




                        loader(false);

                    },
                    error: function(response) {
                        loader(false);
                        if (response.status == 500) {
                            toastr.error("Something went wrong")
                        } else {
                            toastr.error(response.responseJSON.message)
                        }
                    }
                });

            }

            function _back() {
                window.location.href = "{{ url('/employee-onboarding/create/emergency-contacts') }}/{{ request()->id }}";
            }
        @endif
    </script>


    <style>
        .input-detail {
            display: flex;
        }


        @media only screen and (max-width: 520px) {
            .input-detail {
                display: block;
            }

            .superannuations-usi-number {
                width: 100%;
            }

        }
        

        .eye-icon {
            position: absolute;
            top: 40px;
            right: 30px;
        }

        .arrow-icon {
            position: absolute;
            top: 40px;
            right: 50px;
        }

        @media only screen and (max-width: 280px) {
            .text-field {
                margin-top: 39px;
            }

            .input-file {
                margin-left: -10px;
            }
        }



        @media only screen and (min-width: 913px)and (max-width: 1024px) {
            .eye-icon {
                right: 18px;
            }

            .arrow-icon {
                right: 35px;
            }
        }


        @media only screen and (min-width: 320px)and (max-width: 1280px) {


            .superannuations-usi-number {
                width: 100%;
            }
        }

       
        @media only screen and (min-width: 768px)and (max-width: 1366px) {

            .superannuations-usi-number {
                width: 100%;
            }
        }
        @media only screen and (min-width: 320px)and (max-width: 1024px) {
            
        }

        .nav .nav-link:hover,
        .nav .nav-link:focus,
        .nav .nav-link:not(.active):hover {
            color: #544f5a !important;
        }

        .suggestions {
            margin-top: 10px;
            max-height: 200px;
            overflow-y: auto;
            max-width: 350px;
            border: none;
            z-index: 100;
        }

        .suggestion {
            padding: 10px;
            cursor: pointer;
        }

        .suggestion:hover {
            background-color: #f5f5f5;
        }

        .suggestions.has-suggestions {
            border: 1px solid #ccc;
        }

        .superannuations-usi-number {
            border: 1px solid #d4d3d5 !important;
            border-radius: 5px !important;
            outline: none !important;
        }

        .superannuations-border-color:focus-within .form-control,
        .superannuations-border-color:focus-within .input-group-text {
            border: 1px solid #d4d3d5 !important;
        }
    </style>
@endsection
