<!DOCTYPE html>
@php

    use App\General\SettingsClass;
    use Illuminate\Support\Facades\Route;

    $settings_ = DB::table('settings')->get();
    $webLogo_ = SettingsClass::getOptionValue('_web_logo', $settings_);
    $link_management = '';
    $team_id = '';

    if (isset($_GET['key']) && !empty($_GET['key'])) {
        $link_management = DB::table('link_management')
            ->where(['secret_key' => $_GET['key'], 'status' => '1'])
            ->first();
        $team_id = isset($link_management->team_ids) ? (string) $link_management->team_ids : '';
    }

@endphp
<html lang="en" class="light-style layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default"
    data-assets-path="{{ url('/') }}/assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>{{ env('APP_NAME') }}</title>
    <meta name="description" content="" />
    <link rel="icon" type="image/x-icon" href="{{ url($webLogo_) }}" />
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/fonts/materialdesignicons.css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/node-waves/node-waves.css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/css/theme-default.css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/css/demo.css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.7.1/jquery.min.js"></script>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.css">
    <script src="https://code.jquery.com/ui/1.12.1/jquery-ui.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jSignature/2.1.2/jSignature.min.js"></script>
    <script src="{{ url('/') }}/assets/vendor/js/helpers.js"></script>
    <script src="{{ url('/') }}/assets/js/config.js"></script>
    <link href='https://fonts.googleapis.com/css?family=Poppins' rel='stylesheet'>
</head>

<style>
    .authentication-wrapper .authentication-image-model {
        width: 768px;
    }

    .authentication-wrapper.authentication-cover .authentication-inner {
        min-height: 100vh;
        position: relative;
    }

    .authentication-wrapper .authentication-inner {
        width: 100%;
    }

    .authentication-wrapper.authentication-cover .authentication-image-tree {
        position: absolute;
        bottom: 3rem;
        left: 3rem;
    }

    .authentication-wrapper.authentication-cover .authentication-image {
        inset-inline-start: unset;
    }

    .authentication-wrapper .authentication-image {
        z-index: -1;
        inline-size: 100%;
        position: absolute;
        inset-inline-start: 0;
        bottom: 0;
    }

    .light-style .authentication-wrapper .authentication-bg {
        background-color: #fff;
    }

    .mt-class {
        margin-top: 100px;
    }

    @media (max-width: 1199.98px) {
        .authentication-cover .authentication-image-model {
            position: relative;
            width: 575px;
            top: 6rem;
        }
    }

    .full_loader {
        background: url('/loader.gif');
        background-repeat: no-repeat;
        background-attachment: fixed;
        background-position: center;
        background-size: 50px;
        z-index: 1000;
        position: absolute;
        min-width: 100% !important;
        min-height: 100% !important;
        overflow: hidden;
        max-width: 100% !important;
        max-height: 100% !important;
        background-color: white;
    }

    .eye-icon {
        position: absolute;
        top: 40px;
        right: 30px;
    }

    .arrow-icon {
        position: absolute;
        top: 40px;
        right: 50px;
    }



    .input-detail {
        display: flex;
    }

    @media only screen and (min-width: 913px)and (max-width: 1024px) {
        .eye-icon {
            right: 18px;
        }

        .arrow-icon {
            right: 35px;
        }
    }

    @media only screen and (max-width: 520px) {
        .input-detail {
            display: block;
        }

        .superannuations-usi-number {
            width: 100%;
        }

    }


    @media only screen and (max-width: 280px) {
        .text-field {
            margin-top: 39px;
        }

        .input-file {
            margin-left: -10px;
        }
    }


    @media only screen and (min-width: 320px)and (max-width: 1280px) {


        .superannuations-usi-number {
            width: 100%;
        }
    }


    @media only screen and (min-width: 768px)and (max-width: 1366px) {

        .superannuations-usi-number {
            width: 100%;
        }
    }


    @media (max-width: 425px) {
        #signature {
            height: 150px;
            background: red;
            padding: 0px !important;
            margin: 0px !important;
        }

        #signature canvas {
            width: 100% !important;
            height: 100% !important;
        }
    }

    .nav .nav-link:hover,
    .nav .nav-link:focus,
    .nav .nav-link:not(.active):hover {
        color: #544f5a !important;
    }

    .suggestions {
        margin-top: 10px;
        max-height: 200px;
        overflow-y: auto;
        max-width: 350px;
        border: none;
        z-index: 100;
    }

    .suggestion {
        padding: 10px;
        cursor: pointer;
    }

    .suggestion:hover {
        background-color: #f5f5f5;
    }

    .suggestions.has-suggestions {
        border: 1px solid #ccc;
    }

    .superannuations-usi-number {
        border: 1px solid #d4d3d5 !important;
        border-radius: 5px !important;
        outline: none !important;
    }

    .superannuations-border-color:focus-within .form-control,
    .superannuations-border-color:focus-within .input-group-text {
        border: 1px solid #d4d3d5 !important;
    }
</style>

<body>

    <div class="full_loader"></div>
    <div class="container-xxl flex-grow-1 container-p-y h-container">

        <div class="">
            <a href="{{ url('/') }}" class="auth-cover-brand d-flex align-items-center gap-2">
                <span class="app-brand-logo demo">
                    <span style="color:var(--bs-primary);">
                        <img src="{{ url($webLogo_) }}" width="200" height="70">
                    </span>
                </span>
            </a>
        </div>

        <div class="card mb-1 mt-class">

            <div class="card-body mb-2">

                <div class="border-bottom pb-2 ps-1">
                    <div class="h4 pb-0 mb-0 ">External Employee Onboarding</div>
                    <small>Employee Onboarding</small>
                </div>

                @if (!isset($link_management->id))
                    <div class="row mt-3">
                        <div class="col-md-12 mb-3 py-3 text-danger text-center">
                            <b> The link does not match or may be inactive. Please contact the admin. </b>
                        </div>
                    </div>
                @endif

                <div class="row mt-3 mb-3">
                    <div class="col-md-12 bg-primary  py-3 text-white rounded">
                        <b> Personal Details </b>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-8">
                        <div class="row">
                            <div class="col-md-4 form-group mb-3">
                                <label for="" class="text-dark">First Name <span
                                        class="text-danger">*</span></label>
                                <input type="text" id="first_name" class=" form-control mt-1"
                                    placeholder="First Name">
                            </div>
                            <div class="col-md-4 form-group mb-3">
                                <label for="" class="text-dark">Middle Name</label>
                                <input type="text" id="middle_name" class="form-control mt-1"
                                    placeholder="Middle Name">

                            </div>
                            <div class="col-md-4 form-group mb-3">
                                <label for="" class="text-dark">Last Name <span
                                        class="text-danger">*</span></label>
                                <input type="text" id="last_name" class="form-control mt-1" placeholder="Last Name">
                            </div>
                            <div class="col-md-4 form-group">
                                <label for="email" class="text-dark">Employee Email <span
                                        class="text-danger">*</span></label>
                                <input type="email" id="employee_email" class="form-control mt-1"
                                    placeholder="Employee Email">
                            </div>
                            <div class="col-md-4 form-group">
                                <label for="" class="text-dark">Date of Birth <span
                                        class="text-danger">*</span></label>
                                <input type="date" id="date_of_birth" class="form-control mt-1"
                                    placeholder="Date of Birth">
                            </div>
                            <div class="col-md-4 form-group">
                                <label for="mobile" class="text-dark">Mobile <span
                                        class="text-danger">*</span></label>
                                <div class="input-group mb-3 mt-1">
                                    <span class="input-group-text"
                                        style="background-color: #e9ecef;border-radius:0px;">+61</span>
                                    <input type="text" id="mobile" placeholder="Mobile" class="form-control">
                                </div>
                            </div>
                            <div class="col-md-12 form-group">
                                <label for="mobile" class="text-dark">Street Address <span class="text-danger">*</span></label>
                                <div class="input-group mb-3" style="position: relative;">
                                    <input type="text" class="form-control address-input" id="streat_address" name="streat_address"
                                        placeholder="Search for..." aria-label="Search for..." aria-describedby="button-addon2">
                                    <button class="btn btn-primary" type="button" id="search_button"><i
                                            class="mdi mdi-magnify"></i></button>
                                </div>
                                <div class="suggestions m-0"
                                    style="background:white; z-index: 100; z-index: 100; position: absolute; ">
                                </div>
                                <div class="details"></div>
                            </div>
                            <div class="col-md-4 form-group mb-3">
                                <label for="suburb" class="text-dark">Town/Suburb <span
                                        class="text-danger">*</span></label>
                                <input type="text" id="suburb" placeholder="Town/Suburb"
                                    class="form-control mt-1">
                            </div>
                            <div class="col-md-4 form-group mb-3">
                                <label for="state" class="text-dark">State <span
                                        class="text-danger">*</span></label>
                                <input type="text" id="state" placeholder="State" class="form-control mt-1">
                            </div>
                        </div>
                    </div>

                    <div class="col-md-4 form-group mb-3">
                        <label for="thumbnail" class="text-dark">Profile Image <span
                                class="text-danger">*</span></label>
                        <input type="file" class="form-control mt-1" name="thumbnail" required id="thumbnail"
                            accept="image/*" onchange="previewThumbnail()">
                        <div id="thumbnail-preview" class="mt-3 text-center">
                            <img src="{{ url('/upload/images/default.png') }}" class="rounded-circle"
                                alt="Thumbnail Preview" style="width:200px;height:200px;">
                        </div>
                    </div>

                </div>

                <div class="row mb-3">
                    <div class="col-md-12 bg-primary  py-3 text-white rounded">
                        <b> Work Related Info </b>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-4 form-group mb-3">
                        <label class="text-dark">Job Title<span class="text-danger">*</span></label>
                        <input type="text" id="job_title" class="form-control mt-1" placeholder="Job Title">
                    </div>
                    <div class="col-md-4 form-group mb-3">
                        <label for="employer_name" class="text-dark">Employer Company Name <span
                                class="text-danger">*</span></label>
                        <input type="text" id="employer_name" class="form-control mt-1"
                            placeholder="Employer Company Name">
                    </div>
                    <div class="col-md-4 form-group mb-3">
                        <label for="site_address" class="text-dark">Worker Type <span
                                class="text-danger">*</span></label>
                        <select id="worker_type" class="form-select mt-1">
                            <option value="">--Worker Type--</option>
                        </select>
                    </div>
                    <div class="col-md-4 form-group mb-3 ml-1">
                        <label class="form-check-label"> Are you trade qualified </label>
                        <input class="form-check-input" id="trade_qualified" type="checkbox" value="1"
                            onchange="disabled_it(this,'#trade_qualified_year');" checked>
                        <input type="number" id="trade_qualified_year" class="form-control mt-1"
                            placeholder="Years Completed">
                    </div>
                    <div class="col-md-4 form-group mb-3 ml-1">
                        <label class="form-check-label"> Are you trade licensed </label>
                        <input class="form-check-input" id="trade_licensed" type="checkbox"
                            onchange="disabled_it(this,'#trade_licensed_year');" value="1" checked>
                        <input type="number" id="trade_licensed_year" class="form-control mt-1"
                            placeholder="License Number">
                    </div>
                    <div class="col-md-4 form-group mb-3">
                        <label class="text-dark">Work Experience <span class="text-danger">*</span></label>
                        <select id="work_experience" class="form-select mt-1">
                            <option value="">--Work Experience--</option>
                        </select>
                    </div>
                    <div class="col-md-4 form-group mb-3">
                        <label class="text-dark">Year Commenced in Construction <span
                                class="text-danger">*</span></label>
                        <input type="number" id="year_commenced" class="form-control mt-1"
                            placeholder="Year Commenced in Construction">
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-12 bg-primary  py-3 text-white rounded">
                        <b> Citizenship Status </b>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-12 form-group mb-3 ml-1">
                        <label class="form-check-label">Are you legally allowed to work in Australia? </label>
                        <label class="mt-4 mt-sm-4 mt-md-0"><input class="form-check-input" name="legally_australia"
                                type="radio" value="1" checked> Yes</label>
                        <label class="mt-4 mt-sm-4 mt-md-0"><input class="form-check-input ms-3"
                                name="legally_australia" type="radio" value="0"> No</label>
                    </div>
                </div>

                <div class="row mt-3">
                    <div class="col-md-12 form-group mb-3 ml-1">
                        <div class="row mt-3">
                            <div class="col-md-8">
                                <label class="form-check-label ml-2"><input class="form-check-input"
                                        name="citizenship_status" value="0"
                                        onchange="$('#temporary_student_visa').removeAttr('disabled');" type="radio"
                                        checked> Visa holder (attach visa here; if copy is not available, bring it on
                                    the morning of work) </label>
                                <div class="row">
                                    <div class="col-md-6">
                                        <input type="file" id="temporary_student_visa" class="form-control mt-3">
                                    </div>
                                    <!-- <div class="col-md-3 d-flex align-items-center citizenship_link_box">
                                            <div class="mt-3">
                                                Download :
                                            </div>
                                            <a href="/app_store.png" class="ml-3 mt-3 citizenship_link" download  >
                                                <span class="mdi mdi-download mdi-20px text-primary"></span>
                                            </a>
                                        </div> -->
                                </div>
                            </div>
                            <div class="col-md-3 mt-4 mt-sm-0 mt-md-0">
                                <label class="form-check-label"><input class="form-check-input"
                                        name="citizenship_status" value="1"
                                        onchange="$('#temporary_student_visa').val('').attr('disabled','disabled');"
                                        type="radio"> Aussie citizen </label>
                            </div>
                        </div>
                    </div>
                </div>


                {{-- <div class="row mb-3">
                        <div class="col-md-12 bg-primary  py-3 text-white rounded">
                        <b> Bank Details </b>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12 mb-1 mt-1 row">
                            <div class="col-md-4 form-group mb-3">
                                <label  class="text-dark">Account Name <span class="text-danger">*</span></label>
                                <input type="text" placeholder="Account Name"  id="account_title" class="form-control mt-1">
                            </div>
                            <div class="col-md-4 form-group mb-3">
                                <label  class="text-dark">Account Number <span class="text-danger">*</span></label>
                                <input type="text"  placeholder="Account Number"  id="account_number" class="form-control mt-1">
                            </div>
                            <div class="col-md-4 form-group mb-3">
                                <label  class="text-dark">BSB <span class="text-danger">*</span></label>
                                <input type="number"  placeholder="BSB" maxlength="6" id="bank_name" class="form-control mt-1">
                            </div>
                        </div>

                    </div> --}}

                {{-- <div class="row mb-3">
                        <div class="col-md-12 bg-primary  py-3 text-white rounded">
                        <b> Superannuation Funds / Unioin Funds </b>
                        </div>
                    </div>

                    <div class="row">
                        <div class="col-md-12  mb-3 mt-1 append_superannuation">

                        </div>
                    </div> --}}

                <div class="row mb-3">
                    <div class="col-md-12 bg-primary  py-3 text-white rounded">
                        <b> Emergency Contacts </b>
                        <spna>(Give emergency contacts if classified)</span>
                    </div>
                </div>

                <div class="row">
                    {{-- <div class="col-md-12 form-group mb-3 ml-1">
                            <label class="form-check-label" >Are you classified as high risk? (If yes, complete a few questions) </label>
                            <input class="form-check-input" type="checkbox" id="classified_high_risk" value="1" onchange="/*hide_contects_rows(this)*/"  checked >
                        </div>   --}}
                    <div class="col-md-12 mt-1 row row_contact">
                        <div class="col-md-4 form-group mb-3">
                            <label class="text-dark">Name <span class="text-danger">*</span></label>
                            <input type="text" placeholder="Name" id="contact_name_first"
                                class="form-control mt-1">
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label class="text-dark">Relation <span class="text-danger">*</span></label>
                            <select class="form-select mt-1" id="contact_relation_first">
                                <option value="">Relation</option>
                                <option value="Mother">Mother</option>
                                <option value="Father">Father</option>
                                <option value="Son">Son</option>
                                <option value="Daughter">Daughter</option>
                                <option value="Brother">Brother</option>
                                <option value="Sister">Sister</option>
                                <option value="Spouse">Spouse</option>
                                <option value="Uncle">Uncle</option>
                                <option value="Grand Father">Grand Father</option>
                                <option value="Friend">Friend</option>
                                <option value="Partner">Partner</option>
                                <option value="Other">Other</option>
                            </select>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="mobile" class="text-dark">Phone <span class="text-danger">*</span></label>
                            <div class="input-group mb-3 mt-1">
                                <span class="input-group-text"
                                    style="background-color: #e9ecef;border-radius:0px;">+61</span>
                                <input type="number" id="contact_phone_first" placeholder="Phone"
                                    class="form-control">
                            </div>
                        </div>
                    </div>

                    {{-- <div class="col-md-12 mt-1 row row_contact">
                            <div class="col-md-4 form-group mb-3">
                                <label  class="text-dark">Name</label>
                                <input type="text" placeholder="Name" id="contact_name_second" class="form-control mt-1">
                            </div>
                            <div class="col-md-4 form-group mb-3">
                                <label  class="text-dark">Relation</label>
                                <select class="form-select mt-1" id="contact_relation_second">
                                    <option value="">Relation</option>
                                    <option value="Mother">Mother</option>
                                    <option value="Father">Father</option>
                                    <option value="Son">Son</option>
                                    <option value="Daughter">Daughter</option>
                                    <option value="Brother">Brother</option>
                                    <option value="Sister">Sister</option>
                                    <option value="Spouse">Spouse</option>
                                    <option value="Uncle">Uncle</option>
                                    <option value="Grand Father">Grand Father</option>
                                    <option value="Friend">Friend</option>
                                    <option value="Partner">Partner</option>
                                    <option value="Other">Other</option>
                                </select>
                            </div>
                            <div class="col-md-4 form-group mb-2 mb-sm-3">
                                <label for="Phone" class="text-dark">Phone</label>
                                <div class="input-group mb-3 mt-1">
                                    <span class="input-group-text" style="background-color: #e9ecef;border-radius:0px;">+61</span>
                                    <input type="number" placeholder="Phone" id="contact_phone_second" class="form-control">
                                </div>
                            </div>
                        </div> --}}

                </div>

                <div class="row">
                    <div class="col-md-12 bg-primary  py-3 text-white rounded">
                        <b> Documents & Certifications </b></span>
                    </div>
                </div>

                <div class="row mb-2">
                    <div class="col-md-12">
                        <form action="" id="doc-form" method="post" enctype="multipart/form-data">

                        </form>
                    </div>
                </div>

                <div class="row mt-3 mb-3">
                    <div class="col-md-12 bg-primary  py-3 text-white rounded">
                        <b> Medical Checklist </b>
                    </div>
                </div>

                <div class="col-md-12 form-group ml-1">
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <label class="form-check-label">Allergies</label>
                            <input class="form-check-input" id="allergies" type="checkbox"
                                onchange="disabled_it(this,'#details_allergies');" value="1">
                        </div>
                        <div class="col-md-6 mb-3">
                            <label class="form-check-label">Previous injuries</label>
                            <input class="form-check-input" id="previous_injuries" type="checkbox"
                                onchange="disabled_it(this,'#details_previous_injuries');" value="1">
                        </div>
                    </div>
                    <div class="row">
                        <div class="col-md-6 mb-3">
                            <textarea class="form-control" id="details_allergies" disabled rows="3"></textarea>
                        </div>
                        <div class="col-md-6 mb-3">
                            <textarea class="form-control" id="details_previous_injuries" disabled rows="3"></textarea>
                        </div>
                    </div>

                    <div class="row mt-3">
                        <div class="col-md-6 mb-3">
                            <label class="form-check-label">Existing medical conditions</label>
                            <textarea class="form-control mt-1" id="medical_condition" row="1" placeholder="Existing medical conditions"
                                style="height: 17px !important;"></textarea>
                        </div>
                        <div class="col-md-6">
                            <label class="form-check-label ">Attach files if available/needed </label>
                            <input type="file" id="medical_attach_files" accept="image/*" data-i="0"
                                class="form-control mt-1">
                        </div>
                    </div>
                    <div class="d-flex mt-3 attachment_box mb-3">
                    </div>
                </div>

                <div class="row mb-3">
                    <div class="col-md-12 bg-primary  py-3 text-white rounded">
                        <b> Signature </b>
                    </div>
                </div>

                <div class="row">
                    <div class="col-md-6">
                        <label class="text-dark"> Please signature in the box <span class="text-danger">*</span> <i
                                class="mdi mdi-pencil"></i></label>
                    </div>
                    <div class="col-md-6">
                        <div class="text-end">
                            <button type="button" id="clear" class="btn btn-sm btn-primary">Clear
                                Signature</button>
                        </div>
                    </div>
                </div>

                <div class="row mt-3">
                    <div id="signature" class="border rounded"></div>
                </div>

                <div class="mt-3 d-flex justify-content-end">
                    <button type="button" onclick="_sumbit()" @if (!isset($link_management->id)) disabled @endif
                        class="btn btn-primary">Sign Up</button>
                </div>



            </div>

        </div>

        <div class="card mb-1 mt-5">
            <div class="card-body">
                <div class="mt-3 d-flex justify-content-center text-center flex-column">
                    <b>If you have an account, download the EZISign app to sign in.</b>
                    <div class="d-flex justify-content-center mt-4">
                        <div>
                            <a href="#">
                                <image src="/app_store.png" style="width: 80%;">
                            </a>
                        </div>
                        <div>
                            <a href="https://play.google.com/store/apps/details?id=com.gtech.ezisign&hl=en_US&gl=US"
                                target="_blank">
                                <image src="/google_play.png" style="width: 80%;">
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>

    </div>
    <script src="https://maps.googleapis.com/maps/api/js?key=AIzaSyB7aLtWqhztn7r4Fcce7WqQT-Qdlpl7MnQ&callback=initMap&v=weekly" async defer></script>
    <script>
        /////////////////// STREAT ADDRESS GOOGLE API ///////////////////
        
        var apiKey = 'AgZX0rYQbjfv4k7X9FgD7qZOFbk-cdyVG8PQH582yHiIubT07RL65I2URD9GTWnB';

        var addressInputs = document.querySelectorAll('.address-input');
        var suggestionsContainers = document.querySelectorAll('.suggestions');
        var detailsContainers = document.querySelectorAll('.details');

        addressInputs.forEach((addressInput, index) => {
            const suggestionsContainer = suggestionsContainers[index];
            const detailsContainer = detailsContainers[index];

            addressInput.addEventListener('input', async () => {
                const query = addressInput.value;
                suggestionsContainer.innerHTML = '';

                if (query.length >= 3) {
                    const suggestionEndpoint =
                        `https://dev.virtualearth.net/REST/v1/Autosuggest?query=${query}&key=${apiKey}`;
                    const response = await fetch(suggestionEndpoint);
                    const data = await response.json();

                    const suggestions = data.resourceSets[0].resources[0].value;

                    suggestions.forEach(suggestion => {
                        if (suggestion.__type === "Address") {
                            const formattedAddress = suggestion.address.formattedAddress;
                            const suggestionItem = document.createElement('div');
                            suggestionItem.classList.add('suggestion');
                            suggestionItem.textContent = formattedAddress;
                            suggestionItem.addEventListener('click', () => {
                                displayDetails(suggestion, detailsContainer);
                                addressInput.value = formattedAddress;
                                suggestionsContainer.innerHTML = '';
                            });
                            suggestionsContainer.appendChild(suggestionItem);
                        }
                    });
                    suggestionsContainer.classList.add('has-suggestions');
                } else {
                    suggestionsContainer.classList.remove('has-suggestions');
                }
            });

            document.addEventListener('click', (event) => {
                if (event.target !== addressInput && event.target !== suggestionsContainer) {
                    suggestionsContainer.innerHTML = '';
                    detailsContainer.innerHTML = '';
                    suggestionsContainer.classList.remove('has-suggestions');
                }
            });
        });

        function displayDetails(suggestion, detailsContainer) {
            if (suggestion.__type === "Address") {
                const address = suggestion.address;
                const details = `
              <h2>Details</h2>
              <p>Country/Region: ${address.countryRegion}</p>
              <p>Locality: ${address.locality}</p>
              <p>Admin District: ${address.adminDistrict}</p>
              <p>Postal Code: ${address.postalCode}</p>
              <p>Street Address: ${address.addressLine}</p>
              <p>Street Name: ${address.streetName}</p>
              <p>Formatted Address: ${address.formattedAddress}</p>
          `;
                detailsContainer.innerHTML = details;
            }
        }

        /////////////////// STREAT ADDRESS GOOGLE API ///////////////////

        $(document).ready(function() {
            _get();

            $("#signature").jSignature({
                "background-color": "white",
                "color": "red"
            });

            $("#clear").click(function() {
                $("#signature").jSignature("reset");
            });

            $('#medical_attach_files').on('change', function(event) {

                var fileSize = this.files[0].size;
                var fileSizeInMB = fileSize / (1024 * 1024);
                if (Math.round(fileSizeInMB) > 1) {
                    return;
                }
                var input = event.target;

                if (input.files && input.files[0]) {
                    var reader = new FileReader();

                    reader.onload = function(e) {

                        var i = Number($(input).attr('data-i'));
                        var src = '';

                        var html = `<div class="mt-1 d-flex flex-column" style="margin-right: 20px;">
                                            <span class="badge badge-pill badge-primary text-dark" role="button" style="font-size: 16px;width: 20px;height: 25px;margin-left: auto;" onclick="$(this).parent().remove();" >x</span>
                                            <image src="${e.target.result}" width="100px" height="100px"><div class="d-none ${i}-append"></div>
                                        </div>`;

                        $('.attachment_box').append(html);
                        $(`.${i}-append`).append($(input).clone());
                        $(`.${i}-append input[type='file']`).addClass("medical_attach_files");
                        $(`.${i}-append input[type='file']`).removeAttr(`id`);

                        i++;
                        $(input).val('');
                        $(input).attr('data-i', i);
                    };

                    reader.readAsDataURL(input.files[0]);
                }

            });

            @if (request()->id != 0)
                $('#employee_email').attr('disabled', 'disabled');
            @endif
        });





        // function funds_checkbox(id) {

        //     var title = $('.superannuations-checkbox' + id).attr('data-title');
        //     var percentage = $('.superannuations-checkbox' + id).attr('data-percentage');
        //     var usi = $('.superannuations-checkbox' + id).attr('data-usi');
        //     var usi_number = $('.superannuations-checkbox' + id).attr('data-usi-number');

        //     if ($('.superannuations-checkbox' + id).is(":checked") && usi == 0) {
        //         $('[data-usi-number-id="' + id + '"]').removeAttr('disabled');
        //     } else {
        //         $('[data-usi-number-id="' + id + '"]').attr('disabled', 'disabled');
        //     }

        // }

        function loader(show) {
            if (show) {
                $('.h-container').addClass('d-none');
                $('.full_loader').removeClass('d-none');
            } else {
                $('.h-container').removeClass('d-none');
                $('.full_loader').addClass('d-none');

            }
        }

        function disabled_it(_this, e) {
            if ($(_this).is(':checked')) {
                $(e).removeAttr('disabled');
            } else {
                $(e).val('');
                $(e).attr('disabled', 'disabled');
            }
        }

        function hide_contects_rows(_this) {
            if ($(_this).is(':checked')) {
                $('.row_contact').show()
            } else {
                $('.row_contact input').val('')
                $('.row_contact select').val('')
                $('.row_contact').hide()
            }
        }

        function previewThumbnail() {
            const thumbnailInput = document.querySelector('input[name="thumbnail"]');
            const thumbnailPreview = document.getElementById('thumbnail-preview');
            const files = thumbnailInput.files;

            if (files.length === 0) {
                return;
            }

            const file = files[0];

            var fileSize = file.size;
            var fileSizeInMB = fileSize / (1024 * 1024);
            if (Math.round(fileSizeInMB) > 1) {
                return;
            }

            const reader = new FileReader();
            reader.onload = function() {
                thumbnailPreview.innerHTML =
                    `<img src="${reader.result}" class="rounded-circle" alt="Thumbnail Preview" style="width:200px;height:200px;">`;
            };
            reader.readAsDataURL(file);
        }


        function _get() {

            $.ajax({
                type: "POST",
                url: "{{ url('/api/external-employee-onboarding-edit') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: {
                    'emp_id': '0'
                },
                success: function(response) {

                    var worker_types = response.data.emp_worker_types;
                    var work_experiences = response.data.emp_work_experiences;
                    var funds = response.data.funds;
                    var funds_meta = response.data.funds_meta;
                    var required_documents_data = response.data.required_documents;
                    var emp_documents = response.data.emp_documents;

                    var html = `<option value="" >--Select Worker Type--</option>`;

                    for (var i = 0; i < worker_types.length; i++) {
                        html += `<option value="${worker_types[i].id}" >${worker_types[i].title}</option>`;
                    }

                    $('#worker_type').html(html);

                    var html = `<option value="" >--Select Work Experience--</option>`;

                    for (var i = 0; i < work_experiences.length; i++) {
                        html +=
                            `<option value="${work_experiences[i].id}" >${work_experiences[i].title}</option>`;
                    }

                    $('#work_experience').html(html);


                    // html = ``;

                    // for (i = 0; i < funds.length; i++) {

                    //     html += `<div class="input-group mb-1 superannuations-border-color" >
                //                       <div class="input-group-text form-check mb-0 rounded-0">
                //                           <input  class="form-check-input m-auto superannuations-checkbox superannuations-checkbox${funds[i].id}" data-id="${funds[i].id}" data-title="${funds[i].title}" data-percentage="${funds[i].percentage}"  data-usi="${funds[i].usi}" data-usi-number="${funds[i].usi_number}" type="checkbox" value="" onclick="funds_checkbox(${funds[i].id});" >
                //                       </div>
                //                       <div class="form-control rounded-0 text-capitalize">
                //                          <div class="d-block d-sm-block d-md-flex">
                //                         <div class="col-md-3">
                //                             ${funds[i].title}
                //                         </div>
                //                         <div class="col-md-3">
                //                             ${funds[i].percentage}%
                //                         </div>
                //                         <div class="col-md-3">
                //                             ${funds[i].usi == 1 ? 'USI': 'Non-USI' }
                //                         </div>
                //                         <div class="col-12 col-sm-12 col-md-3">
                //                             <input data-usi-number-id="${funds[i].id}" value="${funds[i].usi_number ?  funds[i].usi_number : '' }" placeholder="Fund number"  disabled class="superannuations-usi-number" >
                //                         </div>
                //                           </div>
                //                       </div>
                //                   </div>`;
                    // }


                    // $('.append_superannuation').html(html);


                    for (i = 0; i < funds_meta.length; i++) {
                        $('.superannuations-checkbox' + funds_meta[i]['fund_id']).prop('checked', true);

                        if ($('.superannuations-checkbox' + funds_meta[i]['fund_id']).attr('data-usi') ==
                            0) {
                            $('[data-usi-number-id="' + funds_meta[i]['fund_id'] + '"]').removeAttr(
                                'disabled');
                            $('input[data-usi-number-id="' + funds_meta[i]['fund_id'] + '"]').val(
                                funds_meta[i]['usi_number']);
                        }

                    }

                    ///////////

                    var save_docs = {};
                    var _save_docs = '';

                    var html = ``;
                    var required_document;

                    for (var i = 0; i < emp_documents.length; i++) {
                        if (!save_docs.hasOwnProperty(emp_documents[i].required_document)) {
                            save_docs[emp_documents[i].required_document] = {};
                        }
                        save_docs[emp_documents[i].required_document][emp_documents[i]
                            .required_document_field
                        ] = emp_documents[i].value;
                    }

                    for (var i = 0; i < required_documents_data.length; i++) {

                        if (required_documents_data[i].for_who == 0) {
                            continue;
                        }

                        html += `<div class="row mt-4">
                                                <div class="form-group col-md-4 mt-1">
                                                    <p class=""><span style="font-weight:bold;">${required_documents_data[i].title}</span></p>
                                                </div>
                                                <div class="row col-md-8">
                                                `;

                        required_document = required_documents_data[i].required_document_field;

                        for (var j = 0; j < required_document.length; j++) {

                            if (required_document[j].status == 0) {
                                continue;
                            }
                            _save_docs = save_docs[required_documents_data[i].id] ? save_docs[
                                required_documents_data[i].id][required_document[j].id] ? save_docs[
                                required_documents_data[i].id][required_document[j].id] : "" : "";

                            html += `<div class="form-group col-md-6 mt-3  ${required_document[j].field_type == 'file' ? 'position-relative': '' } " >
                                                        <lable>${required_document[j].field_name} <span class="text-danger">${required_document[j].field_required == '1' ? '*' : ''}</span>  </lable>
                                                            ${required_document[j].field_type == 'file' ? '<div class="license">' : '' }
                                                                <input type="${required_document[j].field_type}" placeholder="${required_document[j].field_name}"  class="form-control input-file mt-2  ${required_document[j].field_required == '1' ? 'required-class' : ''} "    name="document_array[${required_documents_data[i].id}][${required_document[j].id}]" value="${required_document[j].field_type != 'file' ? _save_docs : '' }" >
                                                            ${required_document[j].field_type == 'file' ?
                                                            `</div>
                                                                                            <a href="${required_document[j].field_type == 'file' ? "{{ url('/') }}/"+_save_docs : '' }" target="_blank" class="eye-icon  ${_save_docs == ''  ?  'd-none' : ''  } "> <span class="mdi mdi-eye text-primary" role="button"></span></a>
                                                                                            <a href="${required_document[j].field_type == 'file' ? "{{ url('/') }}/"+_save_docs : '' }" download class="arrow-icon  ${_save_docs == ''  ?  'd-none' : ''  }"> <span class="mdi mdi-cloud-download mdi-20px text-info me-2"></span></a>` : '' }
                                                        </div>`;
                        }

                        html += `</div></div>`;
                    }

                    $('#doc-form').html(html);


                    ///////////

                    loader(false);

                    $('input[type="file"]').change(function(event) {
                        var fileSize = this.files[0].size;
                        var fileSizeInMB = fileSize / (10240 * 1024);
                        if (Math.round(fileSizeInMB) > 1) {
                            toastr.error("Maximum file size must be 10 MB.");
                            $(this).val('');
                        }
                    });



                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function _sumbit() {

            loader(true);

            // var arr = [];

            // var checkboxes_selected = document.querySelectorAll('.superannuations-checkbox:checked');

            // for (var i = 0; i < checkboxes_selected.length; i++) {
            //     var checkbox = checkboxes_selected[i];
            //     var id = checkbox.getAttribute('data-id');
            //     var usi = checkbox.getAttribute('data-usi');
            //     var usi_number = $('input[data-usi-number-id="' + id + '"]').val();

            //     if (!usi_number || !$.isNumeric(usi_number)) {
            //         toastr.error("Please enter a valid fund number")
            //         loader(false);
            //         return 0;
            //     }

            //     arr[i] = {
            //         'id': id,
            //         'usi_number': usi_number
            //     };


            // }

            var isSignatureProvided = $('#signature').jSignature('getData', 'base30')[1].length > 1 ? true : false;


            if (!isSignatureProvided) {
                toastr.error("Please signature in the box");
                loader(false);
                return 0;
            }

            var signatureData = $("#signature").jSignature("getData", "image");

            var base64Image = signatureData[1];
            if (base64Image.indexOf('data:image/png;base64,') === 0) {
                base64Image = base64Image.replace('data:image/png;base64,', '');
            }
            var byteString = atob(base64Image);
            var ab = new ArrayBuffer(byteString.length);
            var ia = new Uint8Array(ab);
            for (var i = 0; i < byteString.length; i++) {
                ia[i] = byteString.charCodeAt(i);
            }
            var blob = new Blob([ab], {
                type: 'image/jpeg'
            });

            var _FormData = new FormData($('#doc-form')[0]);


            var medical_attach_files = document.querySelectorAll('.medical_attach_files');

            for (var i = 0; i < medical_attach_files.length; i++) {

                _FormData.append(`medical_attach_files[${i}]`, medical_attach_files[i].files[0]);

            }

            var fileInput = document.getElementById('thumbnail');

            _FormData.append("emp_id", '{{ request()->id ?? 0 }}');

            _FormData.append("team_id", @json($team_id));
            _FormData.append("first_name", $('#first_name').val());
            _FormData.append("last_name", $('#last_name').val());
            _FormData.append("middle_name", $('#middle_name').val());
            _FormData.append("employee_email", $('#employee_email').val());
            _FormData.append("date_of_birth", $('#date_of_birth').val());
            _FormData.append("mobile", $('#mobile').val());
            _FormData.append("image", $('#thumbnail')[0].files[0] ? $('#thumbnail')[0].files[0] : '');
            _FormData.append("suburb", $('#suburb').val());
            _FormData.append("state", $('#state').val());
            _FormData.append("streat_address", $('#streat_address').val());
            _FormData.append("job_title", $('#job_title').val());
            _FormData.append("employer_name", $('#employer_name').val());
            _FormData.append("worker_type", $('#worker_type').val());
            _FormData.append("trade_qualified", $('#trade_qualified:checked').is(':checked') ? 1 : 0);
            _FormData.append("trade_qualified_year", $('#trade_qualified_year').val());
            _FormData.append("trade_licensed", $('#trade_licensed').is(':checked') ? 1 : 0);
            _FormData.append("trade_licensed_year", $('#trade_licensed_year').val());
            _FormData.append("work_experience", $('#work_experience').val());
            _FormData.append("year_commenced", $('#year_commenced').val());
            _FormData.append("citizenship_status", $('input[name="citizenship_status"]:checked').val());
            _FormData.append("temporary_student_visa", $('#temporary_student_visa')[0].files[0]);
            // _FormData.append("account_title", $('#account_title').val());
            // _FormData.append("account_number", $('#account_number').val());
            // _FormData.append("bank_name", $('#bank_name').val());
            // _FormData.append("superannuations_funds", JSON.stringify(arr));
            _FormData.append("classified_high_risk", $('#classified_high_risk').is(':checked') ? 1 : 0);
            _FormData.append("contact_name_first", $('#contact_name_first').val());
            _FormData.append("contact_relation_first", $('#contact_relation_first').val());
            _FormData.append("contact_phone_first", $('#contact_phone_first').val());
            // _FormData.append("contact_name_second", $('#contact_name_second').val());
            // _FormData.append("contact_relation_second", $('#contact_relation_second').val());
            // _FormData.append("contact_phone_second", $('#contact_phone_second').val());
            _FormData.append("allergies", $('#allergies').is(':checked') ? 1 : 0);
            _FormData.append("previous_injuries", $('#previous_injuries').is(':checked') ? 1 : 0);
            _FormData.append("medical_condition", $('#medical_condition').val());
            _FormData.append("legally_australia", $('input[name="legally_australia"]:checked').val());
            _FormData.append("details_previous_injuries", $('#details_previous_injuries').val());
            _FormData.append("details_allergies", $('#details_allergies').val());
            _FormData.append('signature', blob, 'signature.jpg');
            _FormData.append('key',
                @if (!isset($link_management->id))
                    ''
                @else
                    '{{ $link_management->secret_key }}'
                @endif );

            loader(true);

            $.ajax({
                type: "POST",
                url: "{{ url('/api/external-employee-onboarding-store') }}",
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                data: _FormData,
                processData: false,
                contentType: false,
                success: function(response) {

                    loader(false);
                    window.location.href = "{{ url('/external-employee-onboarding/success') }}"

                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }
    </script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
    <script src="{{ url('/') }}/assets/vendor/libs/popper/popper.js"></script>
    <script src="{{ url('/') }}/assets/vendor/js/bootstrap.js"></script>
    <script src="{{ url('/') }}/assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="{{ url('/') }}/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="{{ url('/') }}/assets/vendor/js/menu.js"></script>
    <script src="{{ url('/') }}/assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <script src="{{ url('/') }}/assets/js/main.js"></script>
    <script src="{{ url('/') }}/assets/js/dashboards-analytics.js"></script>
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
</body>

</html>
