@extends('includes/layout')
@section('main-page-content')
    @php $cols = DB::table('emp_list_change_cols')->pluck('col')->toArray();  @endphp
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body">
                <div
                    class="border-bottom py-2 d-flex
                flex-wrap justify-content-between align-items-center Employee_table_div">
                    <div class="mb-2 mb-md-0">
                        <div class="h4 pb-0 mb-0 card_sec_headr_font">Employees List</div>
                        <small>Onboarded Employees</small>
                    </div>
                    <div
                        class="d-flex flex-column flex-md-row justify-content-end align-items-center
                    card_sec_headr_options">
                        <div class="d-flex ">
                            <span class="me-md-2 mt-2 me-2 mb-2 mb-md-0">Records per page:</span>
                            <select class="form-select form-select-sm me-md-2 mb-2 mb-md-0 " onchange="_filter(0);  _get(0);"
                                style="width: auto;" id="per_page">
                                <option value="20">20</option>
                                <option value="50">50</option>
                                <option value="100">100</option>
                                <option value="10000">All</option>
                            </select>
                        </div>

                        @if (in_array('Employee List Maintain', Session::get('permissions')))
                            <button
                                class="btn btn-primary waves-effect waves-light mb-2 mb-md-0 card_sec_headr_font card_sec_headr_dropoption"
                                onclick="_download_emp();">Download Employees list</button>
                            <button class="btn btn-primary card_sec_headr_font card_sec_headr_dropoption"
                                onclick="window.location.href='employee-onboarding/create/company-details/0';">
                                <span class="mdi mdi-plus"></span>Add Employee
                            </button>
                        @endif


                        <div class="btn-group Btn_width_dropdown">
                            <button
                                class="btn btn-primary waves-effect waves-light dropdown-toggle card_sec_headr_dropoption2"
                                type="button" data-bs-toggle="dropdown" data-bs-auto-close="false">
                                <span class="mdi mdi-format-list-checks"></span>
                            </button>

                            <form action="{{ url('/employee-list/change-col') }}" method="post">
                                @csrf
                                <ul class="dropdown-menu column-filter p-2" style="min-width:100%;">
                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="First Name"
                                                {{ in_array('First Name', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                First Name
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Middle Name"
                                                {{ in_array('Middle Name', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Middle Name
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Last Name"
                                                {{ in_array('Last Name', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Last Name
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Employee Email"
                                                {{ in_array('Employee Email', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Email
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Teams"
                                                {{ in_array('Teams', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Teams
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Role"
                                                {{ in_array('Role', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Role
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Mobile"
                                                {{ in_array('Mobile', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Mobile
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Address"
                                                {{ in_array('Address', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Address
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Tax File No"
                                                {{ in_array('Tax File No', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Tax File No
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Account Number"
                                                {{ in_array('Account Number', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Account Number
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="BSB"
                                                {{ in_array('BSB', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                BSB
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Registration"
                                                {{ in_array('Registration', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Registration
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Status"
                                                {{ in_array('Status', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Status
                                            </label>
                                        </div>
                                    </li>

                                    <li>
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" value="Type"
                                                {{ in_array('Type', $cols) ? 'checked' : '' }} name="col[]">
                                            <label class="form-check-label" for="flexCheckDefault">
                                                Type
                                            </label>
                                        </div>
                                    </li>
                                    <li>
                                        <button type="submit" class="btn btn-primary btn-sm">Save Changes</button>
                                    </li>
                                </ul>
                            </form>
                        </div>


                    </div>

                </div>
                <div class="mt-3">
                    <div class="table-responsive text-nowrap mt-3 border-bottom">
                        <table class="table">
                            <thead class="table-head-color bg-primary">
                                <tr>
                                    <th style="min-width: 150px;"
                                        class="{{ in_array('First Name', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="first_name"
                                            placeholder="First Name" id="" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-first_name"
                                            autocomplete="off">
                                    </th>
                                    <th style="min-width: 150px;"
                                        class="{{ in_array('Middle Name', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="middle_name"
                                            placeholder="Middle Name" id="" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-middle_name"
                                            autocomplete="off">
                                    </th>
                                    <th style="min-width: 150px;"
                                        class="{{ in_array('Last Name', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="last_name"
                                            placeholder="Last Name" id="" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-last_name"
                                            autocomplete="off">
                                    </th>
                                    <th style="min-width: 150px;"
                                        class="{{ in_array('Employee Email', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="employee_email"
                                            placeholder="Email" id="" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-employee_email"
                                            autocomplete="off">
                                    </th>
                                    <th style="min-width: 150px;" class="{{ in_array('Teams', $cols) ? '' : 'd-none' }}">
                                        <select class="filter select-color " name="teams" aria-placeholder="Teams"
                                            id="">
                                            <option value="">Teams</option>
                                            @php
                                                $emp_teams = DB::table('emp_teams')->where('del', '0')->get();
                                            @endphp
                                            @foreach ($emp_teams as $t)
                                                <option value="{{ $t->id }}">{{ $t->title }}</option>
                                            @endforeach
                                        </select>
                                    </th>
                                    <th style="width: 12%;" class="{{ in_array('Role', $cols) ? '' : 'd-none' }}">
                                        <select class="filter select-color " name="access_role" aria-placeholder="Role"
                                            id="">
                                            <option value="">Role</option>
                                            @php
                                                $access_role = DB::table('roles')->where('del', '0')->get();
                                            @endphp
                                            @foreach ($access_role as $a)
                                                <option value="{{ $a->code }}">{{ $a->title }}</option>
                                            @endforeach
                                        </select>
                                    </th>

                                    <th style="min-width: 150px;"
                                        class="{{ in_array('Mobile', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="mobile"
                                            placeholder="Mobile" id="" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-mobile"
                                            autocomplete="off">
                                    </th>
                                    <th style="min-width: 150px;"
                                        class="{{ in_array('Address', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="streat_address"
                                            placeholder="Address" id="" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-streat_address"
                                            autocomplete="off">
                                    </th>
                                    <th style="min-width: 150px;"
                                        class="{{ in_array('Tax File No', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="tax_file_no"
                                            placeholder="Tax File No" id="" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-tax_file_no"
                                            autocomplete="off">
                                    </th>
                                    <th style="min-width: 150px;"
                                        class="{{ in_array('Account Number', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="account_number"
                                            placeholder="Account Number" id="" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-account_number"
                                            autocomplete="off">
                                    </th>
                                    <th style="min-width: 150px;" class="{{ in_array('BSB', $cols) ? '' : 'd-none' }}">
                                        <input type="text" class="filter form-control" name="bank_name"
                                            placeholder="BSB" id="" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-bank_name"
                                            autocomplete="off">
                                    </th>

                                    <th style="min-width: 150px;"
                                        class="{{ in_array('Registration', $cols) ? '' : 'd-none' }}">
                                        <select class="filter select-color" name="completed" id="">
                                            <option value="">Registration</option>
                                            <option value="1">Completed</option>
                                            <option value="0">InProcess</option>
                                        </select>
                                    </th>
                                    <th style="min-width: 130px;"
                                        class="{{ in_array('Status', $cols) ? '' : 'd-none' }}">
                                        <select class="filter select-color" name="status" id="">
                                            <option value="">Status</option>
                                            <option value="1">Active</option>
                                            <option value="0">InActive</option>
                                        </select>
                                    </th>
                                    <th style="min-width: 100px;" class="{{ in_array('Type', $cols) ? '' : 'd-none' }}">
                                        <select class="filter select-color" name="user_type" id="">
                                            <option value="">Type</option>
                                            <option value="0">Internal</option>
                                            <option value="1">External</option>
                                        </select>
                                    </th>
                                    <th style="width: 10%;" class="text-center">
                                        <div style="margin-top:6px;display:block;">
                                            <button class="btn btn-success btn-sm p-2 waves-effect waves-light filter-btn"
                                                onclick="_filter(1); _get(0);">submit</button>
                                            <button
                                                class="btn btn-danger btn-sm p-2 waves-effect waves-light filter-btn-close"
                                                onclick="_filter(0);  _get(0);">x</button>
                                        </div>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0 table-body">

                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-3  ">
                        <ul class="pagination
                        employeelist_pagination pages_btn">

                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="DeleteEmp" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this record?<br><br>
                    <b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you
                    genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger" id="delete-emp-id" data-id=""
                        onclick="_delete(this)">Delete</button>
                </div>
            </div>
        </div>
    </div>
@endsection






@section('css-js')
    <script>
        $(document).ready(function() {
            _filter(0);
            _get(0);
        });

        function _download_emp() {
            loader(true);
            var per_page = $('#per_page').val();
            $.ajax({
                type: "POST",
                url: `{{ url('/api/emp/download') }}`,
                headers: {
                    'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
                },
                data: {
                    'filter': localStorage.getItem('filter'),
                    'per_page': per_page,
                    'invited': 0
                },
                success: function(response) {
                    loader(false);
                    var link = document.createElement('a');
                    link.href = URL.createObjectURL(new Blob([response]));
                    link.setAttribute('download', 'emp.csv');
                    document.body.appendChild(link);
                    link.click();
                    link.parentNode.removeChild(link);
                },
                error: function(xhr, status, error) {
                    loader(false);
                    if (xhr.status == 500) {
                        toastr.error("Something went wrong");
                    } else {
                        toastr.error(xhr.responseJSON.message);
                    }
                }
            });
        }

        function _filter(filter_on) {
            var collection = document.getElementsByClassName("filter");
            var arr = {};

            for (let i = 0; i < collection.length; i++) {
                arr[collection[i].name] = filter_on == 1 ? collection[i].value : '';
            }
            if (filter_on == 0) {
                $('.filter').val('');
            }

            localStorage.setItem('filter', JSON.stringify(arr));
        }

        function _get(from) {
            loader(true);

            var per_page = $('#per_page').val();

            $.ajax({
                type: "GET",
                url: `{{ url('/api/employee') }}?from=${from}&per_page=${per_page}&filter=${localStorage.getItem('filter')}&invited=0`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    var users = response.data.users;
                    console.log('users[i]?.emp_personal_details:',users)

                    var html = ``;
                    var count = parseInt(response.count) < per_page ? 1 : parseInt(response.count) / per_page;
                    count = Math.ceil(count);
                    var pages_btn = ``;

                    pages_btn += `
                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                        </li>
                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                        </li>`;

                    $('.p-btn').removeClass('active');

                    var c = 0;
                    for (c = 0; c < count; c++) {
                        if (
                            (from == (c - 3) * per_page) ||
                            (from == (c - 2) * per_page) ||
                            (from == (c - 1) * per_page) ||
                            (from == (c - 0) * per_page) ||
                            (from == (c + 1) * per_page) ||
                            (from == (c + 2) * per_page) ||
                            (from == (c + 3) * per_page)
                        ) {
                            pages_btn += `
                                <li class="page-item p-btn ${from == c*per_page ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*per_page});">
                                  <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                </li>
                                `;
                        }

                    }

                    pages_btn += `

                <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                </li>
                <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*per_page});" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                </li>
                `;


                    $('.pages_btn').html(pages_btn);

                    for (var i = 0; i < users.length; i++) {
                        var emp_teams_members = users[i]?.emp_teams_members ?? [];

                        var teams_list = '';
                        for (j = 0; j < emp_teams_members.length; j++) {
                            // if(emp_teams_members[j].emp_teams_list.applied == '1')
                            // {
                            teams_list +=
                                `<span class="badge rounded-pill bg-label-success me-1" style="font-size: 12px;">${emp_teams_members[j].emp_teams_list.title.length > 24 ? emp_teams_members[j].emp_teams_list.title.substr(0,24)+'...' : emp_teams_members[j].emp_teams_list.title}</span><br/>`;
                            // }
                        }


                        html += `
                            <tr>
                            <td class="{{ in_array('First Name', $cols) ? '' : 'd-none' }}"><span class="fw-medium">${users[i]?.emp_personal_details?.first_name ? users[i]?.emp_personal_details?.first_name : "" }</span> </td>
                            <td class="{{ in_array('Middle Name', $cols) ? '' : 'd-none' }}">${users[i]?.emp_personal_details?.middle_name ? users[i]?.emp_personal_details?.middle_name : "" }</td>
                            <td class="{{ in_array('Last Name', $cols) ? '' : 'd-none' }}">${users[i]?.emp_personal_details?.last_name ? users[i]?.emp_personal_details?.last_name : "" }</td>
                            <td class="{{ in_array('Employee Email', $cols) ? '' : 'd-none' }}">${users[i]?.employee_email }</td>
                            <td class="{{ in_array('Teams', $cols) ? '' : 'd-none' }}">${teams_list}</td>
                            <td class="{{ in_array('Role', $cols) ? '' : 'd-none' }}">${users[i]?.access_role?.title ? users[i]?.access_role?.title : "" }</td>


                            <td class="{{ in_array('Mobile', $cols) ? '' : 'd-none' }}">${users[i]?.emp_personal_details?.mobile }</td>
                            <td class="{{ in_array('Address', $cols) ? '' : 'd-none' }}">${users[i]?.emp_personal_details?.streat_address ? users[i]?.emp_personal_details?.streat_address  : ''}</td>
                            <td class="{{ in_array('Tax File No', $cols) ? '' : 'd-none' }}">${users[i]?.tax_file_no ? users[i]?.tax_file_no : '' }</td>
                            <td class="{{ in_array('Account Number', $cols) ? '' : 'd-none' }}">${searchInMeta(users[i]?.emp_meta_data,"account_number")}</td>
                            <td class="{{ in_array('BSB', $cols) ? '' : 'd-none' }}">${searchInMeta(users[i]?.emp_meta_data,"bank_name")}</td>

                            <td class="{{ in_array('Registration', $cols) ? '' : 'd-none' }}">

                            ${users[i]?.compeleted == "1" ?
                            '<span class="badge rounded-pill bg-label-success me-1">Completed</span>'
                            :
                            '<span class="badge rounded-pill bg-label-danger me-1">InProcess</span>'
                            }
                            </td>
                            <td class="status-col${users[i]?.id}  {{ in_array('Status', $cols) ? '' : 'd-none' }}">
                            ${users[i]?.status == "1" ?
                            '<span class="badge rounded-pill bg-label-success me-1">Active</span>'
                            :
                            '<span class="badge rounded-pill bg-label-danger me-1">InActive</span>'
                             }


                            </td>

                            <td class="user_type-col${users[i]?.id}  {{ in_array('Type', $cols) ? '' : 'd-none' }}">
                            ${users[i]?.user_type == "0" ?
                            '<span class="badge rounded-pill bg-label-success me-1">Internal</span>'
                            :
                            '<span class="badge rounded-pill bg-label-warning me-1">External</span>'
                             }


                            </td>


                            <td>
                            @if (in_array('Employee List Maintain', Session::get('permissions')))
                              <div class="dropdown cursor-pointer d-flex justify-content-center">
                              <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>
                              <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                              ${users[i]?.user_type == 1 ? `<li><a class="dropdown-item py-1 ps-2"  onclick="window.location.href='{{ url('/') }}/employee-onboarding/create/company-details/${users[i]?.id}'"><span class="mdi mdi-infinity mdi-20px text-warning"></span> Covert To Internal</a></li>` : ``}
                              <li><a class="dropdown-item py-1 ps-2"  onclick="window.location.href='{{ url('/') }}${users[i]?.user_type == 0 ? '/employee-onboarding/create/company-details/' : '/edit-external-employee/'  }${users[i]?.id}'"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                              <li><a class="dropdown-item py-1 ps-2"  data-id="${users[i].id}" onclick="_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                              <li><a class="dropdown-item py-1 ps-2"  status-btn${users[i]?.id} " onclick="_change_status(${users[i]?.id});"><span  class="mdi status${users[i]?.id}   ${users[i]?.status == 1? 'mdi-pan-down text-secondary' : 'mdi-pan-up text-info' }  mdi-20px"></span>${users[i]?.status == 1 ? 'Inactive' : 'Active' }</a></li>
                              <li><a class="dropdown-item py-1 ps-2" onclick="window.location.href='{{ url('/user-profile') }}/${users[i]?.id}'"><span style="color: #15A7F5;" class="mdi  ${users[i]?.is_submitted == 1 ? 'mdi-account-alert': 'mdi-account'} mdi-20px  me-2"></span> Profile</a></li>
                              <li><a class="dropdown-item py-1 ps-2" onclick="_sendCredentials(${users[i]?.id});"><span style="color: #15A7F5;" class="mdi mdi-send mdi-20px  me-2"></span> Send Credentail</a></li>
                              </ul>
                              </div>
                            </td>
                            @endif

                          </tr>

                    `;
                    }



                    $('.table-body').html(html);

                    if (html == ``) {
                        $('.table-body').html(
                            `<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                    }



                    loader(false);




                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function _change_status(id) {

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: "PUT",
                url: "{{ url('/') }}" + "/api/employee/" + id + "/update-status",
                success: function(response) {

                    var tooltip = response.data.status == 0 ? 'Click to Active Employee' :
                        'Click to InActive Employee';
                    var icon_add = response.data.status == 1 ? 'mdi-pan-up' : 'mdi-pan-down';
                    var icon_remove = response.data.status == 0 ? 'mdi-pan-up' : 'mdi-pan-down';
                    var color_add = response.data.status == 1 ? 'text-info' : 'text-secondary';
                    var color_remove = response.data.status == 0 ? 'text-info' : 'text-secondary';

                    var html = response.data.status == 1 ?
                        '<span class="badge rounded-pill bg-label-success me-1">Active</span>' :
                        '<span class="badge rounded-pill bg-label-danger me-1">InActive</span>';

                    $('.status-btn' + id).attr('data-bs-original-title', tooltip);
                    $('.status' + id).removeClass(icon_remove);
                    $('.status' + id).addClass(icon_add);
                    $('.status' + id).removeClass(color_remove);
                    $('.status' + id).addClass(color_add);
                    $('.status-col' + id).html(html);

                    toastr.success(response.message);


                },
                error: function(response) {
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function _delete_modal(_this) {
            var id = $(_this).attr('data-id');
            $('#delete-emp-id').attr('data-id', id);
            $('#DeleteEmp').modal('show');
        }

        function _delete(_this) {


            var id = $(_this).attr('data-id');

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: "DELETE",
                url: "{{ url('/api/employee') }}/" + id,
                success: function(response) {
                    toastr.success(response.message);
                    _get(0);
                    $('#DeleteEmp').modal('hide');

                    loader(false);


                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function searchInMeta(dataArray, option) {
            var value = '';
            $.each(dataArray, function(index, element) {
                if (element.option === option) {
                    value = element.value;
                    return false;
                }
            });
            return value;
        }
    </script>
    <style>
        .filter {
            width: 100%;
            height: 33px;
            outline: none;
            background: white;
        }

        .filter-form {
            width: 100%;
            height: 33px;
            outline: none;
            background: white;
        }


        .select-color {
            color: #4E4E4E;
            font-weight: 400;
            line-height: 1.47;
            background-size: 9px 5px;
            border: 1px solid #d4d3d5;
            border-radius: 2px;
            transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
            padding-left: 5px;
        }

        .list_color:hover {
            color: #15A7F5;
        }
    </style>
@endsection
