@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body">
                <div class="border-bottom py-2 Invite_Emply_Cardheader">
                    <div>
                        <div class="h4 pb-0 mb-0">Invite Employees List</div>
                        <small>Invite Employees</small>
                    </div>
                    <div class="d-flex justify-content-end align-items-center">
                        @if (in_array('Invite Employee List Maintain', Session::get('permissions')))
                            <button class="btn btn-primary AIE"
                                onclick="window.location.href='/employee-onboarding/create/company-details/0?invite=invite';"><span
                                    class="mdi mdi-plus"></span>Add Invite Employee</button>
                        @endif
                    </div>
                </div>
                <div class="mt-3">
                    <div class="table-responsive text-nowrap mt-3 border-bottom">
                        <table class="table">
                            <thead class="table-head-color bg-primary">
                                <tr>
                                    <th style="width: 15%;">
                                        <input type="text" class="filter form-control" name="first_name" id=""
                                            placeholder="First Name" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-first_name"
                                            autocomplete="off">
                                    </th>
                                    <th style="width: 15%;">
                                        <input type="text" class="filter form-control" name="middle_name" id=""
                                            placeholder="Middle Name" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-middle_name"
                                            autocomplete="off">
                                    </th>
                                    <th style="width: 15%;">
                                        <input type="text" class="filter form-control" name="last_name" id=""
                                            placeholder="Last Name" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-last_name" autocomplete="off">
                                    </th>
                                    <th style="width: 15%;">
                                        <input type="text" class="filter-form form-control" name="employee_email"
                                            id="" placeholder="Email" autocomplete="off">
                                        <input type="text" style="display:none" name="fake-employee_email"
                                            autocomplete="off">
                                    </th>
                                    <th style="width: 12%;">
                                        <select class="filter select-color " name="access_role" aria-placeholder="Roles"
                                            id="">
                                            <option value="">Role</option>
                                            @php
                                                $access_role = DB::table('roles')->where('del', '0')->get();
                                            @endphp
                                            @foreach ($access_role as $a)
                                                <option value="{{ $a->code }}">{{ $a->title }}</option>
                                            @endforeach
                                        </select>
                                    </th>
                                    <th style="width: 12%;">
                                        <select class="filter select-color" name="is_submitted" id="">
                                            <option value="">Profile</option>
                                            <option value="1">Submitted</option>
                                            <option value="0">Not Submitted</option>
                                        </select>
                                    </th>
                                    <th style="width: 12%;">
                                        <select class="filter select-color" name="status" id="">
                                            <option value="">Status</option>
                                            <option value="1">Active</option>
                                            <option value="0">InActive</option>
                                        </select>
                                    </th>
                                    <th>
                                        <div style="margin-top:6px;display:block;">
                                            <button class="btn btn-success btn-sm p-2 waves-effect waves-light filter-btn"
                                                onclick="_filter(1); _get(0);">submit</button>
                                            <button
                                                class="btn btn-danger btn-sm p-2 waves-effect waves-light filter-btn-close"
                                                onclick="_filter(0);  _get(0);">x</button>
                                        </div>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0 table-body">

                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-3 ">
                        <ul class="pagination inviteemployeelist_pagination justify-content-end pages_btn">

                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="DeleteEmp" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this record?<br><br>
                    <b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you
                    genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger" id="delete-emp-id" data-id=""
                        onclick="_delete(this)">Delete</button>
                </div>
            </div>
        </div>
    </div>
@endsection






@section('css-js')
    <script>
        $(document).ready(function() {
            _filter(0);
            _get(0);

        });

        function _filter(filter_on) {

            var collection = document.getElementsByClassName("filter");
            var arr = {};

            for (let i = 0; i < collection.length; i++) {
                arr[collection[i].name] = filter_on == 1 ? collection[i].value : '';
            }

            if (filter_on == 0) {
                $('.filter').val('');
            }

            localStorage.setItem('filter', JSON.stringify(arr));

        }

        function _get(from) {
            loader(true);

            $.ajax({
                type: "GET",
                url: `{{ url('/api/employee') }}?from=${from}&filter=${localStorage.getItem('filter')}&invited=1`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {

                    console.log('Employee:',response)
                    var users = response.data.users;
                    var html = ``;
                    var count = parseInt(response.count) < 20 ? 1 : parseInt(response.count) / 20;
                    count = Math.ceil(count);
                    var pages_btn = ``;

                    pages_btn += `
                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                </li>
                                      <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                        <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                      </li>`;

                    $('.p-btn').removeClass('active');

                    var c = 0;
                    for (c = 0; c < count; c++) {
                        if (
                            (from == (c - 3) * 20) ||
                            (from == (c - 2) * 20) ||
                            (from == (c - 1) * 20) ||
                            (from == (c - 0) * 20) ||
                            (from == (c + 1) * 20) ||
                            (from == (c + 2) * 20) ||
                            (from == (c + 3) * 20)
                        ) {
                            pages_btn += `
                                <li class="page-item p-btn ${from == c*20 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*20});">
                                  <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                </li>
                                `;
                        }

                    }

                    pages_btn += `

                <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                </li>
                <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*20});" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                </li>
                `;


                    $('.pages_btn').html(pages_btn);

                    for (var i = 0; i < users.length; i++) {
                        console.log('users[i]:',users[i])
                        html += `
                    <tr>
                            <td><span class="fw-medium">${users[i]?.emp_personal_details?.first_name ? users[i]?.emp_personal_details?.first_name : "" }</span> </td>
                            <td>${users[i]?.emp_personal_details?.middle_name ? users[i]?.emp_personal_details?.middle_name : "" }</td>
                            <td>${users[i]?.emp_personal_details?.last_name ? users[i]?.emp_personal_details?.last_name : "" }</td>
                            <td>${users[i]?.employee_email ? users[i]?.employee_email : "" }</td>
                            <td>${users[i]?.access_role?.title ? users[i]?.access_role?.title : "" }</td>
                            <td>

                            ${users[i]?.is_submitted == "1" ?
                            '<span class="badge rounded-pill bg-label-success me-1">Submitted</span>'
                            :
                            '<span class="badge rounded-pill bg-label-danger me-1">Not Submitted</span>'
                            }
                            </td>
                            <td class="status-col${users[i]?.id}">
                            ${users[i]?.status == "1" ?
                            '<span class="badge rounded-pill bg-label-success me-1">Active</span>'
                            :
                            '<span class="badge rounded-pill bg-label-danger me-1">InActive</span>'
                             }


                            </td>


                            <td>
                            @if (in_array('Invite Employee List Maintain', Session::get('permissions')))
                              <div class="dropdown cursor-pointer d-flex justify-content-center">
                              <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>

                              <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                              <li><a class="dropdown-item py-1 ps-2"  onclick="window.location.href='{{ url('/employee-onboarding/create/company-details') }}/${users[i]?.id}?invite=invite'"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                              <li><a class="dropdown-item py-1 ps-2"  data-id="${users[i].id}" onclick="_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                              <li><a class="dropdown-item py-1 ps-2"  status-btn${users[i]?.id} " onclick="_change_status(${users[i]?.id});"><span  class="mdi status${users[i]?.id}   ${users[i]?.status == 1? 'mdi-pan-down text-secondary' : 'mdi-pan-up text-info' }  mdi-20px"></span>${users[i]?.status == 1 ? 'Inactive' : 'Active' }</a></li>
                              <li><a class="dropdown-item py-1 ps-2" onclick="window.location.href='{{ url('/user-profile') }}/${users[i]?.id}'"><span style="color: #15A7F5;" class="mdi  ${users[i]?.is_submitted == 1 ? 'mdi-account-alert': 'mdi-account'} mdi-20px  me-2"></span> Profile</a></li>
                              <li><a class="dropdown-item py-1 ps-2" onclick="_sendCredentials(${users[i]?.id});"><span style="color: #15A7F5;" class="mdi mdi-send mdi-20px  me-2"></span> Send Credentail</a></li>
                              </ul>
                              </div>
                              @endif
                            </td>

                          </tr>

                    `;
                    }



                    $('.table-body').html(html);

                    if (html == ``) {
                        $('.table-body').html(
                            `<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                    }



                    loader(false);




                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }

        function _change_status(id) {

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: "PUT",
                url: "{{ url('/') }}" + "/api/employee/" + id + "/update-status",
                success: function(response) {

                    var tooltip = response.data.status == 0 ? 'Click to Active Employee' :
                        'Click to InActive Employee';
                    var icon_add = response.data.status == 1 ? 'mdi-pan-up' : 'mdi-pan-down';
                    var icon_remove = response.data.status == 0 ? 'mdi-pan-up' : 'mdi-pan-down';
                    var color_add = response.data.status == 1 ? 'text-info' : 'text-secondary';
                    var color_remove = response.data.status == 0 ? 'text-info' : 'text-secondary';

                    var html = response.data.status == 1 ?
                        '<span class="badge rounded-pill bg-label-success me-1">Active</span>' :
                        '<span class="badge rounded-pill bg-label-danger me-1">InActive</span>';

                    $('.status-btn' + id).attr('data-bs-original-title', tooltip);
                    $('.status' + id).removeClass(icon_remove);
                    $('.status' + id).addClass(icon_add);
                    $('.status' + id).removeClass(color_remove);
                    $('.status' + id).addClass(color_add);
                    $('.status-col' + id).html(html);

                    toastr.success(response.message);


                },
                error: function(response) {
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }





        function _delete_modal(_this) {
            var id = $(_this).attr('data-id');
            $('#delete-emp-id').attr('data-id', id);
            $('#DeleteEmp').modal('show');
        }

        function _delete(_this) {


            var id = $(_this).attr('data-id');

            $.ajax({
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: "DELETE",
                url: "{{ url('/api/employee') }}/" + id,
                success: function(response) {
                    toastr.success(response.message);
                    _get(0);
                    $('#DeleteEmp').modal('hide');

                    loader(false);


                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });

        }
    </script>
    <style>
        .filter {
            width: 115px;
            height: 33px;
            outline: none;
            background: white;
        }

        .filter-form {
            width: 185px;
            height: 33px;
            outline: none;
            background: white;
        }

        .select-color {
            color: #787878;
            font-weight: 400;
            line-height: 1.47;
            background-size: 9px 5px;
            border: 1px solid #d4d3d5;
            border-radius: 2px;
            transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
            padding-left: 5px;
        }

        .list_color:hover {
            color: #15A7F5;
        }

        @media only screen and (min-width: 320px) and (max-width: 568px) {
            .filter {
                width: 115px;
            }

            .filter-form {
                width: 185px;
            }
        }

        @media only screen and (min-width: 768px) and (max-width: 1024px) {
            .filter {
                width: 115px;
            }

            .filter-form {
                width: 185px;
            }
        }

        @media only screen and (min-width: 800px) and (max-width: 1280px) {
            .filter {
                width: 115px;
            }

            .filter-form {
                width: 185px;
            }
        }

        @media only screen and (min-width: 768px) and (max-width: 1366px) {
            .filter {
                width: 115px;
            }

            .filter-form {
                width: 185px;
            }
        }

        @media only screen and (min-width: 900px) and (max-width: 1440px) {
            .filter {
                width: 115px;
            }

            .filter-form {
                width: 185px;
            }
        }
    </style>
@endsection
