
<style>
/* Style the tab */
.bg-primary th {
color: white;
}

.btn-color {
background-color: #019FF3 !important;
}

.hearder-color {
background-color: #019FF3 !important;
}
.tab {
overflow: hidden;
border: 1px solid #ccc;
background-color: #fff;
}

/* Style the buttons inside the tab */
.tab button {
background-color: inherit;
float: left;
border: none;
outline: none;
cursor: pointer;
padding: 14px 16px;
transition: 0.3s;
font-size: 17px;
}

/* Change background color of buttons on hover */
.tab button:hover {
background-color: #ddd;
}

/* Create an active/current tablink class */
.tab button.active {
background-color: #ccc;
}

.page-item.activeWarning .page-link{
border-color: #15A7F5;
background-color: #15A7F5;
color: #fff;
}



/* Style the tab content */
.tabcontent {
display: none;
padding: 6px 12px;
border: 1px solid #ccc;
border-top: none;
}
</style>
@extends('includes/layout')
@section('main-page-content')
<div class="container-xxl flex-grow-1 container-p-y">
<div class="card mb-4">
<div class="card-header p-0">
<div class="nav-align-top">
<ul class="nav nav-tabs" role="tablist">
<li class="nav-item" role="presentation">
<button type="button" class="nav-link waves-effect active" role="tab" data-bs-toggle="tab"
data-bs-target="#navs-top-role" aria-controls="navs-top-role" aria-selected="true">
Profile
</button>
</li>
<li class="nav-item" role="presentation">
<button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab" data-bs-target="#navs-top-permit-typte" aria-controls="navs-top-permit-typte" aria-selected="false" tabindex="-1">
Warnings
</button>
</li>
<li class="nav-item" role="presentation">
<button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab"
data-bs-target="#navs-top-employementtype" aria-controls="navs-top-documents"
aria-selected="false" tabindex="-1">
Comments Management
</button>
</li>
<span class="tab-slider" style="left: 0px; width: 91.1719px; bottom: 0px;"></span>
</ul>
</div>
</div>
<div class="card-body">
<div class="tab-content p-0">
<!-- Profile Section (previously included from 'PreRequire/roster') -->
<div id="navs-top-role" class="tab-pane fade show active" role="tabpanel" aria-labelledby="navs-top-role-tab">
<!-- Profile content here -->
<div class="container-xxl flex-grow-1 container-p-y">
<div class="card mb-4">
<div class="card-body p-0 m-lg-0">
<div class="row">
<div class="col-12 d-flex p-0">
<div class="user-profile-header d-flex flex-column flex-lg-row text-sm-start text-center mb-4">
<div class="flex-shrink-0 mt-4 mx-lg-0 mx-auto">
<img src="{{ url('/upload/images/default.png') }}" width="200" height="200"
class="emp-image border d-block ms-0 ms-sm-4 rounded user-profile-img">
</div>
<div class="flex-grow-1 mt-3 mt-lg-5">
<div
class="admin-detail align-items-md-end align-items-sm-start align-items-center justify-content-md-between justify-content-start mx-3 mt-lg-5 flex-md-row flex-column gap-4">
<div class="user-profile-info">
<h4 class="emp-full-name">-</h4>
<ul
class="list-inline mb-0 d-flex align-items-center flex-wrap justify-content-sm-start justify-content-center gap-2">
<li class="list-inline-item">
<i class="mdi mdi-map-marker-outline me-1 mdi-20px"></i> <span
class="emp-city fw-medium">-</span>
</li>
<li class="list-inline-item emp-join-date-box">
<i class="mdi mdi-calendar-blank-outline me-1 mdi-20px"></i> <span
class="emp-join-date fw-medium">-</span>
</li>
</ul>
</div>
@if (in_array('Profile Maintain', Session::get('permissions')))
<a href="javascript:void(0)" class="btn btn-primary waves-effect waves-light"
onclick="_sendCredentials('{{ request()->id }}');">
<i class="mdi mdi-account-check-outline me-1"></i>Send Credentials
</a>
@endif
</div>
</div>
</div>
</div>
</div>
</div>
</div>

<div class="row">
<div class="col-lg-6 col-sm-12">
<div class="card mb-4 h-px-1100">
<div class="card-body ">
<div class="d-flex justify-content-between">
<b class="card-text text-uppercase mb-3">Company Detail</b>
@if (in_array('Profile Maintain', Session::get('permissions')))
<div class="custom-gradient"><a
href="{{ url('/employee-onboarding/create/company-details/' . request()->id) }}"
class="mdi mdi-pencil cursor-pointer"></a></div>
@endif
</div>
<div class="">
<ul class="list-group list-group-flush">
<li class="employee-detail list-group-item mb-3">
<div class="title float-start">Employee Email:</div>
<div class="text EmployeeEmail">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Employment Type: </div>
<div class="text EmploymentType"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Access Role: </div>
<div class="text float-start AccessRole"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Work Permit Type: </div>
<div class="text WorkPermitType"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Tax File No: </div>
<div class="text TaxFileNo"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Employment Start Date:</div>
<div class="text EmploymentStartDate">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Employment End Date:</div>
<div class="text EmploymentEndDate">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Attendance Effective From:</div>
<div class="text AttendanceEffectiveFrom">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Employee Payroll/External ID:</div>
<div class="text EmployeePayroll">-</div>
</li>
</ul>
</div>
</div>
</div>
</div>
<div class="col-lg-6 col-sm-12">
<div class="card mb-4 h-px-1100">
<div class="card-body">
<div class="d-flex justify-content-between">
<b class="card-text text-uppercase mb-3">Personal Details</b>
@if (in_array('Profile Maintain', Session::get('permissions')))
<div class="custom-gradient PersonalDetails"><a
href="{{ url('/employee-onboarding/create/personal-details/' . request()->id) }}"
class="mdi mdi-pencil cursor-pointer"></a></div>
@endif

</div>
<div class="">
<ul class="list-group list-group-flush">
<li class="list-group-item mb-3">
<div class="title float-start">First Name: </div>
<div class="text FirstName"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Middle Name: </div>
<div class="text MiddleName"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Last Name: </div>
<div class="text float-start LastName"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Mobile: </div>
<div class="text Mobile"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Street Address: </div>
<div class="text truncate-50 StreetAddress"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Town/Suburb:</div>
<div class="text TownSuburb">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">State:</div>
<div class="text State">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">PostCode/ZipCode:</div>
<div class="text PostCodeZipCode">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Date Of Birth:</div>
<div class="text DateOfBirth">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Blood Group:</div>
<div class="text BloodGroup">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Superannuation Funds:</div>
</li>
</ul>
<div class="table-responsive">
<table class="table">
<thead class="">
<tr>
<th>Title</th>
<th>Percentage</th>
<th>USI / Non-USI</th>
<th>USI Number</th>
</tr>
</thead>
<tbody class="table-border-bottom-0 SuperannuationFunds">

</tbody>
</table>
</div>


</div>
</div>
</div>
</div>
<div class="col-lg-6 col-sm-12">
<div class="card mb-4">
<div class="card-body h-px-400 overflow-auto">
<div class="d-flex justify-content-between">
<b class="card-text text-uppercase mb-3">Documents and Certifications</b>
@if (in_array('Profile Maintain', Session::get('permissions')))
<div class="custom-gradient"><a
href="{{ url('/employee-onboarding/create/documents-certifications/' . request()->id) }}"
class="mdi mdi-pencil cursor-pointer"></a></div>
@endif
</div>
<div class="">
<ul class="list-group list-group-flush DOCUMENTSANDCERTIFICATIONS">
</ul>
</div>
</div>
</div>
</div>

<div class="col-lg-6 col-sm-12">
<div class="card mb-4">
<div class="card-body h-px-400 overflow-auto">
<div class="d-flex justify-content-between">
<b class="card-text text-uppercase mb-3">Emergency Contacts</b>
@if (in_array('Profile Maintain', Session::get('permissions')))
<div class="custom-gradient"><a
href="{{ url('/employee-onboarding/create/emergency-contacts/' . request()->id) }}"
class="mdi mdi-pencil cursor-pointer"></a></div>
@endif
</div>
<div class="">
<table class="table">
<thead class="">
<tr>
<th>Name</th>
<th>Relation</th>
<th>Phone</th>
<th>Email</th>
<th>Address</th>
</tr>
</thead>
<tbody class="table-border-bottom-0 EmergencyContacts">

</tbody>
</table>
</div>
</div>
</div>
</div>
<div class="col-12">
<div class="card mb-3">
<div class="card-body">
<div class="d-flex justify-content-between">
<b class="card-text text-uppercase mb-3">System Access</b>
@if (in_array('Profile Maintain', Session::get('permissions')))
<div class="custom-gradient"><a
href="{{ url('/employee-onboarding/create/access/' . request()->id) }}"
class="mdi mdi-pencil cursor-pointer"></a></div>
@endif
</div>
<div class="">
<ul class="list-group mt-3">
<li class="list-group-item d-flex justify-content-between align-items-center">
Web App
<div class="form-check form-switch mt-1">
<label class="form-check-label" for=""><input class="form-check-input"
type="checkbox" id="access_web_app" disabled> </label>
</div>
</li>
<li class="list-group-item d-flex justify-content-between align-items-center">
Mobile App
<div class="form-check form-switch mt-1">
<label class="form-check-label" for=""><input class="form-check-input"
type="checkbox" id="access_mobile_app" disabled></label>
</div>
</li>
<li class="list-group-item d-flex justify-content-between align-items-center">
Attendance
<div class="form-check form-switch mt-1">
<label class="form-check-label" for=""><input class="form-check-input"
type="checkbox" id="access_attendance" disabled></label>
</div>
</li>
<li class="list-group-item d-flex justify-content-between align-items-center">
Timesheet
<div class="form-check form-switch mt-1">
<label class="form-check-label" for=""><input class="form-check-input"
type="checkbox" id="access_timesheet" disabled></label>
</div </li>

<li class="list-group-item d-flex justify-content-between align-items-center">
Send Timesheet Reminders
<div class="form-check form-switch mt-1">
<label class="form-check-label" for=""><input class="form-check-input"
type="checkbox" id="access_timesheet_reminders" disabled></label>
</div>
</li>
<li class="list-group-item d-flex justify-content-between align-items-center">
Email
<div class="form-check form-switch mt-1">
<label class="form-check-label" for=""><input class="form-check-input"
type="checkbox" id="access_email" disabled></label>
</div>
</li>
</ul>
</div>
</div>
</div>
</div>

<div class="col-12 EXTERNALEMPLOYEEDETAILBox">
<div class="card mb-4 h-px-1000">
<div class="card-body ">
<div class="d-flex justify-content-between">
<b class="card-text text-uppercase mb-3">External Employee Detail</b>
@if (in_array('Profile Maintain', Session::get('permissions')))
<div class="custom-gradient"><a
href="{{ url('/employee-onboarding/create/company-details/' . request()->id) }}"
class="mdi mdi-pencil cursor-pointer"></a></div>
@endif
</div>
<div class="row">
<div class="col-12 col-md-6">
<ul class="list-group list-group-flush">
<li class="employee-detail list-group-item mb-3">
<div class="title float-start">Job Title:</div>
<div class="text JobTitle"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Employer Name: </div>
<div class="text EmployerName"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Worker Type:</div>
<div class="text WorkerType">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Are you trade qualified: </div>
<div class="text float-start TradeQualified"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Years Completed: </div>
<div class="text TradeQualifiedYear"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Are you trade licensed: </div>
<div class="text TradeLicensed"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">License Number:</div>
<div class="text TradeLicensedYear">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Work Experience:</div>
<div class="text WorkExperience">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Year Commenced in Construction:</div>
<div class="text YearCommenced">-</div>
</li>
</ul>
</div>
<div class="col-12 col-md-6">
<ul class="list-group list-group-flush">
<li class="employee-detail list-group-item mb-3">
<div class="title float-start">Are you legally allowed to work in Australia:</div>
<div class="text LegallyAustralia">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Citizen: </div>
<div class="text CitizenshipStatus"> -</div>
</li>
<li class="list-group-item mb-3 TemporaryStudentVisaBox">
<div class="title float-start">Visa Holder Visa: </div>
<div class="text float-start TemporaryStudentVisa"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Allergies: </div>
<div class="text Allergies"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Details Allergies: </div>
<div class="text DetailsAllergies"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Previous injuries: </div>
<div class="text PreviousInjuries"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Details Previous Injuries: </div>
<div class="text DetailsPreviousInjuries"> -</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Existing medical conditions:</div>
<div class="text MedicalCondition">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Signature:</div>
<div class="text Signature">-</div>
</li>
<li class="list-group-item mb-3">
<div class="title float-start">Medical Attach files if available/needed:</div>
<div class="text MedicalAttachFiles">-</div>
</li>
</ul>
</div>
</div>
</div>
</div>
</div>
@if (in_array('Profile Maintain', Session::get('permissions')))
<div class="col-12 submit-history-box">
<div class="card mb-3">
<div class="card-body">
<div class="d-flex justify-content-center"> <!-- New div with flex utilities -->
<div class="list-button"> <!-- Your original div with buttons -->
<button class="btn btn-primary rounded-pill reject-approve-btn" data-bs-toggle="modal"
data-bs-target="#Reject" onclick="_reject_modal();">Reject</button>
<button class="btn btn-primary rounded-pill ms-3 reject-approve-btn"
onclick="_approved()">Approve</button>
<button class="profile-btn btn btn-primary rounded-pill"
onclick="_profile_submit_history();">Profile Submit History</button>
</div>
</div>
</div>
</div>
</div>
@endif
</div>
</div>

<div class="modal fade" id="Reject">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">
<div class="modal-header bg-primary px-4 py-2">
<h5 class="modal-title text-white" id="">Reject</h5>
</div>
<div class="modal-body">
<div class="mb-2">
<label for="defaultFormControlInput" class="form-label">Reason</label>
<textarea class="form-control" id="reason"></textarea>
</div>
</div>
<div class="modal-footer border-top py-2">
<button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
<button type="button" class="btn btn-danger" onclick="_reject();">Reject</button>
</div>
</div>
</div>
</div>

<div class="modal fade bd-example-modal-xl" id="ProfileSubmitHistory">
<div class="modal-dialog modal-dialog-centered modal-xl">
<div class="modal-content">
<div class="modal-header bg-primary px-4 py-2">
<h5 class="modal-title text-white" id="">Profile Submit History</h5>
</div>
<div class="modal-body">
<div class="table-responsive text-nowrap mt-3 border-bottom">
<table class="table">
<thead class="">
<tr>
<th>Approved By</th>
<th>Rejected By</th>
<th>Date</th>
<th>Reason</th>
</tr>
</thead>
<tbody class="table-body profile_submit_history_table">

</tbody>
</table>
</div>
</div>
<div class="modal-footer border-top py-2">
<button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>

<div class="modal fade bd-example-modal-xl" id="ReasonModal">
<div class="modal-dialog modal-dialog-centered modal-xl">
<div class="modal-content">
<div class="modal-header bg-primary px-4 py-2">
<h5 class="modal-title text-white" id="">Reason</h5>
</div>
<div class="modal-body">
<div class="text-wrap mt-3 reason_html">

</div>
</div>
<div class="modal-footer border-top py-2">
<button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
</div>
</div>
</div>
</div>


</div>

<!-- Warnings Section (previously included from 'PreRequire/workerType') -->
<div id="navs-top-permit-typte" class="tab-pane fade" role="tabpanel" aria-labelledby="navs-top-permit-typte-tab">
<!-- Warnings content here -->
<div class="container-xxl flex-grow-1 container-p-y">
<div class="card">
<div class="card-body p-0">
<div class="py-3 px-3 tier-list d-flex justify-content-end ">

<div class="p-2">
<button class="btn btn-primary px-3" data-bs-toggle="modal"
data-bs-target="#warning-modal"><span class="mdi mdi-plus"></span>Add Warning</button>
</div>
</div>
<div>
<div class="table-responsive text-nowrap border-bottom">
<table class="table">
<thead class="table-head-color bg-primary">
<tr class="bg-primary">
<th style="width: 10%;">S/N</th>
<th>Uploaded Person</th>
<th>Date</th>
<th>Description</th>
<th style="width: 10%;">Actions</th>
</tr>
</thead>
<tbody class="table-border-bottom-0 table-body">

</tbody>
</table>
</div>
<nav aria-label="Page navigation" class="mt-3">
<ul class="pagination justify-content-end warning_pages_btn">

</ul>
</nav>
</div>
</div>
</div>
</div>

<!-- Modal -->
<div class="modal fade" id="warning-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">
<div class="modal-header hearder-color p-2">
<h5 class="modal-title text-white text-center ps-3" id="exampleModalLabel">Add New Warning</h5>
</div>
<form id="meeting-form">
<div class="modal-body">
<div class="row">
<div class="col-12">
<div class="mb-3">
<label for="document">Document<span class="text-danger">*</span></label>
<input type="file" class="form-control" name="document" id="document">
</div>
</div>

<div class="col-12">
<div class="mb-3">
<label for="tier_description" class="form-label">Description</label>
<textarea class="form-control" id="description" rows="3" name="description"></textarea>
</div>
</div>
</div>
</div>
<div class="modal-footer border-top p-2">
<button type="button" class="btn btn-outline-light text-black" data-bs-dismiss="modal">Close</button>
<button type="submit" class="btn btn-color text-white" >Save</button>
<!-- //onclick=meeting_store(); -->
</div>
</form>
</div>
</div>
</div>

<!--Edit Modal -->
<div class="modal fade" id="edit-warning-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">
<div class="modal-header hearder-color p-2">
<h5 class="modal-title text-white text-center ps-3" id="exampleModalLabel">Edit Warning</h5>
</div>
<form id="edit-warning-form">
<div class="modal-body">
<input type="hidden" id="warningId">
<div class="row">
<div class="col-10">

<div class="mb-3">
<label for="edit_document">Document<span class="text-danger">*</span></label>
<input type="file" class="form-control" name="edit_document" id="edit_document">
</div>


</div>
<div class="col-2 ">
<div class="mt-4">
<a id="viewDocumentLink" target="_blank" >
<i class="mdi mdi-eye mdi-20px text-primary"></i>
</a>
</div>

</div>

<div class="col-12">
<div class="mb-3">
<label for="tier_description" class="form-label">Description</label>
<textarea class="form-control" id="edit_description" rows="3" name="edit_description"></textarea>
</div>
</div>
</div>
</div>
<div class="modal-footer border-top p-2">
<button type="button" class="btn btn-outline-light text-black" data-bs-dismiss="modal">Close</button>
<button type="submit" class="btn btn-color text-white" >Update</button>
<!-- onclick=tier_update(); -->
</div>
</form>
</div>
</div>
</div>

<!--detail Modal -->
<div class="modal fade" id="tier-desc-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">
<div class="modal-header hearder-color p-2">
<h5 class="modal-title text-white text-center ps-3" id="exampleModalLabel">Description</h5>
</div>
<div class="modal-body">
<input type="hidden" id="warningId">
<div class="row">
<div class="col-12">
<div class="mb-3">
<textarea class="form-control" id="tier_desc" rows="5" disabled name="description"></textarea>
</div>
</div>
</div>
</div>
</div>
</div>
</div>

<div class="modal fade" id="DeleteEmp" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">
<div class="modal-header bg-danger px-4 py-2">
<h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
</div>
<div class="modal-body">
Are you sure you want to delete this record?<br><br>
<b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you genuinely want to delete it before clicking the delete button.
</div>
<div class="modal-footer border-top py-2">
<button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
<button type="button" class="btn btn-danger" id="leave-tier-id" data-id="" onclick="_delete(this)">Delete</button>
</div>
</div>
</div>
</div>

<div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
<div class="offcanvas-header " style="background-color:#019FF3;">
<h5 class="text-white" id="offcanvasRightLabel">Assigned Tier</h5>
<a type="button" class="border px-2 rounded-circle btn-text-white" data-bs-dismiss="offcanvas">X</a>
</div>

<div class="offcanvas-body p-0" >
<div class="h-px-30 w-auto" style="background-color:#d9eeff">
<div class="d-flex justify-content-between py-1 px-4">
<div class="text_color">User</div>
<div class="text_color">Profile</div>
</div>
</div>
<div id="tier_emp">

</div>
</div>


</div>


</div>

<!-- Management Comments Section (previously included from 'PreRequire/workExperience') -->
<div id="navs-top-employementtype" class="tab-pane fade" role="tabpanel" aria-labelledby="navs-top-employementtype-tab">
<div class="container-xxl flex-grow-1 container-p-y">
<div class="card">
<div class="card-body p-0">
<div class="py-3 px-3 tier-list d-flex justify-content-end ">

<div class="p-2">
<button class="btn btn-primary px-3" data-bs-toggle="modal"
data-bs-target="#comment-modal"><span class="mdi mdi-plus"></span>Add Comment</button>
</div>
</div>
<div>
<div class="table-responsive text-nowrap border-bottom">
<table class="table">
<thead class="table-head-color bg-primary">
<tr class="bg-primary">
<th style="width: 10%;">S/N</th>
<th>Uploaded Person</th>
<th>Date</th>
<th>Comment</th>
<th style="width: 10%;">Actions</th>
</tr>
</thead>
<tbody class="table-border-bottom-0 table-body-comment">

</tbody>
</table>
</div>
<nav aria-label="Page navigation" class="mt-3">
<ul class="pagination justify-content-end pages_btn">

</ul>
</nav>
</div>
</div>
</div>
</div>

<!-- Modal -->
<div class="modal fade" id="comment-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">
<div class="modal-header hearder-color p-2">
<h5 class="modal-title text-white text-center ps-3" id="exampleModalLabel">Add New Comment</h5>
</div>
<form id="comment-form">
<div class="modal-body">
<div class="row">
<div class="col-12">
<div class="mb-3">
<label for="comment_document">Document<span class="text-danger">*</span></label>
<input type="file" class="form-control" name="comment_document" id="comment_document">
</div>
</div>

<div class="col-12">
<div class="mb-3">
<label for="commet_description" class="form-label">Comment</label>
<textarea class="form-control" id="commet_description" rows="3" name="commet_description"></textarea>
</div>
</div>
</div>
</div>
<div class="modal-footer border-top p-2">
<button type="button" class="btn btn-outline-light text-black" data-bs-dismiss="modal">Close</button>
<button type="submit" class="btn btn-color text-white" >Save</button>
<!-- //onclick=meeting_store(); -->
</div>
</form>
</div>
</div>
</div>

<!--Edit Modal -->
<div class="modal fade" id="edit-comment-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">
<div class="modal-header hearder-color p-2">
<h5 class="modal-title text-white text-center ps-3" id="exampleModalLabel">Edit Comment</h5>
</div>
<form id="edit-comment-form">
<div class="modal-body">
<input type="hidden" id="CommentId">
<div class="row">
<div class="col-10">

<div class="mb-3">
<label for="edit_comment_document">Document<span class="text-danger">*</span></label>
<input type="file" class="form-control" name="edit_comment_document" id="edit_comment_document">
</div>


</div>
<div class="col-2 ">
<div class="mt-4">
<a id="viewDocumentLinkComment" target="_blank" >
<i class="mdi mdi-eye mdi-20px text-primary"></i>
</a>
</div>

</div>

<div class="col-12">
<div class="mb-3">
<label for="edit_comment_description" class="form-label">Comment</label>
<textarea class="form-control" id="edit_comment_description" rows="3" name="edit_comment_description"></textarea>
</div>
</div>
</div>
</div>
<div class="modal-footer border-top p-2">
<button type="button" class="btn btn-outline-light text-black" data-bs-dismiss="modal">Close</button>
<button type="submit" class="btn btn-color text-white" >Update</button>
<!-- onclick=tier_update(); -->
</div>
</form>
</div>
</div>
</div>

<!--detail Modal -->
<div class="modal fade" id="tier-desc-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">
<div class="modal-header hearder-color p-2">
<h5 class="modal-title text-white text-center ps-3" id="exampleModalLabel">Description</h5>
</div>
<div class="modal-body">
<input type="hidden" id="warningId">
<div class="row">
<div class="col-12">
<div class="mb-3">
<textarea class="form-control" id="tier_desc" rows="5" disabled name="description"></textarea>
</div>
</div>
</div>
</div>
</div>
</div>
</div>

<div class="modal fade" id="DeleteComment" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
<div class="modal-dialog modal-dialog-centered">
<div class="modal-content">
<div class="modal-header bg-danger px-4 py-2">
<h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
</div>
<div class="modal-body">
Are you sure you want to delete this record?<br><br>
<b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you genuinely want to delete it before clicking the delete button.
</div>
<div class="modal-footer border-top py-2">
<button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
<button type="button" class="btn btn-danger" id="comment-id" data-id="" onclick="_deleteComment(this)">Delete</button>
</div>
</div>
</div>
</div>

<div class="offcanvas offcanvas-end" tabindex="-1" id="offcanvasRight" aria-labelledby="offcanvasRightLabel">
<div class="offcanvas-header " style="background-color:#019FF3;">
<h5 class="text-white" id="offcanvasRightLabel">Assigned Tier</h5>
<a type="button" class="border px-2 rounded-circle btn-text-white" data-bs-dismiss="offcanvas">X</a>
</div>

<div class="offcanvas-body p-0" >
<div class="h-px-30 w-auto" style="background-color:#d9eeff">
<div class="d-flex justify-content-between py-1 px-4">
<div class="text_color">User</div>
<div class="text_color">Profile</div>
</div>
</div>
<div id="tier_emp">

</div>
</div>


</div>
</div>

<!-- Other Section (previously included from 'PreRequire/empRole') -->
<div id="navs-top-documents" class="tab-pane fade" role="tabpanel" aria-labelledby="navs-top-documents-tab">
<!-- Additional content here -->
<h5>Other Document/Role</h5>
<p>Other content goes here.</p>
</div>
</div>
</div>
</div>
</div>



@endsection






@section('css-js')
<script>
$(document).ready(function() {
_get();
_getWarning(0);
_getUserComment(0);

});
var csrfToken = $('meta[name="csrf-token"]').attr('content');
// Set up the CSRF token for all AJAX requests
$.ajaxSetup({
headers: {
'X-CSRF-TOKEN': csrfToken
}
});
function openCity(evt, cityName) {
var i, tabcontent, tablinks;
tabcontent = document.getElementsByClassName("tabcontent");
for (i = 0; i < tabcontent.length; i++) {
tabcontent[i].style.display = "none";
}
tablinks = document.getElementsByClassName("tablinks");
for (i = 0; i < tablinks.length; i++) {
tablinks[i].className = tablinks[i].className.replace(" active", "");
}
document.getElementById(cityName).style.display = "block";
evt.currentTarget.className += " active";
}

function _get() {
loader(true);


var _FormData = new FormData();
_FormData.append("id", '{{ request()->id }}');
$.ajax({
type: "POST",
url: "{{ url('/api/profile') }}",
headers: {
'X-CSRF-TOKEN': '{{ csrf_token() }}'
},
data: _FormData,
processData: false,
contentType: false,
success: function(response) {



var personal_details = response.data.profile?.emp_personal_details;
var company_details = response.data.profile;
var empType = response.data.profile?.empType;
var empWorkPermit = response.data.profile?.empWorkPermit;
var empAccessRole = response.data.profile?.empAccessRole;
var emp_documents = response.data.emp_documents;
var _data = response.data.required_documents;
var emp_emergency_contacts = response.data.profile?.emp_emergency_contacts;
var emp_access = response.data.profile?.emp_access;
var _meta = response.data.meta;
var funds_meta = response.data.funds_meta;
var medicalAttachFiles = response.data?.medicalAttachFiles;
var details_previous_injuries = response.data?.details_previous_injuries;
var details_allergies = response.data?.details_allergies;


company_details.user_type == '0' ? $('.submit-history-box').show() : $('.submit-history-box').hide();
company_details.user_type == '1' ? $('.EXTERNALEMPLOYEEDETAILBox').show() : $('.EXTERNALEMPLOYEEDETAILBox').hide();
company_details.user_type == '1' ? $('a.mdi.mdi-pencil.cursor-pointer').attr('href','{{url("/edit-external-employee/".request()->id)}}') : '';


if (_meta) {
$('.EmployeePayroll').html(_meta.employee_payroll_or_external_id ? _meta
.employee_payroll_or_external_id : "-");
}

if (company_details?.is_submitted == '0') {
$('.reject-approve-btn').remove();
}

if (personal_details) {

$('.emp-image').attr('src', "{{ url('/') }}/" + personal_details?.image);
$('.emp-full-name').html(
`${personal_details?.first_name} ${personal_details?.middle_name ? personal_details?.middle_name : ''} ${personal_details?.last_name ? personal_details?.last_name : ''}`
);
$('.emp-city').html(personal_details?.suburb);
$('.FirstName').html(personal_details?.first_name);
$('.LastName').html(personal_details?.last_name ? personal_details?.last_name : ' -');
$('.MiddleName').html(personal_details?.middle_name ? personal_details?.middle_name :
' -');
$('.TownSuburb').html(personal_details?.suburb);
$('.State').html(personal_details?.state);
$('.PostCodeZipCode').html(personal_details?.postcode);
$('.Mobile').html(personal_details?.mobile);
$('.DateOfBirth').html(formate_date(personal_details?.date_of_birth));
$('.BloodGroup').html(personal_details?.blood_group);
$('.StreetAddress').html(personal_details?.streat_address);
}
var empPos = '';


$('.emp-join-date').html(company_details?.employment_start_date ? formate_date(company_details?.employment_start_date) : '-');
company_details?.employment_start_date ? $('.emp-join-date-box').show() : $('.emp-join-date-box').hide();
$('.EmployeeEmail').html(company_details?.employee_email);
$('.EmploymentType').html(empType?.title);
$('.AccessRole').html(empAccessRole?.title);
$('.WorkPermitType').html(empWorkPermit?.title);
$('.TaxFileNo').html(company_details?.tax_file_no);
$('.EmploymentStartDate').html(company_details?.employment_start_date ? formate_date(company_details?.employment_start_date) : '-');
$('.EmploymentEndDate').html(company_details?.employment_end_date ? formate_date(company_details?.employment_end_date) : ' -');
$('.AttendanceEffectiveFrom').html(company_details?.attendance_effective_from ? formate_date(company_details?.attendance_effective_from) : '-');

var save_docs = {};
var _save_docs = '';
var html = ``;
var required_document;

for (var i = 0; i < emp_documents.length; i++) {
if (!save_docs.hasOwnProperty(emp_documents[i].required_document)) {
save_docs[emp_documents[i].required_document] = {};
}
save_docs[emp_documents[i].required_document][emp_documents[i].required_document_field] = emp_documents[i].value;
}

for (var i = 0; i < _data.length; i++) {

if (_data[i].for_who != 2 && _data[i].for_who != company_details?.user_type) {
continue;
}

html += `<div class="row mt-4">
<div class="form-group col-md-4 mt-1">
<p class=""><span style="font-weight:bold;">${_data[i].title}</span></p>
</div>
<div class="row col-md-8">
`;

required_document = _data[i].required_document_field;
console.log(required_document);
for (var j = 0; j < required_document.length; j++) {

if(required_document[j].status == 0)
{
continue;
}

_save_docs = save_docs[_data[i].id] ? save_docs[_data[i].id][required_document[j].id] ? save_docs[_data[i].id][required_document[j].id] : "" : "";

html += `<div class="form-group col-md-6 mt-3 ${required_document[j].field_type == 'file' ? 'position-relative': '' } " >
<lable>${required_document[j].field_name}</lable>
${required_document[j].field_type == 'file' ? '<div class="license">' : '' }
<div>${required_document[j].field_type != 'file' ? _save_docs == '' ? '-' : '' : '' }</div>
${required_document[j].field_type == 'file' ?
`</div>
${_save_docs == '' ? '-' : '' }
<a href="${required_document[j].field_type == 'file' ? "{{url('/')}}/"+_save_docs : '' }" target="_blank" class="eye-icon ${_save_docs == '' ? 'd-none' : '' } "> <span class="mdi mdi-eye text-primary" role="button"></span></a>
<a href="${required_document[j].field_type == 'file' ? "{{url('/')}}/"+_save_docs : '' }" download class="arrow-icon ${_save_docs == '' ? 'd-none' : '' }"> <span class="mdi mdi-cloud-download mdi-20px text-info me-2"></span></a>` : '' }
</div>`;
}

html += `</div></div>`;
}

$('.DOCUMENTSANDCERTIFICATIONS').html(html);


var emp_emergency_contacts_html = "";

for (var i = 0; i < emp_emergency_contacts.length; i++) {
if(emp_emergency_contacts[i]?.del == 1){
continue;
}
emp_emergency_contacts_html += `
<tr>
<td>${emp_emergency_contacts[i]?.name}</td>
<td>${emp_emergency_contacts[i]?.relation}</td>
<td>${emp_emergency_contacts[i]?.phone}</td>
<td>${emp_emergency_contacts[i]?.email ? emp_emergency_contacts[i]?.email : '-'}</td>
<td>${emp_emergency_contacts[i]?.address ? emp_emergency_contacts[i]?.address?.length <= 15 ? emp_emergency_contacts[i]?.address : emp_emergency_contacts[i]?.address?.slice(0, 15) + "..." : '-'}</td>
</tr>`;
}


if (emp_emergency_contacts_html) {
$('.EmergencyContacts').html(emp_emergency_contacts_html);
} else {
$('.EmergencyContacts').html(
'<td colspan="5" class="mt-5 text-center" >No Contacts Yet</td>');
}


if (emp_access) {



if (emp_access.web_app == 1) {
$("#access_web_app").attr("checked", "checked");
} else {
$("#access_web_app").removeAttr("checked");
}


if (emp_access.mobile_app == 1) {
$("#access_mobile_app").attr("checked", "checked");
} else {
$("#access_mobile_app").removeAttr("checked");
}

if (emp_access.attendance == 1) {

$("#access_attendance").attr("checked", "checked");
} else {

$("#access_attendance").removeAttr("checked");
}

if (emp_access.timesheet_reminders == 1) {
$("#access_timesheet_reminders").attr("checked", "checked");
} else {
$("#access_timesheet_reminders").removeAttr("checked");
}

if (emp_access.email == 1) {
$("#access_email").attr("checked", "checked");
} else {
$("#access_email").removeAttr("checked");
}

if (emp_access.timesheet == 1) {
$("#access_timesheet").attr("checked", "checked");
} else {
$("#access_timesheet").removeAttr("checked");
}

}

var _html = ``;

for (i = 0; i < funds_meta.length; i++) {
_html += `<tr>
<td>${funds_meta[i].fund.title}</td>
<td>${funds_meta[i].fund.percentage}%</td>
<td class="uri${funds_meta[i].fund.id}">${funds_meta[i].fund.usi == 1 ? 'USI': 'Non-USI' }</td>
<td class="superannuations-usi-number superannuations-usi-number${funds_meta[i].fund.id}" >${funds_meta[i].fund.usi == 1 ? funds_meta[i].fund.usi_number ? funds_meta[i].fund.usi_number : '' : funds_meta[i].usi_number ? funds_meta[i].usi_number : ''}</td>
</tr>`;
}


$('.SuperannuationFunds').html(_html);
$('.JobTitle').html(company_details?.job_title);
$('.EmployerName').html(company_details?.employer_name);
$('.WorkerType').html(company_details?.worker_type ? company_details?.worker_type.title : '-');
$('.TradeQualified').html(company_details?.trade_qualified == '1' ? 'Yes' : 'NO');
$('.TradeQualifiedYear').html(company_details?.trade_qualified_year);
$('.TradeLicensed').html(company_details?.trade_licensed == '1' ? 'Yes' : 'NO');
$('.TradeLicensedYear').html(company_details?.trade_licensed_year);
$('.WorkExperience').html(company_details?.work_experience ? company_details?.work_experience.title : '-' );
$('.YearCommenced').html(company_details?.year_commenced);
$('.LegallyAustralia').html(company_details?.legally_australia == '1' ? 'Yes' : 'NO');
$('.CitizenshipStatus').html(company_details?.citizenship_status == '1' ? 'Aussie Citizen' : 'Visa Holder');
$('.TemporaryStudentVisa').html(company_details?.temporary_student_visa ? `<a href="/${company_details?.temporary_student_visa}" style="margin-left: 30px !important;" target="_blank" ><span class="mdi mdi-eye text-primary" role="button"></span></a>` : '-');
$('.Allergies').html(company_details?.allergies ? 'Yes' : 'NO');
$('.DetailsPreviousInjuries').html(company_details?.details_previous_injuries != null ? company_details?.details_previous_injuries : '-');
$('.DetailsAllergies').html(company_details?.details_allergies != null ? company_details?.details_allergies : '-');
$('.PreviousInjuries').html(company_details?.previous_injuries ? 'Yes' : 'NO');
$('.MedicalCondition').html(company_details?.medical_condition);
$('.Signature').html(company_details.signature ? `<a href="/${company_details?.signature}" target="_blank" style="margin-left: 30px !important;" ><span class="mdi mdi-eye text-primary" role="button"></span></a>` : '-');

var html = `<br>`;

for(var i = 0 ; i < medicalAttachFiles.length ; i++)
{
html += `<a href="/${medicalAttachFiles[i]?.file}" target="_blank" style="margin-left:20px;"><img src="/${medicalAttachFiles[i]?.file}" style="width:80px;height:80px;" ></a>`;
}

if(html == ``)
{
$('.MedicalAttachFiles').html('-');
}
else
{
$('.MedicalAttachFiles').html(html);
}

loader(false);

},
error: function(response) {
loader(false);
if (response.status == 500) {
toastr.error("Something went wrong")
} else {
toastr.error(response.responseJSON.message)
}
}
});

}

function _getWarning(from)
{

var _FormData = new FormData();
_FormData.append("id", '{{ request()->id }}');
$.ajax({
type: "POST",
url: `{{ url('/api/get-Warnings') }}?from=${from}`,
headers: {
'X-CSRF-TOKEN': '{{ csrf_token() }}'
},
data: _FormData,
processData: false,
contentType: false,
success: function (response) {
var data = response.data;
var html = ``;
var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count)/10;

count = Math.ceil(count);
var pages_btn = ``;

pages_btn += `
<li class="page-item prev ${response.count == 0 ? 'd-none' : ''}" onclick="_getWarning(0);" >
<a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
</li>
<li class="page-item prev ${response.count == 0 ? 'd-none' : ''}" onclick="$('.activeWarning').prev('.Warning-p-btn').trigger('onclick');" >
<a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
</li>`;

$('.Warning-p-btn').removeClass('activeWarning');

var c = 0;
for(c = 0; c < count; c++)
{
if(
(from == (c-3)*10) ||
(from == (c-2)*10) ||
(from == (c-1)*10) ||
(from == (c-0)*10) ||
(from == (c+1)*10) ||
(from == (c+2)*10) ||
(from == (c+3)*10)
)
{
pages_btn += `
<li class="page-item Warning-p-btn ${from == c*10 ? 'activeWarning' : '' } ${response.count == 0 ? 'd-none' : '' } " onclick="_getWarning(${c*10});">
<a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
</li>
`;
}

}

pages_btn += `

<li class="page-item next ${response.count == 0 ? 'd-none' : ''}" onclick="$('.activeWarning').next('.Warning-p-btn').trigger('onclick');" >
<a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
</li>
<li class="page-item next ${response.count == 0 ? 'd-none' : ''}" onclick="_getWarning(${(c-1)*10});" >
<a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
</li>
`;

$('.warning_pages_btn').html(pages_btn);



for (var i = 0; i < data.length; i++) {
var empimgs = data[i]?.company_details?.map(detail => detail?.tier_emp_personal_detail?.image).join(', ') || '';
var tiercount = i + 1;
html += `
<tr>
<td><span class="fw-medium">${tiercount}</span></td>
<td >${data[i].first_name} ${data[i].last_name}</td>

<td>${formatDateToDMY(data[i].created_at)}</td>
<td class="cursor-pointer" data-bs-toggle="modal" data-bs-target="#tier-desc-modal" onclick="_detail(${data[i]?.id})">${data[i]?.description?.length > 50 ? `${data[i].description.slice(0, 50)}...` : data[i].description ? data[i].description : ''}</td>
<td>
@if(in_array('Tier List Maintain',Session::get('permissions')))
<div class="dropdown cursor-pointer d-flex justify-content-center">
<div id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>

<ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
<li><a class="dropdown-item py-1 ps-2" data-id="${data[i].id}" onclick="_edit(${data[i]?.id});"data-bs-toggle="modal" data-bs-target="#edit-warning-modal"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
<li><a class="dropdown-item py-1 ps-2" data-id="${data[i].id}" onclick="_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
<li><a class="dropdown-item py-1 ps-2" onclick="downloadFile('/${data[i].image}')" target="_blank"><span class="mdi mdi-briefcase-download-outline mdi-20px text-warning"></span> Download Document</a></li>
<li><a class="dropdown-item py-1 ps-2" href="/${data[i].image}" target="_blank"><span class="mdi mdi-monitor mdi-20px text-warning"></span> View Document</a></li>
</ul>
</div>
@endif
</td>
</tr>`;
}

$('.table-body').html(html);

if (html == ``) {
$('.table-body').html(`<tr><td colspan="8" class="text-center">No record found</td></tr>`);
}

loader(false);
},
error: function (response) {
loader(false);
if (response.status == 422) {
var errors = response.responseJSON.data;
$.each(errors, function (field, messages) {
error_msg = messages[0];
toastr.error(error_msg);
});
} else if (response.status == 500) {
toastr.error("Something went wrong")
} else {
toastr.error(response.responseJSON.message)
}
}
});
}

function _getUserComment(from)
{
var _FormData = new FormData();
_FormData.append("id", '{{ request()->id }}');
$.ajax({
type: "POST",
url: `{{ url('/api/get-comment-management') }}?from=${from}`,
headers: {
'X-CSRF-TOKEN': '{{ csrf_token() }}'
},
data: _FormData,
processData: false,
contentType: false,
success: function (response) {
var data = response.data;
var html = ``;
var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count)/10;


count = Math.ceil(count);

var pages_btn = ``;

pages_btn += `
<li class="page-item prev ${response.count == 0 ? 'd-none' : ''}" onclick="_getUserComment(0);" >
<a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
</li>
<li class="page-item prev ${response.count == 0 ? 'd-none' : ''}" onclick="$('.active').prev('.p-btn').trigger('onclick');" >
<a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
</li>`;

$('.p-btn').removeClass('active');

var c = 0;
for(c = 0; c < count; c++)
{

if(
(from == (c-3)*10) ||
(from == (c-2)*10) ||
(from == (c-1)*10) ||
(from == (c-0)*10) ||
(from == (c+1)*10) ||
(from == (c+2)*10) ||
(from == (c+3)*10)
)
{
pages_btn += `
<li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } " onclick="_getUserComment(${c*10});">
<a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
</li>
`;
}

}

pages_btn += `

<li class="page-item next ${response.count == 0 ? 'd-none' : ''}" onclick="$('.active').next('.p-btn').trigger('onclick');" >
<a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
</li>
<li class="page-item next ${response.count == 0 ? 'd-none' : ''}" onclick="_getUserComment(${(c-1)*10});" >
<a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
</li>
`;


$('.pages_btn').html(pages_btn);



for (var i = 0; i < data.length; i++) {
var empimgs = data[i]?.company_details?.map(detail => detail?.tier_emp_personal_detail?.image).join(', ') || '';
var tiercount = i + 1;
html += `
<tr>
<td><span class="fw-medium">${tiercount}</span></td>
<td >${data[i].first_name} ${data[i].last_name}</td>
<td>${formatDateToDMY(data[i].created_at)}</td>

<td class="cursor-pointer" data-bs-toggle="modal" data-bs-target="#tier-desc-modal" onclick="_detail(${data[i]?.id})">${data[i]?.description?.length > 50 ? `${data[i].description.slice(0, 50)}...` : data[i].description ? data[i].description : ''}</td>
<td>
@if(in_array('Tier List Maintain',Session::get('permissions')))
<div class="dropdown cursor-pointer d-flex justify-content-center">
<div id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>

<ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
<li><a class="dropdown-item py-1 ps-2" data-id="${data[i].id}" onclick="_editComment(${data[i]?.id});"data-bs-toggle="modal" data-bs-target="#edit-comment-modal"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
<li><a class="dropdown-item py-1 ps-2" data-id="${data[i].id}" onclick="_delete_modal_comment(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
<li><a class="dropdown-item py-1 ps-2" onclick="downloadFile('/${data[i].image}')" target="_blank"><span class="mdi mdi-briefcase-download-outline mdi-20px text-warning"></span> Download Document</a></li>
<li><a class="dropdown-item py-1 ps-2" href="/${data[i].image}" target="_blank"><span class="mdi mdi-monitor mdi-20px text-warning"></span> View Document</a></li>
</ul>
</div>
@endif
</td>
</tr>`;
}

$('.table-body-comment').html(html);

if (html == ``) {
$('.table-body-comment').html(`<tr><td colspan="8" class="text-center">No record found</td></tr>`);
}

loader(false);
},
error: function (response) {
loader(false);
if (response.status == 422) {
var errors = response.responseJSON.data;
$.each(errors, function (field, messages) {
error_msg = messages[0];
toastr.error(error_msg);
});
} else if (response.status == 500) {
toastr.error("Something went wrong")
} else {
toastr.error(response.responseJSON.message)
}
}
});
}
$('#meeting-form').submit(function(e) {
e.preventDefault(); // Prevent default form submission

// Get the description value
var description = $('#description').val();
var document= $('#document')[0].files[0]
if (typeof document === "undefined" || !document) {
toastr.error("Document is required");
return 0;
}
// Create a FormData object to hold the form data and file
var formData = new FormData();
formData.append("emp_id", '{{ request()->id }}');
formData.append('image', $('#document')[0].files[0]); // Append the selected file
formData.append('description', description); // Append the description

// Perform the AJAX request to submit the form
$.ajax({
url: '{{url("/")}}/api/Warnings',// The route where you want to handle the request
method: 'POST',
data: formData,
processData: false, // Don't process the data
contentType: false, // Let the browser set the correct content-type
success: function(response) {
_getWarning();
$('#warning-modal').modal('hide');
$('#meeting-form')[0].reset()
toastr.success(response.message);
},
error: function(xhr, status, error) {
loader(false);

if (xhr.status == 422) {
var errors = xhr.responseJSON.data;
$.each(errors, function(field, messages) {
error_msg = messages[0];
toastr.error(error_msg);
});
}
else
if (xhr.status == 500) {
toastr.error("Something went wrong")
}
else
{
toastr.error(xhr.responseJSON.message)
}
}
});
});


$('#comment-form').submit(function(e) {
e.preventDefault(); // Prevent default form submission

// Get the description value
var description = $('#commet_description').val();
var comment_document= $('#comment_document')[0].files[0]
if (typeof comment_document === "undefined" || !comment_document) {
toastr.error("Document is required");
return 0;
}
// Create a FormData object to hold the form data and file
var formData = new FormData();
formData.append("emp_id", '{{ request()->id }}');
formData.append('image', $('#comment_document')[0].files[0]); // Append the selected file
formData.append('description', description); // Append the description

// Perform the AJAX request to submit the form
$.ajax({
url: '{{url("/")}}/api/comment-management',// The route where you want to handle the request
method: 'POST',
data: formData,
processData: false, // Don't process the data
contentType: false, // Let the browser set the correct content-type
success: function(response) {
_getUserComment();
$('#comment-modal').modal('hide');
$('#comment-form')[0].reset()
toastr.success(response.message);
},
error: function(xhr, status, error) {
loader(false);

if (xhr.status == 422) {
var errors = xhr.responseJSON.data;
$.each(errors, function(field, messages) {
error_msg = messages[0];
toastr.error(error_msg);
});
}
else
if (xhr.status == 500) {
toastr.error("Something went wrong")
}
else
{
toastr.error(xhr.responseJSON.message)
}
}
});
});


function _edit(id)
{
$.ajax({
type: "GET",
url: "{{url('/')}}/api/Warnings/" + id + "/edit",
dataType: 'json',
headers: {
'X-CSRF-TOKEN': '{{ csrf_token() }}'
},
success: function (data) {

var data = data[0];
var image = "/" + data.image;
// $('#document').val(data.image);
$('#viewDocumentLink').attr('href', image);
$('#edit_description').val(data.description);
$('#warningId').val(data.id);
},
error: function (error) {
console.error("Error:", error);
toastr.error("Error fetching data");
}
});

}

function _editComment(id)
{
$.ajax({
type: "GET",
url: "{{url('/')}}/api/comment-management/" + id + "/edit",
dataType: 'json',
headers: {
'X-CSRF-TOKEN': '{{ csrf_token() }}'
},
success: function (data) {

var data = data[0];
var image = "/" + data.image;
// $('#document').val(data.image);
$('#viewDocumentLinkComment').attr('href', image);
$('#edit_comment_description').val(data.description);
$('#CommentId').val(data.id);
},
error: function (error) {
console.error("Error:", error);
toastr.error("Error fetching data");
}
});

}

$('#edit-warning-form').submit(function(e) {
e.preventDefault(); // Prevent default form submission

// Get the description value
var description = $('#edit_description').val();
var warningId = $('#warningId').val();
// Create a FormData object to hold the form data and file
var formData = new FormData();
formData.append("emp_id", '{{ request()->id }}');
formData.append('image', $('#edit_document')[0].files[0]); // Append the selected file
formData.append('description', description); // Append the description
formData.append("id", warningId);
// Perform the AJAX request to submit the form
$.ajax({
url: '{{url("/")}}/api/update-Warnings',
method: 'post',
data: formData,
processData: false, // Don't process the data
contentType: false, // Let the browser set the correct content-type
success: function(response) {
_getWarning();
$('#edit-warning-modal').modal('hide');
$('#edit-warning-form')[0].reset()
toastr.success(response.message);
},
error: function(xhr, status, error) {
loader(false);

if (xhr.status == 422) {
var errors = xhr.responseJSON.data;
$.each(errors, function(field, messages) {
error_msg = messages[0];
toastr.error(error_msg);
});
}
else
if (xhr.status == 500) {
toastr.error("Something went wrong")
}
else
{
toastr.error(xhr.responseJSON.message)
}
}
});
});


$('#edit-comment-form').submit(function(e) {
e.preventDefault(); // Prevent default form submission

// Get the description value
var description = $('#edit_comment_description').val();
var CommentId = $('#CommentId').val();
// Create a FormData object to hold the form data and file
var formData = new FormData();
formData.append("emp_id", '{{ request()->id }}');
formData.append('image', $('#edit_comment_document')[0].files[0]); // Append the selected file
formData.append('description', description); // Append the description
formData.append("id", CommentId);
// Perform the AJAX request to submit the form
$.ajax({
url: '{{url("/")}}/api/update-comment-management',
method: 'post',
data: formData,
processData: false, // Don't process the data
contentType: false, // Let the browser set the correct content-type
success: function(response) {
_getUserComment();
$('#edit-comment-modal').modal('hide');
$('#edit-comment-form')[0].reset()
toastr.success(response.message);
},
error: function(xhr, status, error) {
loader(false);

if (xhr.status == 422) {
var errors = xhr.responseJSON.data;
$.each(errors, function(field, messages) {
error_msg = messages[0];
toastr.error(error_msg);
});
}
else
if (xhr.status == 500) {
toastr.error("Something went wrong")
}
else
{
toastr.error(xhr.responseJSON.message)
}
}
});
});


function _delete_modal(_this)
{
var id = $(_this).attr('data-id');
$('#leave-tier-id').attr('data-id',id);
$('#DeleteEmp').modal('show');
}
function _delete_modal_comment(_this)
{
var id = $(_this).attr('data-id');
$('#comment-id').attr('data-id',id);
$('#DeleteComment').modal('show');
}
function _delete(_this)
{
var id = $(_this).attr('data-id');
console.log("data id is ",id );
$.ajax({
type: "DELETE",
url: "{{url('/')}}/api/Warnings/" + id,
headers: {
'X-CSRF-TOKEN': '{{ csrf_token() }}'
},
success: function (response) {
$('#DeleteEmp').modal('hide');
_getWarning();
// location.reload();
},
error: function (response) {
loader(false);
$('#DeleteEmp').modal('hide');
if (response.status == 500) {
toastr.error("Something went wrong")
} else {
toastr.error(response.responseJSON.message)
}
}
});
}

function _deleteComment(_this)
{
var id = $(_this).attr('data-id');
console.log("data id is ",id );
$.ajax({
type: "DELETE",
url: "{{url('/')}}/api/comment-management/" + id,
headers: {
'X-CSRF-TOKEN': '{{ csrf_token() }}'
},
success: function (response) {
$('#DeleteComment').modal('hide');
_getUserComment();
// location.reload();
},
error: function (response) {
loader(false);
$('#DeleteComment').modal('hide');
if (response.status == 500) {
toastr.error("Something went wrong")
} else {
toastr.error(response.responseJSON.message)
}
}
});
}

function _reject_modal() {
$('#reason').val('');
}


function _approved() {
    var id = "{{ request()->id }}";    
    $.ajax({
        type: "POST",
        url: "{{ url('/api/approved_invite/') }}" + "/" + id, // Correct concatenation
        headers: {
            'X-CSRF-TOKEN': '{{ csrf_token() }}'
        },

        success: function(response) {
            
            window.location.href = "{{ url('/employee-onboarding/create/access/') }}" + "/" + id; // Using id in the redirection
        },
        error: function(response) {
            loader(false);
            if (response.status == 500) {
                toastr.error("Something went wrong");
            } else {
                toastr.error(response.responseJSON.message); // Assuming response has 'message' property
            }
        }
    });
}


function _reject() {
loader(true);

var _FormData = new FormData();
_FormData.append("reason", $('#reason').val());
_FormData.append("emp_id", "{{ request()->id }}");
$.ajax({
type: "POST",
url: "{{ url('/api/rejected') }}",
headers: {
'X-CSRF-TOKEN': '{{ csrf_token() }}'
},
data: _FormData,
processData: false,
contentType: false,
success: function(response) {

toastr.success(response.message);
$('#Reject').modal('hide');
$('.reject-approve-btn').remove();
loader(false);
},
error: function(response) {
loader(false);
if (response.status == 500) {
toastr.error("Something went wrong")
} else {
toastr.error(response.responseJSON.message)
}
}
});
}

function downloadFile(fileUrl) {
// Create an anchor element
var link = document.createElement('a');

// Set the 'href' attribute to the file URL
link.href = fileUrl;

// Set the 'download' attribute to trigger the download
link.download = fileUrl.split('/').pop(); // This will use the file name as the default name

// Append the link to the body (it won't be visible)
document.body.appendChild(link);

// Programmatically click the link to start the download
link.click();

// Remove the link after the click
document.body.removeChild(link);
}

function _reason_modal(text) {
$('.reason_html').html(text);
$('#ReasonModal').modal('show');
}

function formatDateToDMY(dateString) {
const date = new Date(dateString);
// Extract day, month, and year
const day = String(date.getDate()).padStart(2, '0'); // Adds leading zero if day is less than 10
const month = String(date.getMonth() + 1).padStart(2, '0'); // Months are 0-based, so we add 1
const year = String(date.getFullYear()).slice(-4); // Get the last 2 digits of the year
// Return the formatted date in d-m-y format
return `${day}-${month}-${year}`;
}

</script>
<style>
.admin-detail {
display: flex;
}

.profile-btn {
margin-left: 1rem;
}

.employee-detail {
display: flex;
}

@media only screen and (min-width: 280px)and (max-width: 320px) {
.employee-detail {
display: block;
}
}

@media only screen and (min-width: 320px)and (max-width: 425px) {
.profile-btn {
margin-left: 0.5rem;
margin-top: 14px;
}
}

.custom-gradient:hover {
color: #15A7F5;
}

.truncate-50 {
overflow: hidden;
text-overflow: ellipsis;
display: -webkit-box;
-webkit-line-clamp: 2;
/* Number of lines to show */
-webkit-box-orient: vertical;
}

.h-px-850 {
height: 850px;
}

.h-px-1100 {
height: 1100px;
}

@media only screen and (min-width: 768px)and (max-width: 1024px) {
.admin-detail {
display: block;
}
}
</style>
@endsection 