@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-1">
            <div class="card-body mb-2">
                <div class="border-bottom pb-2 ps-1">
                    <div class="h4 pb-0 mb-0 ">Add Pay Roll</div>
                    <small>Dashboard-Pay Roll</small>
                </div>
                <form method="POST" action="{{ route('fine.update', $fine->id) }}">
                    @csrf
                    @method('PUT')
                    <div class="row mt-3">
                        <div class="col-md-4 form-group mb-3">
                            <label for="fine_date" class="text-dark">Select Date<span
                                    class="text-danger">*</span></label>
                            <input type="date" id="fine_date" name="fine_date" class="form-control mt-1"
                                value="{{ $fine->date }}" required>
                        </div>


                        <div class="col-md-4 form-group mb-3">
                            <label for="thumbnail" class="text-dark">Employee<span class="text-danger">*</span></label>
                            <select name="employee_id" id="employee_id" class="form-control mt-1" required>
                                @foreach ($get_employees as $employee)
                                    <option value="{{ $employee->id }}"
                                        {{ $employee->id == $fine->employee_id ? 'selected' : '' }}>
                                        {{ $employee->EmpPersonalDetails->first_name }}
                                        {{ $employee->EmpPersonalDetails->middle_name }}
                                        {{ $employee->EmpPersonalDetails->last_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="fine_amount" class="text-dark">Fine Amount<span class="text-danger">*</span></label>
                            <input type="number" value="{{ $fine->fine_amount }}" name="fine_amount" id="fine_amount"
                                class="form-control mt-1" placeholder="Enter Fine Amount" required min="0"
                                step="0.01">
                        </div>

                        <div class="col-md-4 form-group mb-3">
                            <label for="fine_reason" class="text-dark">
                                Reason<span class="text-danger">*</span>
                            </label>
                            <textarea name="fine_reason"  id="fine_reason" class="form-control mt-1" placeholder="Enter Fine Reason (max 250 characters)" required maxlength="250" >{{ $fine->fine_reason }}</textarea>
                        </div>
                        <div class="col-md-4 form-group mb-3">
                            <label for="type" class="text-dark">Type<span class="text-danger">*</span></label>
                            <select class="type form-select mt-1" id="type" name="type">
                                <option value="">--Select--</option>
                                <option value="1" {{ old('type', $fine->type ?? '') == '1' ? 'selected' : '' }}>Bonus</option>
                                <option value="0" {{ old('type', $fine->type ?? '') == '0' ? 'selected' : '' }}>Fine</option>
                               
                            </select>
                        </div>
                    </div>
                    <div class="mt-3 d-flex justify-content-end">
                        <div class="col-md-12 text-end mt-3">
                            <button type="submit" class="btn btn-primary">Save and Submit</button>
                        </div>
                    </div>
                </form>

            </div>
        </div>
    </div>
@endsection
