@extends('includes/layout')

@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body">
                <div class="d-flex justify-content-between align-items-center">
                    <div>
                        <div class="h4 pb-0 mb-0">Fine/Bonus Management</div>
                        <small>Dashboard - Fine Mnagement</small>
                    </div>
                    <div>
                        @if (in_array('Sites Maintain', Session::get('permissions')))
                            <button class="btn btn-primary" onclick="window.location='{{ route('fine.create') }}'"><span
                                    class="mdi mdi-plus"></span>Add Fine</button>
                        @endif
                    </div>
                </div>
                <form method="GET" action="{{ route('fine.management') }}" class="mt-3">
                    <div class="row">
                        <div class="col-md-3 mb-3">
                            <label>Employee</label>
                            <select class="form-control" name="employee">
                                <option value="">Select Employee</option>
                                @foreach ($get_employees as $employee)
                                    <option value="{{ $employee->id }}"
                                        {{ ($filters['employee'] ?? '') == $employee->id ? 'selected' : '' }}>
                                        {{ $employee->EmpPersonalDetails->first_name }}
                                        {{ $employee->EmpPersonalDetails->middle_name }}
                                        {{ $employee->EmpPersonalDetails->last_name }}
                                    </option>
                                @endforeach
                            </select>
                        </div>


                        <div class="col-md-2 mb-3">
                            <label>Date Range</label>
                            <input type="text" class="form-control" name="date" id="date_range"
                                placeholder="Select Date Range" autocomplete="off" value="{{ $filters['date'] ?? '' }}">
                            <input type="hidden" name="from_date" value="{{ $filters['from_date'] ?? '' }}">
                            <input type="hidden" name="to_date" value="{{ $filters['to_date'] ?? '' }}">
                        </div>
                        <div class="col-md-2 mb-3">
                            <label>Amount</label>
                            <input class="form-control" placeholder="Amount" type="number" name="fine_amount"
                                value="{{ isset($filters['fine_amount']) ? $filters['fine_amount'] : '' }}">
                        </div>
                        <div class="col-md-2 mb-3">
                            <label>Type</label>
                            <select name="type" class="form-control">
                                <option value="">Select Type</option>
                                <option value="1" {{ old('type', $filters['type'] ?? '') == '1' ? 'selected' : '' }}>Bonus</option>
                                <option value="0" {{ old('type', $filters['type'] ?? '') == '0' ? 'selected' : '' }}>Fine</option>
                            </select>                            
                        </div>
                        <div class="col-md-3 text-center" style="margin-top: 23px">
                            <button type="submit" class="btn btn-secondary">Filter</button>
                            <a href="{{ route('fine.management') }}" class="btn btn-danger">Reset</a>
                        </div>
                        
                    </div>
                </form>
                <div class="table-responsive text-nowrap mt-3">
                    <table class="table">
                        <thead class="bg-primary text-white">
                            <tr>
                                <th>Employee</th>
                                <th>Date</th>
                                <th>Amount</th>
                                <th>Reason</th>
                                <th>Type</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse ($fines as $fine)
                                <tr>
                                    <td>{{ $fine->employee ? trim($fine->employee->first_name . ' ' . ($fine->employee->middle_name ?? '') . ' ' . $fine->employee->last_name) : 'N/A' }}
                                    </td>
                                    <td>{{ date('d-m-Y', strtotime($fine->date)) }}</td>
                                    <td>{{ $fine->fine_amount }}</td>
                                    <td class="text-wrap">{{ $fine->fine_reason }}</td>
                                    <td>
                                        <span class="badge {{ $fine->type ? 'bg-success' : 'bg-danger' }}">
                                            {{ $fine->type ? 'Bonus' : 'Fine' }}
                                        </span>
                                    </td>
                                    <td>
                                        <div class="dropdown">
                                            <button class="btn btn-secondary waves-effect waves-light dropdown-toggle card_sec_headr_dropoption2" type="button"
                                                 data-bs-toggle="dropdown" aria-expanded="false">
                                                <i class="mdi mdi-dots-vertical"></i>
                                            </button>
                                            <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton">
                                                <li><a class="dropdown-item"
                                                        href="{{ route('fine.edit', $fine->id) }}">Edit</a></li>
                                                <li>
                                                    <form method="POST" action="{{ route('fine.destroy', $fine->id) }}"
                                                        style="display:inline;">
                                                        @csrf
                                                        @method('DELETE')
                                                        <button type="button" class="dropdown-item"
                                                            onclick="confirmDeletion(event, this)">Delete</button>
                                                    </form>

                                                </li>
                                            </ul>
                                        </div>
                                    </td>

                                </tr>
                            @empty
                                <tr>
                                    <td colspan="8" class="text-center">No Record found.</td>
                                </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $fines->appends(request()->query())->links() }}
                </div>
            </div>
        </div>
    </div>
@endsection
@section('css-js')
    <script>
        $(document).ready(function() {
            // Initialize date range picker
            $('input[name="date"]').daterangepicker({
                locale: {
                    format: 'DD-MM-YYYY',
                    separator: ' / '
                },
                autoUpdateInput: false
            });

            // Handle date range picker events
            $('input[name="date"]').on('apply.daterangepicker', function(ev, picker) {
                $(this).val(picker.startDate.format('DD-MM-YYYY') + ' / ' + picker.endDate.format('DD-MM-YYYY'));
                
                // Update hidden fields
                $('input[name="from_date"]').val(picker.startDate.format('YYYY-MM-DD'));
                $('input[name="to_date"]').val(picker.endDate.format('YYYY-MM-DD'));
            });

            $('input[name="date"]').on('cancel.daterangepicker', function(ev, picker) {
                $(this).val('');
                $('input[name="from_date"]').val('');
                $('input[name="to_date"]').val('');
            });

            // Set initial value if exists
            @if(isset($filters['from_date']) && isset($filters['to_date']) && $filters['from_date'] && $filters['to_date'])
                var fromDate = '{{ \Carbon\Carbon::parse($filters["from_date"])->format("d-m-Y") }}';
                var toDate = '{{ \Carbon\Carbon::parse($filters["to_date"])->format("d-m-Y") }}';
                $('input[name="date"]').val(fromDate + ' / ' + toDate);
            @endif
        });

        function confirmDeletion(event, element) {
            event.preventDefault(); // Prevent the default form submission on button click

            Swal.fire({
                title: 'Are you sure?',
                text: "You won't be able to revert this!",
                icon: 'warning',
                showCancelButton: true,
                confirmButtonColor: '#3085d6',
                cancelButtonColor: '#d33',
                confirmButtonText: 'Yes, delete it!'
            }).then((result) => {
                if (result.isConfirmed) {
                    // If the user confirms, submit the form programmatically
                    element.closest('form').submit(); // Corrected this line
                }
            });
        }
    </script>
@endsection
