<!DOCTYPE html>
@php
    use App\General\SettingsClass;
    use Illuminate\Support\Facades\Route;

    $settings_ = DB::table('settings')->get();
    $webLogo_ = SettingsClass::getOptionValue('_web_logo', $settings_);

@endphp
<html lang="en" class="light-style layout-menu-fixed layout-compact" dir="ltr" data-theme="theme-default"
    data-assets-path="{{ url('/') }}/assets/" data-template="vertical-menu-template-free">

<head>
    <meta charset="utf-8" />
    <meta name="viewport"
        content="width=device-width, initial-scale=1.0, user-scalable=no, minimum-scale=1.0, maximum-scale=1.0" />
    <title>{{ env('APP_NAME') }}</title>
    <meta name="description" content="" />
    <!-- Favicon -->
    <link rel="icon" type="image/x-icon" href="{{ url($webLogo_) }}" />
    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com" />
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin />
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&ampdisplay=swap"
        rel="stylesheet" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/fonts/materialdesignicons.css" />
    <!-- Menu waves for no-customizer fix -->
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/node-waves/node-waves.css" />
    <!-- Core CSS -->
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/css/core.css" class="template-customizer-core-css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/css/theme-default.css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/css/demo.css" />
    <!-- Vendors CSS -->
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.css" />
    <link rel="stylesheet" href="{{ url('/') }}/assets/vendor/libs/apex-charts/apex-charts.css" />
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />
    <!-- Page CSS -->
    <!-- Helpers -->
    <script src="{{ url('/') }}/assets/vendor/js/helpers.js"></script>

    <script src="{{ url('/') }}/assets/js/config.js"></script>
    <link href='https://fonts.googleapis.com/css?family=Poppins' rel='stylesheet'>
</head>
<style>
    .body {
        font-family: Poppins !important;
    }

    .authentication-wrapper .authentication-image-model {
        width: 768px;
    }

    .authentication-wrapper.authentication-cover .authentication-inner {
        min-height: 100vh;
        position: relative;
    }

    .authentication-wrapper .authentication-inner {
        width: 100%;
    }

    .authentication-wrapper.authentication-cover .authentication-image-tree {
        position: absolute;
        bottom: 3rem;
        left: 3rem;
    }

    .authentication-wrapper.authentication-cover .authentication-image {
        inset-inline-start: unset;
    }

    .authentication-wrapper .authentication-image {
        z-index: -1;
        inline-size: 100%;
        position: absolute;
        inset-inline-start: 0;
        bottom: 0;
    }

    .light-style .authentication-wrapper .authentication-bg {
        background-color: #fff;
    }

    @media (max-width: 1199.98px) {
        .authentication-cover .authentication-image-model {
            position: relative;
            width: 575px;
            top: 6rem;
        }
    }

    .full_loader {
        background: url('/loader.gif');
        background-repeat: no-repeat;
        background-attachment: fixed;
        background-position: center;
        background-size: 50px;
        z-index: 1000;
        position: absolute;
        min-width: 100vw;
        min-height: 100vh;
        overflow: hidden;
        max-width: 100vw;
        max-height: 100vh;
        background-color: white;
    }

    .user-form h4 {
        font-size: 32px;
        font-weight: 500;
        line-height: 48px;
        letter-spacing: 0em;
        color: #000000B2;
    }

    .form-control {
        border: 1px solid #C4C4C5;
        border-radius: 4px;
    }

    .text-area .form-control {
        height: 181.75px;
    }

    .icon {
        color: #FF0909;
    }

    .text {
        font-weight: 700
    }
</style>

<body>
    <div class="full_loader "></div>
    <div class="authentication-wrapper authentication-cover">
        <!-- Logo -->
        <a href="{{url('/')}}" class="auth-cover-brand d-flex align-items-center gap-2">
            <span class="app-brand-logo demo" style="background-color: #1aa9f5">
                <span style="color:var(--bs-primary);">

                    <img src="{{ url($webLogo_) }}" width="200" height="70">
                </span>
            </span>
            {{-- <span class="app-brand-text demo text-heading fw-semibold">{{env("APP_NAME")}}</span> --}}
        </a>
        <!-- /Logo -->
        <div class="authentication-inner row m-0">
            <!-- /Left Section -->
            <div class="d-none d-lg-flex col-lg-7 col-xl-8 align-items-center justify-content-center p-5 pb-2">
                <div>
                    <img src="{{ url('/') }}/assets/img/illustrations/auth-cover-login.png" class="authentication-image-model d-none d-lg-block bb" alt="auth-model">
                </div>
            </div>
          
            <div
                class="d-flex col-12 col-lg-5 col-xl-4 align-items-center authentication-bg position-relative py-sm-5 px-4 py-4">
                <div class="user-form w-px-400 mx-auto pt-5 pt-lg-0">
                    <h4 class="mb-3">JOIN MEETING</h4>
                    <p class="mb-1">You are joining : <span class="text"> {{ $meeting->agenda }}</span></p>
                    <p class="mb-4">
                      Meeting Date: <span class="text">Date of the Meeting ({{ formatDate($guest_meeting_date) }})</span>
                    </p>

                    <form method="POST" id="add_guest_user_page_form" class="mb-3 fv-plugins-bootstrap5 fv-plugins-framework" novalidate="novalidate">
                        <input type="hidden" name="meeting_id" value="{{$meeting->id}}">
                        <input type="hidden" name="meeting_date" value="{{$guest_meeting_date}}">
                        
                        <label for="Name">Name</label> <span class="icon">*</span>
                        <div class="form-floating form-floating-outline mb-3 fv-plugins-icon-container">
                            <input type="text" class="form-control" id="name" name="name" placeholder="Enter your name">
                        </div>

                        <label for="email">Email</label> <span class="icon">*</span>
                        <div class="form-floating form-floating-outline mb-3 fv-plugins-icon-container">
                            <input type="text" class="form-control" id="email" name="email" placeholder="Enter your email">
                        </div>

                        <label for="phone-no">Phone Number</label> <span class="icon">*</span>
                        <div class="form-floating form-floating-outline mb-3 fv-plugins-icon-container">
                            <input type="text" class="form-control" id="phone-no"  name="phone_number" placeholder="Enter your phone-no">
                        </div>

                        <label for="occupation">Occupation</label> <span class="icon">*</span>
                        <div class="form-floating form-floating-outline mb-3 fv-plugins-icon-container">
                            <input type="text" class="form-control" id="occupation" name="occupation" placeholder="Enter your occupation">
                        </div>

                        <label for="details">Details (Optional)</label>
                        <div class="text-area form-floating form-floating-outline mb-3 fv-plugins-icon-container">
                            <textarea class="form-control" id="details" rows="3" name="details"></textarea>
                        </div>
                        <div class="mt-4 d-flex justify-content-end">
                            <button class="btn btn-primary d-grid w-24 waves-effect waves-light" type="submit">
                                Save
                            </button>
                        </div>
                    </form>
                </div>
            </div>
            <!-- /Login -->
        </div>
    </div>


    <script src="{{ url('/') }}/assets/vendor/libs/jquery/jquery.js"></script>
    <script src="{{ url('/') }}/assets/vendor/libs/popper/popper.js"></script>
    <script src="{{ url('/') }}/assets/vendor/js/bootstrap.js"></script>
    <script src="{{ url('/') }}/assets/vendor/libs/node-waves/node-waves.js"></script>
    <script src="{{ url('/') }}/assets/vendor/libs/perfect-scrollbar/perfect-scrollbar.js"></script>
    <script src="{{ url('/') }}/assets/vendor/js/menu.js"></script>
    <!-- endbuild -->
    <!-- Vendors JS -->
    <script src="{{ url('/') }}/assets/vendor/libs/apex-charts/apexcharts.js"></script>
    <!-- Main JS -->
    <script src="{{ url('/') }}/assets/js/main.js"></script>
    <!-- Page JS -->
    <script src="{{ url('/') }}/assets/js/dashboards-analytics.js"></script>
    <!-- Place this tag in your head or just before your close body tag. -->
    <script async defer src="https://buttons.github.io/buttons.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>


    <script>
      // Check if 'Remember Me' checkbox is checked and fill in the credentials
      $(document).ready(function () {
          $('.full_loader').addClass('d-none');
          if (localStorage.getItem('rememberMe') === 'true') {
              $('#remember-me').prop('checked', true);
              $('.remember_email').val(localStorage.getItem('email'));
              $('.remember_password').val(localStorage.getItem('password'));
          }
      });

      function loader(show) {
        if (show) {
            $('.full_loader').removeClass('d-none');
        } else {
            $('.full_loader').addClass('d-none');
        }
      }
      $('#add_guest_user_page_form').submit(function(e) {
        e.preventDefault();
        var formData = new FormData(this);

        $.ajax({
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            type: "POST",
            url: "{{ url('/guest/add') }}",
            data: formData,
            contentType: false,
            processData: false,
            success: function(response) {
                toastr.success(response.message);
                // var meeting_id = response.data.meeting_id;
                window.location.href = "{{ url('/guest/success') }}" ;
            },
            error: function(response) {
                if (response.status == 422) {
                    var error = response.responseJSON.message;
                    toastr.error(error);
                } else if (response.status == 500) {
                    toastr.error("Something went wrong");
                } else {
                    toastr.error(response.responseJSON.message);
                }
            }
        });

      });
    </script>
</body>

</html>
