@extends('includes/layout')
@section('main-page-content')
    <style>
        .bg-primary th {
            color: white;
        }

        .btn-color {
            background-color: #1A2D4D !important;
        }

        .hearder-color {
            background-color: #1A2D4D !important;
        }
    </style>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body p-0">
                <div class="public-details py-3 px-3 justify-content-between align-items-center">
                    <div class="me-auto">
                        <div class="h4 pb-0 mb-0">Public Holiday</div>
                        <small>Leave Management / Public Holidays</small>
                    </div>
                    <div class="search-detail justify-content-end align-items-center">
                        <div class="p-0 pt-3 pt-md-0 p-md-1 p-lg-2 align-items-center ">
                            <label class="pe-2">Search:</label>
                            <input type="text" class="form-control" id="search_data">
                        </div>
                        <div class="pt-3 pt-md-0 mt-4  text-start">
                            @if (in_array('Public Holiday Maintain', Session::get('permissions')))
                                <button class="btn btn-primary px-3" data-bs-toggle="modal"
                                    data-bs-target="#publicholiday"><span class="mdi mdi-plus"></span>Add Holiday</button>
                            @endif
                        </div>

                    </div>
                </div>
                <div>
                    <div class="table-responsive text-nowrap border-bottom">
                        <table class="table">
                            <thead class="table-head-color bg-primary">
                                <tr class="bg-primary">
                                    <th style="width: 10%;">S/N</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th>Start Date</th>
                                    <th>End Date</th>
                                    <th style="width: 10%;">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0 table-body">

                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-3">
                        <ul class="pagination justify-content-end pages_btn">

                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>



    <div class="modal fade" id="publicholiday" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header hearder-color p-2">
                    <h5 class="modal-title text-white text-center ps-3" id="exampleModalLabel">Add New Holiday</h5>
                </div>
                <form id="public-holiday-form" action="" method="">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label>Holiday Name<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="holiday_name" required>
                            </div>
                                <div class="col-6 mb-3">
                                <label>Start Date<span class="text-danger">*</span></label>
                                <input type="date" class="form-control" name="start_date" required>
                            </div>
                            <div class="col-6 mb-3">
                                <label>End Date<span class="text-danger">*</span></label>
                                <input type="date" class="form-control" name="end_date" required>
                            </div>
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="meeting_desc" class="form-label">Description<span
                                            class="text-danger">*</span></label>
                                    <textarea class="form-control" id="meeting_desc" rows="3" name="description" required></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer border-top p-2">
                        <button type="button" class="btn btn-outline-light text-black"
                            data-bs-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-color text-white"
                            onclick="public_holiday_store();">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="editpublicholiday" tabindex="-1" aria-labelledby="editexampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header hearder-color p-2">
                    <h5 class="modal-title text-white text-center ps-3" id="editexampleModalLabel">Edit Holiday</h5>
                </div>
                <form id="update-public-holiday-form" action="" method="">
                    <div class="modal-body">
                        <input type="hidden" id="holidayId" value="">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label>Holiday Name<span class="text-danger">*</span></label>
                                <input type="text" class="form-control edit-title" name="holiday_name" required>
                            </div>
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="meeting_desc" class="form-label">Description<span
                                            class="text-danger">*</span></label>
                                    <textarea class="form-control edit-description" id="meeting_desc" rows="3" name="description" required></textarea>
                                </div>
                            </div>
                            <div class="col-6 mb-3">
                                <label>Start Date<span class="text-danger">*</span></label>
                                <input type="date" class="form-control edit-from" name="start_date" required>
                            </div>
                            <div class="col-6 mb-3">
                                <label>End Date<span class="text-danger">*</span></label>
                                <input type="date" class="form-control edit-to" name="end_date" required>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer border-top p-2">
                        <button type="button" class="btn btn-outline-light text-black"
                            data-bs-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-color text-white"
                            onclick="public_holiday_update();">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!--detail Modal -->
    <div class="modal fade" id="holiday-desc-modal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header hearder-color p-2">
                    <h5 class="modal-title text-white text-center ps-3" id="exampleModalLabel">Description</h5>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="holidayId">
                    <div class="row">
                        <div class="col-12">
                            <div class="mb-3">
                                <textarea class="form-control" id="holiday_desc" rows="5" disabled name="description"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>


    <div class="modal fade" id="DeleteEmp" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this record?<br><br>
                    <b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you
                    genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger" id="leave-holiday-id" data-id=""
                        onclick="_delete(this)">Delete</button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('css-js')
    <script>
        $(document).ready(function() {
            $("#search_data").on("keyup", function() {
                var searchText = $(this).val().toLowerCase();
                var $tableRows = $(".table-body tr");
                $tableRows.hide();
                $tableRows.filter(function() {
                    return $(this).text().toLowerCase().indexOf(searchText) > -1;
                }).show();
                if ($tableRows.filter(":visible").length === 0) {
                    $(".table-body").append(
                        '<tr><td colspan="8" class="text-center">Records Not found</td></tr>');
                } else {
                    $(".table-body tr:contains('Records Not found')").remove();
                }
            });
        });
    </script>
    <script>
        function formatDate(dateString) {
            // Assuming dateString is in the format "yyyy-mm-dd"
            const parts = dateString.split('-');
            const formattedDate = `${parts[2]}-${parts[1]}-${parts[0]}`;
            return formattedDate;
        }
    </script>
    <script>
        $(document).ready(function() {
            _filter(0);
            _get(0);

        });

        function _filter(filter_on) {

            var collection = document.getElementsByClassName("filter");
            var arr = {};

            for (let i = 0; i < collection.length; i++) {
                arr[collection[i].name] = filter_on == 1 ? collection[i].value : '';
            }

            if (filter_on == 0) {
                $('.filter').val('');
            }

            localStorage.setItem('filter', JSON.stringify(arr));

        }

        function _get(from) {
            // loader(true);

            $.ajax({
                type: "GET",
                url: `{{ url('/api/public-holiday') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                // success: function (response){},
                success: function(response) {
                    var holidays = response.data.holidays;
                    console.log(holidays);
                    var html = ``;
                    var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count) / 10;
                    count = Math.ceil(count);
                    var pages_btn = ``;

                    pages_btn += `
                            <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                    </li>
                                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                        </li>`;

                    $('.p-btn').removeClass('active');

                    var c = 0;
                    for (c = 0; c < count; c++) {
                        if (
                            (from == (c - 3) * 10) ||
                            (from == (c - 2) * 10) ||
                            (from == (c - 1) * 10) ||
                            (from == (c - 0) * 10) ||
                            (from == (c + 1) * 10) ||
                            (from == (c + 2) * 10) ||
                            (from == (c + 3) * 10)
                        ) {
                            pages_btn += `
                                    <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*10});">
                                    <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                    </li>
                                    `;
                        }

                    }

                    pages_btn += `

                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                    </li>
                    <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*10});" >
                            <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                    </li>
                    `;


                    $('.pages_btn').html(pages_btn);



                    for (var i = 0; i < holidays.length; i++) {

                        var holidaycount = i + 1;

                        html += `
                        <tr>
                            <td><span class="fw-medium">${holidaycount}</span></td>
                            <td>${holidays[i].title}</td>
                            <td class="cursor-pointer" data-bs-toggle="modal" data-bs-target="#holiday-desc-modal" onclick="_detail(${holidays[i]?.id})">${holidays[i].description.length > 50 ? `${holidays[i].description.slice(0, 50)}...` : holidays[i].description}</td>
                            <td>${formatDate(holidays[i].from)}</td>
                            <td>${formatDate(holidays[i].to)}</td>
                            <!-- Add other columns as needed -->


                                <td>
                              @if (in_array('Public Holiday Maintain', Session::get('permissions')))
                                <div class="dropdown cursor-pointer d-flex justify-content-center">
                                <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>
                                <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                                <li><a class="dropdown-item py-1 ps-2"  data-id="${holidays[i].id}"  onclick="_edit(${holidays[i]?.id});"data-bs-toggle="modal" data-bs-target="#editpublicholiday"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                                <li><a class="dropdown-item py-1 ps-2"  data-id="${holidays[i].id}" onclick="_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                                </ul>
                                </div>
                              @endif
                            </td>
                        </tr>`;
                    }
                    // onclick="_delete(${holidays[i]?.id});"
                    $('.table-body').html(html);

                    if (html == ``) {
                        $('.table-body').html(
                            `<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                    }

                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }



        function public_holiday_store() {
            var formData = $('#public-holiday-form').serialize();

            $.ajax({
                url: '{{ url('/') }}/api/public-holiday',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: 'POST',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    // toastr.success(response.message);
                    $('#publicholiday').modal('hide');
                    window.location.reload();
                    console.log(response);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }


        function capitalizeFirstLetter(string) {
            return string.charAt(0).toUpperCase() + string.slice(1);
        }


        function _edit(id) {
            $.ajax({
                type: "GET",
                url: "{{ url('/') }}/api/public-holiday/" + id + "/edit",
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(data) {
                    console.log(data);
                    var holidayData = data[0];

                    var fromDate = new Date(holidayData.from);
                    var toDate = new Date(holidayData.to);
                    // Populate the modal with the retrieved data
                    $('.edit-title').val(holidayData.title);
                    $('.edit-description').val(holidayData.description);
                    $('#holidayId').val(holidayData.id);
                    $('.edit-from').val(fromDate.toISOString().split('T')[0]); // Format to "yyyy-MM-dd"
                    $('.edit-to').val(toDate.toISOString().split('T')[0]);
                },
                error: function(error) {
                    console.error("Error:", error);
                    toastr.error("Error fetching data");
                }
            });

        }

        function public_holiday_update() {
            var formData = $('#update-public-holiday-form').serialize();
            var holidayId = $('#holidayId').val();
            $.ajax({
                url: '{{ url('/') }}/api/public-holiday/' + holidayId,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                type: 'PUT',
                data: formData,
                dataType: 'json',
                success: function(response) {
                    // toastr.success(response.message);
                    $('#editpublicholiday').modal('hide');
                    window.location.reload();
                    console.log(response);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }

        function _delete_modal(_this) {
            var id = $(_this).attr('data-id');
            $('#leave-holiday-id').attr('data-id', id);
            $('#DeleteEmp').modal('show');
        }

        function _delete(_this) {
            var id = $(_this).attr('data-id');
            $.ajax({
                type: "DELETE",
                url: "{{ url('/') }}/api/public-holiday/" + id,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    // toastr.success(response.message);
                    location.reload();
                },
                error: function(error) {
                    console.error("Error:", error);
                    toastr.error("Failed to delete Public Holiday");
                }
            });
        }



        function _detail(id) {
            $.ajax({
                type: 'GET',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                url: '{{ url('/') }}/api/holiday-desc/' + id,
                success: function(data) {
                    $('#holiday_desc').text(data.data.description);

                },
                error: function(error) {
                    console.error('Error fetching data:', error);
                }
            });
        }
    </script>


    <style>
        .public-details {
            display: flex;
        }

        .search-detail {
            display: flex;
        }

        @media only screen and (min-width: 320px)and (max-width: 425px) {
            .public-details {
                display: block;
            }

            .search-detail {
                display: block;
            }
        }
    </style>
@endsection
