@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4 ">
            <div class="border-bottom p-3">
                <div class="h4 pb-0 mb-0 ">Leave Request</div>
                <small>Dashboard-Leave Management-Leave Request</small>
            </div>
            <form id="leave-request-form">
                <input type="hidden" name="full_day" value="0">
                <input type="hidden" name="start_time" value="">
                <input type="hidden" name="end_time" value="">
            <div class="row p-3">
                <div class="col-6 ">
                    <div class="mb-3">
                        <label>Employee<span class="text-danger">*</span></label>
                        <select class="form-select" aria-label="Default select example" name="employee" onchange="emp_id(this.value)">
                            <option value="">--select--</option>
                            @foreach($emp_details as $emp_detail)
                            @if ($emp_detail->EmpPersonalDetails)
                            <option value="{{$emp_detail->id}}">
                                {{$emp_detail->EmpPersonalDetails->first_name}}
                                {{$emp_detail->EmpPersonalDetails->middle_name}}
                                {{$emp_detail->EmpPersonalDetails->last_name}}
                            </option>
                        @endif
                        @endforeach
                        </select>
                        
                    </div>
                    
                </div>
                <div class="col-6 mb-3">
                    <div class="mb-3">
                        <label>Leave Package<span class="text-danger">*</span></label>
                  
                    <select class="form-select" aria-label="Default select example" name="leave_package" id="leavePackageSelect">
                            <option value=""  >Select an option</option>
                                @foreach($leave_packages as $leave_package)
                                    <option value="{{$leave_package->id}}">{{$leave_package->title}}</option>
                                @endforeach
                            </select>

                    </div>
                </div>
                
                <div class="col-6">
                    <div class="mb-3">
                        <label>Start Date<span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="start-date" name="start_date" value="">
                    </div>
                </div>
                <div class="col-6">
                    <div class="mb-3">
                        <label>End Date<span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="end-date" name="end_date" value="">
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="mb-3">
                        <label for="leave-reason" class="form-label">Reason<span class="text-danger">*</span></label>
                        <textarea class="form-control" id="leave-reason" rows="3" name="reason"></textarea>
                    </div>
                </div>
            </div>
            <div class="border-top p-3 d-flex justify-content-end">
                <button type="button" class="btn btn-outline-light text-dark me-2" onclick="window.location='{{ url('/') }}/leave-request'">CANCEL</button>
                <button type="button" class="btn btn-primary waves-effect" onclick="leave_request_store();">SAVE</button>
            </div>
        </form>
        </div>
    </div>
@endsection
@section('css-js')

<script>
    $(document).ready(function() {
        $('#clearButton').click(function() {
            $('#leave-request-form')[0].reset();
        });
    });
</script>
<script>
    function leave_request_store()
    {
        var formData = $('#leave-request-form').serialize();
        
        $.ajax({
            url: "{{ url('api/leave-request-store') }}",
            type: 'POST',
            data: formData,
            dataType: 'json',
            headers: {
            'X-CSRF-TOKEN': '{{csrf_token()}}'
        },
            success: function(response) {
                toastr.success(response.message);
                
                window.location.href = "{{ url('/') }}/leave-request";
            },
            error: function(response) {
                if (response.status == 500) {
                        toastr.error("Something went wrong")
                    }
                    else
                    {
                        toastr.error(response.responseJSON.message)
                    }
                }
        });
    }

    function leave_pkg(id) {
    $.ajax({
        url: '{{ url("api/leave-count") }}/' + id,
        method: 'POST',
        dataType: 'json',
        success: function(response) {
            $('#remain_leave').text('Your Remaining leave for ' + response.title_leave + ': ' + response.remaining_leave);
            console.log(response.remaining_leave);
        },
        error: function(xhr, status, error) {
            console.error(error);
        }
    });
}


function emp_id(id) {
    $.ajax({
        url: '{{url("api/employee-pkg") }}/' + id,
        headers: {
                'X-CSRF-TOKEN': '{{csrf_token()}}'
            },
        method: 'POST',
        dataType: 'json',
        success: function(response) {
            console.log("response:",response);

            if (Array.isArray(response.all_packages) && response.all_packages.length > 0) {
                var selectElement = $('#leavePackageSelect');
                selectElement.empty();

                

                response.all_packages.forEach(function(package) {
                    selectElement.append('<option value="' + package.id + '">' + package.title + '</option>');
                });
            } else {
                var selectElement = $('#leavePackageSelect');
                selectElement.empty();
                selectElement.append('<option value="">--select--</option>');
            }
        },
        error: function(xhr, status, error) {
            console.error(error);
        }
    });
}


</script>
@endsection
