@extends('includes/layout')
@section('main-page-content')
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4 ">
            <div class="border-bottom p-3">
                <div class="h4 pb-0 mb-0 ">Edit Leave Request</div>
                <small>Dashboard-Leave Management-Edit Leave Request</small>
            </div>
            <form id="leave-request-update-form">
            <div class="row p-3">
                <input type="hidden" name="full_day" value="{{$leaverquest->full_day}}" >
                <input type="hidden" name="start_time" value="{{$leaverquest->start_time}}">
                <input type="hidden" name="end_time" value="{{$leaverquest->end_time}}">
                <input type="hidden" value="{{$leaverquest->id}}" id="leave_request_id">
                <div class="col-6 ">
                    <div class="mb-3">
                        <label>Employee<span class="text-danger">*</span></label>
                        <select class="form-select" aria-label="Default select example" name="employee" onchange="emp_id(this.value)">
                            <option value="">--select--</option>
                            @foreach($emp_details as $emp_detail)
                            @if ($emp_detail->EmpPersonalDetails)
                            <option value="{{$emp_detail->id}}"  {{$leaverquest->employee_id == $emp_detail->id ? 'selected' : ''}}>
                                {{$emp_detail->EmpPersonalDetails->first_name}}
                                {{$emp_detail->EmpPersonalDetails->middle_name}}
                                {{$emp_detail->EmpPersonalDetails->last_name}}
                            </option>
                        @endif
                        @endforeach
                        </select>
                    </div>
                </div>
                <div class="col-6 mb-3">
                    <div class="mb-3">
                        <label>Leave Package<span class="text-danger">*</span></label>
                        <select class="form-select" aria-label="Default select example" name="leave_package" id="leavePackageSelect">
                            <option value="">--select--</option>
                            {{-- @foreach($leave_packages as $leave_package)
                                <option value="{{$leave_package->id}}" {{$leaverquest->leave_package_id == $leave_package->id ? 'selected' : ''}}>{{$leave_package->title}}</option>
                            @endforeach --}}
                        </select>
                        
                    </div>
                </div>
                <div class="col-6">
                    <div class="mb-3">
                        <label>Start Date<span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="start-date" name="start_date" value="{{ \Carbon\Carbon::parse($leaverquest->from)->format('Y-m-d') }}">
                    </div>
                </div>
                <div class="col-6">
                    <div class="mb-3">
                        <label>End Date<span class="text-danger">*</span></label>
                        <input type="date" class="form-control" id="end-date" name="end_date" value="{{ \Carbon\Carbon::parse($leaverquest->to)->format('Y-m-d') }}">
                    </div>
                </div>
                <div class="col-lg-12">
                    <div class="mb-3">
                        <label for="leave-reason" class="form-label">Reason<span class="text-danger">*</span></label>
                        <textarea class="form-control" id="leave-reason" rows="3" name="reason" >{{$leaverquest->reason}}</textarea>
                    </div>
                </div>
            </div>
            <div class="border-top p-3 d-flex justify-content-end">
                <button type="button" class="btn btn-outline-light text-dark me-2" onclick="window.location='{{ url('/') }}/leave-request'">CANCEL</button>
                <button type="button" class="btn btn-primary waves-effect" onclick="leave_request_update();">SAVE</button>
            </div>
        </form>
        </div>
    </div>
@endsection
@section('css-js')
<script>
    
    function leave_request_update()
    {
        var formData = $('#leave-request-update-form').serialize();
        var lrequestId = $('#leave_request_id').val();
        $.ajax({
            url: "{{ url('api/leave-request-update') }}/" + lrequestId,
            type: 'POST',
            data: formData,
            dataType: 'json',
            headers: {
            'X-CSRF-TOKEN': '{{csrf_token()}}'
        },
            success: function(response) {
                // toastr.success(response.message);
                window.location.href = "{{ url('/') }}/leave-request";
            },
            error: function(response) {
                    if (response.status == 422) {
                        // var errors = response.responseJSON.data;                    
                        // $.each(errors, function(field, messages) {
                        //     error_msg = messages[0]; 
                        //     toastr.error(error_msg);
                        // });
                        var error_msg = response.responseJSON.message;
                        toastr.error(error_msg);
                    }
                    else 
                    if (response.status == 500) {
                        toastr.error("Something went wrong")
                    }
                    else
                    {
                        toastr.error(response.responseJSON.message)
                    }
                }
        });
    }
    
    $(document).ready(function() {
        var selectedEmployeeId = "{{$leaverquest->employee_id }}";
        emp_id(selectedEmployeeId);
    });

    function emp_id(id) {
        var selectedpkg = "{{$leaverquest->leave_package_id}}";
        $.ajax({
            url: '{{ url("api/employee-pkg") }}/' + id,
            method: 'POST',
            dataType: 'json',
            headers: {
                'X-CSRF-TOKEN': '{{csrf_token()}}'
            },
            success: function(response) {
                console.log(response);

                if (Array.isArray(response.all_packages) && response.all_packages.length > 0) {
                    var selectElement = $('#leavePackageSelect');
                    selectElement.empty();

                    

                    response.all_packages.forEach(function(package) {
                        selectElement.append('<option value="' + package.id + '">' + package.title + '</option>');
                        if (package.id == selectedpkg) {
                            selectElement.val(package.id); // Set the selected option
                        }
                    });
                } else {
                    var selectElement = $('#leavePackageSelect');
                    selectElement.empty();
                    selectElement.append('<option value="">No leave packages assigned</option>');
                }
            },
            error: function(xhr, status, error) {
                console.error(error);
            }
        });
    }

</script>
@endsection
