@extends('includes/layout')
@section('main-page-content')
    <style>
        .bg-primary th {
            color: white;
        }

        .btn-color {
            background-color: #019FF3 !important;
        }

        .hearder-color {
            background-color: #019FF3 !important;
        }
        @media (max-width: 768px) {
        .full_loader
        {
        min-width:5vw !important;
        }
        }
        .full_loader
        {
            background: url('/loader.gif');
            background-repeat: no-repeat;
            background-attachment: fixed;
            background-position: center;
            background-size: 50px;
            z-index: 1000;
            position: absolute;
            min-width: 100vw;
            min-height: 100vh;
            overflow: hidden;
            max-width: 100vw;
            max-height: 100vh;
            background-color: white;
        }
    </style>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body p-0">
                <div class="leave-types py-3 px-3 justify-content-between align-items-center">
                    <div class="me-auto">
                        <div class="h4 pb-0 mb-0">Leave Request</div>
                        <small>Leave Management / Leave Request</small>
                    </div>
                    <div class="leave-group-btn justify-content-end align-items-center">
                        <button class="btn btn-warning px-3 me-2 mt-2" id="approveSelectedBtn" onclick="approveSelectedLeaveRequests()" style="display: none;">
                            <span class="mdi mdi-check"></span> Approve Selected
                        </button>
                        <div class="p-2 pt-3">
                        @if(in_array('Leave Request Maintain',Session::get('permissions')))
                            <button class="btn btn-primary px-3"  onclick="window.location='{{route('leave-request.create') }}'"><span class="mdi mdi-plus"></span>Add Leave Request</button>
                       @endif
                        </div>

                    </div>
                </div>
                <div>
                    <div class="table-responsive text-nowrap border-bottom">
                        <table class="table">
                            <thead class="table-head-color bg-primary">
                                <tr>
                                    <th style="width: 5%;">
                                        <input type="checkbox" style="width: 20px; height: 20px;" id="selectAllCheckbox" class="form-check-input">
                                    </th>
                                    <th style="width: 10%;font-size: 14px;align-content: center;">
                                        S/N
                                    </th>
                                    <th >
                                        <input type="text" class="filter form-control" name="first_name"
                                            placeholder="Employee"  autocomplete="off">
                                        <input type="text" style="display:none" name="fake-first_name" autocomplete="off">
                                    </th>
                                    <th >
                                        <select class="filter select-color" name="leave_package_id" >
                                            @php $LeavePackages = DB::table('leave_packages')->get(); @endphp
                                            <option value="" >Leave Package</option>
                                            @foreach($LeavePackages as $LeavePackage)
                                            <option value="{{$LeavePackage->id}}">{{$LeavePackage->title}}</option>
                                            @endforeach
                                        </select>
                                    </th>
                                    <th >
                                        <input type="text" class="filter form-control" name="from"
                                            placeholder="Start Date"  autocomplete="off">
                                        <input type="text" style="display:none" name="fake-from" autocomplete="off">
                                    </th>
                                    <th >
                                        <input type="text" class="filter form-control" name="to"
                                            placeholder="End Date"  autocomplete="off">
                                        <input type="text" style="display:none" name="fake-to" autocomplete="off">
                                    </th>
                                    <th >
                                        <select class="filter select-color" name="status" >
                                            <option value="">Status</option>
                                            <option value="0">Pending</option>
                                            <option value="1">Approved</option>
                                            <option value="2">Rejected</option>
                                            <option value="3">Expired</option>
                                        </select>
                                    </th>
                                    <th style="width: 10%;" class="text-center">
                                        <div style="margin-top:6px;display:block;">
                                            <button class="btn btn-success btn-sm p-2 waves-effect waves-light filter-btn"
                                                onclick="_filter(1); _get(0);">submit</button>
                                            <button
                                                class="btn btn-danger btn-sm p-2 waves-effect waves-light filter-btn-close"
                                                onclick="_filter(0);  _get(0);">x</button>
                                        </div>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0 table-body">

                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-3">
                        <ul class="pagination justify-content-end pages_btn">

                    </nav>
                </div>
            </div>
        </div>
    </div>

  <!-- Modal -->
  <div class="modal fade" id="leave_reason" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header border-bottom bg-primary p-2">
          <h5 class="modal-title text-white ms-3" id="exampleModalLabel">Reason </h5>
        </div>
        <div class="modal-body">
            <div class="mb-3">
                <p class="p-3 border rounded" disabled id="leave_concern"></p>
            </div>
        </div>
      </div>
    </div>
  </div>


  <div class="modal fade" id="DeleteEmp" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header bg-danger px-4 py-2">
          <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
        </div>
        <div class="modal-body">
          Are you sure you want to delete this record?<br><br>
          <b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you genuinely want to delete it before clicking the delete button.
        </div>
        <div class="modal-footer border-top py-2">
          <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
          <button type="button" class="btn btn-danger" id="leave-request-id" data- onclick="_delete(this)">Delete</button>
        </div>
      </div>
    </div>
</div>
@endsection
@section('css-js')
<script>
 $(document).ready(function() {
    $('.full_loader').addClass('d-none');
    function loader(show) {
      if (show) {
          $('.full_loader').removeClass('d-none');
      } else {
          $('.full_loader').addClass('d-none');
      }
  }
});
$(document).ready(function () {
        $("#search_data").on("keyup", function () {
            var searchText = $(this).val().toLowerCase();
            var $tableRows = $(".table-body tr");
            $tableRows.hide();
            $tableRows.filter(function () {
                return $(this).text().toLowerCase().indexOf(searchText) > -1;
            }).show();
            if ($tableRows.filter(":visible").length === 0) {
                $(".table-body").append('<tr><td colspan="8" class="text-center">Records Not found</td></tr>');
            } else {
                $(".table-body tr:contains('Records Not found')").remove();
            }
        });
    });
</script>
<script>
function formatDate(dateString) {
    const parts = dateString.split('-');
    const formattedDate = `${parts[2]}-${parts[1]}-${parts[0]}`;
    return formattedDate;
}
</script>
<script>
    $(document).ready(function () {
       _filter(0);
         const urlParams = new URLSearchParams(window.location.search);
         const fromParam = parseInt(urlParams.get('from')) || 0;
         _get(fromParam);

     });

     function _filter(filter_on)
     {

       var  collection = document.getElementsByClassName("filter");
       var arr = {};

       for (let i = 0; i < collection.length; i++) {
         arr[collection[i].name] =  filter_on == 1 ? collection[i].value : '';
       }

       if(filter_on == 0)
       {
         $('.filter').val('');
       }

       localStorage.setItem('filter', JSON.stringify(arr));

     }

     function _get(from)
      {
             $.ajax({
             type: "GET",
             url: `{{ url('api/leave-request-get') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
             headers: {
                 'X-CSRF-TOKEN': '{{csrf_token()}}'
             },
             success: function (response) {
               console.log(response);
             var leaverequest = response.data.leaverequest;
             console.log(leaverequest);
             var html = ``;
             var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count)/10;
                         count = Math.ceil(count);
                         var pages_btn = ``;

                         pages_btn += `
                         <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                           <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                 </li>
                                       <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                         <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                       </li>`;

                         $('.p-btn').removeClass('active');

                           var c = 0;
                         for(c = 0; c < count; c++)
                         {
                             if(
                               (from == (c-3)*10) ||
                               (from == (c-2)*10) ||
                               (from == (c-1)*10) ||
                               (from == (c-0)*10) ||
                               (from == (c+1)*10) ||
                               (from == (c+2)*10) ||
                               (from == (c+3)*10)
                               )
                               {
                                 pages_btn += `
                                 <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*10});">
                                   <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                 </li>
                                 `;
                               }

                         }

                 pages_btn += `

                 <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                           <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                 </li>
                 <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*10});" >
                           <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                 </li>
                 `;


                 $('.pages_btn').html(pages_btn);



             for (var i = 0; i < leaverequest.length; i++) {

                 var leavecount = i + 1;

                 html += `
                     <tr>
                         <td>
                             <input type="checkbox" style="width: 15px; height: 15px;" class="form-check-input leave-checkbox" value="${leaverequest[i].id}" onchange="updateApproveButton()">
                         </td>
                         <td><span class="fw-medium">${leavecount}</span></td>
                         <td>${leaverequest[i].emp_personal_details ? (leaverequest[i].emp_personal_details.middle_name ? `${leaverequest[i].emp_personal_details.first_name} ${leaverequest[i].emp_personal_details.middle_name} ${leaverequest[i].emp_personal_details.last_name}` : `${leaverequest[i].emp_personal_details.first_name} ${leaverequest[i].emp_personal_details.last_name}`): ''}</td>
                         <td>${leaverequest[i].leave_package ? leaverequest[i].leave_package.title : ''}</td>
                         <td>${leaverequest[i].from ? formatDate(leaverequest[i].from) : ''}</td>
                         <td>${leaverequest[i].to ? formatDate(leaverequest[i].to) : ''}</td>
                        <td class="w-px-150">
                        ${leaverequest[i].status == 0 ? '<span class="badge rounded-pill bg-label-info me-1">Pending</span>'
                        : (leaverequest[i].status == 1 ? '<span class="badge rounded-pill bg-label-success me-1">Approved</span>'
                        : (leaverequest[i].status == 2 ? '<span class="badge rounded-pill bg-label-danger me-1">Rejected</span>'
                        : (leaverequest[i].status == 3 ? '<span class="badge rounded-pill bg-label-warning me-1">Expired</span>'
                        : (leaverequest[i].status == 4 ? '<span class="badge rounded-pill bg-label-warning me-1">Approved as Unpaid</span>'
                        : 'h'))))
                        }
                        </td>
                        <td>
                              <div class="dropdown cursor-pointer d-flex justify-content-center">
                              <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>
                              <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                              @if(in_array('Leave Request Maintain',Session::get('permissions')))
                              <li><a class="dropdown-item py-1 ps-2"  data-id="${leaverequest[i].id}" onclick="window.location='/leave-request/${leaverequest[i]?.id}/edit'"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                              <li><a class="dropdown-item py-1 ps-2"   data-id="${leaverequest[i].id}" onclick="_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                              @endif
                              <li><a class="dropdown-item py-1 ps-2" data-id="${leaverequest[i].id}" onclick="window.location='/leave-view/${leaverequest[i]?.id}?from=${from}'"><span class="mdi mdi-eye text-primary"></span> View Detail</a></li>
                              </ul>
                              </div>
                            </td>
                     </tr>`;
             }

             $('.table-body').html(html);

             if (html == ``) {
                 $('.table-body').html(`<tr><td colspan="9" class="text-center">No record found</td></tr>`);
             }

             loader(false);
         },
         error: function (response) {
             loader(false);
             if (response.status == 422) {
                 var errors = response.responseJSON.data;
                 $.each(errors, function (field, messages) {
                     error_msg = messages[0];
                     toastr.error(error_msg);
                 });
             } else if (response.status == 500) {
                 toastr.error("Something went wrong")
             } else {
                 toastr.error(response.responseJSON.message)
             }
         }
     });
 }

function _leave_reason(id){
    $.ajax({
        type: 'GET',
        url: 'api/leave-request-reason/' + id,
        success: function(data) {
            $('#leave_concern').text(data.data.reason);
            console.log(data);
        },
        error: function(error) {
            console.error('Error fetching data:', error);
        }
    });
  }
  function _delete_modal(_this)
    {
      var id  =  $(_this).attr('data-id');
      $('#leave-request-id').attr('data-id',id);
      $('#DeleteEmp').modal('show');
    }
 function _delete(_this)
     {
            var id  =  $(_this).attr('data-id');
             $.ajax({
                 type: "POST",
                 url: "api/leave-request-delete/" + id,
                 headers: {
                     'X-CSRF-TOKEN': '{{ csrf_token() }}'
                 },
                 success: function (response) {
                    //  toastr.success(response.message);
                     location.reload();
                 },
                 error: function (error) {
                     console.error("Error:", error);
                     toastr.error("Failed to delete Leave Request");
                 }
             });
     }

// Select All functionality
$(document).ready(function() {
    $('#selectAllCheckbox').on('change', function() {
        $('.leave-checkbox').prop('checked', this.checked);
        updateApproveButton();
    });
});

// Show/hide Approve Selected button
function updateApproveButton() {
    var checkedBoxes = $('.leave-checkbox:checked');
    if (checkedBoxes.length > 0) {
        $('#approveSelectedBtn').show();
    } else {
        $('#approveSelectedBtn').hide();
    }
}

// Approve selected leave requests with SweetAlert2
function approveSelectedLeaveRequests() {
    var selectedIds = [];
    $('.leave-checkbox:checked').each(function() {
        selectedIds.push($(this).val());
    });

    if (selectedIds.length === 0) {
        toastr.warning('Please select at least one leave request to approve.');
        return;
    }

    Swal.fire({
        title: 'Confirm Approval',
        text: 'Are you sure you want to approve ' + selectedIds.length + ' selected leave request(s)?',
        icon: 'question',
        showCancelButton: true,
        confirmButtonColor: '#3085d6',
        cancelButtonColor: '#d33',
        confirmButtonText: 'Yes, approve them!',
        cancelButtonText: 'Cancel'
    }).then((result) => {
        if (result.isConfirmed) {
            $.ajax({
                type: "POST",
                url: `{{ url('api/leave-request-approve-multiple') }}`,
                data: { 
                    ids: selectedIds,
                    status: 1 // 1 = Approved
                },
                headers: { 'X-CSRF-TOKEN': '{{ csrf_token() }}' },
                success: function(response) {
                    if (response.success) {
                        Swal.fire(
                            'Approved!',
                            response.message,
                            'success'
                        );
                        $('.leave-checkbox').prop('checked', false);
                        $('#selectAllCheckbox').prop('checked', false);
                        updateApproveButton();
                        _get(0); // Refresh table
                    } else {
                        Swal.fire(
                            'Error!',
                            response.message,
                            'error'
                        );
                    }
                },
                error: function(xhr) {
                    Swal.fire(
                        'Error!',
                        'Error approving leave requests',
                        'error'
                    );
                }
            });
        }
    });
}
</script>


<style>
    .leave-types{
        display: flex;
    }
    .leave-group-btn {
        display: flex;
    }
    @media only screen and (min-width: 320px)and (max-width: 568px) {
        .leave-types{
        display: block;
    }
    .leave-group-btn {
        display: block;
    }
    }

        .filter {
            width: 100%;
            height: 33px;
            outline: none;
            background: white;
        }
        .filter-form{
            width: 100%;
            height: 33px;
            outline: none;
            background: white;
        }


        .select-color {
            color: #4E4E4E;
            font-weight: 400;
            line-height: 1.47;
            background-size: 9px 5px;
            border: 1px solid #d4d3d5;
            border-radius: 2px;
            transition: border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
            padding-left: 5px;
        }

        .list_color:hover {
            color: #15A7F5;
        }
    </style>



@endsection
