@extends('includes/layout')
@section('main-page-content')
    <style>
        .bg-primary th {
            color: white;
        }

        .btn-color {
            background-color: #1A2D4D !important;
        }

        .hearder-color {
            background-color: #1A2D4D !important;
        }
    </style>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-body p-0">
                <div class="leave-page py-2 px-2 p-0 pt-3 pt-md-0 p-md-1 p-lg-2  justify-content-between align-items-center">
                    <div class="me-auto">
                        <div class="h4 pb-0 mb-0">Leave Type</div>
                        <small>Leave Management / Leave Type</small>
                    </div>
                    <div class="search-group justify-content-end align-items-center">
                        <div class="p-2 align-items-center ">
                            <label class="pe-2">Search:</label>
                            <input type="text" class="form-control" id="search_data">
                        </div>
                        <div class="pt-3 mt-4  pt-md-0 text-start ps-2">
                            @if (in_array('Leave Type Maintain', Session::get('permissions')))
                                <button class="btn btn-primary px-3" data-bs-toggle="modal"
                                    data-bs-target="#leave-type-modal"><span class="mdi mdi-plus"></span>Add Type</button>
                            @endif
                        </div>

                    </div>
                </div>
                <div>
                    <div class="table-responsive text-nowrap border-bottom">
                        <table class="table">
                            <thead class="table-head-color bg-primary">
                                <tr class="bg-primary">
                                    <th style="width: 10%;">S/N</th>
                                    <th>Title</th>
                                    <th>Description</th>
                                    <th style="width: 10%;">Actions</th>
                                </tr>
                            </thead>
                            <tbody class="table-border-bottom-0 table-body">

                            </tbody>
                        </table>
                    </div>
                    <nav aria-label="Page navigation" class="mt-3">
                        <ul class="pagination justify-content-end pages_btn">

                        </ul>
                    </nav>
                </div>
            </div>
        </div>
    </div>



    <div class="modal fade" id="leave-type-modal" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header hearder-color p-2">
                    <h5 class="modal-title text-white text-center ps-3" id="exampleModalLabel">Add Leave Type</h5>
                </div>
                <form id="leave-type-form">
                    <div class="modal-body">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label>Leave Type<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" name="leave_type">
                            </div>
                            <div class="col-12 mb-3">
                                <label>Leave Hours<span class="text-danger">*</span></label>
                                <input type="number" class="form-control" name="leave_hours">
                            </div>
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="type_desc" class="form-label">Description<span
                                            class="text-danger">*</span></label>
                                    <textarea class="form-control" rows="3" name="description" required></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer border-top p-2">
                        <button type="button" class="btn btn-outline-light text-black"
                            data-bs-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-color text-white" onclick="leave_type_store();">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <div class="modal fade" id="edit-leave-type-modal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header hearder-color p-2">
                    <h5 class="modal-title text-white text-center ps-3" id="exampleModalLabel">Edit Leave Type</h5>
                </div>
                <form id="edit-leave-type-form">
                    <div class="modal-body">
                        <input type="hidden" id="typeId" value="">
                        <div class="row">
                            <div class="col-12 mb-3">
                                <label>Leave Type<span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="type-title" name="leave_type">
                            </div>
                            <div class="col-12 mb-3">
                                <label>Leave Hours<span class="text-danger">*</span></label>
                                <input type="number" class="form-control" id="leave_hours" name="leave_hours">
                            </div>
                            <div class="col-12">
                                <div class="mb-3">
                                    <label for="type_desc" class="form-label">Description<span
                                            class="text-danger">*</span></label>
                                    <textarea class="form-control" id="type_desc" rows="3" name="description" required></textarea>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="modal-footer border-top p-2">
                        <button type="button" class="btn btn-outline-light text-black"
                            data-bs-dismiss="modal">Close</button>
                        <button type="button" class="btn btn-color text-white" onclick="leave_type_update();">Save</button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!--detail Modal -->
    <div class="modal fade" id="leavetype-desc-modal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header hearder-color p-2">
                    <h5 class="modal-title text-white text-center ps-3" id="exampleModalLabel">Description</h5>
                </div>
                <div class="modal-body">
                    <input type="hidden" id="holidayId">
                    <div class="row">
                        <div class="col-12">
                            <div class="mb-3">
                                <textarea class="form-control" id="leave_type_desc" rows="5" disabled name="description"></textarea>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="DeleteEmp" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete this record?<br><br>
                    <b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you
                    genuinely want to delete it before clicking the delete button.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger" id="leave-type-id" data-id=""
                        onclick="_delete(this)">Delete</button>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('css-js')
    <script>
        $(document).ready(function() {
            $("#search_data").on("keyup", function() {
                var searchText = $(this).val().toLowerCase();
                var $tableRows = $(".table-body tr");
                $tableRows.hide();
                $tableRows.filter(function() {
                    return $(this).text().toLowerCase().indexOf(searchText) > -1;
                }).show();
                if ($tableRows.filter(":visible").length === 0) {
                    $(".table-body").append(
                        '<tr><td colspan="8" class="text-center">Records Not found</td></tr>');
                } else {
                    $(".table-body tr:contains('Records Not found')").remove();
                }
            });
        });
    </script>

    <script>
        $(document).ready(function() {
            _filter(0);
            _get(0);

        });

        function _filter(filter_on) {

            var collection = document.getElementsByClassName("filter");
            var arr = {};

            for (let i = 0; i < collection.length; i++) {
                arr[collection[i].name] = filter_on == 1 ? collection[i].value : '';
            }

            if (filter_on == 0) {
                $('.filter').val('');
            }

            localStorage.setItem('filter', JSON.stringify(arr));

        }

        function _get(from) {
            // loader(true);

            $.ajax({
                type: "GET",
                url: `{{ url('/api/leave-type') }}?from=${from}&filter=${localStorage.getItem('filter')}`,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                // success: function (response){},
                success: function(response) {
                    var leavetypes = response.data.leavetypes;
                    console.log(leavetypes);
                    var html = ``;
                    var count = parseInt(response.count) < 10 ? 1 : parseInt(response.count) / 10;
                    count = Math.ceil(count);
                    var pages_btn = ``;

                    pages_btn += `
                        <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(0);" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-left"></i></a>
                </li>
                                      <li class="page-item prev ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').prev('.p-btn').trigger('onclick');" >
                                        <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-left"></i></a>
                                      </li>`;

                    $('.p-btn').removeClass('active');

                    var c = 0;
                    for (c = 0; c < count; c++) {
                        if (
                            (from == (c - 3) * 10) ||
                            (from == (c - 2) * 10) ||
                            (from == (c - 1) * 10) ||
                            (from == (c - 0) * 10) ||
                            (from == (c + 1) * 10) ||
                            (from == (c + 2) * 10) ||
                            (from == (c + 3) * 10)
                        ) {
                            pages_btn += `
                                <li class="page-item p-btn ${from == c*10 ? 'active' : '' } ${response.count == 0 ? 'd-none' : '' } "   onclick="_get(${c*10});">
                                  <a class="page-link waves-effect" href="javascript:void(0);">${c+1}</a>
                                </li>
                                `;
                        }

                    }

                    pages_btn += `

                <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"  onclick="$('.active').next('.p-btn').trigger('onclick');" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-right"></i></a>
                </li>
                <li class="page-item next ${response.count == 0 ? 'd-none' : ''}"   onclick="_get(${(c-1)*10});" >
                          <a class="page-link waves-effect" href="javascript:void(0);"><i class="tf-icon mdi mdi-chevron-double-right"></i></a>
                </li>
                `;


                    $('.pages_btn').html(pages_btn);



                    for (var i = 0; i < leavetypes.length; i++) {

                        var holidaycount = i + 1;

                        html += `
                    <tr>
                        <td><span class="fw-medium">${holidaycount}</span></td>
                        <td>${leavetypes[i].title}</td>
                        <td class="cursor-pointer" data-bs-toggle="modal" data-bs-target="#leavetype-desc-modal" onclick="_detail(${leavetypes[i]?.id})">${leavetypes[i].description.length > 50 ? `${leavetypes[i].description.slice(0, 50)}...` : leavetypes[i].description}</td>
                        <!-- Add other columns as needed -->


                        <td>
                              <div class="dropdown cursor-pointer d-flex justify-content-center">
                              <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>
                              <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                              @if (in_array('Leave Type Maintain', Session::get('permissions')))
                              <li><a class="dropdown-item py-1 ps-2"  data-id="${leavetypes[i].id}"  onclick="_edit(${leavetypes[i]?.id});"data-bs-toggle="modal" data-bs-target="#edit-leave-type-modal"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                              <li><a class="dropdown-item py-1 ps-2"   data-id="${leavetypes[i].id}" onclick="_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                              @endif
                              </ul>
                              </div>
                            </td>
                    </tr>`;
                    }

                    $('.table-body').html(html);

                    if (html == ``) {
                        $('.table-body').html(
                            `<tr><td colspan="8" class="text-center">No record found</td></tr>`);
                    }

                    loader(false);
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errors = response.responseJSON.data;
                        $.each(errors, function(field, messages) {
                            error_msg = messages[0];
                            toastr.error(error_msg);
                        });
                    } else if (response.status == 500) {
                        toastr.error("Something went wrong")
                    } else {
                        toastr.error(response.responseJSON.message)
                    }
                }
            });
        }




        function leave_type_store() {
            var formData = $('#leave-type-form').serialize();

            $.ajax({
                url: '{{ url('/') }}/api/leave-type',
                type: 'POST',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function(response) {
                    // toastr.success(response.message);
                    $('#publicholiday').modal('hide');
                    window.location.reload();
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errorResponse = response.responseJSON;
                        toastr.error(errorResponse.message);
                    } else {
                        toastr.error("Something went wrong");
                    }
                }
            });
        }


        function _edit(id) {
            $.ajax({
                type: "GET",
                url: "{{ url('/') }}/api/leave-type/" + id + "/edit",
                dataType: 'json',
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(data) {
                    console.log(data);
                    var holidayData = data[0];

                    // Populate the modal with the retrieved data
                    $('#type-title').val(holidayData.title);
                    $('#leave_hours').val(holidayData.leave_hours);
                    $('#type_desc').val(holidayData.description);
                    $('#typeId').val(holidayData.id);
                },
                error: function(error) {
                    console.error("Error:", error);
                    toastr.error("Error fetching data");
                }
            });

        }

        function leave_type_update() {
            var formData = $('#edit-leave-type-form').serialize();
            var holidayId = $('#typeId').val();

            $.ajax({
                url: '{{ url('/') }}/api/leave-type/' + holidayId,
                type: 'PUT',
                data: formData,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                dataType: 'json',
                success: function(response) {
                    // toastr.success(response.message);
                    $('#edit-leave-type-modal').modal('hide');
                    window.location.reload();
                },
                error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                        var errorResponse = response.responseJSON;
                        toastr.error(errorResponse.message);
                    } else {
                        toastr.error("Something went wrong");
                    }
                }
            });
        }

        function _delete_modal(_this) {
            var id = $(_this).attr('data-id');
            $('#leave-type-id').attr('data-id', id);
            $('#DeleteEmp').modal('show');
        }

        function _delete(_this) {
            var id = $(_this).attr('data-id');
            $.ajax({
                type: "DELETE",
                url: "{{ url('/') }}/api/leave-type/" + id,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(response) {
                    // toastr.success(response.message);
                    location.reload();
                },
                error: function(error) {
                    console.error("Error:", error);
                    toastr.error("Failed to delete Leave Type");
                }
            });
        }

        function _detail(id) {
            $.ajax({
                type: 'GET',
                url: '{{ url('/') }}/api/leave-type-desc/' + id,
                headers: {
                    'X-CSRF-TOKEN': '{{ csrf_token() }}'
                },
                success: function(data) {
                    $('#leave_type_desc').text(data.data.description);

                },
                error: function(error) {
                    console.error('Error fetching data:', error);
                }
            });
        }
    </script>

    <style>
        .leave-page {
            display: flex;
        }

        .search-group {
            display: flex;
        }

        @media only screen and (min-width: 320px)and (max-width: 568px) {
            .leave-page {
                display: block;
            }

            .search-group {
                display: block;
            }
        }
    </style>
@endsection
