@php
    // Helper for time formatting
    function formatMinutes($minutes)
    {
        if (!$minutes || $minutes <= 0) {
            return '0h 00m';
        }
        $h = floor($minutes / 60);
        $m = $minutes % 60;
        return sprintf('%dh %02dm', $h, $m);
    }
    $totalFines = isset($fines) ? $fines->where('type', 0)->sum('fine_amount') : 0;
    $totalBonuses = isset($fines) ? $fines->where('type', 1)->sum('fine_amount') : 0;
@endphp
<!DOCTYPE html>
<html>

<head>
    <meta charset="utf-8">
    <title>Attendance Details - {{ optional($payroll->employee)->first_name }}
        {{ optional($payroll->employee)->last_name }}</title>
    <style>
        body {
            font-family: 'DejaVu Sans', Arial, Helvetica, sans-serif;
            color: #2C3E50;
            background: #fff;
            margin: 0;
            padding: 0;
            font-size: 12px;
        }

        .header {
            background: #1A2D4D;
            color: #fff;
            padding: 20px;
            text-align: center;
            margin-bottom: 20px;
        }

        .header h2 {
            margin: 0;
            font-size: 24px;
        }

        .header small {
            font-size: 14px;
            color: #f2f2f2;
        }

        .section {
            margin: 20px;
        }

        .summary-table,
        .info-table,
        .attendance-table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
            font-size: 11px;
        }

        .summary-table th,
        .summary-table td,
        .info-table th,
        .info-table td,
        .attendance-table th,
        .attendance-table td {
            border: 1px solid #E8E8E8;
            padding: 8px;
            text-align: left;
        }

        .summary-table th,
        .info-table th,
        .attendance-table th {
            background: #1A2D4D;
            color: #fff;
            font-weight: bold;
        }

        .summary-table td,
        .info-table td,
        .attendance-table td {
            background: #F8F9FA;
        }

        .title {
            font-size: 16px;
            font-weight: bold;
            margin-bottom: 10px;
            color: #1A2D4D;
            border-bottom: 2px solid #1A2D4D;
            padding-bottom: 5px;
        }

        .divider {
            height: 1px;
            background: #E8E8E8;
            margin: 20px 0;
            border: none;
        }

        .text-success {
            color: #27AE60;
        }

        .text-danger {
            color: #E74C3C;
        }

        .text-center {
            text-align: center;
        }

        .text-end {
            text-align: right;
        }

        .badge {
            display: inline-block;
            padding: 2px 6px;
            border-radius: 4px;
            font-size: 10px;
            font-weight: bold;
        }

        .badge-success {
            background: #27AE60;
            color: #fff;
        }

        .badge-danger {
            background: #E74C3C;
            color: #fff;
        }

        .badge-warning {
            background: #F39C12;
            color: #fff;
        }

        .badge-info {
            background: #3498DB;
            color: #fff;
        }

        .summary-cards {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .summary-cards td {
            border: 1px solid #1A2D4D;
            padding: 12px;
            text-align: center;
            vertical-align: middle;
            width: 16.66%;
        }

        .summary-value {
            font-size: 16px;
            font-weight: bold;
            color: #1A2D4D;
            margin: 5px 0;
        }

        .summary-label {
            color: #6C757D;
            font-size: 10px;
            font-weight: 500;
            text-transform: uppercase;
        }

        .attendance-cards {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }

        .attendance-cards td {
            border: 1px solid #E8E8E8;
            padding: 12px;
            text-align: center;
            vertical-align: middle;
            width: 20%;
        }

        .attendance-cards td.primary {
            border-color: #1A2D4D;
        }

        .attendance-cards td.success {
            border-color: #27AE60;
        }

        .attendance-cards td.danger {
            border-color: #E74C3C;
        }

        .attendance-cards td.info {
            border-color: #3498DB;
        }

        .attendance-cards td.warning {
            border-color: #F39C12;
        }

        .attendance-number {
            font-size: 20px;
            font-weight: bold;
            margin: 5px 0;
        }

        .attendance-number.primary {
            color: #1A2D4D;
        }

        .attendance-number.success {
            color: #27AE60;
        }

        .attendance-number.danger {
            color: #E74C3C;
        }

        .attendance-number.info {
            color: #3498DB;
        }

        .attendance-number.warning {
            color: #F39C12;
        }

        .attendance-label {
            color: #6C757D;
            font-size: 10px;
            font-weight: 500;
        }

        .page-break {
            page-break-before: always;
        }

        .no-break {
            page-break-inside: avoid;
        }
    </style>
</head>

<body>
    <div class="header">
        <h2>Attendance Details</h2>
        <small>{{ optional($payroll->employee)->first_name }} {{ optional($payroll->employee)->last_name }} -
            {{ date('F Y', mktime(0, 0, 0, $payroll->pay_month, 1, $payroll->pay_year)) }}</small>
    </div>
    
    <div class="section">
        <div class="title">Employee Information</div>
        <table class="info-table">
            <tr>
                <th>Full Name</th>
                <td>{{ optional($payroll->employee)->first_name }} {{ optional($payroll->employee)->middle_name }}
                    {{ optional($payroll->employee)->last_name }}</td>
                <th>Employee ID</th>
                <td>#{{ optional($payroll->employee)->id ?: 'N/A' }}</td>
            </tr>
            <tr>
                <th>Mobile Number</th>
                <td>{{ optional($payroll->employee)->mobile ?: 'Not Available' }}</td>
                <th>Email Address</th>
                <td>{{ optional($payroll->employeCom)->employee_email ?: 'Not Available' }}</td>
            </tr>
        </table>

        <div class="divider"></div>

        <div class="title">Salary Summary</div>
        <table class="summary-cards">
            <tr>
                <td>
                    <div class="summary-label">Hours Required</div>
                    <div class="summary-value">{{ number_format($payroll->working_hours / 60, 1) }}h</div>
                </td>
                <td>
                    <div class="summary-label">Hours Worked</div>
                    <div class="summary-value">{{ number_format($payroll->actual_working_hours / 60, 1) }}h</div>
                </td>
                <td>
                    <div class="summary-label">Leave Hours</div>
                    <div class="summary-value">{{ $approvedLeaveHours ?? 0 }}h</div>
                </td>
                <td>
                    <div class="summary-label">Basic Salary</div>
                    <div class="summary-value">PKR {{ number_format($payroll->basic_salary, 0) }}</div>
                </td>
                <td>
                    <div class="summary-label">Calculated Salary</div>
                    <div class="summary-value">PKR {{ number_format($payroll->calculated_salary, 0) }}</div>
                </td>
                <td>
                    <div class="summary-label">Final Amount</div>
                    <div class="summary-value">PKR {{ number_format($adjustedSalary ?? $payroll->calculated_salary, 0) }}</div>
                </td>
            </tr>
        </table>

        <div class="divider"></div>

        <div class="title">Salary Breakdown</div>
        <table class="summary-table">
            <tr>
                <th>Item</th>
                <th>Details</th>
                <th class="text-end">Amount</th>
            </tr>
            <tr>
                <td>Basic Salary</td>
                <td>Monthly basic salary</td>
                <td class="text-end">PKR {{ number_format($payroll->basic_salary, 0) }}</td>
            </tr>
            <tr>
                <td>Working Hours</td>
                <td>Scheduled Required hours</td>
                <td class="text-end">{{ number_format($payroll->working_hours / 60, 1) }} hours</td>
            </tr>
            <tr>
                <td>Approved Leaves</td>
                <td>Number of approved leave days</td>
                <td class="text-end">{{ $approvedLeave ?? 0 }}</td>
            </tr>
            <tr>
                <td>Approved Leave Hours</td>
                <td>Total leave hours</td>
                <td class="text-end">{{ $approvedLeaveHours ?? 0 }} hours</td>
            </tr>
            <tr>
                <td>Hours Worked</td>
                <td>Actual hours spent</td>
                <td class="text-end">{{ number_format($payroll->actual_working_hours / 60, 1) }} hours</td>
            </tr>
            <tr>
                <td>Overtime Hours</td>
                <td>Total overtime hours</td>
                <td class="text-end">{{ number_format($payroll->overtime_hours / 60, 1) }} hours</td>
            </tr>
            <tr>
                <td>Total Fines</td>
                <td>Deductions for fines</td>
                <td class="text-end text-danger">PKR {{ number_format($totalFines, 0) }}</td>
            </tr>
            <tr>
                <td>Total Bonuses</td>
                <td>Additional bonuses</td>
                <td class="text-end text-success">PKR {{ number_format($totalBonuses, 0) }}</td>
            </tr>
        </table>

        <div class="divider"></div>

        <div class="title">Attendance Summary</div>
        <table class="attendance-cards">
            <tr>
                <td class="primary">
                    <div class="attendance-number primary">{{ $totalWorkingDays ?? 0 }}</div>
                    <div class="attendance-label">Total Working Days</div>
                </td>
                <td class="warning">
                    <div class="attendance-number warning">{{ $totalHolidays ?? 0 }}</div>
                    <div class="attendance-label">Holidays</div>
                </td>
                <td class="success">
                    <div class="attendance-number success">{{ $presentDays ?? 0 }}</div>
                    <div class="attendance-label">Present Days</div>
                </td>
                <td class="danger">
                    <div class="attendance-number danger">{{ $absentDays ?? 0 }}</div>
                    <div class="attendance-label">Absent Days</div>
                </td>
                <td class="info">
                    <div class="attendance-number info">{{ $attendanceRate ?? 0 }}%</div>
                    <div class="attendance-label">Attendance Rate</div>
                </td>
            </tr>
        </table>

        @if (isset($attendances) && $attendances->count() > 0)
            <div class="title">Daily Attendance Records</div>
            <table class="attendance-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Day</th>
                        <th>Check In</th>
                        <th>Check Out</th>
                        <th class="text-end">Working Hours</th>
                        <th class="text-center">Status</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($attendances as $attendance)
                        <tr>
                            <td>{{ \Carbon\Carbon::parse($attendance->date)->format('d M Y') }}</td>
                            <td>{{ \Carbon\Carbon::parse($attendance->date)->format('l') }}</td>
                            <td>{{ $attendance->check_in ? \Carbon\Carbon::parse($attendance->check_in)->format('H:i') : 'N/A' }}
                            </td>
                            <td>{{ $attendance->check_out ? \Carbon\Carbon::parse($attendance->check_out)->format('H:i') : 'N/A' }}
                            </td>
                            <td class="text-end">
                                {{ formatMinutes($attendance->working_hours ?? 0) }}
                            </td>
                            <td class="text-center">
                                @if ($attendance->check_in && $attendance->check_out)
                                    <span class="badge badge-success">Present</span>
                                @elseif($attendance->check_in && !$attendance->check_out)
                                    <span class="badge badge-warning">Incomplete</span>
                                @else
                                    <span class="badge badge-danger">Absent</span>
                                @endif
                            </td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @else
            <div class="title">No Attendance Records</div>
            <p>No attendance records found for this period.</p>
        @endif

        @if (isset($overtimeRecords) && $overtimeRecords->count() > 0)
            <div class="divider"></div>
            <div class="title">Overtime Records</div>
            <table class="attendance-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Start Time</th>
                        <th>End Time</th>
                        <th class="text-end">Duration</th>
                        <th>Reason</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($overtimeRecords as $overtime)
                        <tr>
                            <td>{{ \Carbon\Carbon::parse($overtime->date)->format('d M Y') }}</td>
                            <td>{{ $overtime->check_in ? \Carbon\Carbon::parse($overtime->check_in)->format('H:i') : 'N/A' }}
                            </td>
                            <td>{{ $overtime->check_out ? \Carbon\Carbon::parse($overtime->check_out)->format('H:i') : 'N/A' }}
                            </td>
                            <td class="text-end">
                                @php
                                    $duration = 0;
                                    if ($overtime->check_in && $overtime->check_out) {
                                        $start = \Carbon\Carbon::parse($overtime->check_in);
                                        $end = \Carbon\Carbon::parse($overtime->check_out);
                                        $duration = $end->diffInMinutes($start);
                                    }
                                @endphp
                                {{ formatMinutes($duration) }}
                            </td>
                            <td>{{ $overtime->description ?? 'No reason provided' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif

        @if (isset($fines) && $fines->count() > 0)
            <div class="divider"></div>
            <div class="title">Fines & Bonuses</div>
            <table class="attendance-table">
                <thead>
                    <tr>
                        <th>Date</th>
                        <th>Type</th>
                        <th>Reason</th>
                        <th class="text-end">Amount</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($fines as $fine)
                        <tr>
                            <td>{{ date('d M Y', strtotime($fine->date)) }}</td>
                            <td>
                                @if ($fine->type == 0)
                                    <span class="badge badge-danger">Fine</span>
                                @else
                                    <span class="badge badge-success">Bonus</span>
                                @endif
                            </td>
                            <td>{{ $fine->fine_reason }}</td>
                            <td class="text-end">
                                <span class="{{ $fine->type == 0 ? 'text-danger' : 'text-success' }}">
                                    {{ $fine->type == 0 ? '-' : '+' }}PKR
                                    {{ number_format($fine->fine_amount, 0) }}
                                </span>
                            </td>
                        </tr>
                    @endforeach
                </tbody>
                <tfoot>
                    <tr>
                        <th colspan="3">Net Impact</th>
                        <th class="text-end">
                            <span class="{{ $totalBonuses - $totalFines >= 0 ? 'text-success' : 'text-danger' }}">
                                {{ $totalBonuses - $totalFines >= 0 ? '+' : '' }}PKR
                                {{ number_format($totalBonuses - $totalFines, 0) }}
                            </span>
                        </th>
                    </tr>
                </tfoot>
            </table>
        @endif

        @if (isset($holidays) && $holidays->count() > 0)
            <div class="divider"></div>
            <div class="title">Public Holidays</div>
            <table class="attendance-table">
                <thead>
                    <tr>
                        <th>Holiday Name</th>
                        <th>From Date</th>
                        <th>To Date</th>
                        <th>Description</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach ($holidays as $holiday)
                        <tr>
                            <td>{{ $holiday->name ?? 'Holiday' }}</td>
                            <td>{{ date('d M Y', strtotime($holiday->from)) }}</td>
                            <td>{{ date('d M Y', strtotime($holiday->to)) }}</td>
                            <td>{{ $holiday->description ?? 'Public Holiday' }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
        @endif
    </div>
</body>

</html>
