@extends('includes/layout')
@section('main-page-content')
<style>
    .height-width
    {
      width: 56px;
      height: 32px;
    }
    .list_color:hover{
  color: #15A7F5;
}
.table-no-bottom-border tbody tr:last-child td {
    border-bottom: none !important;
}

.nav-tabs {
    display: flex;
    overflow-x: auto; /* Allow horizontal scrolling */
    -webkit-overflow-scrolling: touch; /* Smooth scrolling on iOS */
}

.nav-tabs .nav-item {
    flex: 0 0 auto; /* Prevent the tabs from shrinking or growing */
}

.nav-item {
    margin-right: 10px; /* Space between tabs */
}

.tab-slider {
    position: absolute;
    bottom: 0;
    height: 2px;
    background-color: #15A7F5; /* Color for slider */
    transition: left 0.3s ease, width 0.3s ease;
}


  </style>
    <div class="container-xxl flex-grow-1 container-p-y">
        <div class="card mb-4">
            <div class="card-header p-0">
                <div class="nav-align-top">
                    <ul class="nav nav-tabs" role="tablist">
                        <li class="nav-item" role="presentation">
                            <button type="button" class="nav-link waves-effect active" role="tab" data-bs-toggle="tab"
                                data-bs-target="#navs-top-role" aria-controls="navs-top-role" aria-selected="true">
                                Employee Role
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab" data-bs-target="#navs-top-permit-typte" aria-controls="navs-top-permit-typte" aria-selected="false" tabindex="-1">
                                Work Permit Types
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab"
                                data-bs-target="#navs-top-employementtype" aria-controls="navs-top-documents"
                                aria-selected="false" tabindex="-1">
                                Employement Types
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab"
                                data-bs-target="#navs-top-emloyeeteam" aria-controls="navs-top-emergency"
                                aria-selected="false" tabindex="-1">
                                Teams
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab"
                                data-bs-target="#navs-top-document" aria-controls="navs-top-document"
                                aria-selected="false" tabindex="-1">
                                Required Document
                            </button>
                        </li>
                        <li class="nav-item" role="presentation">
                            <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab" data-bs-target="#navs-top-worker-type" aria-controls="navs-top-worker-type" aria-selected="false" tabindex="-1">
                                Worker Type
                            </button>
                        </li>

                        <li class="nav-item" role="presentation">
                            <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab" data-bs-target="#navs-top-work-experience" aria-controls="navs-top-work-experience" aria-selected="false" tabindex="-1">
                                Work Experience
                            </button>
                        </li>

                        <li class="nav-item" role="presentation">
                            <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab" data-bs-target="#navs-top-roster" aria-controls="navs-top-roster" aria-selected="false" tabindex="-1">
                                Roster Setting
                            </button>
                        </li>

                        <li class="nav-item d-none" role="presentation">
                            <button type="button" class="nav-link waves-effect" role="tab" data-bs-toggle="tab"
                                data-bs-target="#navs-top-external-document" aria-controls="navs-top-external-document"
                                aria-selected="false" tabindex="-1">
                                External Document 
                            </button>
                        </li>

                        <span class="tab-slider" style="left: 0px; width: 91.1719px; bottom: 0px;"></span>
                    </ul>
                </div>
            </div>
            <div class="card-body">
                <div class="tab-content p-0">
                    @include('PreRequire/roster')
                    
                    @include('PreRequire/workerType')

                    @include('PreRequire/workExperience')

                    @include('PreRequire/empRole')
                    
                    @include('PreRequire/workPermitsTypes')
                    
                    @include('PreRequire/employementType')

                    @include('PreRequire/requiredTeams')

                    @include('PreRequire/requiredDocumentExternal')

                    @include('PreRequire/requiredDocument')
                    
                </div>
            </div>
        </div>
    </div>

    <!-- modal -->
    <div class="modal fade" id="AddNewPre" tabindex="-1" aria-labelledby="AddNewPreLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-primary px-4 py-2">
                    <h5 class="modal-title text-white" id="AddNewPreLabel">Add New</h5>
                </div>
                <div class="modal-body">
                    .....
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary">Save</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="EditPre" tabindex="-1" aria-labelledby="EditPreLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-warning px-4 py-2">
                    <h5 class="modal-title text-white" id="EditPreLabel">Edit</h5>
                </div>
                <div class="modal-body">
                    ...
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-warning">Save Changes</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="deletePre" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header bg-danger px-4 py-2">
                    <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
                </div>
                <div class="modal-body">
                    Are you sure you want to delete the 'Human Resource Manager' position?<br><br>
                    <b class="text-warning">Warning:</b> All the associated user will no longer able to access with Human
                    Resource Manager Position. Best action to associate the employee to another Position first.
                </div>
                <div class="modal-footer border-top py-2">
                    <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-danger">Delete</button>
                </div>
            </div>
        </div>
    </div>
@endsection



@section('css-js')
<script>
    document.addEventListener('DOMContentLoaded', function () {
    const tabs = document.querySelectorAll('.nav-tabs .nav-link');
    const tabSlider = document.querySelector('.tab-slider');

    function updateTabSlider() {
        const activeTab = document.querySelector('.nav-link.active');
        if (!activeTab) return;

        const tabWidth = activeTab.offsetWidth;
        const tabOffset = activeTab.offsetLeft;

        // Update tab slider position and width
        tabSlider.style.width = `${tabWidth}px`;
        tabSlider.style.left = `${tabOffset}px`;
    }

    // Initialize tab slider position
    updateTabSlider();

    // Update tab slider when switching tabs
    document.querySelector('.nav-tabs').addEventListener('shown.bs.tab', function () {
        updateTabSlider();
    });

    // Update the tab slider when the window is resized (to handle responsive cases)
    window.addEventListener('resize', function() {
        updateTabSlider();
    });
});


</script>
@endsection
