<div class="tab-pane fade" id="navs-top-emloyeeteam" role="tabpanel">
    <div class=" py-3 d-flex justify-content-between align-items-center">
        <div>
            <div class="h4 pb-0 mb-0">Teams</div>
            <small>Teams List</small>
        </div>
        @if(in_array('Registration Setting Maintain',Session::get('permissions')))
        <button class="btn btn-primary bt-lg" data-bs-toggle="modal" data-bs-target="#AddNewEmployeeTeam" onclick="_emp_team_create();"><span
                class="mdi mdi-plus"></span>Add</button>
                @endif
    </div>
    <table class="table border-top  table-no-bottom-border">
        <tbody class="table-border-bottom emp_team_append">
           
        </tbody>
    </table>
</div>


<div class="modal fade" id="AddNewEmployeeTeam" tabindex="-1" aria-labelledby="AddNewEmployeeTeam" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary px-4 py-2">
                <h5 class="modal-title text-white" id="AddNewEmployeeTeamLabel">New Employee Team</h5>
            </div>
            <div class="modal-body">
                <div class="mb-2">
                    <label for="defaultFormControlInput" class="form-label">Title</label>
                    <input type="text" class="form-control" id="create-emp-team-title" placeholder="Title"
                        aria-describedby="defaultFormControlHelp">
                </div>
                <div class="mb-2">
                    <label for="defaultFormControlInput" class="form-label">Team Lead</label>
                    <select class="form-select" id="create-emp-team-supervisor">
                        <option value="">Team Lead</option>
                    </select>

                </div>
                <div class="mb-2">
                    <label for="defaultFormControlInput" class="form-label">Description</label>
                    <textarea type="text" class="form-control" id="create-emp-team-description" placeholder="Description"
                        aria-describedby="defaultFormControlHelp"></textarea>
                </div>
            </div>
            <div class="modal-footer border-top py-2">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" onclick="_emp_team_store();">Save</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="EditEmpTeam" tabindex="-1" aria-labelledby="EditEmpTeamLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary px-4 py-2">
                <h5 class="modal-title text-white" id="EditRoleLabel">Edit Employee Team</h5>
            </div>
            <div class="modal-body">
                <div class="mb-2">
                    <label for="defaultFormControlInput" class="form-label">Title</label>
                    <input type="text" class="form-control" id="edit-emp-team-title" placeholder="Title"
                        aria-describedby="defaultFormControlHelp">
                </div>
                <div class="mb-2">
                    <label for="defaultFormControlInput" class="form-label">Team Lead</label>
                    <select class="form-select" id="edit-emp-team-supervisor">
                        <option value="" >Team Lead</option>
                    </select>

                </div>
                <div class="mb-2">
                    <label for="defaultFormControlInput" class="form-label">Description</label>
                    <textarea type="text" class="form-control" id="edit-emp-team-description" placeholder="Description"
                        aria-describedby="defaultFormControlHelp"></textarea>
                </div>
                <input type="hidden" class="form-control height-width" id="edit-emp-team-id" value=""
                    aria-describedby="defaultFormControlHelp">

            </div>
            <div class="modal-footer border-top py-2">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-primary" data-id="" onclick="_emp_team_update();">Save
                    Changes</button>
            </div>
        </div>
    </div>
</div>

<div class="modal fade" id="DeleteEmpTeam" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-danger px-4 py-2">
                <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
            </div>
            <div class="modal-body">
                Are you sure you want to delete this record?<br><br>
                <b class="text-warning">Warning:</b>This record will no longer be available. Please ensure you
                genuinely want to delete it before clicking the delete button.
            </div>
            <div class="modal-footer border-top py-2">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
                <button type="button" class="btn btn-danger" id="delete-emp-team-id" data-id=""
                    onclick="_emp_team_delete(this)">Delete</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="HistoryEmpTeam" tabindex="-1" aria-labelledby="" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary px-4 py-2">
                <h5 class="modal-title text-white" id="">History</h5>
            </div>

            <div class="modal-body history-div" style="min-height:70vh;max-height:70vh;overflow-y: scroll;">


            </div>

            <div class="modal-footer border-top py-2">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>


<div class="modal fade" id="MemberEmpTeam" tabindex="-1" aria-labelledby="MemberPreLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-header bg-primary px-4 py-2">
                <h5 class="modal-title text-white" id="">Team Detail</h5>
            </div>
            <div class="modal-body">
                <input type="hidden" value="" class="emp-team-id">

                @php
                    $emp_company_details = $users = DB::table('emp_company_details')
                        ->join('emp_personal_details', 'emp_company_details.id', '=', 'emp_personal_details.emp_id')
                        ->where('emp_company_details.compeleted', '1')
                        ->where('emp_company_details.status', '1')
                        ->where('emp_company_details.del', '0')
                        ->select('emp_personal_details.emp_id', 'emp_personal_details.first_name', 'emp_personal_details.middle_name', 'emp_personal_details.last_name')
                        ->get();

                @endphp

                <p class="team_title mb-1"></p>
                <p class="team_supervisor mb-1 "></p>
                <input id="search-member" class="form-control" value="" placeholder="Search">
                <div class="mt-3 all-box" style="min-height:50vh;max-height:50vh;overflow-y: scroll;" id="">

                    @foreach ($emp_company_details as $company)
                        <div class="input-group mb-1 one-item" role="button">
                            <div class="input-group-text form-check mb-0 rounded-0">
                                <input class="form-check-input m-auto memeber-c memeber-c{{ $company->emp_id }}"
                                    type="checkbox" value="{{ $company->emp_id }}"
                                    onchange="add_remove_member({{ $company->emp_id }});">
                            </div>
                            <div class="form-control rounded-0 text-capitalize" aria-label="Text input with checkbox"
                                onclick="window.location.href = '{{ url('/') }}/user-profile/{{ $company->emp_id }}'">
                                {{ $company->first_name }} {{ $company->middle_name }} {{ $company->last_name }}
                            </div>
                        </div>
                    @endforeach

                </div>

                <p class="team_description mt-2 mb-1 "></p>
            </div>
            <div class="modal-footer border-top py-2">
                <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
            </div>
        </div>
    </div>
</div>

<script>
    $(document).ready(function() {

        loader(false);
        _emp_team_get();

    });

    function add_remove_member(emp_id)
    {
        console.log($('.emp-team-id').val());
        $.ajax({
            type: "PUT",
            url: `{{ url('/add-remove-team-member') }}?team_id=${$('.emp-team-id').val()}&emp_id=${emp_id}&applied=1`,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {
                loader(false);

            },
            error: function(response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function(field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });
    }

    function _emp_team_get()
    {
        loader(true);

        $.ajax({
            type: "GET",
            url: "{{ url('/emp-team') }}",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {
                _emp_team_append(response.data.emp_teams);

                loader(false);

            },
            error: function(response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function(field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });

    }

    function _emp_team_append(data)
    {
        var html = ``;
        for (var i = 0; i < data.length; i++) {
            html += `<tr>
                <td>
                    <span class="fw-medium">${data[i].title}</span>
                </td>

                <td style="width: 130px;">
                @if(in_array('Registration Setting Maintain',Session::get('permissions')))
                  <div class="dropdown cursor-pointer d-flex justify-content-center">
                  <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>

                  <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                    <li><a class="dropdown-item py-1 ps-2" data-title="${data[i].title}"  data-id="${data[i].id}" onclick="_emp_team_history_modal();"><span class="mdi mdi-history text-primary"></span> History</a></li>
                    <li><a class="dropdown-item py-1 ps-2"  id="member-btn-emp-team-id"   data-title="${data[i].title}"  data-id="${data[i].id}" onclick="_emp_team_memeber_modal(this)"><span class="mdi mdi-eye text-primary"></span> Detail</a></li>
                  <li><a class="dropdown-item py-1 ps-2"  data-title="${data[i].title}" data-description="${data[i].description}" data-supervisor="${data[i].supervisor}"  data-id="${data[i].id}" onclick="_emp_team_edit(this)"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                  <li><a class="dropdown-item py-1 ps-2"  id="delete-btn-emp-team-id"  data-title="${data[i].title}"  data-id="${data[i].id}" onclick="_emp_team_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                  </ul>
                  </div>
                  @endif
                </td>
            </tr>`;
        }

        if (html == ``) {
            html = `<div class="w-100 text-center mt-5"> 
                  no employee team yet
                  </div>`;
        }


        $('.emp_team_append').html(html);
    }

    function _emp_team_delete_modal(_this)
    {
        var id = $(_this).attr('data-id');
        $('#delete-emp-team-id').attr('data-id', id);
        $('#DeleteEmpTeam').modal('show');
    }

    function _emp_team_memeber_modal(_this)
    {
        var _FormData = new FormData();
        _FormData.append("team_id", $(_this).attr('data-id'));
        $('.memeber-c').prop('checked', false);
        var id = $(_this).attr('data-id');


        $.ajax({
            type: "POST",
            url: "{{ url('/get-team-member') }}",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            data: _FormData,
            processData: false,
            contentType: false,
            success: function(response) {

                var teams_members = response.data.teams_member;
                var emp_team = response.data.emp_team;
                $('.emp-team-id').val(id);

                for (var i = 0; i < teams_members.length; i++) {
                    $(`.memeber-c${teams_members[i].emp_id}`).prop('checked', true);
                }
                $('.team_title').html(`Title: ${emp_team.title}`);
                $('.team_supervisor').html(
                    `Supervisor: <a href="{{ url('/') }}/user-profile/221" style="text-transform: capitalize;" role="button" class="primary text-decoration-none">  ${emp_team?.team_supervisor?.first_name} ${emp_team?.team_supervisor?.middle_name || ''} ${emp_team?.team_supervisor?.last_name} </a>`
                    );
                $('.team_description').html(`Description: ${emp_team.description}`);
                $('#MemberEmpTeam').modal('show');



                loader(false);

            },
            error: function(response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function(field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });

    }

    function _emp_team_history_modal()
    {
        $.ajax({
            type: "POST",
            url: "{{ url('/get-team-history') }}",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {

                var team_historis = response.data.team_history;


                var html = ``;

                for (var i = 0; i < team_historis.length; i++) {



                    html += `<div class="history-box ${i == (team_historis.length-1) ? 'history-box-last' : '' }  ">
                        <div class="history-tagline">
                        ${team_historis[i].description}
                        </div>
                        <div class="history-timestamp">
                        ${date_formate_style(team_historis[i].created_at)}
                        </div>
                        <div class="history-circle ${i == 0 ? 'history-circle-active' : '' }  "></div>
                     </div>`;
                }

                if (html == ``) {
                    html += `<div class="text-center" >No history yet</div>`;
                }

                $('.history-div').html(html);




                $('#HistoryEmpTeam').modal('show');



                loader(false);

            },
            error: function(response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function(field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });

    }

    function _emp_team_create()
    {


        $.ajax({
            type: "GET",
            url: "{{ url('/emp-team/create') }}",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {


                var supervisor = response.data.supervisor;
                var html = `<option value="">Select Team Lead</option>`;

                for (var i = 0; i < supervisor.length; i++) {
                    html +=
                        `<option value="${supervisor[i].id}">${supervisor[i]?.emp_personal_details?.first_name ? supervisor[i]?.emp_personal_details?.first_name: ""} ${supervisor[i]?.emp_personal_details?.middle_name ? supervisor[i]?.emp_personal_details?.middle_name: ""} ${supervisor[i]?.emp_personal_details?.last_name ? supervisor[i]?.emp_personal_details?.last_name: ""}</option>`;
                }

                $('#create-emp-team-supervisor').html(html);
                $('#AddNewEmployeeTeam').modal('show');
                $('#create-emp-team-title').val('');
                $('#create-emp-team-supervisor').val('');
                $('#create-emp-team-description').val('');

                loader(false);

            },
            error: function(response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function(field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });


    }

    function _emp_team_store()
    {
        loader(true);

        var _FormData = new FormData();
        _FormData.append("title", $('#create-emp-team-title').val());
        _FormData.append("supervisor", $('#create-emp-team-supervisor').val());
        _FormData.append("description", $('#create-emp-team-description').val());


        $.ajax({
            type: "POST",
            url: "{{ url('/emp-team') }}",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            data: _FormData,
            processData: false,
            contentType: false,
            success: function(response) {
                toastr.success(response.message);
                _emp_team_append(response.data.emp_teams);
                $('#AddNewEmployeeTeam').modal('hide');

                loader(false);

            },
            error: function(response) {
                loader(false);
                if (response.status == 500) {
                                toastr.error("Something went wrong")
                            }
                            else
                            {
                                toastr.error(response.responseJSON.message)
                            }
                }
        });

    }

    function _emp_team_edit(_this)
    {
     
        var id = $(_this).attr('data-id');
        
        var title = $(_this).attr('data-title');
        var supervisor_id = $(_this).attr('data-supervisor');
        var description = $(_this).attr('data-description');
        
        $.ajax({
            type: "GET",
            url: `{{ url('/emp-team') }}/${id}/edit`,
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            success: function(response) {


                var supervisor = response.data.supervisor;

                var html = `<option value="" >Select Supervisor</option>`;

                for (var i = 0; i < supervisor.length; i++) {
                    console.log(`${supervisor[i].id} -   ${supervisor_id}`);

                    html +=
                        `<option value="${supervisor[i].id}" >${supervisor[i]?.emp_personal_details?.first_name ? supervisor[i]?.emp_personal_details?.first_name: ""} ${supervisor[i]?.emp_personal_details?.middle_name ? supervisor[i]?.emp_personal_details?.middle_name: ""} ${supervisor[i]?.emp_personal_details?.last_name ? supervisor[i]?.emp_personal_details?.last_name: ""}</option>`;
                }
               

                $('#edit-emp-team-supervisor').html(html);




                $('#edit-emp-team-id').val(id);
                $('#edit-emp-team-title').val(title);
                $('#edit-emp-team-description').val(description);
                $('#edit-emp-team-supervisor').val(supervisor_id);

                $('#EditEmpTeam').modal('show');

                loader(false);

            },
            error: function(response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function(field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });

    }

    function _emp_team_update()
    {
        loader(true);

        var id = $('#edit-emp-team-id').val();
        var title = $('#edit-emp-team-title').val();
        var supervisor_id = $('#edit-emp-team-supervisor').val();
        var description = $('#edit-emp-team-description').val();

        $.ajax({
            type: "PUT",
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            url: `/emp-team/${id}?title=${title}&description=${description}&supervisor=${supervisor_id}`,
            success: function(response) {
                toastr.success(response.message);
                _emp_team_append(response.data.emp_teams);
                $('#EditEmpTeam').modal('hide');

                loader(false);

            },
            error: function(response) {
                loader(false);
                if (response.status == 500) {
                                toastr.error("Something went wrong")
                            }
                            else
                            {
                                toastr.error(response.responseJSON.message)
                            }
                }
        });

    }

    function _emp_team_delete(_this)
    {


        var id = $(_this).attr('data-id');


        $.ajax({
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}'
            },
            type: "DELETE",
            url: "{{ url('/emp-team') }}/" + id,
            success: function(response) {
                toastr.success(response.message);
                _emp_team_append(response.data.emp_teams);
                $('#DeleteEmpTeam').modal('hide');

                loader(false);


            },
            error: function(response) {
                loader(false);
                if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function(field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                    });
                } else if (response.status == 500) {
                    toastr.error("Something went wrong")
                } else {
                    toastr.error(response.responseJSON.message)
                }
            }
        });

    }

    $("#search-member").on("keyup", function() {
        var value = this.value.toLowerCase().trim();
        $(".all-box .one-item").show().filter(function() {
            return $(this).text().toLowerCase().trim().indexOf(value) == -1;
        }).hide();
    });
</script>
