<div class="tab-pane fade" id="navs-top-worker-type" role="tabpanel">
    <div class="py-2">
        <div class=" py-3 d-flex justify-content-between align-items-center">
            <div>
                <div class="h4 pb-0 mb-0">Worker Type</div>
                <small>Worker Type List</small>
            </div>
            @if(in_array('Registration Setting Maintain',Session::get('permissions')))
            <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#Addworkertype"><span
                    class="mdi mdi-plus"></span>Add</button>
                    @endif
        </div>
    </div>
    <table class="table border-top  table-no-bottom-border">
        <tbody class="emp_worker_type_append">
            <tr>
                <td>
                    <span class="fw-medium">Super Visor</span>
                </td>
                <td style="width: 130px;">
                    <button class="btn p-0" data-bs-toggle="modal" data-bs-target="#EditPre"><span
                            class="mdi mdi-square-edit-outline text-info me-2"></span></button>
                    <button class="btn p-0" data-bs-toggle="modal" data-bs-target="#deletePre"><span
                            class="mdi mdi-trash-can-outline mdi-20px text-danger me-2"></span></button>
                </td>
            </tr>

        </tbody>
    </table>
</div>

<div class="modal fade" id="Addworkertype" tabindex="-1" aria-labelledby="Addworkertype" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header bg-primary px-4 py-2">
          <h5 class="modal-title text-white" id="AddworkertypeLabel">New Worker Types</h5>
        </div>
        <div class="modal-body">
          <div class="mb-2">
            <label for="defaultFormControlInput" class="form-label">Title</label>
            <input type="text" class="form-control" id="create-emp-worker-type-title" placeholder="Hard Work" aria-describedby="defaultFormControlHelp">
          </div>
        </div>
        <div class="modal-footer border-top py-2">
          <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary" onclick="_emp_worker_type_store();">Save</button>
        </div>
      </div>
    </div>
  </div>

  <div class="modal fade" id="EditEmpWorkerType" tabindex="-1" aria-labelledby="EditEmpWorkerTypeLabel" aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered">
          <div class="modal-content">
            <div class="modal-header bg-primary px-4 py-2">
              <h5 class="modal-title text-white" id="EditRoleLabel">Edit Worker Types</h5>
            </div>
            <div class="modal-body">
                <div class="mb-2">
                  <label for="defaultFormControlInput" class="form-label">Title</label>
                  <input type="text" class="form-control" id="edit-emp-worker-type-title" placeholder="Hard Work" aria-describedby="defaultFormControlHelp">
                </div>
                <input type="hidden" class="form-control height-width" id="edit-emp-worker-type-id"  value="" aria-describedby="defaultFormControlHelp">

              </div>
            <div class="modal-footer border-top py-2">
              <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
              <button type="button" class="btn btn-primary" data-id="" onclick="_emp_worker_type_update();">Save Changes</button>
            </div>
          </div>
        </div>
  </div>

  <div class="modal fade" id="DeleteEmpWorkerType" tabindex="-1" aria-labelledby="deletePreLabel" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header bg-danger px-4 py-2">
          <h5 class="modal-title text-white" id="deletePreLabel">Delete</h5>
        </div>
        <div class="modal-body">
          Are you sure you want to delete this record?<br><br>
          <b class="text-warning">Warning:</b> This record will no longer be available. Please ensure you genuinely want to delete it before clicking the delete button.
        </div>
        <div class="modal-footer border-top py-2">
          <button type="button" class="btn btn-outline-dark" data-bs-dismiss="modal">Close</button>
          <button type="button" class="btn btn-danger" id="delete-emp-worker-type-id" data-id="" onclick="_emp_worker_type_delete(this)">Delete</button>
        </div>
      </div>
    </div>
  </div>


  <script>
        $(document).ready(function () {

loader(false);
_emp_worker_type_get();

});

function _emp_worker_type_get()
{
      loader(true);

      $.ajax({
                  type: "GET",
                  url: "{{url('/emp-worker-type')}}",
                  headers: {
                      'X-CSRF-TOKEN': '{{csrf_token()}}'
                  },
                  success: function(response) {
                    _emp_worker_type_append(response.data.emp_worker_types);

                    loader(false);

                  },
                  error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function(field, messages) {
                          error_msg = messages[0];
                          toastr.error(error_msg);
                    });
                    }
            else  if (response.status == 500) {
                toastr.error("Something went wrong")
              }
              else
              {
                toastr.error(response.responseJSON.message)
              }
                }
      });

}

function _emp_worker_type_append(data)
{
var html = ``;
  for(var i=0; i < data.length; i++)
  {
    html +=  `<tr>
                <td>
                    <span class="fw-medium">${data[i].title}</span>
                </td>
                <td style="width: 130px;">
                @if(in_array('Registration Setting Maintain',Session::get('permissions')))
                  <div class="dropdown cursor-pointer d-flex justify-content-center">
                  <div   id="dropdownMenuButton1" data-bs-toggle="dropdown" aria-expanded="false"><span class="mdi mdi-dots-vertical list_color"></span></div>
                  <ul class="dropdown-menu" aria-labelledby="dropdownMenuButton1">
                  <li><a class="dropdown-item py-1 ps-2"  data-title="${data[i].title}"  data-id="${data[i].id}" onclick="_emp_worker_type_edit(this)"><span class="mdi mdi-square-edit-outline mdi-20px text-warning"></span> Edit</a></li>
                  <li><a class="dropdown-item py-1 ps-2"  id="delete-btn-emp-worker-type-id" data-title="${data[i].title}"  data-id="${data[i].id}" onclick="_emp_worker_type_delete_modal(this)"><span class="mdi mdi-trash-can-outline mdi-20px text-danger"></span> Delete</a></li>
                  </ul>
                  </div>
                  @endif
                </td>
            </tr>`;
  }

    if(html == ``)
    {
      html = `<div class="w-100 text-center mt-5">
                  no work worker type yet
                  </div>`;
    }


  $('.emp_worker_type_append').html(html);
}

function _emp_worker_type_create()
{

$('#create-emp-worker-type-title').val('');
}

function _emp_worker_type_store()
{
      loader(true);

        var _FormData = new FormData();
        _FormData.append("title", $('#create-emp-worker-type-title').val());


      $.ajax({
                  type: "POST",
                  url: "{{url('/emp-worker-type')}}",
                  headers: {
                      'X-CSRF-TOKEN': '{{csrf_token()}}'
                  },
                  data: _FormData,
                  processData: false,
                  contentType: false,
                  success: function(response) {
                    toastr.success(response.message);
                   _emp_worker_type_append(response.data.emp_worker_types);
                   $('#Addworkertype').modal('hide');
                    loader(false);
                    $('#create-emp-worker-type-title').val('');

                  },
                  error: function(response) {
                    loader(false);
                    if (response.status == 422) {
                    var errors = response.responseJSON.data;
                    $.each(errors, function(field, messages) {
                          error_msg = messages[0];
                          toastr.error(error_msg);
                    });
                    }
            else  if (response.status == 500) {
                toastr.error("Something went wrong")
              }
              else
              {
                toastr.error(response.responseJSON.message)
              }
                }
      });

}

function _emp_worker_type_edit(_this)
{
var id  =  $(_this).attr('data-id');
var title  =  $(_this).attr('data-title');

$('#edit-emp-worker-type-id').val(id);
$('#edit-emp-worker-type-title').val(title);
$('#EditEmpWorkerType').modal('show');
}

function _emp_worker_type_update()
{
    loader(true);

var id  =  $('#edit-emp-worker-type-id').val();
var title = $('#edit-emp-worker-type-title').val();

    $.ajax({
                type: "PUT",
                headers: {
                    'X-CSRF-TOKEN': '{{csrf_token()}}'
                },
                url : `/emp-worker-type/${id}?title=${title}`,
                success: function(response) {
                  toastr.success(response.message);
                   _emp_worker_type_append(response.data.emp_worker_types);
                   $('#EditEmpWorkerType').modal('hide');

                    loader(false);

                },
                error: function(response) {
                  loader(false);
                  if (response.status == 422) {
                  var errors = response.responseJSON.data;
                  $.each(errors, function(field, messages) {
                        error_msg = messages[0];
                        toastr.error(error_msg);
                  });
                  }
          else  if (response.status == 500) {
              toastr.error("Something went wrong")
            }
            else
            {
              toastr.error(response.responseJSON.message)
            }
              }
    });

}

function  _emp_worker_type_delete(_this)
{


   var id  =  $(_this).attr('data-id');

  $.ajax({
          headers: {
              'X-CSRF-TOKEN': '{{csrf_token()}}'
          },
          type: "DELETE",
          url: "{{url('/emp-worker-type')}}/"+id,
          success: function(response) {
            toastr.success(response.message);
            _emp_worker_type_append(response.data.emp_worker_types);
            $('#DeleteEmpWorkerType').modal('hide');

            loader(false);


          },
          error: function(response) {
          loader(false);
          if (response.status == 422) {
          var errors = response.responseJSON.data;
          $.each(errors, function(field, messages) {
                  error_msg = messages[0];
                  toastr.error(error_msg);
          });
          }
    else  if (response.status == 500) {
      toastr.error("Something went wrong")
      }
      else
      {
      toastr.error(response.responseJSON.message)
      }
      }
  });

}

function _emp_worker_type_delete_modal(_this)
{
var id  =  $(_this).attr('data-id');
$('#delete-emp-worker-type-id').attr('data-id',id);
$('#DeleteEmpWorkerType').modal('show');
}

  </script>



